*                                                                                  ;
*    Reading in the 2009 PSID data                                                 ;
*                                                                                  ;
*            John Soroushian 2/16/11                                               ;
*                                                                                  ;
*    We read it all in and then output select variables to a flat                  ;
*    file to be picked up by STATA.                                                ;
*                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam09.raw' ;

PROC PRINTTO LOG='F:\PSID\logfiles\readfam09.log' NEW;
RUN;

PROC PRINTTO PRINT='F:\PSID\logfiles\readfam09.lst' NEW;
RUN; 

 
data one;
   ATTRIB 
      ER42001   LABEL="RELEASE NUMBER"                                   format=f1.
      ER42002   LABEL="2009 FAMILY INTERVIEW (ID) NUMBER"                format=f5.
      ER42003   LABEL="PSID STATE OF RESIDENCE CODE"                     format=f2.
      ER42004   LABEL="CURRENT STATE"                                    format=f2.
      ER42005   LABEL="SPLITOFF INDICATOR"                               format=f1.
      ER42006   LABEL="MODE OF INTERVIEW"                                format=f1.
      ER42007   LABEL="FAMILY COMPOSITION CHANGE"                        format=f1.
      ER42008   LABEL="TYPE INSTITUTION"                                 format=f1.
      ER42009   LABEL="1968 FAMILY IDENTIFIER"                           format=f4.
      ER42010   LABEL="WTR REINSTATED DROPPED FAMILY"                    format=f1.
      ER42011   LABEL="INTERVIEWER ID"                                   format=f8.
      ER42012   LABEL="MONTH  CURRENT IW"                                format=f2.
      ER42013   LABEL="DAY CURRENT IW"                                   format=f2.
      ER42014   LABEL="YEAR CURRENT IW"                                  format=f4.
      ER42015   LABEL="LENGTH OF IW IN MINUTES"                          format=f3.
      ER42016   LABEL="# IN FU"                                          format=f2.
      ER42017   LABEL="AGE OF HEAD"                                      format=f3.
      ER42018   LABEL="SEX OF HEAD"                                      format=f1.
      ER42019   LABEL="AGE OF WIFE"                                      format=f3.
      ER42020   LABEL="# CHILDREN IN FU"                                 format=f2.
      ER42021   LABEL="AGE YOUNGEST CHILD"                               format=f3.
      ER42022   LABEL="# NONFU SHARING HU"                               format=f2.
      ER42023   LABEL="HEAD MARITAL STATUS"                              format=f1.
      ER42024   LABEL="A3 LIFE SATISFACTION"                             format=f1.
      ER42025   LABEL="A4 TYPE DU"                                       format=f1.
      ER42026   LABEL="A6 LIVE IN ELDERLY HSNG"                          format=f1.
      ER42027   LABEL="A7 TYPE ELDERLY HSNG"                             format=f1.
      ER42028   LABEL="A8 ACTUAL # ROOMS"                                format=f2.
      ER42029   LABEL="A19 OWN/RENT OR WHAT"                             format=f1.
      ER42030   LABEL="A20 HOUSE VALUE"                                  format=f7.
      ER42031   LABEL="ACCURACY OF HOUSE VALUE"                          format=f1.
      ER42032   LABEL="A20A WTR HOUSE WORTH 100,000+"                    format=f1.
      ER42033   LABEL="A20B WTR HOUSE WORTH 200,000+"                    format=f1.
      ER42034   LABEL="A20C WTR HOUSE WORTH 400,000+"                    format=f1.
      ER42035   LABEL="A20D WTR HOUSE WORTH 75,000+"                     format=f1.
      ER42036   LABEL="A20E WTR HOUSE WORTH 25,000+"                     format=f1.
      ER42037   LABEL="A21 ANNUAL PROPERTY TAX"                          format=f5.
      ER42038   LABEL="ACCURACY OF ANNUAL PROPERTY TAX"                  format=f1.
      ER42039   LABEL="A22 ANNUAL OWNR INSURANC"                         format=f4.
      ER42040   LABEL="A23 HAVE MORTGAGE?"                               format=f1.
      ER42041   LABEL="A23A TYPE MORTGAGE MOR 1"                         format=f1.
      ER42042   LABEL="A23C WTR ORIGINAL LOAN/REFINANCED #1"             format=f1.
      ER42043   LABEL="A24 REM PRINCIPAL MOR 1"                          format=f7.
      ER42044   LABEL="ACCURACY OF REMAINING MORTGAGE PRIN #1"           format=f1.
      ER42045   LABEL="A25 MNTHLY PMTS MOR 1"                            format=f5.
      ER42046   LABEL="ACCURACY OF MONTHLY PYMNTS ON MTGE #1"            format=f1.
      ER42047   LABEL="A25A CURR INTEREST RATE WHOLE PERCENT #1"         format=f2.
      ER42048   LABEL="A25A CURR INT RATE DECIMAL FRACTION #1"           format=f3.
      ER42049   LABEL="A25A1 WTR CURR INT RATE FIXED/VARBLE #1"          format=f1.
      ER42050   LABEL="A26 YEAR OBTAINED LOAN #1"                        format=f4.
      ER42051   LABEL="A27 YRS TO PAY MOR    1"                          format=f2.
      ER42052   LABEL="A27F1 WTR BEHIND ON MTGE # 1"                     format=f1.
      ER42053   LABEL="A27F2 MONTHS BEHIND ON MTGE # 1"                  format=f2.
      ER42054   LABEL="A27F3 WTR FORECLOSURE ON MTGE # 1"                format=f1.
      ER42055   LABEL="A27F4 MONTH FORECLOSURE ON MTGE # 1"              format=f2.
      ER42056   LABEL="A27F4 YEAR FORECLOSURE ON MTGE # 1"               format=f4.
      ER42057   LABEL="A27F5 WTR RESTRUCTURED MTGE # 1"                  format=f1.
      ER42058   LABEL="A27F6 LIKELY TO FALL BEHIND ON MTGE #1"           format=f1.
      ER42059   LABEL="A28 2ND MORTGAGE"                                 format=f1.
      ER42060   LABEL="A23A TYPE MORTGAGE MOR 2"                         format=f1.
      ER42061   LABEL="A23C WTR ORIGINAL LOAN/REFINANCED #2"             format=f1.
      ER42062   LABEL="A24 REM PRINCIPAL MOR 2"                          format=f7.
      ER42063   LABEL="ACCURACY OF REMAINING MORTGAGE PRIN #2"           format=f1.
      ER42064   LABEL="A25 MNTHLY PMTS MOR   2"                          format=f5.
      ER42065   LABEL="ACCURACY OF MONTHLY PYMNTS ON MTGE #2"            format=f1.
      ER42066   LABEL="A25A CURR INTEREST RATE WHOLE PERCENT #2"         format=f2.
      ER42067   LABEL="A25A CURR INT RATE DECIMAL FRACTION #2"           format=f3.
      ER42068   LABEL="A25A1 WTR CURR INT RATE FIXED/VARBLE #2"          format=f1.
      ER42069   LABEL="A26 YEAR OBTAINED LOAN #2"                        format=f4.
      ER42070   LABEL="A27 YRS TO PAY MOR    2"                          format=f2.
      ER42071   LABEL="A27F1 WTR BEHIND ON MTGE # 2"                     format=f1.
      ER42072   LABEL="A27F2 MONTHS BEHIND ON MTGE # 2"                  format=f2.
      ER42073   LABEL="A27F3 WTR FORECLOSURE ON MTGE # 2"                format=f1.
      ER42074   LABEL="A27F4 MONTH FORECLOSURE ON MTGE # 2"              format=f2.
      ER42075   LABEL="A27F4 YEAR FORECLOSURE ON MTGE # 2"               format=f4.
      ER42076   LABEL="A27F5 WTR RESTRUCTURED MTGE # 2"                  format=f1.
      ER42077   LABEL="A27F6 LIKELY TO FALL BEHIND ON MTGE # 2"          format=f1.
      ER42078   LABEL="A29 MTG INCL PROP TAXES"                          format=f1.
      ER42079   LABEL="A30 MTG INCL INS PREM"                            format=f1.
      ER42080   LABEL="A31 DOLLARS RENT"                                 format=f5.
      ER42081   LABEL="A31 DOLLARS PER WHAT"                             format=f1.
      ER42082   LABEL="ACCURACY OF RENT"                                 format=f1.
      ER42083   LABEL="A31A FURNISHED APT/HOUSE"                         format=f1.
      ER42084   LABEL="A31B RENT INCL HEAT"                              format=f1.
      ER42085   LABEL="A32 IN PUBLIC OWND PROJ?"                         format=f1.
      ER42086   LABEL="A33 GOVT PAY PART RENT?"                          format=f1.
      ER42087   LABEL="A35 DOLLARS RENT IF RENT"                         format=f4.
      ER42088   LABEL="A35 DOLLARS PER WHAT"                             format=f1.
      ER42089   LABEL="ACCURACY OF VALUE IF RENTED"                      format=f1.
      ER42090   LABEL="A36 IN PUBLIC OWND PROJ?"                         format=f1.
      ER42091   LABEL="A37 GOVT PAY ALL RENT?"                           format=f1.
      ER42092   LABEL="A37F1 WTR FORCLOSURE BEG OTR HOME # 1"            format=f1.
      ER42093   LABEL="A37F2 MONTH FORCLOSURE OTR HOME # 1"              format=f2.
      ER42094   LABEL="A37F2 YEAR FORCLOSURE OTR HOME # 1"               format=f4.
      ER42095   LABEL="A37F3 WTR FORECLOSURED OTR HOME # 1"              format=f1.
      ER42096   LABEL="A37F4 WTR LOST OTR HOME FORECLOSURE # 1"          format=f1.
      ER42097   LABEL="A37F5 WTR MAIN RESIDENCE OTR HOME # 1"            format=f1.
      ER42098   LABEL="A37F6 AMT STILL OWED OTR HOME # 1"                format=f7.
      ER42099   LABEL="A37F1 WTR FORCLOSURE BEG OTR HOME # 2"            format=f1.
      ER42100   LABEL="A37F2 MONTH FORCLOSURE OTR HOME # 2"              format=f2.
      ER42101   LABEL="A37F2 YEAR FORCLOSURE OTR HOME # 2"               format=f4.
      ER42102   LABEL="A37F3 WTR FORECLOSURED OTR HOME # 2"              format=f1.
      ER42103   LABEL="A37F4 WTR LOST OTR HOME FORECLOSURE # 2"          format=f1.
      ER42104   LABEL="A37F5 WTR MAIN RESIDENCE OTR HOME # 2"            format=f1.
      ER42105   LABEL="A37F6 AMT STILL OWED OTR HOME # 2"                format=f7.
      ER42106   LABEL="A38 HAVE AIR CONDITNG"                            format=f1.
      ER42107   LABEL="A39 A/C ALL OR SOME ROOM"                         format=f1.
      ER42108   LABEL="A40 TYPE HEATING 1ST MENTION"                     format=f2.
      ER42109   LABEL="A40 TYPE HEATING 2ND MENTION"                     format=f2.
      ER42110   LABEL="A40 TYPE HEATING 3RD MENTION"                     format=f2.
      ER42111   LABEL="A42 WTR GAS/ELEC COSTS ON ONE BILL"               format=f1.
      ER42112   LABEL="A41 HEATING FUEL EXPENSE"                         format=f4.
      ER42113   LABEL="A41 HEATING FUEL EXPENSE PER"                     format=f1.
      ER42114   LABEL="A42 ELECTRICITY EXPENSE"                          format=f4.
      ER42115   LABEL="A42 ELECTRICITY PER"                              format=f1.
      ER42116   LABEL="A42 COMBINED GAS/ELECT EXPENSE"                   format=f4.
      ER42117   LABEL="A42 COMBINED GAS/ELECT EXPENSE PER"               format=f1.
      ER42118   LABEL="A43 WATER/SEWER EXPENSE"                          format=f4.
      ER42119   LABEL="A43 WATER/SEWER EXPENSE PER"                      format=f1.
      ER42120   LABEL="A44 TELEPHONE EXPENSE"                            format=f4.
      ER42121   LABEL="A44 TELEPHONE EXPENSE PER"                        format=f1.
      ER42122   LABEL="A45 WTR OTR UTILITY EXP"                          format=f1.
      ER42123   LABEL="A45A GARBAGE EXPENSE"                             format=f1.
      ER42124   LABEL="A45B TOTAL OTR UTILITIES"                         format=f3.
      ER42125   LABEL="A45B OTR UTILITIES PER"                           format=f1.
      ER42126   LABEL="A46 RECD GOVT HTG SUBSDY"                         format=f1.
      ER42127   LABEL="A46A AMT GOVT HTG SUBSDY"                         format=f4.
      ER42128   LABEL="A47A WTR COMPUTER IN HOME-HD"                     format=f1.
      ER42129   LABEL="A47B WTR USED INTERNET-HD"                        format=f1.
      ER42130   LABEL="A47A WTR COMPUTER IN HOME-WF"                     format=f1.
      ER42131   LABEL="A47B WTR USED INTERNET-WF"                        format=f1.
      ER42132   LABEL="A49 WTR MOVED SINCE JAN 1 OF PRIOR YEAR"          format=f1.
      ER42133   LABEL="A49 MONTH MOVED"                                  format=f2.
      ER42134   LABEL="A49 YEAR MOVED"                                   format=f4.
      ER42135   LABEL="A50 WHY MOVED 1ST MENTION"                        format=f1.
      ER42136   LABEL="A50 WHY MOVED 2ND MENTION"                        format=f1.
      ER42137   LABEL="A50 WHY MOVED 3RD MENTION"                        format=f1.
      ER42138   LABEL="A51 WTR MIGHT MOVE"                               format=f1.
      ER42139   LABEL="A52 LIKELIHOOD OF MOVING"                         format=f1.
      ER42140   LABEL="BC1 EMPLOYMENT STATUS-1ST MENTION"                format=f2.
      ER42141   LABEL="BC1 EMPLOYMENT STATUS-2ND MENTION"                format=f2.
      ER42142   LABEL="BC1 EMPLOYMENT STATUS-3RD MENTION"                format=f2.
      ER42143   LABEL="BC2 YEAR RETIRED"                                 format=f4.
      ER42144   LABEL="BC3 WTR WORK FOR MONEY"                           format=f1.
      ER42145   LABEL="BC3A WTR WORKD SINCE JAN 1 OF PRIOR YEAR"         format=f1.
      ER42146   LABEL="BC14A_B WEEKS EMPLOYED LAST YEAR"                 format=f2.
      ER42147   LABEL="ACCURACY OF HEAD WKS EMPLOYED LAST YEAR"          format=f1.
      ER42148   LABEL="BC14BB AVERAGE HOURS WORKED LAST YEAR"            format=f3.
      ER42149   LABEL="ACCURACY OF HEAD HOURS WORKED LAST YEAR"          format=f1.
      ER42150   LABEL="BC16-17 MAIN JOB INDICATOR"                       format=f1.
      ER42151   LABEL="BC6 BEGINNING MONTH--JOB 1"                       format=f2.
      ER42152   LABEL="BC6 BEGINNING YEAR--JOB 1"                        format=f4.
      ER42153   LABEL="BC6 ENDING MONTH--JOB 1"                          format=f2.
      ER42154   LABEL="BC6 ENDING YEAR--JOB 1"                           format=f4.
      ER42155   LABEL="BC6 WTR EMPLOYED--JOB 1 JAN"                      format=f1.
      ER42156   LABEL="BC6 WTR EMPLOYED--JOB 1 FEB"                      format=f1.
      ER42157   LABEL="BC6 WTR EMPLOYED--JOB 1 MAR"                      format=f1.
      ER42158   LABEL="BC6 WTR EMPLOYED--JOB 1 APR"                      format=f1.
      ER42159   LABEL="BC6 WTR EMPLOYED--JOB 1 MAY"                      format=f1.
      ER42160   LABEL="BC6 WTR EMPLOYED--JOB 1 JUN"                      format=f1.
      ER42161   LABEL="BC6 WTR EMPLOYED--JOB 1 JUL"                      format=f1.
      ER42162   LABEL="BC6 WTR EMPLOYED--JOB 1 AUG"                      format=f1.
      ER42163   LABEL="BC6 WTR EMPLOYED--JOB 1 SEP"                      format=f1.
      ER42164   LABEL="BC6 WTR EMPLOYED--JOB 1 OCT"                      format=f1.
      ER42165   LABEL="BC6 WTR EMPLOYED--JOB 1 NOV"                      format=f1.
      ER42166   LABEL="BC6 WTR EMPLOYED--JOB 1 DEC"                      format=f1.
      ER42167   LABEL="BC20 MAIN OCC FOR JOB 1: 2000 CODE (HD)"          format=f3.
      ER42168   LABEL="BC21 MAIN IND FOR JOB 1: 2000 CODE (HD)"          format=f3.
      ER42169   LABEL="BC22 WORK SELF/OTR?--JOB 1"                       format=f1.
      ER42170   LABEL="BC23 CORP/UNCORP BUS--JOB 1"                      format=f1.
      ER42171   LABEL="BC24 WORK FOR GOVT?--JOB 1"                       format=f1.
      ER42172   LABEL="BC25A NUMBER EMPLOYED AT WORK LOCATION"           format=f9.
      ER42173   LABEL="BC25B WTR 200 OR MORE"                            format=f1.
      ER42174   LABEL="BC25C WTR 100 OR MORE"                            format=f1.
      ER42175   LABEL="BC25D WTR 50 OR MORE"                             format=f1.
      ER42176   LABEL="BC25E WTR 500 OR MORE"                            format=f1.
      ER42177   LABEL="BC25F WTR 1000 OR MORE"                           format=f1.
      ER42178   LABEL="BC26 JOB NOW UNION? (H-E)"                        format=f1.
      ER42179   LABEL="BC27 BELONG UNION? (HD-E)"                        format=f1.
      ER42180   LABEL="BC28A WTR JOB REQUIRES COMPUTER USE"              format=f1.
      ER42181   LABEL="BC29 SLRY/HRLY/OTR (H-E)"                         format=f1.
      ER42182   LABEL="BC30 SALARY AMOUNT"                               format=f10.2
      ER42183   LABEL="BC30 SALARY PER WHAT"                             format=f1.
      ER42184   LABEL="BC31 WTR SAL PD OT (HD-E)"                        format=f1.
      ER42185   LABEL="BC32 HOW PAID FOR OT"                             format=f1.
      ER42186   LABEL="BC32A EXACT OT PAY IF SALARIED"                   format=f10.2
      ER42187   LABEL="BC32A EXACT OT PAY PER"                           format=f1.
      ER42188   LABEL="BC33 HOURLY REGULAR RATE"                         format=f6.2
      ER42189   LABEL="BC34 OT DIFFERENTIAL 1ST"                         format=f1.
      ER42190   LABEL="BC34 OT DIFFERENTIAL 2ND"                         format=f1.
      ER42191   LABEL="BC34 OT DIFFERENTIAL 3RD"                         format=f1.
      ER42192   LABEL="BC34A EXACT OT PAY IF HOURLY"                     format=f10.2
      ER42193   LABEL="BC34A EXACT OT PAY PER"                           format=f1.
      ER42194   LABEL="BC36 AVG TIPS/COMM"                               format=f8.2
      ER42195   LABEL="BC36 TIPS/COMM PER WHAT"                          format=f1.
      ER42196   LABEL="BC37 AVG TIPS/COMM"                               format=f7.
      ER42197   LABEL="BC37 TIPS/COMM PER WHAT"                          format=f1.
      ER42198   LABEL="BC38 HOW PAID-OTR (HD-E)"                         format=f1.
      ER42199   LABEL="BC39 OT RATE"                                     format=f9.2
      ER42200   LABEL="BC41 YRS PRES EMP (H-E)"                          format=f2.
      ER42201   LABEL="BC41 MOS PRES EMP (H-E)"                          format=f2.
      ER42202   LABEL="BC41 WKS PRES EMP (H-E)"                          format=f2.
      ER42203   LABEL="BC43 HOURS/WEEK WORKED--JOB 1"                    format=f3.
      ER42204   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 1"               format=f1.
      ER42205   LABEL="BC44 WTR WORKED OT--JOB 1"                        format=f1.
      ER42206   LABEL="BC45 AMT OF OT WORKED--JOB 1"                     format=f4.
      ER42207   LABEL="BC45 OT TIME UNIT--JOB 1"                         format=f1.
      ER42208   LABEL="ACCURACY OF OT--HD JOB 1"                         format=f1.
      ER42209   LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 1"              format=f10.2
      ER42210   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 1"           format=f1.
      ER42211   LABEL="BC51 WHY LAST JOB END (HD-U)"                     format=f1.
      ER42212   LABEL="BC6 BEGINNING MONTH--JOB 2"                       format=f2.
      ER42213   LABEL="BC6 BEGINNING YEAR--JOB 2"                        format=f4.
      ER42214   LABEL="BC6 ENDING MONTH--JOB 2"                          format=f2.
      ER42215   LABEL="BC6 ENDING YEAR--JOB 2"                           format=f4.
      ER42216   LABEL="BC6 WTR EMPLOYED--JOB 2 JAN"                      format=f1.
      ER42217   LABEL="BC6 WTR EMPLOYED--JOB 2 FEB"                      format=f1.
      ER42218   LABEL="BC6 WTR EMPLOYED--JOB 2 MAR"                      format=f1.
      ER42219   LABEL="BC6 WTR EMPLOYED--JOB 2 APR"                      format=f1.
      ER42220   LABEL="BC6 WTR EMPLOYED--JOB 2 MAY"                      format=f1.
      ER42221   LABEL="BC6 WTR EMPLOYED--JOB 2 JUN"                      format=f1.
      ER42222   LABEL="BC6 WTR EMPLOYED--JOB 2 JUL"                      format=f1.
      ER42223   LABEL="BC6 WTR EMPLOYED--JOB 2 AUG"                      format=f1.
      ER42224   LABEL="BC6 WTR EMPLOYED--JOB 2 SEP"                      format=f1.
      ER42225   LABEL="BC6 WTR EMPLOYED--JOB 2 OCT"                      format=f1.
      ER42226   LABEL="BC6 WTR EMPLOYED--JOB 2 NOV"                      format=f1.
      ER42227   LABEL="BC6 WTR EMPLOYED--JOB 2 DEC"                      format=f1.
      ER42228   LABEL="BC20 MAIN OCC FOR JOB 2: 2000 CODE (HD)"          format=f3.
      ER42229   LABEL="BC21 MAIN IND FOR JOB 2: 2000 CODE (HD)"          format=f3.
      ER42230   LABEL="BC22 WORK SELF/OTR?--JOB 2"                       format=f1.
      ER42231   LABEL="BC23 CORP/UNCORP BUS--JOB 2"                      format=f1.
      ER42232   LABEL="BC24 WORK FOR GOVT?--JOB 2"                       format=f1.
      ER42233   LABEL="BC43 HOURS/WEEK WORKED--JOB 2"                    format=f3.
      ER42234   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 2"               format=f1.
      ER42235   LABEL="BC44 WTR WORKED OT--JOB 2"                        format=f1.
      ER42236   LABEL="BC45 AMT OF OT WORKED--JOB 2"                     format=f4.
      ER42237   LABEL="BC45 OT TIME UNIT--JOB 2"                         format=f1.
      ER42238   LABEL="ACCURACY OF OT--HD JOB 2"                         format=f1.
      ER42239   LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 2"              format=f10.2
      ER42240   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 2"           format=f1.
      ER42241   LABEL="BC51 WHY JOB ENDED--JOB 2"                        format=f1.
      ER42242   LABEL="BC6 BEGINNING MONTH--JOB 3"                       format=f2.
      ER42243   LABEL="BC6 BEGINNING YEAR--JOB 3"                        format=f4.
      ER42244   LABEL="BC6 ENDING MONTH--JOB 3"                          format=f2.
      ER42245   LABEL="BC6 ENDING YEAR--JOB 3"                           format=f4.
      ER42246   LABEL="BC6 WTR EMPLOYED--JOB 3 JAN"                      format=f1.
      ER42247   LABEL="BC6 WTR EMPLOYED--JOB 3 FEB"                      format=f1.
      ER42248   LABEL="BC6 WTR EMPLOYED--JOB 3 MAR"                      format=f1.
      ER42249   LABEL="BC6 WTR EMPLOYED--JOB 3 APR"                      format=f1.
      ER42250   LABEL="BC6 WTR EMPLOYED--JOB 3 MAY"                      format=f1.
      ER42251   LABEL="BC6 WTR EMPLOYED--JOB 3 JUN"                      format=f1.
      ER42252   LABEL="BC6 WTR EMPLOYED--JOB 3 JUL"                      format=f1.
      ER42253   LABEL="BC6 WTR EMPLOYED--JOB 3 AUG"                      format=f1.
      ER42254   LABEL="BC6 WTR EMPLOYED--JOB 3 SEP"                      format=f1.
      ER42255   LABEL="BC6 WTR EMPLOYED--JOB 3 OCT"                      format=f1.
      ER42256   LABEL="BC6 WTR EMPLOYED--JOB 3 NOV"                      format=f1.
      ER42257   LABEL="BC6 WTR EMPLOYED--JOB 3 DEC"                      format=f1.
      ER42258   LABEL="BC20 MAIN OCC FOR JOB 3: 2000 CODE (HD)"          format=f3.
      ER42259   LABEL="BC21 MAIN IND FOR JOB 3: 2000 CODE (HD)"          format=f3.
      ER42260   LABEL="BC22 WORK SELF/OTR?--JOB 3"                       format=f1.
      ER42261   LABEL="BC23 CORP/UNCORP BUS--JOB 3"                      format=f1.
      ER42262   LABEL="BC24 WORK FOR GOVT?--JOB 3"                       format=f1.
      ER42263   LABEL="BC43 HOURS/WEEK WORKED--JOB 3"                    format=f3.
      ER42264   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 3"               format=f1.
      ER42265   LABEL="BC44 WTR WORKED OT--JOB 3"                        format=f1.
      ER42266   LABEL="BC45 AMT OF OT WORKED--JOB 3"                     format=f4.
      ER42267   LABEL="BC45 OT TIME UNIT--JOB 3"                         format=f1.
      ER42268   LABEL="ACCURACY OF OT--HD JOB 3"                         format=f1.
      ER42269   LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 3"              format=f10.2
      ER42270   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 3"           format=f1.
      ER42271   LABEL="BC51 WHY JOB ENDED--JOB 3"                        format=f1.
      ER42272   LABEL="BC6 BEGINNING MONTH--JOB 4"                       format=f2.
      ER42273   LABEL="BC6 BEGINNING YEAR--JOB 4"                        format=f4.
      ER42274   LABEL="BC6 ENDING MONTH--JOB 4"                          format=f2.
      ER42275   LABEL="BC6 ENDING YEAR--JOB 4"                           format=f4.
      ER42276   LABEL="BC6 WTR EMPLOYED--JOB 4 JAN"                      format=f1.
      ER42277   LABEL="BC6 WTR EMPLOYED--JOB 4 FEB"                      format=f1.
      ER42278   LABEL="BC6 WTR EMPLOYED--JOB 4 MAR"                      format=f1.
      ER42279   LABEL="BC6 WTR EMPLOYED--JOB 4 APR"                      format=f1.
      ER42280   LABEL="BC6 WTR EMPLOYED--JOB 4 MAY"                      format=f1.
      ER42281   LABEL="BC6 WTR EMPLOYED--JOB 4 JUN"                      format=f1.
      ER42282   LABEL="BC6 WTR EMPLOYED--JOB 4 JUL"                      format=f1.
      ER42283   LABEL="BC6 WTR EMPLOYED--JOB 4 AUG"                      format=f1.
      ER42284   LABEL="BC6 WTR EMPLOYED--JOB 4 SEP"                      format=f1.
      ER42285   LABEL="BC6 WTR EMPLOYED--JOB 4 OCT"                      format=f1.
      ER42286   LABEL="BC6 WTR EMPLOYED--JOB 4 NOV"                      format=f1.
      ER42287   LABEL="BC6 WTR EMPLOYED--JOB 4 DEC"                      format=f1.
      ER42288   LABEL="BC20 MAIN OCC FOR JOB 4: 2000 CODE (HD)"          format=f3.
      ER42289   LABEL="BC21 MAIN IND FOR JOB 4: 2000 CODE (HD)"          format=f3.
      ER42290   LABEL="BC22 WORK SELF/OTR?--JOB 4"                       format=f1.
      ER42291   LABEL="BC23 CORP/UNCORP BUS--JOB 4"                      format=f1.
      ER42292   LABEL="BC24 WORK FOR GOVT?--JOB 4"                       format=f1.
      ER42293   LABEL="BC43 HOURS/WEEK WORKED--JOB 4"                    format=f3.
      ER42294   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 4"               format=f1.
      ER42295   LABEL="BC44 WTR WORKED OT--JOB 4"                        format=f1.
      ER42296   LABEL="BC45 AMT OF OT WORKED--JOB 4"                     format=f4.
      ER42297   LABEL="BC45 OT TIME UNIT--JOB 4"                         format=f1.
      ER42298   LABEL="ACCURACY OF OT--HD JOB 4"                         format=f1.
      ER42299   LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 4"              format=f10.2
      ER42300   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 4"           format=f1.
      ER42301   LABEL="BC51 WHY JOB ENDED--JOB 4"                        format=f1.
      ER42302   LABEL="NUMBER OF ADDITIONAL JOBS--HD"                    format=f1.
      ER42303   LABEL="BC10 WTR OTRS ILL (HD)"                           format=f1.
      ER42304   LABEL="BC10 DAYS OTHERS SICK"                            format=f3.
      ER42305   LABEL="ACCURACY OF DAYS OTRS SICK (HD)"                  format=f1.
      ER42306   LABEL="BC10 WEEKS OTHERS SICK"                           format=f2.
      ER42307   LABEL="ACCURACY OF WEEKS OTRS SICK (HD)"                 format=f1.
      ER42308   LABEL="BC10 MONTHS OTHERS SICK"                          format=f2.
      ER42309   LABEL="ACCURACY OF MONTHS OTRS SICK (HD)"                format=f1.
      ER42310   LABEL="BC11 WTR SELF ILL (HD)"                           format=f1.
      ER42311   LABEL="BC11 DAYS SELF SICK"                              format=f3.
      ER42312   LABEL="ACCURACY OF DAYS SELF ILL (HD)"                   format=f1.
      ER42313   LABEL="BC11 WEEKS SELF SICK"                             format=f2.
      ER42314   LABEL="ACCURACY OF WEEKS SELF ILL (HD)"                  format=f1.
      ER42315   LABEL="BC11 MONTHS SELF SICK"                            format=f2.
      ER42316   LABEL="ACCURACY OF MONTHS SELF ILL (HD)"                 format=f1.
      ER42317   LABEL="BC12 WTR VACATION (HD)"                           format=f1.
      ER42318   LABEL="BC12 DAYS VACATION"                               format=f3.
      ER42319   LABEL="ACCURACY OF DAYS VACATION (HD)"                   format=f1.
      ER42320   LABEL="BC12 WEEKS VACATION"                              format=f2.
      ER42321   LABEL="ACCURACY OF WEEKS VACATION (HD)"                  format=f1.
      ER42322   LABEL="BC12 MONTHS VACATION"                             format=f2.
      ER42323   LABEL="ACCURACY OF MONTHS VACATION (HD)"                 format=f1.
      ER42324   LABEL="BC13 WTR STRIKE (HD)"                             format=f1.
      ER42325   LABEL="BC13 DAYS STRIKE"                                 format=f3.
      ER42326   LABEL="ACCURACY OF STRIKE DAYS (HD)"                     format=f1.
      ER42327   LABEL="BC13 WEEKS STRIKE"                                format=f2.
      ER42328   LABEL="ACCURACY OF STRIKE WEEKS (HD)"                    format=f1.
      ER42329   LABEL="BC13 MONTHS STRIKE"                               format=f2.
      ER42330   LABEL="ACCURACY OF STRIKE MONTHS (HD)"                   format=f1.
      ER42331   LABEL="BC14 WTR LAID OFF (HD)"                           format=f1.
      ER42332   LABEL="BC14 DAYS LAID OFF"                               format=f3.
      ER42333   LABEL="ACCURACY OF DAYS LAID OFF (HD)"                   format=f1.
      ER42334   LABEL="BC14 WEEKS LAID OFF"                              format=f2.
      ER42335   LABEL="ACCURACY OF WEEKS LAID OFF (HD)"                  format=f1.
      ER42336   LABEL="BC14 MONTHS LAID OFF"                             format=f2.
      ER42337   LABEL="ACCURACY OF MONTHS LAID OFF (HD)"                 format=f1.
      ER42338   LABEL="BC8 WTR UNEMPLOYED(HD)"                           format=f1.
      ER42339   LABEL="BC8 DAYS UNEMPLOYED"                              format=f3.
      ER42340   LABEL="ACCURACY OF DAYS UNEMPLOYED (HD)"                 format=f1.
      ER42341   LABEL="BC8 WEEKS UNEMPLOYED"                             format=f2.
      ER42342   LABEL="ACCURACY OF WEEKS UNEMPLOYED (HD)"                format=f1.
      ER42343   LABEL="BC8 MONTHS UNEMPLOYED"                            format=f2.
      ER42344   LABEL="ACCURACY OF MONTHS UNEMPLOYED (HD)"               format=f1.
      ER42345   LABEL="BC8 WTR UNEMPLOYED JAN"                           format=f1.
      ER42346   LABEL="BC8 WTR UNEMPLOYED FEB"                           format=f1.
      ER42347   LABEL="BC8 WTR UNEMPLOYED MAR"                           format=f1.
      ER42348   LABEL="BC8 WTR UNEMPLOYED APR"                           format=f1.
      ER42349   LABEL="BC8 WTR UNEMPLOYED MAY"                           format=f1.
      ER42350   LABEL="BC8 WTR UNEMPLOYED JUN"                           format=f1.
      ER42351   LABEL="BC8 WTR UNEMPLOYED JUL"                           format=f1.
      ER42352   LABEL="BC8 WTR UNEMPLOYED AUG"                           format=f1.
      ER42353   LABEL="BC8 WTR UNEMPLOYED SEP"                           format=f1.
      ER42354   LABEL="BC8 WTR UNEMPLOYED OCT"                           format=f1.
      ER42355   LABEL="BC8 WTR UNEMPLOYED NOV"                           format=f1.
      ER42356   LABEL="BC8 WTR UNEMPLOYED DEC"                           format=f1.
      ER42357   LABEL="BC7 WTR OUT LAB FRC(H)"                           format=f1.
      ER42358   LABEL="BC7 DAYS OUT OF LAB FORCE"                        format=f3.
      ER42359   LABEL="ACCURACY OF DAYS OUT OF LAB FORCE (HD)"           format=f1.
      ER42360   LABEL="BC7WEEKS OUT LABOR FORCE"                         format=f2.
      ER42361   LABEL="ACCURACY OF WKS OUT OF LAB FORCE (HD)"            format=f1.
      ER42362   LABEL="BC7 MONTHS OUT LABR FORCE"                        format=f2.
      ER42363   LABEL="ACCURACY OF MOS OUT OF LAB FORCE (HD)"            format=f1.
      ER42364   LABEL="BC7 WTR OUT LAB FORC JAN"                         format=f1.
      ER42365   LABEL="BC7 WTR OUT LAB FORC FEB"                         format=f1.
      ER42366   LABEL="BC7 WTR OUT LAB FORC MAR"                         format=f1.
      ER42367   LABEL="BC7 WTR OUT LAB FORC APR"                         format=f1.
      ER42368   LABEL="BC7 WTR OUT LAB FORC MAY"                         format=f1.
      ER42369   LABEL="BC7 WTR OUT LAB FORC JUN"                         format=f1.
      ER42370   LABEL="BC7 WTR OUT LAB FORC JUL"                         format=f1.
      ER42371   LABEL="BC7 WTR OUT LAB FORC AUG"                         format=f1.
      ER42372   LABEL="BC7 WTR OUT LAB FORC SEP"                         format=f1.
      ER42373   LABEL="BC7 WTR OUT LAB FORC OCT"                         format=f1.
      ER42374   LABEL="BC7 WTR OUT LAB FORC NOV"                         format=f1.
      ER42375   LABEL="BC7 WTR OUT LAB FORC DEC"                         format=f1.
      ER42376   LABEL="BC62 WTR EVER WORKED"                             format=f1.
      ER42377   LABEL="BC63 MO LAST WORKED"                              format=f2.
      ER42378   LABEL="BC63 YR LAST WORKED"                              format=f4.
      ER42379   LABEL="BC64 WTR LOOKING FOR JOB"                         format=f1.
      ER42380   LABEL="BC65 WTR PUBLIC EMP AGENCY (HD)"                  format=f1.
      ER42381   LABEL="BC65 WTR PRIVATE EMP AGENCY (HD)"                 format=f1.
      ER42382   LABEL="BC65 WTR CHKD W/CURRENT EMP (HD)"                 format=f1.
      ER42383   LABEL="BC65 WTR CHKD W/OTHER EMP (HD)"                   format=f1.
      ER42384   LABEL="BC65 WTR CHKD W/FRIEND OR REL (HD)"               format=f1.
      ER42385   LABEL="BC65 WTR PLACED OR ANSWERED ADS (HD)"             format=f1.
      ER42386   LABEL="BC65 WTR OTHER ACTIVITY (HD)"                     format=f1.
      ER42387   LABEL="BC65 WTR DONE NOTHING (HD)"                       format=f1.
      ER42388   LABEL="BC67 YRS LOOK WRK (H-U)"                          format=f2.
      ER42389   LABEL="BC67 MOS LOOK WRK (H-U)"                          format=f2.
      ER42390   LABEL="BC67 WKS LOOK WRK (H-U)"                          format=f2.
      ER42391   LABEL="DE1 CKPT: WTR WIFE IN FU"                         format=f1.
      ER42392   LABEL="DE1 EMPLOYMENT STATUS-1ST MENTION"                format=f2.
      ER42393   LABEL="DE1 EMPLOYMENT STATUS-2ND MENTION"                format=f2.
      ER42394   LABEL="DE1 EMPLOYMENT STATUS-3RD MENTION"                format=f2.
      ER42395   LABEL="DE2 YEAR RETIRED (WF-R)"                          format=f4.
      ER42396   LABEL="DE3 WTR WORK FOR MONEY"                           format=f1.
      ER42397   LABEL="DE3A WTR WORKD SINCE JAN 1 OF PRIOR YEAR"         format=f1.
      ER42398   LABEL="DE14A_B WEEKS EMPLOYED LAST YEAR"                 format=f2.
      ER42399   LABEL="ACCURACY OF WIFE WKS EMPLOYED LAST YEAR"          format=f1.
      ER42400   LABEL="DE14BB AVERAGE HOURS WORKED LAST YEAR"            format=f3.
      ER42401   LABEL="ACCURACY OF WIFE HOURS WORKED LAST YEAR"          format=f1.
      ER42402   LABEL="DE16-17 MAIN JOB INDICATOR"                       format=f1.
      ER42403   LABEL="DE6 BEGINNING MONTH--JOB 1"                       format=f2.
      ER42404   LABEL="DE6 BEGINNING YEAR--JOB 1"                        format=f4.
      ER42405   LABEL="DE6 ENDING MONTH--JOB 1"                          format=f2.
      ER42406   LABEL="DE6 ENDING YEAR--JOB 1"                           format=f4.
      ER42407   LABEL="DE6 WTR EMPLOYED--JOB 1 JAN"                      format=f1.
      ER42408   LABEL="DE6 WTR EMPLOYED--JOB 1 FEB"                      format=f1.
      ER42409   LABEL="DE6 WTR EMPLOYED--JOB 1 MAR"                      format=f1.
      ER42410   LABEL="DE6 WTR EMPLOYED--JOB 1 APR"                      format=f1.
      ER42411   LABEL="DE6 WTR EMPLOYED--JOB 1 MAY"                      format=f1.
      ER42412   LABEL="DE6 WTR EMPLOYED--JOB 1 JUN"                      format=f1.
      ER42413   LABEL="DE6 WTR EMPLOYED--JOB 1 JUL"                      format=f1.
      ER42414   LABEL="DE6 WTR EMPLOYED--JOB 1 AUG"                      format=f1.
      ER42415   LABEL="DE6 WTR EMPLOYED--JOB 1 SEP"                      format=f1.
      ER42416   LABEL="DE6 WTR EMPLOYED--JOB 1 OCT"                      format=f1.
      ER42417   LABEL="DE6 WTR EMPLOYED--JOB 1 NOV"                      format=f1.
      ER42418   LABEL="DE6 WTR EMPLOYED--JOB 1 DEC"                      format=f1.
      ER42419   LABEL="DE20 MAIN OCC FOR JOB 1: 2000 CODE (WF)"          format=f3.
      ER42420   LABEL="DE21 MAIN IND FOR JOB 1: 2000 CODE (WF)"          format=f3.
      ER42421   LABEL="DE22 WORK SELF/OTR?--JOB 1"                       format=f1.
      ER42422   LABEL="DE23 CORP/UNCORP BUS--JOB 1"                      format=f1.
      ER42423   LABEL="DE24 WORK FOR GOVT?--JOB 1"                       format=f1.
      ER42424   LABEL="DE25A NUMBER EMPLOYED AT WORK LOCATION"           format=f9.
      ER42425   LABEL="DE25B WTR 200 OR MORE"                            format=f1.
      ER42426   LABEL="DE25C WTR 100 OR MORE"                            format=f1.
      ER42427   LABEL="DE25D WTR 50 OR MORE"                             format=f1.
      ER42428   LABEL="DE25E WTR 500 OR MORE"                            format=f1.
      ER42429   LABEL="DE25F WTR 1000 OR MORE"                           format=f1.
      ER42430   LABEL="DE26 JOB NOW UNION? (W-E)"                        format=f1.
      ER42431   LABEL="DE27 BELONG UNION? (WF-E)"                        format=f1.
      ER42432   LABEL="DE28A WTR JOB REQUIRES COMPUTER USE"              format=f1.
      ER42433   LABEL="DE29 SLRY/HRLY/OTR (W-E)"                         format=f1.
      ER42434   LABEL="DE30 SALARY AMOUNT"                               format=f10.2
      ER42435   LABEL="DE30 SALARY PER WHAT"                             format=f1.
      ER42436   LABEL="DE31 WTR SAL PD OT (WF-E)"                        format=f1.
      ER42437   LABEL="DE32 HOW PAID FOR OT"                             format=f1.
      ER42438   LABEL="DE32A EXACT OT PAY IF SALARIED"                   format=f10.2
      ER42439   LABEL="DE32A EXACT OT PAY PER"                           format=f1.
      ER42440   LABEL="DE33 HOURLY REGULAR RATE"                         format=f6.2
      ER42441   LABEL="DE34 OT DIFFERENTIAL 1ST"                         format=f1.
      ER42442   LABEL="DE34 OT DIFFERENTIAL 2ND"                         format=f1.
      ER42443   LABEL="DE34 OT DIFFERENTIAL 3RD"                         format=f1.
      ER42444   LABEL="DE34A EXACT OT PAY IF HOURLY"                     format=f10.2
      ER42445   LABEL="DE34A EXACT OT PAY PER"                           format=f1.
      ER42446   LABEL="DE36 AVG TIPS/COMM"                               format=f8.2
      ER42447   LABEL="DE36 TIPS/COMM PER WHAT"                          format=f1.
      ER42448   LABEL="DE37 AVG TIPS/COMM"                               format=f7.
      ER42449   LABEL="DE37 TIPS/COMM PER WHAT"                          format=f1.
      ER42450   LABEL="DE38 HOW PAID-OTR (WF-E)"                         format=f1.
      ER42451   LABEL="DE39 OT RATE"                                     format=f9.2
      ER42452   LABEL="DE41 YRS PRES EMP (W-E)"                          format=f2.
      ER42453   LABEL="DE41 MOS PRES EMP (W-E)"                          format=f2.
      ER42454   LABEL="DE41 WKS PRES EMP (W-E)"                          format=f2.
      ER42455   LABEL="DE43 HOURS/WEEK WORKED--JOB 1"                    format=f3.
      ER42456   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 1"               format=f1.
      ER42457   LABEL="DE44 WTR WORKED OT--JOB 1"                        format=f1.
      ER42458   LABEL="DE45 AMT OF OT WORKED--JOB 1"                     format=f4.
      ER42459   LABEL="DE45 OT TIME UNIT--JOB 1"                         format=f1.
      ER42460   LABEL="ACCURACY OF OT--WF JOB 1"                         format=f1.
      ER42461   LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 1"              format=f10.2
      ER42462   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 1"           format=f1.
      ER42463   LABEL="DE51 WHY LAST JOB END (WF-U)"                     format=f1.
      ER42464   LABEL="DE6 BEGINNING MONTH--JOB 2"                       format=f2.
      ER42465   LABEL="DE6 BEGINNING YEAR--JOB 2"                        format=f4.
      ER42466   LABEL="DE6 ENDING MONTH--JOB 2"                          format=f2.
      ER42467   LABEL="DE6 ENDING YEAR--JOB 2"                           format=f4.
      ER42468   LABEL="DE6 WTR EMPLOYED--JOB 2 JAN"                      format=f1.
      ER42469   LABEL="DE6 WTR EMPLOYED--JOB 2 FEB"                      format=f1.
      ER42470   LABEL="DE6 WTR EMPLOYED--JOB 2 MAR"                      format=f1.
      ER42471   LABEL="DE6 WTR EMPLOYED--JOB 2 APR"                      format=f1.
      ER42472   LABEL="DE6 WTR EMPLOYED--JOB 2 MAY"                      format=f1.
      ER42473   LABEL="DE6 WTR EMPLOYED--JOB 2 JUN"                      format=f1.
      ER42474   LABEL="DE6 WTR EMPLOYED--JOB 2 JUL"                      format=f1.
      ER42475   LABEL="DE6 WTR EMPLOYED--JOB 2 AUG"                      format=f1.
      ER42476   LABEL="DE6 WTR EMPLOYED--JOB 2 SEP"                      format=f1.
      ER42477   LABEL="DE6 WTR EMPLOYED--JOB 2 OCT"                      format=f1.
      ER42478   LABEL="DE6 WTR EMPLOYED--JOB 2 NOV"                      format=f1.
      ER42479   LABEL="DE6 WTR EMPLOYED--JOB 2 DEC"                      format=f1.
      ER42480   LABEL="DE20 MAIN OCC FOR JOB 2: 2000 CODE (WF)"          format=f3.
      ER42481   LABEL="DE21 MAIN IND FOR JOB 2: 2000 CODE (WF)"          format=f3.
      ER42482   LABEL="DE22 WORK SELF/OTR?--JOB 2"                       format=f1.
      ER42483   LABEL="DE23 CORP/UNCORP BUS--JOB 2"                      format=f1.
      ER42484   LABEL="DE24 WORK FOR GOVT?--JOB 2"                       format=f1.
      ER42485   LABEL="DE43 HOURS/WEEK WORKED--JOB 2"                    format=f3.
      ER42486   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 2"               format=f1.
      ER42487   LABEL="DE44 WTR WORKED OT--JOB 2"                        format=f1.
      ER42488   LABEL="DE45 AMT OF OT WORKED--JOB 2"                     format=f4.
      ER42489   LABEL="DE45 OT TIME UNIT--JOB 2"                         format=f1.
      ER42490   LABEL="ACCURACY OF OT--WF JOB 2"                         format=f1.
      ER42491   LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 2"              format=f10.2
      ER42492   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 2"           format=f1.
      ER42493   LABEL="DE51 WHY JOB ENDED--JOB 2"                        format=f1.
      ER42494   LABEL="DE6 BEGINNING MONTH--JOB 3"                       format=f2.
      ER42495   LABEL="DE6 BEGINNING YEAR--JOB 3"                        format=f4.
      ER42496   LABEL="DE6 ENDING MONTH--JOB 3"                          format=f2.
      ER42497   LABEL="DE6 ENDING YEAR--JOB 3"                           format=f4.
      ER42498   LABEL="DE6 WTR EMPLOYED--JOB 3 JAN"                      format=f1.
      ER42499   LABEL="DE6 WTR EMPLOYED--JOB 3 FEB"                      format=f1.
      ER42500   LABEL="DE6 WTR EMPLOYED--JOB 3 MAR"                      format=f1.
      ER42501   LABEL="DE6 WTR EMPLOYED--JOB 3 APR"                      format=f1.
      ER42502   LABEL="DE6 WTR EMPLOYED--JOB 3 MAY"                      format=f1.
      ER42503   LABEL="DE6 WTR EMPLOYED--JOB 3 JUN"                      format=f1.
      ER42504   LABEL="DE6 WTR EMPLOYED--JOB 3 JUL"                      format=f1.
      ER42505   LABEL="DE6 WTR EMPLOYED--JOB 3 AUG"                      format=f1.
      ER42506   LABEL="DE6 WTR EMPLOYED--JOB 3 SEP"                      format=f1.
      ER42507   LABEL="DE6 WTR EMPLOYED--JOB 3 OCT"                      format=f1.
      ER42508   LABEL="DE6 WTR EMPLOYED--JOB 3 NOV"                      format=f1.
      ER42509   LABEL="DE6 WTR EMPLOYED--JOB 3 DEC"                      format=f1.
      ER42510   LABEL="DE20 MAIN OCC FOR JOB 3: 2000 CODE (WF)"          format=f3.
      ER42511   LABEL="DE21 MAIN IND FOR JOB 3: 2000 CODE (WF)"          format=f3.
      ER42512   LABEL="DE22 WORK SELF/OTR?--JOB 3"                       format=f1.
      ER42513   LABEL="DE23 CORP/UNCORP BUS--JOB 3"                      format=f1.
      ER42514   LABEL="DE24 WORK FOR GOVT?--JOB 3"                       format=f1.
      ER42515   LABEL="DE43 HOURS/WEEK WORKED--JOB 3"                    format=f3.
      ER42516   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 3"               format=f1.
      ER42517   LABEL="DE44 WTR WORKED OT--JOB 3"                        format=f1.
      ER42518   LABEL="DE45 AMT OF OT WORKED--JOB 3"                     format=f4.
      ER42519   LABEL="DE45 OT TIME UNIT--JOB 3"                         format=f1.
      ER42520   LABEL="ACCURACY OF OT--WF JOB 3"                         format=f1.
      ER42521   LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 3"              format=f10.2
      ER42522   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 3"           format=f1.
      ER42523   LABEL="DE51 WHY JOB ENDED--JOB 3"                        format=f1.
      ER42524   LABEL="DE6 BEGINNING MONTH--JOB 4"                       format=f2.
      ER42525   LABEL="DE6 BEGINNING YEAR--JOB 4"                        format=f4.
      ER42526   LABEL="DE6 ENDING MONTH--JOB 4"                          format=f2.
      ER42527   LABEL="DE6 ENDING YEAR--JOB 4"                           format=f4.
      ER42528   LABEL="DE6 WTR EMPLOYED--JOB 4 JAN"                      format=f1.
      ER42529   LABEL="DE6 WTR EMPLOYED--JOB 4 FEB"                      format=f1.
      ER42530   LABEL="DE6 WTR EMPLOYED--JOB 4 MAR"                      format=f1.
      ER42531   LABEL="DE6 WTR EMPLOYED--JOB 4 APR"                      format=f1.
      ER42532   LABEL="DE6 WTR EMPLOYED--JOB 4 MAY"                      format=f1.
      ER42533   LABEL="DE6 WTR EMPLOYED--JOB 4 JUN"                      format=f1.
      ER42534   LABEL="DE6 WTR EMPLOYED--JOB 4 JUL"                      format=f1.
      ER42535   LABEL="DE6 WTR EMPLOYED--JOB 4 AUG"                      format=f1.
      ER42536   LABEL="DE6 WTR EMPLOYED--JOB 4 SEP"                      format=f1.
      ER42537   LABEL="DE6 WTR EMPLOYED--JOB 4 OCT"                      format=f1.
      ER42538   LABEL="DE6 WTR EMPLOYED--JOB 4 NOV"                      format=f1.
      ER42539   LABEL="DE6 WTR EMPLOYED--JOB 4 DEC"                      format=f1.
      ER42540   LABEL="DE20 MAIN OCC FOR JOB 4: 2000 CODE (WF)"          format=f3.
      ER42541   LABEL="DE21 MAIN IND FOR JOB 4: 2000 CODE (WF)"          format=f3.
      ER42542   LABEL="DE22 WORK SELF/OTR?--JOB 4"                       format=f1.
      ER42543   LABEL="DE23 CORP/UNCORP BUS--JOB 4"                      format=f1.
      ER42544   LABEL="DE24 WORK FOR GOVT?--JOB 4"                       format=f1.
      ER42545   LABEL="DE43 HOURS/WEEK WORKED--JOB 4"                    format=f3.
      ER42546   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 4"               format=f1.
      ER42547   LABEL="DE44 WTR WORKED OT--JOB 4"                        format=f1.
      ER42548   LABEL="DE45 AMT OF OT WORKED--JOB 4"                     format=f4.
      ER42549   LABEL="DE45 OT TIME UNIT--JOB 4"                         format=f1.
      ER42550   LABEL="ACCURACY OF OT--WF JOB 4"                         format=f1.
      ER42551   LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 4"              format=f10.2
      ER42552   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 4"           format=f1.
      ER42553   LABEL="DE51 WHY JOB ENDED--JOB 4"                        format=f1.
      ER42554   LABEL="NUMBER OF ADDITIONAL JOBS--WF"                    format=f1.
      ER42555   LABEL="DE10 WTR OTRS ILL (WF)"                           format=f1.
      ER42556   LABEL="DE10 DAYS OTHERS SICK"                            format=f3.
      ER42557   LABEL="ACCURACY OF DAYS OTRS SICK (WF)"                  format=f1.
      ER42558   LABEL="DE10 WEEKS OTHERS SICK"                           format=f2.
      ER42559   LABEL="ACCURACY OF WEEKS OTRS SICK (WF)"                 format=f1.
      ER42560   LABEL="DE10 MONTHS OTHERS SICK"                          format=f2.
      ER42561   LABEL="ACCURACY OF MONTHS OTRS SICK (WF)"                format=f1.
      ER42562   LABEL="DE11 WTR SELF ILL (WF)"                           format=f1.
      ER42563   LABEL="DE11 DAYS SELF SICK"                              format=f3.
      ER42564   LABEL="ACCURACY OF DAYS SELF ILL (WF)"                   format=f1.
      ER42565   LABEL="DE11 WEEKS SELF SICK"                             format=f2.
      ER42566   LABEL="ACCURACY OF WEEKS SELF ILL (WF)"                  format=f1.
      ER42567   LABEL="DE11 MONTHS SELF SICK"                            format=f2.
      ER42568   LABEL="ACCURACY OF MONTHS SELF ILL (WF)"                 format=f1.
      ER42569   LABEL="DE12 WTR VACATION (WF)"                           format=f1.
      ER42570   LABEL="DE12 DAYS VACATION"                               format=f3.
      ER42571   LABEL="ACCURACY OF DAYS VACATION (WF)"                   format=f1.
      ER42572   LABEL="DE12 WEEKS VACATION"                              format=f2.
      ER42573   LABEL="ACCURACY OF WEEKS VACATION (WF)"                  format=f1.
      ER42574   LABEL="DE12 MONTHS VACATION"                             format=f2.
      ER42575   LABEL="ACCURACY OF MONTHS VACATION (WF)"                 format=f1.
      ER42576   LABEL="DE13 WTR STRIKE (WF)"                             format=f1.
      ER42577   LABEL="DE13 DAYS STRIKE"                                 format=f3.
      ER42578   LABEL="ACCURACY OF STRIKE DAYS (WF)"                     format=f1.
      ER42579   LABEL="DE13 WEEKS STRIKE"                                format=f2.
      ER42580   LABEL="ACCURACY OF STRIKE WEEKS (WF)"                    format=f1.
      ER42581   LABEL="DE13 MONTHS STRIKE"                               format=f2.
      ER42582   LABEL="ACCURACY OF STRIKE MONTHS (WF)"                   format=f1.
      ER42583   LABEL="DE14 WTR LAID OFF (WF)"                           format=f1.
      ER42584   LABEL="DE14 DAYS LAID OFF"                               format=f3.
      ER42585   LABEL="ACCURACY OF DAYS LAID OFF (WF)"                   format=f1.
      ER42586   LABEL="DE14 WEEKS LAID OFF"                              format=f2.
      ER42587   LABEL="ACCURACY OF WEEKS LAID OFF (WF)"                  format=f1.
      ER42588   LABEL="DE14 MONTHS LAID OFF"                             format=f2.
      ER42589   LABEL="ACCURACY OF MONTHS LAID OFF (WF)"                 format=f1.
      ER42590   LABEL="DE8 WTR UNEMPLOYED(WF)"                           format=f1.
      ER42591   LABEL="DE8 DAYS UNEMPLOYED"                              format=f3.
      ER42592   LABEL="ACCURACY OF DAYS UNEMPLOYED (WF)"                 format=f1.
      ER42593   LABEL="DE8 WEEKS UNEMPLOYED"                             format=f2.
      ER42594   LABEL="ACCURACY OF WEEKS UNEMPLOYED (WF)"                format=f1.
      ER42595   LABEL="DE8 MONTHS UNEMPLOYED"                            format=f2.
      ER42596   LABEL="ACCURACY OF MONTHS UNEMPLOYED (WF)"               format=f1.
      ER42597   LABEL="DE8 WTR UNEMPLOYED JAN"                           format=f1.
      ER42598   LABEL="DE8 WTR UNEMPLOYED FEB"                           format=f1.
      ER42599   LABEL="DE8 WTR UNEMPLOYED MAR"                           format=f1.
      ER42600   LABEL="DE8 WTR UNEMPLOYED APR"                           format=f1.
      ER42601   LABEL="DE8 WTR UNEMPLOYED MAY"                           format=f1.
      ER42602   LABEL="DE8 WTR UNEMPLOYED JUN"                           format=f1.
      ER42603   LABEL="DE8 WTR UNEMPLOYED JUL"                           format=f1.
      ER42604   LABEL="DE8 WTR UNEMPLOYED AUG"                           format=f1.
      ER42605   LABEL="DE8 WTR UNEMPLOYED SEP"                           format=f1.
      ER42606   LABEL="DE8 WTR UNEMPLOYED OCT"                           format=f1.
      ER42607   LABEL="DE8 WTR UNEMPLOYED NOV"                           format=f1.
      ER42608   LABEL="DE8 WTR UNEMPLOYED DEC"                           format=f1.
      ER42609   LABEL="DE7 WTR OUT LAB FRC(W)"                           format=f1.
      ER42610   LABEL="DE7 DAYS OUT OF LAB FORCE"                        format=f3.
      ER42611   LABEL="ACCURACY OF DAYS OUT OF LAB FORCE (WF)"           format=f1.
      ER42612   LABEL="DE7WEEKS OUT LABOR FORCE"                         format=f2.
      ER42613   LABEL="ACCURACY OF WKS OUT OF LAB FORCE (WF)"            format=f1.
      ER42614   LABEL="DE7 MONTHS OUT LABR FORCE"                        format=f2.
      ER42615   LABEL="ACCURACY OF MOS OUT OF LAB FORCE (WF)"            format=f1.
      ER42616   LABEL="DE7 WTR OUT LAB FORC JAN"                         format=f1.
      ER42617   LABEL="DE7 WTR OUT LAB FORC FEB"                         format=f1.
      ER42618   LABEL="DE7 WTR OUT LAB FORC MAR"                         format=f1.
      ER42619   LABEL="DE7 WTR OUT LAB FORC APR"                         format=f1.
      ER42620   LABEL="DE7 WTR OUT LAB FORC MAY"                         format=f1.
      ER42621   LABEL="DE7 WTR OUT LAB FORC JUN"                         format=f1.
      ER42622   LABEL="DE7 WTR OUT LAB FORC JUL"                         format=f1.
      ER42623   LABEL="DE7 WTR OUT LAB FORC AUG"                         format=f1.
      ER42624   LABEL="DE7 WTR OUT LAB FORC SEP"                         format=f1.
      ER42625   LABEL="DE7 WTR OUT LAB FORC OCT"                         format=f1.
      ER42626   LABEL="DE7 WTR OUT LAB FORC NOV"                         format=f1.
      ER42627   LABEL="DE7 WTR OUT LAB FORC DEC"                         format=f1.
      ER42628   LABEL="DE62 WTR EVER WORKED"                             format=f1.
      ER42629   LABEL="DE63 MO LAST WORKED"                              format=f2.
      ER42630   LABEL="DE63 YR LAST WORKED"                              format=f4.
      ER42631   LABEL="DE64 WTR LOOKING FOR JOB"                         format=f1.
      ER42632   LABEL="DE65 WTR PUBLIC EMP AGENCY (WF)"                  format=f1.
      ER42633   LABEL="DE65 WTR PRIVATE EMP AGENCY (WF)"                 format=f1.
      ER42634   LABEL="DE65 WTR CHKD W/CURRENT EMP (WF)"                 format=f1.
      ER42635   LABEL="DE65 WTR CHKD W/OTHER EMP (WF)"                   format=f1.
      ER42636   LABEL="DE65 WTR CHKD W/FRIEND OR REL (WF)"               format=f1.
      ER42637   LABEL="DE65 WTR PLACED OR ANSWERED ADS (WF)"             format=f1.
      ER42638   LABEL="DE65 WTR OTHER ACTIVITY (WF)"                     format=f1.
      ER42639   LABEL="DE65 WTR DONE NOTHING (WF)"                       format=f1.
      ER42640   LABEL="DE67 YRS LOOK WRK (W-U)"                          format=f2.
      ER42641   LABEL="DE67 MOS LOOK WRK (W-U)"                          format=f2.
      ER42642   LABEL="DE67 WKS LOOK WRK (W-U)"                          format=f2.
      ER42643   LABEL="F1 CKPT:TYPE HD+WF"                               format=f1.
      ER42644   LABEL="F2 HOUSEWORK HRS-WIFE"                            format=f3.
      ER42645   LABEL="ACCURACY OF WF HOUSEWORK HRS"                     format=f1.
      ER42646   LABEL="F3 HOUSEWORK HOURS-HEAD"                          format=f3.
      ER42647   LABEL="ACCURACY OF HD HOUSEWORK HRS"                     format=f1.
      ER42648   LABEL="F5 FAM TOGETHR MAIN MEAL"                         format=f1.
      ER42649   LABEL="F6 CKPT: WTR CHILD 5-18 IN FU LAST YEAR"          format=f1.
      ER42650   LABEL="F6A WTR CH REC FREE/LOW LUNCH LAST YR"            format=f1.
      ER42651   LABEL="F6B WTR CH REC FREE/LOW BKFST LAST YR"            format=f1.
      ER42652   LABEL="F6D COST CHILD CARE LAST YEAR"                    format=f6.
      ER42653   LABEL="F6D CHILD CARE COST PER"                          format=f1.
      ER42654   LABEL="F6D2 WTR PAID FOR CHILD CARE JAN LAST YR"         format=f1.
      ER42655   LABEL="F6D2 WTR PAID FOR CHILD CARE FEB LAST YR"         format=f1.
      ER42656   LABEL="F6D2 WTR PAID FOR CHILD CARE MAR LAST YR"         format=f1.
      ER42657   LABEL="F6D2 WTR PAID FOR CHILD CARE APR LAST YR"         format=f1.
      ER42658   LABEL="F6D2 WTR PAID FOR CHILD CARE MAY LAST YR"         format=f1.
      ER42659   LABEL="F6D2 WTR PAID FOR CHILD CARE JUN LAST YR"         format=f1.
      ER42660   LABEL="F6D2 WTR PAID FOR CHILD CARE JUL LAST YR"         format=f1.
      ER42661   LABEL="F6D2 WTR PAID FOR CHILD CARE AUG LAST YR"         format=f1.
      ER42662   LABEL="F6D2 WTR PAID FOR CHILD CARE SEP LAST YR"         format=f1.
      ER42663   LABEL="F6D2 WTR PAID FOR CHILD CARE OCT LAST YR"         format=f1.
      ER42664   LABEL="F6D2 WTR PAID FOR CHILD CARE NOV LAST YR"         format=f1.
      ER42665   LABEL="F6D2 WTR PAID FOR CHILD CARE DEC LAST YR"         format=f1.
      ER42666   LABEL="F6E WTR CHILD IN DAY CARE CNTR LAST YR"           format=f1.
      ER42667   LABEL="F6F WTR MEALS/SNACKS PROVIDED TO CHILD"           format=f1.
      ER42668   LABEL="F6G WTR DAY CARE IN CHILD/ADULT FOOD PGM"         format=f1.
      ER42669   LABEL="F6H FU FEMALE 15-45/CHILD <5 LAST YR"             format=f1.
      ER42670   LABEL="F6I WTR RECD FOOD THROUGH WIC PROGRAM"            format=f1.
      ER42671   LABEL="F7 WTR ADULT IN ADULT DAY CARE PREV YR"           format=f1.
      ER42672   LABEL="F7A AMT PAID FOR ADULT DAY CARE"                  format=f6.
      ER42673   LABEL="F7B WTR FU MEMBER 60+ LAST YR"                    format=f1.
      ER42674   LABEL="F7C WTR RECD FREE/REDUCD MEALS LAST YR"           format=f1.
      ER42675   LABEL="F8 WTR USED FOOD STAMPS 2 YRS AGO"                format=f1.
      ER42676   LABEL="F9 VALUE OF FOOD STAMPS 2 YRS AGO"                format=f6.
      ER42677   LABEL="F9 TIME UNIT-VALUE FOOD STAMPS 2 YRS AGO"         format=f1.
      ER42678   LABEL="ACCURACY OF FOOD STAMPS 2 YEARS AGO"              format=f1.
      ER42679   LABEL="F10 WTR RECVD FOOD STAMPS JAN 2 YRS AGO"          format=f1.
      ER42680   LABEL="F10 WTR RECVD FOOD STAMPS FEB 2 YRS AGO"          format=f1.
      ER42681   LABEL="F10 WTR RECVD FOOD STAMPS MAR 2 YRS AGO"          format=f1.
      ER42682   LABEL="F10 WTR RECVD FOOD STAMPS APR 2 YRS AGO"          format=f1.
      ER42683   LABEL="F10 WTR RECVD FOOD STAMPS MAY 2 YRS AGO"          format=f1.
      ER42684   LABEL="F10 WTR RECVD FOOD STAMPS JUN 2 YRS AGO"          format=f1.
      ER42685   LABEL="F10 WTR RECVD FOOD STAMPS JUL 2 YRS AGO"          format=f1.
      ER42686   LABEL="F10 WTR RECVD FOOD STAMPS AUG 2 YRS AGO"          format=f1.
      ER42687   LABEL="F10 WTR RECVD FOOD STAMPS SEP 2 YRS AGO"          format=f1.
      ER42688   LABEL="F10 WTR RECVD FOOD STAMPS OCT 2 YRS AGO"          format=f1.
      ER42689   LABEL="F10 WTR RECVD FOOD STAMPS NOV 2 YRS AGO"          format=f1.
      ER42690   LABEL="F10 WTR RECVD FOOD STAMPS DEC 2 YRS AGO"          format=f1.
      ER42691   LABEL="F11 WTR RECEIVED FOOD STAMPS LAST YEAR"           format=f1.
      ER42692   LABEL="F12 VALUE OF FOOD STAMPS LAST YEAR"               format=f6.
      ER42693   LABEL="F12 TIME UNIT-VALUE FOOD STAMPS LAST YR"          format=f1.
      ER42694   LABEL="ACCURACY OF FOOD STAMPS LAST YEAR"                format=f1.
      ER42695   LABEL="F13 WTR RECVD FOOD STAMPS JAN LAST YEAR"          format=f1.
      ER42696   LABEL="F13 WTR RECVD FOOD STAMPS FEB LAST YEAR"          format=f1.
      ER42697   LABEL="F13 WTR RECVD FOOD STAMPS MAR LAST YEAR"          format=f1.
      ER42698   LABEL="F13 WTR RECVD FOOD STAMPS APR LAST YEAR"          format=f1.
      ER42699   LABEL="F13 WTR RECVD FOOD STAMPS MAY LAST YEAR"          format=f1.
      ER42700   LABEL="F13 WTR RECVD FOOD STAMPS JUN LAST YEAR"          format=f1.
      ER42701   LABEL="F13 WTR RECVD FOOD STAMPS JUL LAST YEAR"          format=f1.
      ER42702   LABEL="F13 WTR RECVD FOOD STAMPS AUG LAST YEAR"          format=f1.
      ER42703   LABEL="F13 WTR RECVD FOOD STAMPS SEP LAST YEAR"          format=f1.
      ER42704   LABEL="F13 WTR RECVD FOOD STAMPS OCT LAST YEAR"          format=f1.
      ER42705   LABEL="F13 WTR RECVD FOOD STAMPS NOV LAST YEAR"          format=f1.
      ER42706   LABEL="F13 WTR RECVD FOOD STAMPS DEC LAST YEAR"          format=f1.
      ER42707   LABEL="F14 WTR RECEIVED FOOD STAMPS LAST MONTH"          format=f1.
      ER42708   LABEL="F15 # FU MEMBERS RECEIVED FOOD STAMPS"            format=f1.
      ER42709   LABEL="F16 VALUE OF FOOD STAMPS RECD LAST MONTH"         format=f6.
      ER42710   LABEL="ACCURACY OF FOOD STAMPS LAST MONTH"               format=f1.
      ER42711   LABEL="F17 WTR BUY FOOD TO USE AT HOME"                  format=f1.
      ER42712   LABEL="F18 REPORTED COST OF FOOD AT HOME"                format=f8.2
      ER42713   LABEL="F18 COST OF FOOD AT HOME PER"                     format=f1.
      ER42714   LABEL="ACCURACY OF FOOD AT HOME-RECD FD STAMPS"          format=f1.
      ER42715   LABEL="F19 WTR FOOD DELIVERED TO HOME"                   format=f1.
      ER42716   LABEL="F20 COST OF DELIVERED FOOD"                       format=f8.2
      ER42717   LABEL="F20 COST OF DELIVERED FOOD PER"                   format=f1.
      ER42718   LABEL="ACCURACY OF DELIVERD FOOD-RECD FD STAMPS"         format=f1.
      ER42719   LABEL="F21 COST OF FOOD EATEN OUT"                       format=f8.2
      ER42720   LABEL="F21 COST OF FOOD EATEN OUT PER"                   format=f1.
      ER42721   LABEL="ACCURACY OF FOOD EATN OUT-RECD FD STAMPS"         format=f1.
      ER42722   LABEL="F22 REPORTED COST OF FOOD AT HOME"                format=f8.2
      ER42723   LABEL="F22 COST OF FOOD AT HOME PER"                     format=f1.
      ER42724   LABEL="ACCURACY OF FOOD AT HOME-NO FD STAMPS"            format=f1.
      ER42725   LABEL="F23 WTR FOOD DELIVERED TO HOME"                   format=f1.
      ER42726   LABEL="F24 COST OF DELIVERED FOOD"                       format=f8.2
      ER42727   LABEL="F24 COST OF DELIVERED FOOD PER"                   format=f1.
      ER42728   LABEL="ACCURACY OF DELIVERED FOOD-NO FD STAMPS"          format=f1.
      ER42729   LABEL="F25 COST OF FOOD EATEN OUT"                       format=f8.2
      ER42730   LABEL="F25 COST OF FOOD EATEN OUT PER"                   format=f1.
      ER42731   LABEL="ACCURACY OF FOOD EATEN OUT-NO FD STAMPS"          format=f1.
      ER42732   LABEL="F47 WTR HAVE VEHICLE"                             format=f1.
      ER42733   LABEL="F48 NUMBER OF VEHICLES"                           format=f2.
      ER42734   LABEL="F49 MANUFACTURER CODE #1"                         format=f2.
      ER42735   LABEL="F49 VEHICLE MAKE CODE #1"                         format=f2.
      ER42736   LABEL="F49 VEHICLE MODEL YEAR #1"                        format=f4.
      ER42737   LABEL="F49 VEHICLE TYPE CODE #1"                         format=f1.
      ER42738   LABEL="F53 HOW ACQUIRED #1"                              format=f1.
      ER42739   LABEL="F54 WTR NEW OR USED #1"                           format=f1.
      ER42740   LABEL="F55 YR ACQUIRED #1"                               format=f4.
      ER42741   LABEL="F57 WTR USED FOR BUSINESS #1"                     format=f1.
      ER42742   LABEL="F58 WTR USED MOSTLY FOR BUSINESS #1"              format=f1.
      ER42743   LABEL="F60 WTR OWN/LEASE >3 YR OLD VEHICLE #1"           format=f1.
      ER42744   LABEL="F61 TOTAL PRICE #1"                               format=f6.
      ER42745   LABEL="F64 CASH DOWNPMT AMT #1"                          format=f6.
      ER42746   LABEL="F65 WTR GOT LOAN #1"                              format=f1.
      ER42747   LABEL="F66 LOAN AMOUNT #1"                               format=f6.
      ER42748   LABEL="F67 LOAN PAYMENT AMT #1"                          format=f6.
      ER42749   LABEL="F67 LOAN PMT AMT PER #1"                          format=f1.
      ER42750   LABEL="F69 LOAN TOTAL # PMTS #1"                         format=f3.
      ER42751   LABEL="F70 LOAN # PMTS MADE #1"                          format=f3.
      ER42752   LABEL="F71 LEASE INITIAL OUTLAY #1"                      format=f6.
      ER42753   LABEL="F72 LEASE PMT AMOUNT #1"                          format=f6.
      ER42754   LABEL="F72 LEASE AMOUNT PER #1"                          format=f1.
      ER42755   LABEL="F73 LEASE TOTAL # PMTS #1"                        format=f3.
      ER42756   LABEL="F74 LEASE # PMTS MADE #1"                         format=f3.
      ER42757   LABEL="F49 MANUFACTURER CODE #2"                         format=f2.
      ER42758   LABEL="F49 VEHICLE MAKE CODE #2"                         format=f2.
      ER42759   LABEL="F49 VEHICLE MODEL YEAR #2"                        format=f4.
      ER42760   LABEL="F49 VEHICLE TYPE CODE #2"                         format=f1.
      ER42761   LABEL="F53 HOW ACQUIRED #2"                              format=f1.
      ER42762   LABEL="F54 WTR NEW OR USED #2"                           format=f1.
      ER42763   LABEL="F55 YR ACQUIRED #2"                               format=f4.
      ER42764   LABEL="F57 WTR USED FOR BUSINESS #2"                     format=f1.
      ER42765   LABEL="F58 WTR MOSTLY FOR BUSINESS #2"                   format=f1.
      ER42766   LABEL="F60 CKPT: WTR OWN >3 YR OLD VEHICLE #2"           format=f1.
      ER42767   LABEL="F61 TOTAL PRICE #2"                               format=f6.
      ER42768   LABEL="F64 CASH DOWNPMT AMT #2"                          format=f6.
      ER42769   LABEL="F65 WTR GOT LOAN #2"                              format=f1.
      ER42770   LABEL="F66 LOAN AMOUNT #2"                               format=f6.
      ER42771   LABEL="F67 LOAN PAYMENT AMT #2"                          format=f6.
      ER42772   LABEL="F67 LOAN PMT AMT PER #2"                          format=f1.
      ER42773   LABEL="F69 LOAN TOT # PMTS #2"                           format=f3.
      ER42774   LABEL="F70 LOAN # PMTS MADE #2"                          format=f3.
      ER42775   LABEL="F71 LEASE INITIAL OUTLAY #2"                      format=f6.
      ER42776   LABEL="F72 LEASE PMT AMOUNT #2"                          format=f6.
      ER42777   LABEL="F72 LEASE AMOUNT PER #2"                          format=f1.
      ER42778   LABEL="F73 LEASE TOTAL # PMTS #2"                        format=f3.
      ER42779   LABEL="F74 LEASE # PMTS MADE #2"                         format=f3.
      ER42780   LABEL="F49 MANUFACTURER CODE #3"                         format=f2.
      ER42781   LABEL="F49 VEHICLE MAKE CODE #3"                         format=f2.
      ER42782   LABEL="F49 VEHICLE MODEL YEAR #3"                        format=f4.
      ER42783   LABEL="F49 VEHICLE TYPE CODE #3"                         format=f1.
      ER42784   LABEL="F53 HOW ACQUIRED #3"                              format=f1.
      ER42785   LABEL="F54 WTR NEW OR USED #3"                           format=f1.
      ER42786   LABEL="F55 YR ACQUIRED #3"                               format=f4.
      ER42787   LABEL="F57 WTR USED FOR BUSINESS #3"                     format=f1.
      ER42788   LABEL="F58 WTR MOSTLY FOR BUSINESS #3"                   format=f1.
      ER42789   LABEL="F60 CKPT: WTR OWN >3 YR OLD VEHICLE #3"           format=f1.
      ER42790   LABEL="F61 TOTAL PRICE #3"                               format=f6.
      ER42791   LABEL="F64 CASH DOWNPMT AMT #3"                          format=f6.
      ER42792   LABEL="F65 WTR GOT LOAN #3"                              format=f1.
      ER42793   LABEL="F66 LOAN AMOUNT #3"                               format=f6.
      ER42794   LABEL="F67 LOAN PAYMENT AMT #3"                          format=f6.
      ER42795   LABEL="F67 LOAN PMT AMT PER #3"                          format=f1.
      ER42796   LABEL="F69 LOAN TOTAL # PMTS #3"                         format=f3.
      ER42797   LABEL="F70 LOAN # PMTS MADE #3"                          format=f3.
      ER42798   LABEL="F71 LEASE INITIAL OUTLAY #3"                      format=f6.
      ER42799   LABEL="F72 LEASE PMT AMOUNT #3"                          format=f6.
      ER42800   LABEL="F72 LEASE AMOUNT PER #3"                          format=f1.
      ER42801   LABEL="F73 LEASE TOTAL # PMTS #3"                        format=f3.
      ER42802   LABEL="F74 LEASE # PMTS MADE #3"                         format=f3.
      ER42803   LABEL="F77 CAR INSURANCE EXPENSE"                        format=f6.
      ER42804   LABEL="F77 CAR INSURANCE PER"                            format=f1.
      ER42805   LABEL="F78CKPT WTR OTR VEHICLES"                         format=f1.
      ER42806   LABEL="F79 ADDL CAR/LEASE PMTS"                          format=f6.
      ER42807   LABEL="F80A CAR REPAIR EXPENSES"                         format=f5.
      ER42808   LABEL="F80B GASOLINE EXPENSES"                           format=f5.
      ER42809   LABEL="F80C PARKING EXPENSES"                            format=f5.
      ER42810   LABEL="F81A BUS/TRAIN FARES"                             format=f5.
      ER42811   LABEL="F81B CAB FARE EXPENSES"                           format=f5.
      ER42812   LABEL="F81C OTR TRANSP EXPENSES"                         format=f5.
      ER42813   LABEL="F82 WTR SCHOOL EXPENSES"                          format=f1.
      ER42814   LABEL="F83 TOTAL SCHOOL EXPENSES"                        format=f6.
      ER42815   LABEL="F84 WTR OTR SCHOOL EXPENSES"                      format=f1.
      ER42816   LABEL="F86 TOTAL OTR SCHOOL EXPENSES"                    format=f6.
      ER42817   LABEL="F87 COST OF HOME REPAIRS LAST YEAR"               format=f6.
      ER42818   LABEL="F87 TIME UNIT FOR HOME REPAIRS"                   format=f1.
      ER42819   LABEL="F87A WTR $400 OR MORE"                            format=f1.
      ER42820   LABEL="F87B WTR $1000 OR MORE"                           format=f1.
      ER42821   LABEL="F87C WTR $100 OR MORE"                            format=f1.
      ER42822   LABEL="F88 COST OF HHOLD FURNISHINGS LAST YEAR"          format=f6.
      ER42823   LABEL="F88 TIME UNIT FOR HHOLD FURNISHINGS"              format=f1.
      ER42824   LABEL="F88A WTR $500 OR MORE"                            format=f1.
      ER42825   LABEL="F88B WTR $1500 OR MORE"                           format=f1.
      ER42826   LABEL="F88C WTR $100 OR MORE"                            format=f1.
      ER42827   LABEL="F89 COST OF CLOTHING LAST YEAR"                   format=f6.
      ER42828   LABEL="F89 TIME UNIT FOR CLOTHING"                       format=f1.
      ER42829   LABEL="F89A WTR $700 OR MORE"                            format=f1.
      ER42830   LABEL="F89B WTR$1500 OR MORE"                            format=f1.
      ER42831   LABEL="F89C WTR $200 OR MORE"                            format=f1.
      ER42832   LABEL="F90 COST OF TRIPS, VACATIONS LAST YEAR"           format=f6.
      ER42833   LABEL="F90 TIME UNIT FOR TRIPS, VACATIONS"               format=f1.
      ER42834   LABEL="F90A WTR $500 OR MORE"                            format=f1.
      ER42835   LABEL="F90B WTR $1500 OR MORE"                           format=f1.
      ER42836   LABEL="F90C WTR $200 OR MORE"                            format=f1.
      ER42837   LABEL="F91 COST OF OTR RECREATION LAST YEAR"             format=f6.
      ER42838   LABEL="F91 TIME UNIT FOR OTR RECREATON"                  format=f1.
      ER42839   LABEL="F91A WTR $500 OR MORE"                            format=f1.
      ER42840   LABEL="F91B WTR $1500 OR MORE"                           format=f1.
      ER42841   LABEL="F91C WTR $200 OR MORE"                            format=f1.
      ER42842   LABEL="G1A WHETHER HEAD FARMER"                          format=f1.
      ER42843   LABEL="G2 TOTAL FARM RECEIPTS"                           format=f7.
      ER42844   LABEL="G3 PYR FARM EXPENSES"                             format=f7.
      ER42845   LABEL="G4 PYR NET FARM INCOME"                           format=f7.
      ER42846   LABEL="ACCURACY OF FARM INCOME"                          format=f1.
      ER42847   LABEL="G5 WHETHER BUSINESS"                              format=f1.
      ER42848   LABEL="G7A 2-DIGIT INDUSTRY-BUS 1"                       format=f2.
      ER42849   LABEL="G8 HEAD OWN BUSINESS 1?"                          format=f1.
      ER42850   LABEL="G8 WIFE OWN BUSINESS 1?"                          format=f1.
      ER42851   LABEL="G8OTR RELATIVE OWN BUS1?"                         format=f1.
      ER42852   LABEL="G8OTHER PERSON OWN BUS1?"                         format=f1.
      ER42853   LABEL="HEAD WORK IN BUSINESS 1"                          format=f2.
      ER42854   LABEL="HEAD REPORT HRS BUSNS 1"                          format=f2.
      ER42855   LABEL="WIFE WORK IN BUSINESS 1"                          format=f2.
      ER42856   LABEL="WIFE REPORT HRS BUSNS 1"                          format=f2.
      ER42857   LABEL="G10 CORP/UNINCORP BUS1"                           format=f1.
      ER42858   LABEL="G11 GROSS RECEIPTS BUS1"                          format=f7.
      ER42859   LABEL="G11A EXPENSES BUS 1"                              format=f7.
      ER42860   LABEL="G11B PROFIT/LOSS BUS 1"                           format=f7.
      ER42861   LABEL="ACCURACY OF BUSINESS1 PROFIT/LOSS"                format=f1.
      ER42862   LABEL="G7A 2-DIGIT INDUSTRY-BUS 2"                       format=f2.
      ER42863   LABEL="G8 HEAD OWN BUSINESS 2?"                          format=f1.
      ER42864   LABEL="G8 WIFE OWN BUSINESS 2?"                          format=f1.
      ER42865   LABEL="G8OTR RELATIVE OWN BUS2?"                         format=f1.
      ER42866   LABEL="G8OTHER PERSON OWN BUS2?"                         format=f1.
      ER42867   LABEL="HEAD WORK IN BUSINESS 2"                          format=f2.
      ER42868   LABEL="HEAD REPORT HRS BUSNS 2"                          format=f2.
      ER42869   LABEL="WIFE WORK IN BUSINESS 2"                          format=f2.
      ER42870   LABEL="WIFE REPORT HRS BUSNS 2"                          format=f2.
      ER42871   LABEL="G10 CORP/UNINCORP BUS2"                           format=f1.
      ER42872   LABEL="G11 GROSS RECEIPTS BUS 2"                         format=f7.
      ER42873   LABEL="G11A EXPENSES BUS 2"                              format=f7.
      ER42874   LABEL="G11B PROFIT/LOSS BUS 2"                           format=f7.
      ER42875   LABEL="ACCURACY OF BUSINESS2 PROFIT/LOSS"                format=f1.
      ER42876   LABEL="G7A 2-DIGIT INDUSTRY-BUS 3"                       format=f2.
      ER42877   LABEL="G8 HEAD OWN BUSINESS 3?"                          format=f1.
      ER42878   LABEL="G8 WIFE OWN BUSINESS 3?"                          format=f1.
      ER42879   LABEL="G8OTR RELATIVE OWN BUS3?"                         format=f1.
      ER42880   LABEL="G8OTHER PERSON OWN BUS3?"                         format=f1.
      ER42881   LABEL="HEAD WORK IN BUSINESS 3"                          format=f2.
      ER42882   LABEL="HEAD REPORT HRS BUSNS 3"                          format=f2.
      ER42883   LABEL="WIFE WORK IN BUSINESS 3"                          format=f2.
      ER42884   LABEL="WIFE REPORT HRS BUSNS 3"                          format=f2.
      ER42885   LABEL="G10 CORP/UNINCORP BUS3"                           format=f1.
      ER42886   LABEL="G11 GROSS RECEIPTS BUS 3"                         format=f7.
      ER42887   LABEL="G11A EXPENSES BUS 3"                              format=f7.
      ER42888   LABEL="G11B PROFIT/LOSS BUS 3"                           format=f7.
      ER42889   LABEL="ACCURACY OF BUSINESS3 PROFIT/LOSS"                format=f1.
      ER42890   LABEL="G7A 2-DIGIT INDUSTRY-BUS 4"                       format=f2.
      ER42891   LABEL="G8 HEAD OWN BUSINESS 4?"                          format=f1.
      ER42892   LABEL="G8 WIFE OWN BUSINESS 4?"                          format=f1.
      ER42893   LABEL="G8OTR RELATIVE OWN BUS4?"                         format=f1.
      ER42894   LABEL="G8OTHER PERSON OWN BUS4?"                         format=f1.
      ER42895   LABEL="HEAD WORK IN BUSINESS 4"                          format=f2.
      ER42896   LABEL="HEAD REPORT HRS BUSNS 4"                          format=f2.
      ER42897   LABEL="WIFE WORK IN BUSINESS 4"                          format=f2.
      ER42898   LABEL="WIFE REPORT HRS BUSNS 4"                          format=f2.
      ER42899   LABEL="G10 CORP/UNINCORP BUS4"                           format=f1.
      ER42900   LABEL="G11 GROSS RECEIPTS BUS 4"                         format=f7.
      ER42901   LABEL="G11A EXPENSES BUS 4"                              format=f7.
      ER42902   LABEL="G11B PROFIT/LOSS BUS 4"                           format=f7.
      ER42903   LABEL="ACCURACY OF BUSINESS4 PROFIT/LOSS"                format=f1.
      ER42904   LABEL="G7A 2-DIGIT INDUSTRY-BUS 5"                       format=f2.
      ER42905   LABEL="G8 HEAD OWN BUSINESS 5?"                          format=f1.
      ER42906   LABEL="G8 WIFE OWN BUSINESS 5?"                          format=f1.
      ER42907   LABEL="G8OTR RELATIVE OWN BUS5?"                         format=f1.
      ER42908   LABEL="G8OTHER PERSON OWN BUS5?"                         format=f1.
      ER42909   LABEL="HEAD WORK IN BUSINESS 5"                          format=f2.
      ER42910   LABEL="HEAD REPORT HRS BUSNS 5"                          format=f2.
      ER42911   LABEL="WIFE WORK IN BUSINESS 5"                          format=f2.
      ER42912   LABEL="WIFE REPORT HRS BUSNS 5"                          format=f2.
      ER42913   LABEL="G10 CORP/UNINCORP BUS5"                           format=f1.
      ER42914   LABEL="G11 GROSS RECEIPTS BUS 5"                         format=f7.
      ER42915   LABEL="G11A EXPENSES BUS 5"                              format=f7.
      ER42916   LABEL="G11B PROFIT/LOSS BUS 5"                           format=f7.
      ER42917   LABEL="ACCURACY OF BUSINESS5 PROFIT/LOSS"                format=f1.
      ER42918   LABEL="G12 HEAD HAVE WAGES"                              format=f1.
      ER42919   LABEL="G13 WAGES/SALARY OF HEAD"                         format=f7.
      ER42920   LABEL="ACCURACY OF WAGES/SALARY-HEAD"                    format=f1.
      ER42921   LABEL="G14/16 HD BONUS/OT/COMM"                          format=f1.
      ER42922   LABEL="HEAD HAVE BONUS"                                  format=f1.
      ER42923   LABEL="AMT HEAD BONUS"                                   format=f6.
      ER42924   LABEL="ACCURACY OF BONUS-HEAD"                           format=f1.
      ER42925   LABEL="HEAD HAVE OVERTIME"                               format=f1.
      ER42926   LABEL="AMT HEAD OVERTIME"                                format=f6.
      ER42927   LABEL="ACCURACY OF OVERTIME-HEAD"                        format=f1.
      ER42928   LABEL="HEAD HAVE TIPS"                                   format=f1.
      ER42929   LABEL="AMT HEAD TIPS"                                    format=f6.
      ER42930   LABEL="ACCURACY OF TIPS-HEAD"                            format=f1.
      ER42931   LABEL="HEAD HAVE COMMISSION"                             format=f1.
      ER42932   LABEL="AMT HEAD COMMISSION"                              format=f6.
      ER42933   LABEL="ACCURACY OF COMMISSION-HEAD"                      format=f1.
      ER42934   LABEL="WTR OTHER LABOR Y-HEAD"                           format=f1.
      ER42935   LABEL="AMT OTHER LABOR Y-HEAD"                           format=f6.
      ER42936   LABEL="ACCURACY OF OTHER LABOR Y-HEAD"                   format=f1.
      ER42937   LABEL="WTR WORK HRS FOR WAGES ETC"                       format=f1.
      ER42938   LABEL="G18A WTR HEAD PROF PRACT"                         format=f1.
      ER42939   LABEL="AMT PROF PRACTICE OF HD"                          format=f7.
      ER42940   LABEL="AMT PROF PRACTICE PER"                            format=f1.
      ER42941   LABEL="ACCURACY OF PROF PRACTICE-HEAD"                   format=f1.
      ER42942   LABEL="PROF/TRADE INCOME H JAN"                          format=f1.
      ER42943   LABEL="PROF/TRADE INCOME H FEB"                          format=f1.
      ER42944   LABEL="PROF/TRADE INCOME H MAR"                          format=f1.
      ER42945   LABEL="PROF/TRADE INCOME H APR"                          format=f1.
      ER42946   LABEL="PROF/TRADE INCOME H MAY"                          format=f1.
      ER42947   LABEL="PROF/TRADE INCOME H JUN"                          format=f1.
      ER42948   LABEL="PROF/TRADE INCOME H JUL"                          format=f1.
      ER42949   LABEL="PROF/TRADE INCOME H AUG"                          format=f1.
      ER42950   LABEL="PROF/TRADE INCOME H SEP"                          format=f1.
      ER42951   LABEL="PROF/TRADE INCOME H OCT"                          format=f1.
      ER42952   LABEL="PROF/TRADE INCOME H NOV"                          format=f1.
      ER42953   LABEL="PROF/TRADE INCOME H DEC"                          format=f1.
      ER42954   LABEL="G21A WTR WORK HRS FOR PROF PRAC"                  format=f1.
      ER42955   LABEL="G18B WTR HEAD MKT GDNING"                         format=f1.
      ER42956   LABEL="AMT MKT GARDENING OF HD"                          format=f7.
      ER42957   LABEL="AMT MKT GARDENING PER"                            format=f1.
      ER42958   LABEL="ACCURACY OF MKT GARDENING-HEAD"                   format=f1.
      ER42959   LABEL="GARDEN/FARM INCOME H JAN"                         format=f1.
      ER42960   LABEL="GARDEN/FARM INCOME H FEB"                         format=f1.
      ER42961   LABEL="GARDEN/FARM INCOME H MAR"                         format=f1.
      ER42962   LABEL="GARDEN/FARM INCOME H APR"                         format=f1.
      ER42963   LABEL="GARDEN/FARM INCOME H MAY"                         format=f1.
      ER42964   LABEL="GARDEN/FARM INCOME H JUN"                         format=f1.
      ER42965   LABEL="GARDEN/FARM INCOME H JUL"                         format=f1.
      ER42966   LABEL="GARDEN/FARM INCOME H AUG"                         format=f1.
      ER42967   LABEL="GARDEN/FARM INCOME H SEP"                         format=f1.
      ER42968   LABEL="GARDEN/FARM INCOME H OCT"                         format=f1.
      ER42969   LABEL="GARDEN/FARM INCOME H NOV"                         format=f1.
      ER42970   LABEL="GARDEN/FARM INCOME H DEC"                         format=f1.
      ER42971   LABEL="G21B WTR WORK HRS FOR MKT GRDNG"                  format=f1.
      ER42972   LABEL="G18C WTR HEAD ROOMERS"                            format=f1.
      ER42973   LABEL="AMT ROOMERS/BOARDERS HD"                          format=f7.
      ER42974   LABEL="AMT ROOMERS/BOARDERS PER"                         format=f1.
      ER42975   LABEL="ACCURACY OF ROOMERS/BOARDERS-HEAD"                format=f1.
      ER42976   LABEL="ROOM/BORD INCOME H JAN"                           format=f1.
      ER42977   LABEL="ROOM/BORD INCOME H FEB"                           format=f1.
      ER42978   LABEL="ROOM/BORD INCOME H MAR"                           format=f1.
      ER42979   LABEL="ROOM/BORD INCOME H APR"                           format=f1.
      ER42980   LABEL="ROOM/BORD INCOME H MAY"                           format=f1.
      ER42981   LABEL="ROOM/BORD INCOME H JUN"                           format=f1.
      ER42982   LABEL="ROOM/BORD INCOME H JUL"                           format=f1.
      ER42983   LABEL="ROOM/BORD INCOME H AUG"                           format=f1.
      ER42984   LABEL="ROOM/BORD INCOME H SEP"                           format=f1.
      ER42985   LABEL="ROOM/BORD INCOME H OCT"                           format=f1.
      ER42986   LABEL="ROOM/BORD INCOME H NOV"                           format=f1.
      ER42987   LABEL="ROOM/BORD INCOME H DEC"                           format=f1.
      ER42988   LABEL="G21C WTR WORK HRS FOR ROOMERS"                    format=f1.
      ER42989   LABEL="G23 WTR INCL EARNINGS XTRA JOB"                   format=f1.
      ER42990   LABEL="AMT FROM XTRA JOBS"                               format=f7.
      ER42991   LABEL="ACCURACY OF XTRA JOB INCOME-HEAD"                 format=f1.
      ER42992   LABEL="G25A WHETHER RENT HEAD"                           format=f1.
      ER42993   LABEL="RENT OF HEAD"                                     format=f6.
      ER42994   LABEL="RENT OF HEAD PER"                                 format=f1.
      ER42995   LABEL="ACCURACY OF RENT-HEAD"                            format=f1.
      ER42996   LABEL="G26A2 WTR RENT JOINT WITH WIFE"                   format=f1.
      ER42997   LABEL="RENT INCOME HEAD JAN"                             format=f1.
      ER42998   LABEL="RENT INCOME HEAD FEB"                             format=f1.
      ER42999   LABEL="RENT INCOME HEAD MAR"                             format=f1.
      ER43000   LABEL="RENT INCOME HEAD APR"                             format=f1.
      ER43001   LABEL="RENT INCOME HEAD MAY"                             format=f1.
      ER43002   LABEL="RENT INCOME HEAD JUN"                             format=f1.
      ER43003   LABEL="RENT INCOME HEAD JUL"                             format=f1.
      ER43004   LABEL="RENT INCOME HEAD AUG"                             format=f1.
      ER43005   LABEL="RENT INCOME HEAD SEP"                             format=f1.
      ER43006   LABEL="RENT INCOME HEAD OCT"                             format=f1.
      ER43007   LABEL="RENT INCOME HEAD NOV"                             format=f1.
      ER43008   LABEL="RENT INCOME HEAD DEC"                             format=f1.
      ER43009   LABEL="G25B WHETHER DIVIDENDS HEAD"                      format=f1.
      ER43010   LABEL="DIVIDENDS OF HEAD"                                format=f6.
      ER43011   LABEL="DIVIDENDS OF HEAD PER"                            format=f1.
      ER43012   LABEL="ACCURACY OF DIVIDENDS-HEAD"                       format=f1.
      ER43013   LABEL="G26B2 WTR DIVIDENDS JOINT WITH WIFE"              format=f1.
      ER43014   LABEL="DIVIDEND INCOME HEAD JAN"                         format=f1.
      ER43015   LABEL="DIVIDEND INCOME HEAD FEB"                         format=f1.
      ER43016   LABEL="DIVIDEND INCOME HEAD MAR"                         format=f1.
      ER43017   LABEL="DIVIDEND INCOME HEAD APR"                         format=f1.
      ER43018   LABEL="DIVIDEND INCOME HEAD MAY"                         format=f1.
      ER43019   LABEL="DIVIDEND INCOME HEAD JUN"                         format=f1.
      ER43020   LABEL="DIVIDEND INCOME HEAD JUL"                         format=f1.
      ER43021   LABEL="DIVIDEND INCOME HEAD AUG"                         format=f1.
      ER43022   LABEL="DIVIDEND INCOME HEAD SEP"                         format=f1.
      ER43023   LABEL="DIVIDEND INCOME HEAD OCT"                         format=f1.
      ER43024   LABEL="DIVIDEND INCOME HEAD NOV"                         format=f1.
      ER43025   LABEL="DIVIDEND INCOME HEAD DEC"                         format=f1.
      ER43026   LABEL="G25C WHETHER INTEREST HEAD"                       format=f1.
      ER43027   LABEL="INTEREST OF HEAD"                                 format=f6.
      ER43028   LABEL="INTEREST OF HEAD PER"                             format=f1.
      ER43029   LABEL="ACCURACY OF INTEREST-HEAD"                        format=f1.
      ER43030   LABEL="G26C2 WTR INTEREST JOINT WITH WIFE"               format=f1.
      ER43031   LABEL="INTEREST INCOME HEAD JAN"                         format=f1.
      ER43032   LABEL="INTEREST INCOME HEAD FEB"                         format=f1.
      ER43033   LABEL="INTEREST INCOME HEAD MAR"                         format=f1.
      ER43034   LABEL="INTEREST INCOME HEAD APR"                         format=f1.
      ER43035   LABEL="INTEREST INCOME HEAD MAY"                         format=f1.
      ER43036   LABEL="INTEREST INCOME HEAD JUN"                         format=f1.
      ER43037   LABEL="INTEREST INCOME HEAD JUL"                         format=f1.
      ER43038   LABEL="INTEREST INCOME HEAD AUG"                         format=f1.
      ER43039   LABEL="INTEREST INCOME HEAD SEP"                         format=f1.
      ER43040   LABEL="INTEREST INCOME HEAD OCT"                         format=f1.
      ER43041   LABEL="INTEREST INCOME HEAD NOV"                         format=f1.
      ER43042   LABEL="INTEREST INCOME HEAD DEC"                         format=f1.
      ER43043   LABEL="WHETHER TRUST FUND HEAD"                          format=f1.
      ER43044   LABEL="G25D TRUST FUND OF HEAD"                          format=f6.
      ER43045   LABEL="TRUST FUND OF HEAD PER"                           format=f1.
      ER43046   LABEL="ACCURACY OF TRUST FUND-HEAD"                      format=f1.
      ER43047   LABEL="TRUST/ROYAL INCOME H JAN"                         format=f1.
      ER43048   LABEL="TRUST/ROYAL INCOME H FEB"                         format=f1.
      ER43049   LABEL="TRUST/ROYAL INCOME H MAR"                         format=f1.
      ER43050   LABEL="TRUST/ROYAL INCOME H APR"                         format=f1.
      ER43051   LABEL="TRUST/ROYAL INCOME H MAY"                         format=f1.
      ER43052   LABEL="TRUST/ROYAL INCOME H JUN"                         format=f1.
      ER43053   LABEL="TRUST/ROYAL INCOME H JUL"                         format=f1.
      ER43054   LABEL="TRUST/ROYAL INCOME H AUG"                         format=f1.
      ER43055   LABEL="TRUST/ROYAL INCOME H SEP"                         format=f1.
      ER43056   LABEL="TRUST/ROYAL INCOME H OCT"                         format=f1.
      ER43057   LABEL="TRUST/ROYAL INCOME H NOV"                         format=f1.
      ER43058   LABEL="TRUST/ROYAL INCOME H DEC"                         format=f1.
      ER43059   LABEL="G25E WHETHER ADC/TANF HEAD"                       format=f1.
      ER43060   LABEL="ADC/TANF OF HEAD"                                 format=f6.
      ER43061   LABEL="ADC/TANF OF HEAD PER"                             format=f1.
      ER43062   LABEL="ACCURACY OF ADC/TANF-HEAD"                        format=f1.
      ER43063   LABEL="ADC/TANF INCOME HEAD JAN"                         format=f1.
      ER43064   LABEL="ADC/TANF INCOME HEAD FEB"                         format=f1.
      ER43065   LABEL="ADC/TANF INCOME HEAD MAR"                         format=f1.
      ER43066   LABEL="ADC/TANF INCOME HEAD APR"                         format=f1.
      ER43067   LABEL="ADC/TANF INCOME HEAD MAY"                         format=f1.
      ER43068   LABEL="ADC/TANF INCOME HEAD JUN"                         format=f1.
      ER43069   LABEL="ADC/TANF INCOME HEAD JUL"                         format=f1.
      ER43070   LABEL="ADC/TANF INCOME HEAD AUG"                         format=f1.
      ER43071   LABEL="ADC/TANF INCOME HEAD SEP"                         format=f1.
      ER43072   LABEL="ADC/TANF INCOME HEAD OCT"                         format=f1.
      ER43073   LABEL="ADC/TANF INCOME HEAD NOV"                         format=f1.
      ER43074   LABEL="ADC/TANF INCOME HEAD DEC"                         format=f1.
      ER43075   LABEL="G25F WHETHER SSI HEAD"                            format=f1.
      ER43076   LABEL="HEAD SSI SELF/ELSE/BOTH"                          format=f1.
      ER43077   LABEL="SSI OF HEAD"                                      format=f6.
      ER43078   LABEL="SSI OF HEAD PER"                                  format=f1.
      ER43079   LABEL="ACCURACY OF SSI-HEAD"                             format=f1.
      ER43080   LABEL="SSI INCOME HEAD JAN"                              format=f1.
      ER43081   LABEL="SSI INCOME HEAD FEB"                              format=f1.
      ER43082   LABEL="SSI INCOME HEAD MAR"                              format=f1.
      ER43083   LABEL="SSI INCOME HEAD APR"                              format=f1.
      ER43084   LABEL="SSI INCOME HEAD MAY"                              format=f1.
      ER43085   LABEL="SSI INCOME HEAD JUN"                              format=f1.
      ER43086   LABEL="SSI INCOME HEAD JUL"                              format=f1.
      ER43087   LABEL="SSI INCOME HEAD AUG"                              format=f1.
      ER43088   LABEL="SSI INCOME HEAD SEP"                              format=f1.
      ER43089   LABEL="SSI INCOME HEAD OCT"                              format=f1.
      ER43090   LABEL="SSI INCOME HEAD NOV"                              format=f1.
      ER43091   LABEL="SSI INCOME HEAD DEC"                              format=f1.
      ER43092   LABEL="G25G WHETHER OTHER WELFARE HD"                    format=f1.
      ER43093   LABEL="OTHER WELFARE OF HEAD"                            format=f6.
      ER43094   LABEL="OTHER WELFARE OF HD PER"                          format=f1.
      ER43095   LABEL="ACCURACY OF OTR WELFARE-HEAD"                     format=f1.
      ER43096   LABEL="OTR WELFARE INCOME H JAN"                         format=f1.
      ER43097   LABEL="OTR WELFARE INCOME H FEB"                         format=f1.
      ER43098   LABEL="OTR WELFARE INCOME H MAR"                         format=f1.
      ER43099   LABEL="OTR WELFARE INCOME H APR"                         format=f1.
      ER43100   LABEL="OTR WELFARE INCOME H MAY"                         format=f1.
      ER43101   LABEL="OTR WELFARE INCOME H JUN"                         format=f1.
      ER43102   LABEL="OTR WELFARE INCOME H JUL"                         format=f1.
      ER43103   LABEL="OTR WELFARE INCOME H AUG"                         format=f1.
      ER43104   LABEL="OTR WELFARE INCOME H SEP"                         format=f1.
      ER43105   LABEL="OTR WELFARE INCOME H OCT"                         format=f1.
      ER43106   LABEL="OTR WELFARE INCOME H NOV"                         format=f1.
      ER43107   LABEL="OTR WELFARE INCOME H DEC"                         format=f1.
      ER43108   LABEL="G31 ANY FU MEMB GET SOCSEC"                       format=f1.
      ER43109   LABEL="G37 WHETHER HEAD VA PENSION"                      format=f1.
      ER43110   LABEL="VA PENSION OF HEAD AMT"                           format=f6.
      ER43111   LABEL="VA PENSION OF HEAD PER"                           format=f1.
      ER43112   LABEL="ACCURACY OF VA PENSION-HEAD"                      format=f1.
      ER43113   LABEL="VA INCOME HEAD JAN"                               format=f1.
      ER43114   LABEL="VA INCOME HEAD FEB"                               format=f1.
      ER43115   LABEL="VA INCOME HEAD MAR"                               format=f1.
      ER43116   LABEL="VA INCOME HEAD APR"                               format=f1.
      ER43117   LABEL="VA INCOME HEAD MAY"                               format=f1.
      ER43118   LABEL="VA INCOME HEAD JUN"                               format=f1.
      ER43119   LABEL="VA INCOME HEAD JUL"                               format=f1.
      ER43120   LABEL="VA INCOME HEAD AUG"                               format=f1.
      ER43121   LABEL="VA INCOME HEAD SEP"                               format=f1.
      ER43122   LABEL="VA INCOME HEAD OCT"                               format=f1.
      ER43123   LABEL="VA INCOME HEAD NOV"                               format=f1.
      ER43124   LABEL="VA INCOME HEAD DEC"                               format=f1.
      ER43125   LABEL="G40A WTR NONVA RETIREMT-HEAD"                     format=f1.
      ER43126   LABEL="NONVA RETIREMENT-HEAD"                            format=f6.
      ER43127   LABEL="NONVA RETIREMENT PER-HD"                          format=f1.
      ER43128   LABEL="ACCURACY OF NONVA RETIREMENT-HEAD"                format=f1.
      ER43129   LABEL="RETIREMENT INCOME H JAN"                          format=f1.
      ER43130   LABEL="RETIREMENT INCOME H FEB"                          format=f1.
      ER43131   LABEL="RETIREMENT INCOME H MAR"                          format=f1.
      ER43132   LABEL="RETIREMENT INCOME H APR"                          format=f1.
      ER43133   LABEL="RETIREMENT INCOME H MAY"                          format=f1.
      ER43134   LABEL="RETIREMENT INCOME H JUN"                          format=f1.
      ER43135   LABEL="RETIREMENT INCOME H JUL"                          format=f1.
      ER43136   LABEL="RETIREMENT INCOME H AUG"                          format=f1.
      ER43137   LABEL="RETIREMENT INCOME H SEP"                          format=f1.
      ER43138   LABEL="RETIREMENT INCOME H OCT"                          format=f1.
      ER43139   LABEL="RETIREMENT INCOME H NOV"                          format=f1.
      ER43140   LABEL="RETIREMENT INCOME H DEC"                          format=f1.
      ER43141   LABEL="G40B WHETHER HEAD ANNUITIES"                      format=f1.
      ER43142   LABEL="ANNUITIES OF HEAD"                                format=f6.
      ER43143   LABEL="ANNUITIES OF HEAD PER"                            format=f1.
      ER43144   LABEL="ACCURACY OF ANNUITIES-HEAD"                       format=f1.
      ER43145   LABEL="ANNUITIES INCOME JAN"                             format=f1.
      ER43146   LABEL="ANNUITIES INCOME FEB"                             format=f1.
      ER43147   LABEL="ANNUITIES INCOME MAR"                             format=f1.
      ER43148   LABEL="ANNUITIES INCOME APR"                             format=f1.
      ER43149   LABEL="ANNUITIES INCOME MAY"                             format=f1.
      ER43150   LABEL="ANNUITIES INCOME JUN"                             format=f1.
      ER43151   LABEL="ANNUITIES INCOME JUL"                             format=f1.
      ER43152   LABEL="ANNUITIES INCOME AUG"                             format=f1.
      ER43153   LABEL="ANNUITIES INCOME SEP"                             format=f1.
      ER43154   LABEL="ANNUITIES INCOME OCT"                             format=f1.
      ER43155   LABEL="ANNUITIES INCOME NOV"                             format=f1.
      ER43156   LABEL="ANNUITIES INCOME DEC"                             format=f1.
      ER43157   LABEL="G40C WHETHER HEAD OTR PENSION"                    format=f1.
      ER43158   LABEL="OTHER PENSION OF HEAD"                            format=f6.
      ER43159   LABEL="OTHER PENSION OF HD PER"                          format=f1.
      ER43160   LABEL="ACCURACY OF OTR PENSION-HEAD"                     format=f1.
      ER43161   LABEL="OTR PENSION HEAD JAN"                             format=f1.
      ER43162   LABEL="OTR PENSION HEAD FEB"                             format=f1.
      ER43163   LABEL="OTR PENSION HEAD MAR"                             format=f1.
      ER43164   LABEL="OTR PENSION HEAD APR"                             format=f1.
      ER43165   LABEL="OTR PENSION HEAD MAY"                             format=f1.
      ER43166   LABEL="OTR PENSION HEAD JUN"                             format=f1.
      ER43167   LABEL="OTR PENSION HEAD JUL"                             format=f1.
      ER43168   LABEL="OTR PENSION HEAD AUG"                             format=f1.
      ER43169   LABEL="OTR PENSION HEAD SEP"                             format=f1.
      ER43170   LABEL="OTR PENSION HEAD OCT"                             format=f1.
      ER43171   LABEL="OTR PENSION HEAD NOV"                             format=f1.
      ER43172   LABEL="OTR PENSION HEAD DEC"                             format=f1.
      ER43173   LABEL="G43 NUM OF HEAD NON VA PENSN"                     format=f1.
      ER43174   LABEL="G44A WTR UNEMPL COMP OF HEAD"                     format=f1.
      ER43175   LABEL="AMT UNEMPL COMP OF HEAD"                          format=f6.
      ER43176   LABEL="AMT UNEMPL COMP HD PER"                           format=f1.
      ER43177   LABEL="ACCURACY OF UNEMPL COMP-HEAD"                     format=f1.
      ER43178   LABEL="UNEMPLOY INCOME HEAD JAN"                         format=f1.
      ER43179   LABEL="UNEMPLOY INCOME HEAD FEB"                         format=f1.
      ER43180   LABEL="UNEMPLOY INCOME HEAD MAR"                         format=f1.
      ER43181   LABEL="UNEMPLOY INCOME HEAD APR"                         format=f1.
      ER43182   LABEL="UNEMPLOY INCOME HEAD MAY"                         format=f1.
      ER43183   LABEL="UNEMPLOY INCOME HEAD JUN"                         format=f1.
      ER43184   LABEL="UNEMPLOY INCOME HEAD JUL"                         format=f1.
      ER43185   LABEL="UNEMPLOY INCOME HEAD AUG"                         format=f1.
      ER43186   LABEL="UNEMPLOY INCOME HEAD SEP"                         format=f1.
      ER43187   LABEL="UNEMPLOY INCOME HEAD OCT"                         format=f1.
      ER43188   LABEL="UNEMPLOY INCOME HEAD NOV"                         format=f1.
      ER43189   LABEL="UNEMPLOY INCOME HEAD DEC"                         format=f1.
      ER43190   LABEL="G44B WTR WORKMEN COMP OF HEAD"                    format=f1.
      ER43191   LABEL="AMT WORKMEN COMP OF HEAD"                         format=f6.
      ER43192   LABEL="AMT WORKMEN COMP HD PER"                          format=f1.
      ER43193   LABEL="ACCURACY OF WORKMEN COMP-HEAD"                    format=f1.
      ER43194   LABEL="WORKER COMP INCOME H JAN"                         format=f1.
      ER43195   LABEL="WORKER COMP INCOME H FEB"                         format=f1.
      ER43196   LABEL="WORKER COMP INCOME H MAR"                         format=f1.
      ER43197   LABEL="WORKER COMP INCOME H APR"                         format=f1.
      ER43198   LABEL="WORKER COMP INCOME H MAY"                         format=f1.
      ER43199   LABEL="WORKER COMP INCOME H JUN"                         format=f1.
      ER43200   LABEL="WORKER COMP INCOME H JUL"                         format=f1.
      ER43201   LABEL="WORKER COMP INCOME H AUG"                         format=f1.
      ER43202   LABEL="WORKER COMP INCOME H SEP"                         format=f1.
      ER43203   LABEL="WORKER COMP INCOME H OCT"                         format=f1.
      ER43204   LABEL="WORKER COMP INCOME H NOV"                         format=f1.
      ER43205   LABEL="WORKER COMP INCOME H DEC"                         format=f1.
      ER43206   LABEL="G44C WTR CHILD SUPPORT OF HD"                     format=f1.
      ER43207   LABEL="AMT CHILD SUPPORT OF HD"                          format=f6.
      ER43208   LABEL="AMT CHILD SUPPORT HD PER"                         format=f1.
      ER43209   LABEL="ACCURACY OF CHILD SUPPORT-HEAD"                   format=f1.
      ER43210   LABEL="CHILD SUPPORT INC H JAN"                          format=f1.
      ER43211   LABEL="CHILD SUPPORT INC H FEB"                          format=f1.
      ER43212   LABEL="CHILD SUPPORT INC H MAR"                          format=f1.
      ER43213   LABEL="CHILD SUPPORT INC H APR"                          format=f1.
      ER43214   LABEL="CHILD SUPPORT INC H MAY"                          format=f1.
      ER43215   LABEL="CHILD SUPPORT INC H JUN"                          format=f1.
      ER43216   LABEL="CHILD SUPPORT INC H JUL"                          format=f1.
      ER43217   LABEL="CHILD SUPPORT INC H AUG"                          format=f1.
      ER43218   LABEL="CHILD SUPPORT INC H SEP"                          format=f1.
      ER43219   LABEL="CHILD SUPPORT INC H OCT"                          format=f1.
      ER43220   LABEL="CHILD SUPPORT INC H NOV"                          format=f1.
      ER43221   LABEL="CHILD SUPPORT INC H DEC"                          format=f1.
      ER43222   LABEL="G44D WTR ALIMONY OF HEAD"                         format=f1.
      ER43223   LABEL="AMT ALIMONY OF HEAD"                              format=f6.
      ER43224   LABEL="AMT ALIMONY OF HEAD PER"                          format=f1.
      ER43225   LABEL="ACCURACY OF ALIMONY-HEAD"                         format=f1.
      ER43226   LABEL="ALIMONY INCOME HEAD JAN"                          format=f1.
      ER43227   LABEL="ALIMONY INCOME HEAD FEB"                          format=f1.
      ER43228   LABEL="ALIMONY INCOME HEAD MAR"                          format=f1.
      ER43229   LABEL="ALIMONY INCOME HEAD APR"                          format=f1.
      ER43230   LABEL="ALIMONY INCOME HEAD MAY"                          format=f1.
      ER43231   LABEL="ALIMONY INCOME HEAD JUN"                          format=f1.
      ER43232   LABEL="ALIMONY INCOME HEAD JUL"                          format=f1.
      ER43233   LABEL="ALIMONY INCOME HEAD AUG"                          format=f1.
      ER43234   LABEL="ALIMONY INCOME HEAD SEP"                          format=f1.
      ER43235   LABEL="ALIMONY INCOME HEAD OCT"                          format=f1.
      ER43236   LABEL="ALIMONY INCOME HEAD NOV"                          format=f1.
      ER43237   LABEL="ALIMONY INCOME HEAD DEC"                          format=f1.
      ER43238   LABEL="G44E WTR HELP FRM RELATIV HEAD"                   format=f1.
      ER43239   LABEL="AMT HELP FRM RELATIV HD"                          format=f6.
      ER43240   LABEL="AMT HELP FRM RELATIV PER"                         format=f1.
      ER43241   LABEL="ACCURACY OF HELP FRM RELATIV-HEAD"                format=f1.
      ER43242   LABEL="HELP FROM RELATIVE H JAN"                         format=f1.
      ER43243   LABEL="HELP FROM RELATIVE H FEB"                         format=f1.
      ER43244   LABEL="HELP FROM RELATIVE H MAR"                         format=f1.
      ER43245   LABEL="HELP FROM RELATIVE H APR"                         format=f1.
      ER43246   LABEL="HELP FROM RELATIVE H MAY"                         format=f1.
      ER43247   LABEL="HELP FROM RELATIVE H JUN"                         format=f1.
      ER43248   LABEL="HELP FROM RELATIVE H JUL"                         format=f1.
      ER43249   LABEL="HELP FROM RELATIVE H AUG"                         format=f1.
      ER43250   LABEL="HELP FROM RELATIVE H SEP"                         format=f1.
      ER43251   LABEL="HELP FROM RELATIVE H OCT"                         format=f1.
      ER43252   LABEL="HELP FROM RELATIVE H NOV"                         format=f1.
      ER43253   LABEL="HELP FROM RELATIVE H DEC"                         format=f1.
      ER43254   LABEL="G44F WTR HELP FRM OTHERS HEAD"                    format=f1.
      ER43255   LABEL="AMT HELP FRM OTHERS HD"                           format=f6.
      ER43256   LABEL="AMT HELP FRM OTHERS PER"                          format=f1.
      ER43257   LABEL="ACCURACY OF HELP FRM OTHERS-HEAD"                 format=f1.
      ER43258   LABEL="HELP FROM OTHERS H JAN"                           format=f1.
      ER43259   LABEL="HELP FROM OTHERS H FEB"                           format=f1.
      ER43260   LABEL="HELP FROM OTHERS H MAR"                           format=f1.
      ER43261   LABEL="HELP FROM OTHERS H APR"                           format=f1.
      ER43262   LABEL="HELP FROM OTHERS H MAY"                           format=f1.
      ER43263   LABEL="HELP FROM OTHERS H JUN"                           format=f1.
      ER43264   LABEL="HELP FROM OTHERS H JUL"                           format=f1.
      ER43265   LABEL="HELP FROM OTHERS H AUG"                           format=f1.
      ER43266   LABEL="HELP FROM OTHERS H SEP"                           format=f1.
      ER43267   LABEL="HELP FROM OTHERS H OCT"                           format=f1.
      ER43268   LABEL="HELP FROM OTHERS H NOV"                           format=f1.
      ER43269   LABEL="HELP FROM OTHERS H DEC"                           format=f1.
      ER43270   LABEL="G44G WTR ANYTHING ELSE OF HD"                     format=f1.
      ER43271   LABEL="AMT ANYTHING ELSE OF HD"                          format=f6.
      ER43272   LABEL="AMT ANYTHING ELSE PER"                            format=f1.
      ER43273   LABEL="ACCURACY OF ANYTHING ELSE-HEAD"                   format=f1.
      ER43274   LABEL="ANY OTHER INCOME H JAN"                           format=f1.
      ER43275   LABEL="ANY OTHER INCOME H FEB"                           format=f1.
      ER43276   LABEL="ANY OTHER INCOME H MAR"                           format=f1.
      ER43277   LABEL="ANY OTHER INCOME H APR"                           format=f1.
      ER43278   LABEL="ANY OTHER INCOME H MAY"                           format=f1.
      ER43279   LABEL="ANY OTHER INCOME H JUN"                           format=f1.
      ER43280   LABEL="ANY OTHER INCOME H JUL"                           format=f1.
      ER43281   LABEL="ANY OTHER INCOME H AUG"                           format=f1.
      ER43282   LABEL="ANY OTHER INCOME H SEP"                           format=f1.
      ER43283   LABEL="ANY OTHER INCOME H OCT"                           format=f1.
      ER43284   LABEL="ANY OTHER INCOME H NOV"                           format=f1.
      ER43285   LABEL="ANY OTHER INCOME H DEC"                           format=f1.
      ER43286   LABEL="G49 WTR WIFE IN FU NOW"                           format=f1.
      ER43287   LABEL="G50 WHETHER WIFE HAD INCOME"                      format=f1.
      ER43288   LABEL="G51A WHETHER WIFE LABOR INC"                      format=f1.
      ER43289   LABEL="G51B WHETHER WFE INC FRM WORK"                    format=f1.
      ER43290   LABEL="WAGES/SALARY OF WIFE"                             format=f7.
      ER43291   LABEL="ACCURACY OF WAGES/SALARY-WIFE"                    format=f1.
      ER43292   LABEL="G52B WTR WORK HOURS FOR WIFE"                     format=f1.
      ER43293   LABEL="G53 WHETHER UNEMPLOYMENT WFE"                     format=f1.
      ER43294   LABEL="UNEMPLOYMNT COMP OF WIFE"                         format=f6.
      ER43295   LABEL="UNEMPLOYMNT COMP WFE PER"                         format=f1.
      ER43296   LABEL="ACCURACY OF UNEMPLOYMENT COMP-WIFE"               format=f1.
      ER43297   LABEL="UNEMPLOY INCOME WIFE JAN"                         format=f1.
      ER43298   LABEL="UNEMPLOY INCOME WIFE FEB"                         format=f1.
      ER43299   LABEL="UNEMPLOY INCOME WIFE MAR"                         format=f1.
      ER43300   LABEL="UNEMPLOY INCOME WIFE APR"                         format=f1.
      ER43301   LABEL="UNEMPLOY INCOME WIFE MAY"                         format=f1.
      ER43302   LABEL="UNEMPLOY INCOME WIFE JUN"                         format=f1.
      ER43303   LABEL="UNEMPLOY INCOME WIFE JUL"                         format=f1.
      ER43304   LABEL="UNEMPLOY INCOME WIFE AUG"                         format=f1.
      ER43305   LABEL="UNEMPLOY INCOME WIFE SEP"                         format=f1.
      ER43306   LABEL="UNEMPLOY INCOME WIFE OCT"                         format=f1.
      ER43307   LABEL="UNEMPLOY INCOME WIFE NOV"                         format=f1.
      ER43308   LABEL="UNEMPLOY INCOME WIFE DEC"                         format=f1.
      ER43309   LABEL="G56 WHETHER WORKERS COMP WFE"                     format=f1.
      ER43310   LABEL="WORKERS COMP OF WIFE"                             format=f6.
      ER43311   LABEL="WORKERS COMP OF WIFE PER"                         format=f1.
      ER43312   LABEL="ACCURACY OF WORKERS COMP-WIFE"                    format=f1.
      ER43313   LABEL="WORKER COMP INCOME W JAN"                         format=f1.
      ER43314   LABEL="WORKER COMP INCOME W FEB"                         format=f1.
      ER43315   LABEL="WORKER COMP INCOME W MAR"                         format=f1.
      ER43316   LABEL="WORKER COMP INCOME W APR"                         format=f1.
      ER43317   LABEL="WORKER COMP INCOME W MAY"                         format=f1.
      ER43318   LABEL="WORKER COMP INCOME W JUN"                         format=f1.
      ER43319   LABEL="WORKER COMP INCOME W JUL"                         format=f1.
      ER43320   LABEL="WORKER COMP INCOME W AUG"                         format=f1.
      ER43321   LABEL="WORKER COMP INCOME W SEP"                         format=f1.
      ER43322   LABEL="WORKER COMP INCOME W OCT"                         format=f1.
      ER43323   LABEL="WORKER COMP INCOME W NOV"                         format=f1.
      ER43324   LABEL="WORKER COMP INCOME W DEC"                         format=f1.
      ER43325   LABEL="G59A WHETHER WIFE RENT"                           format=f1.
      ER43326   LABEL="RENT OF WIFE AMT"                                 format=f6.
      ER43327   LABEL="RENT OF WIFE PER"                                 format=f1.
      ER43328   LABEL="ACCURACY OF RENT-WIFE"                            format=f1.
      ER43329   LABEL="G59A3 WTR RENT ADDITIONAL TO HEAD AMT"            format=f1.
      ER43330   LABEL="RENT INCOME WIFE JAN"                             format=f1.
      ER43331   LABEL="RENT INCOME WIFE FEB"                             format=f1.
      ER43332   LABEL="RENT INCOME WIFE MAR"                             format=f1.
      ER43333   LABEL="RENT INCOME WIFE APR"                             format=f1.
      ER43334   LABEL="RENT INCOME WIFE MAY"                             format=f1.
      ER43335   LABEL="RENT INCOME WIFE JUN"                             format=f1.
      ER43336   LABEL="RENT INCOME WIFE JUL"                             format=f1.
      ER43337   LABEL="RENT INCOME WIFE AUG"                             format=f1.
      ER43338   LABEL="RENT INCOME WIFE SEP"                             format=f1.
      ER43339   LABEL="RENT INCOME WIFE OCT"                             format=f1.
      ER43340   LABEL="RENT INCOME WIFE NOV"                             format=f1.
      ER43341   LABEL="RENT INCOME WIFE DEC"                             format=f1.
      ER43342   LABEL="G59B WHETHER WIFE DIVIDENDS"                      format=f1.
      ER43343   LABEL="DIVIDENDS OF WIFE AMT"                            format=f6.
      ER43344   LABEL="DIVIDENDS OF WIFE PER"                            format=f1.
      ER43345   LABEL="ACCURACY OF DIVIDENDS-WIFE"                       format=f1.
      ER43346   LABEL="G59B3 WTR DIVS ADDITIONAL TO HEAD AMT"            format=f1.
      ER43347   LABEL="DIVIDEND INCOME WIFE JAN"                         format=f1.
      ER43348   LABEL="DIVIDEND INCOME WIFE FEB"                         format=f1.
      ER43349   LABEL="DIVIDEND INCOME WIFE MAR"                         format=f1.
      ER43350   LABEL="DIVIDEND INCOME WIFE APR"                         format=f1.
      ER43351   LABEL="DIVIDEND INCOME WIFE MAY"                         format=f1.
      ER43352   LABEL="DIVIDEND INCOME WIFE JUN"                         format=f1.
      ER43353   LABEL="DIVIDEND INCOME WIFE JUL"                         format=f1.
      ER43354   LABEL="DIVIDEND INCOME WIFE AUG"                         format=f1.
      ER43355   LABEL="DIVIDEND INCOME WIFE SEP"                         format=f1.
      ER43356   LABEL="DIVIDEND INCOME WIFE OCT"                         format=f1.
      ER43357   LABEL="DIVIDEND INCOME WIFE NOV"                         format=f1.
      ER43358   LABEL="DIVIDEND INCOME WIFE DEC"                         format=f1.
      ER43359   LABEL="G59C WHETHER WIFE INTEREST"                       format=f1.
      ER43360   LABEL="INTEREST OF WIFE AMT"                             format=f6.
      ER43361   LABEL="INTEREST OF WIFE AMT PER"                         format=f1.
      ER43362   LABEL="ACCURACY OF INTEREST-WIFE"                        format=f1.
      ER43363   LABEL="G59C3 WTR INTEREST ADDITNL TO HEAD AMT"           format=f1.
      ER43364   LABEL="INTEREST INCOME WIFE JAN"                         format=f1.
      ER43365   LABEL="INTEREST INCOME WIFE FEB"                         format=f1.
      ER43366   LABEL="INTEREST INCOME WIFE MAR"                         format=f1.
      ER43367   LABEL="INTEREST INCOME WIFE APR"                         format=f1.
      ER43368   LABEL="INTEREST INCOME WIFE MAY"                         format=f1.
      ER43369   LABEL="INTEREST INCOME WIFE JUN"                         format=f1.
      ER43370   LABEL="INTEREST INCOME WIFE JUL"                         format=f1.
      ER43371   LABEL="INTEREST INCOME WIFE AUG"                         format=f1.
      ER43372   LABEL="INTEREST INCOME WIFE SEP"                         format=f1.
      ER43373   LABEL="INTEREST INCOME WIFE OCT"                         format=f1.
      ER43374   LABEL="INTEREST INCOME WIFE NOV"                         format=f1.
      ER43375   LABEL="INTEREST INCOME WIFE DEC"                         format=f1.
      ER43376   LABEL="G59D WHETHER WIFE TRUST FUND"                     format=f1.
      ER43377   LABEL="TRUST FUND OF WIFE AMT"                           format=f6.
      ER43378   LABEL="TRUST FUND OF WIFE PER"                           format=f1.
      ER43379   LABEL="ACCURACY OF TRUST FUND-WIFE"                      format=f1.
      ER43380   LABEL="TRUST INCOME WIFE JAN"                            format=f1.
      ER43381   LABEL="TRUST INCOME WIFE FEB"                            format=f1.
      ER43382   LABEL="TRUST INCOME WIFE MAR"                            format=f1.
      ER43383   LABEL="TRUST INCOME WIFE APR"                            format=f1.
      ER43384   LABEL="TRUST INCOME WIFE MAY"                            format=f1.
      ER43385   LABEL="TRUST INCOME WIFE JUN"                            format=f1.
      ER43386   LABEL="TRUST INCOME WIFE JUL"                            format=f1.
      ER43387   LABEL="TRUST INCOME WIFE AUG"                            format=f1.
      ER43388   LABEL="TRUST INCOME WIFE SEP"                            format=f1.
      ER43389   LABEL="TRUST INCOME WIFE OCT"                            format=f1.
      ER43390   LABEL="TRUST INCOME WIFE NOV"                            format=f1.
      ER43391   LABEL="TRUST INCOME WIFE DEC"                            format=f1.
      ER43392   LABEL="G60A WHETHER WIFE RECD SSI"                       format=f1.
      ER43393   LABEL="G60A1 WIFE SSI SELF/ELSE/BOTH"                    format=f1.
      ER43394   LABEL="SSI OF WIFE AMT"                                  format=f6.
      ER43395   LABEL="SSI OF WIFE AMT PER"                              format=f1.
      ER43396   LABEL="ACCURACY OF SSI-WIFE"                             format=f1.
      ER43397   LABEL="SSI INCOME WIFE JAN"                              format=f1.
      ER43398   LABEL="SSI INCOME WIFE FEB"                              format=f1.
      ER43399   LABEL="SSI INCOME WIFE MAR"                              format=f1.
      ER43400   LABEL="SSI INCOME WIFE APR"                              format=f1.
      ER43401   LABEL="SSI INCOME WIFE MAY"                              format=f1.
      ER43402   LABEL="SSI INCOME WIFE JUN"                              format=f1.
      ER43403   LABEL="SSI INCOME WIFE JUL"                              format=f1.
      ER43404   LABEL="SSI INCOME WIFE AUG"                              format=f1.
      ER43405   LABEL="SSI INCOME WIFE SEP"                              format=f1.
      ER43406   LABEL="SSI INCOME WIFE OCT"                              format=f1.
      ER43407   LABEL="SSI INCOME WIFE NOV"                              format=f1.
      ER43408   LABEL="SSI INCOME WIFE DEC"                              format=f1.
      ER43409   LABEL="G60B WTR WIFE RECD ADC/TANF"                      format=f1.
      ER43410   LABEL="ADC/TANF OF WIFE AMT"                             format=f6.
      ER43411   LABEL="ADC/TANF OF WIFE AMT PER"                         format=f1.
      ER43412   LABEL="ACCURACY OF ADC/TANF-WIFE"                        format=f1.
      ER43413   LABEL="ADC/TANF INCOME WIFE JAN"                         format=f1.
      ER43414   LABEL="ADC/TANF INCOME WIFE FEB"                         format=f1.
      ER43415   LABEL="ADC/TANF INCOME WIFE MAR"                         format=f1.
      ER43416   LABEL="ADC/TANF INCOME WIFE APR"                         format=f1.
      ER43417   LABEL="ADC/TANF INCOME WIFE MAY"                         format=f1.
      ER43418   LABEL="ADC/TANF INCOME WIFE JUN"                         format=f1.
      ER43419   LABEL="ADC/TANF INCOME WIFE JUL"                         format=f1.
      ER43420   LABEL="ADC/TANF INCOME WIFE AUG"                         format=f1.
      ER43421   LABEL="ADC/TANF INCOME WIFE SEP"                         format=f1.
      ER43422   LABEL="ADC/TANF INCOME WIFE OCT"                         format=f1.
      ER43423   LABEL="ADC/TANF INCOME WIFE NOV"                         format=f1.
      ER43424   LABEL="ADC/TANF INCOME WIFE DEC"                         format=f1.
      ER43425   LABEL="G60C WTR WF RECD CHILD SUPPRT"                    format=f1.
      ER43426   LABEL="CHILD SUPPORT OF WF AMT"                          format=f6.
      ER43427   LABEL="CHILD SUPPORT OF WF PER"                          format=f1.
      ER43428   LABEL="ACCURACY OF CHILD SUPPORT-WIFE"                   format=f1.
      ER43429   LABEL="CHILD SUPPORT INC W JAN"                          format=f1.
      ER43430   LABEL="CHILD SUPPORT INC W FEB"                          format=f1.
      ER43431   LABEL="CHILD SUPPORT INC W MAR"                          format=f1.
      ER43432   LABEL="CHILD SUPPORT INC W APR"                          format=f1.
      ER43433   LABEL="CHILD SUPPORT INC W MAY"                          format=f1.
      ER43434   LABEL="CHILD SUPPORT INC W JUN"                          format=f1.
      ER43435   LABEL="CHILD SUPPORT INC W JUL"                          format=f1.
      ER43436   LABEL="CHILD SUPPORT INC W AUG"                          format=f1.
      ER43437   LABEL="CHILD SUPPORT INC W SEP"                          format=f1.
      ER43438   LABEL="CHILD SUPPORT INC W OCT"                          format=f1.
      ER43439   LABEL="CHILD SUPPORT INC W NOV"                          format=f1.
      ER43440   LABEL="CHILD SUPPORT INC W DEC"                          format=f1.
      ER43441   LABEL="G60D WTR WF RECD OTR WELFARE"                     format=f1.
      ER43442   LABEL="OTHER WELFARE OF WF AMT"                          format=f6.
      ER43443   LABEL="OTHER WELFARE OF WF PER"                          format=f1.
      ER43444   LABEL="ACCURACY OF OTHER WELFARE-WIFE"                   format=f1.
      ER43445   LABEL="OTHER WELFARE INC W JAN"                          format=f1.
      ER43446   LABEL="OTHER WELFARE INC W FEB"                          format=f1.
      ER43447   LABEL="OTHER WELFARE INC W MAR"                          format=f1.
      ER43448   LABEL="OTHER WELFARE INC W APR"                          format=f1.
      ER43449   LABEL="OTHER WELFARE INC W MAY"                          format=f1.
      ER43450   LABEL="OTHER WELFARE INC W JUN"                          format=f1.
      ER43451   LABEL="OTHER WELFARE INC W JUL"                          format=f1.
      ER43452   LABEL="OTHER WELFARE INC W AUG"                          format=f1.
      ER43453   LABEL="OTHER WELFARE INC W SEP"                          format=f1.
      ER43454   LABEL="OTHER WELFARE INC W OCT"                          format=f1.
      ER43455   LABEL="OTHER WELFARE INC W NOV"                          format=f1.
      ER43456   LABEL="OTHER WELFARE INC W DEC"                          format=f1.
      ER43457   LABEL="G61 WTR WF RECD PENS/ANNUITY"                     format=f1.
      ER43458   LABEL="PENSION/ANNUITY WF AMT"                           format=f6.
      ER43459   LABEL="PENSION/ANNUITY WF PER"                           format=f1.
      ER43460   LABEL="ACCURACY OF PENSION/ANNUITY-WIFE"                 format=f1.
      ER43461   LABEL="PENSION/ANNUITY W JAN"                            format=f1.
      ER43462   LABEL="PENSION/ANNUITY W FEB"                            format=f1.
      ER43463   LABEL="PENSION/ANNUITY W MAR"                            format=f1.
      ER43464   LABEL="PENSION/ANNUITY W APR"                            format=f1.
      ER43465   LABEL="PENSION/ANNUITY W MAY"                            format=f1.
      ER43466   LABEL="PENSION/ANNUITY W JUN"                            format=f1.
      ER43467   LABEL="PENSION/ANNUITY W JUL"                            format=f1.
      ER43468   LABEL="PENSION/ANNUITY W AUG"                            format=f1.
      ER43469   LABEL="PENSION/ANNUITY W SEP"                            format=f1.
      ER43470   LABEL="PENSION/ANNUITY W OCT"                            format=f1.
      ER43471   LABEL="PENSION/ANNUITY W NOV"                            format=f1.
      ER43472   LABEL="PENSION/ANNUITY W DEC"                            format=f1.
      ER43473   LABEL="G62A WTR WF HELP FR RELATIVES"                    format=f1.
      ER43474   LABEL="HELP FR RELATIVES WF AMT"                         format=f6.
      ER43475   LABEL="HELP FR RELS WF PER"                              format=f1.
      ER43476   LABEL="ACCURACY OF HELP FRM RELATIVES-WIFE"              format=f1.
      ER43477   LABEL="HELP FR RELATIVES WF JAN"                         format=f1.
      ER43478   LABEL="HELP FR RELATIVES WF FEB"                         format=f1.
      ER43479   LABEL="HELP FR RELATIVES WF MAR"                         format=f1.
      ER43480   LABEL="HELP FR RELATIVES WF APR"                         format=f1.
      ER43481   LABEL="HELP FR RELATIVES WF MAY"                         format=f1.
      ER43482   LABEL="HELP FR RELATIVES WF JUN"                         format=f1.
      ER43483   LABEL="HELP FR RELATIVES WF JUL"                         format=f1.
      ER43484   LABEL="HELP FR RELATIVES WF AUG"                         format=f1.
      ER43485   LABEL="HELP FR RELATIVES WF SEP"                         format=f1.
      ER43486   LABEL="HELP FR RELATIVES WF OCT"                         format=f1.
      ER43487   LABEL="HELP FR RELATIVES WF NOV"                         format=f1.
      ER43488   LABEL="HELP FR RELATIVES WF DEC"                         format=f1.
      ER43489   LABEL="G62B WTR WF HELP FROM FRIENDS"                    format=f1.
      ER43490   LABEL="HELP FR FRIENDS WF AMT"                           format=f6.
      ER43491   LABEL="HELP FR FRIENDS WF PER"                           format=f1.
      ER43492   LABEL="ACCURACY OF HELP FRM FRIENDS-WIFE"                format=f1.
      ER43493   LABEL="HELP FROM FRIENDS W JAN"                          format=f1.
      ER43494   LABEL="HELP FROM FRIENDS W FEB"                          format=f1.
      ER43495   LABEL="HELP FROM FRIENDS W MAR"                          format=f1.
      ER43496   LABEL="HELP FROM FRIENDS W APR"                          format=f1.
      ER43497   LABEL="HELP FROM FRIENDS W MAY"                          format=f1.
      ER43498   LABEL="HELP FROM FRIENDS W JUN"                          format=f1.
      ER43499   LABEL="HELP FROM FRIENDS W JUL"                          format=f1.
      ER43500   LABEL="HELP FROM FRIENDS W AUG"                          format=f1.
      ER43501   LABEL="HELP FROM FRIENDS W SEP"                          format=f1.
      ER43502   LABEL="HELP FROM FRIENDS W OCT"                          format=f1.
      ER43503   LABEL="HELP FROM FRIENDS W NOV"                          format=f1.
      ER43504   LABEL="HELP FROM FRIENDS W DEC"                          format=f1.
      ER43505   LABEL="G63 WTR WFE RECD OTR INCOME"                      format=f1.
      ER43506   LABEL="WIFE OTHER INCOME AMT"                            format=f6.
      ER43507   LABEL="WIFE OTHER INCOME PER"                            format=f1.
      ER43508   LABEL="ACCURACY OF OTHER INCOME-WIFE"                    format=f1.
      ER43509   LABEL="ANY OTHER INCOME W JAN"                           format=f1.
      ER43510   LABEL="ANY OTHER INCOME W FEB"                           format=f1.
      ER43511   LABEL="ANY OTHER INCOME W MAR"                           format=f1.
      ER43512   LABEL="ANY OTHER INCOME W APR"                           format=f1.
      ER43513   LABEL="ANY OTHER INCOME W MAY"                           format=f1.
      ER43514   LABEL="ANY OTHER INCOME W JUN"                           format=f1.
      ER43515   LABEL="ANY OTHER INCOME W JUL"                           format=f1.
      ER43516   LABEL="ANY OTHER INCOME W AUG"                           format=f1.
      ER43517   LABEL="ANY OTHER INCOME W SEP"                           format=f1.
      ER43518   LABEL="ANY OTHER INCOME W OCT"                           format=f1.
      ER43519   LABEL="ANY OTHER INCOME W NOV"                           format=f1.
      ER43520   LABEL="ANY OTHER INCOME W DEC"                           format=f1.
      ER43521   LABEL="G99 WTR LUMP SUM PAYMNTS"                         format=f1.
      ER43522   LABEL="G100 LUMP SUM PAYMENTS"                           format=f7.
      ER43523   LABEL="G101 INHERITANCE"                                 format=f7.
      ER43524   LABEL="G102 WTR ITEMIZE FOR TAX"                         format=f1.
      ER43525   LABEL="G102A ITEMIZED CHARITABLE CONTRIB AMT"            format=f6.
      ER43526   LABEL="G102B ITEMIZED MEDICAL EXPENSES AMT"              format=f6.
      ER43527   LABEL="G103 WTR HELP OTRS"                               format=f1.
      ER43528   LABEL="G104 # OTRS SUPPORTED"                            format=f2.
      ER43529   LABEL="G105 WHO SUPPORT      1"                          format=f2.
      ER43530   LABEL="G105 WHO SUPPORT      2"                          format=f2.
      ER43531   LABEL="G105 WHO SUPPORT      3"                          format=f2.
      ER43532   LABEL="G105 WHO SUPPORT      4"                          format=f2.
      ER43533   LABEL="G105 WHO SUPPORT      5"                          format=f2.
      ER43534   LABEL="G106 TOTAL SUPP OF OTRS"                          format=f7.
      ER43535   LABEL="G107 ANY CHILD SUPPORT"                           format=f1.
      ER43536   LABEL="AMT OF CHLD SUPPRT GIVEN"                         format=f7.
      ER43537   LABEL="G109 ANY ALIMONY"                                 format=f1.
      ER43538   LABEL="AMT OF ALIMONY GIVEN"                             format=f7.
      ER43539   LABEL="G112 WTR DEPNDT OTRS"                             format=f1.
      ER43540   LABEL="G113 NUMBER DEPNDT OTR"                           format=f2.
      ER43541   LABEL="G114 WTR DEPNDT OTHS"                             format=f1.
      ER43542   LABEL="W1 WTR OTR REAL ESTATE"                           format=f1.
      ER43543   LABEL="W1A WTR SECOND HOME"                              format=f1.
      ER43544   LABEL="W2 PROFIT IF SOLD OTR REAL ESTATE"                format=f9.
      ER43545   LABEL="W3 WTR PROFIT GE 50,000"                          format=f1.
      ER43546   LABEL="W4 WTR PROFIT GE 150,000"                         format=f1.
      ER43547   LABEL="W5 WTR PROFIT GE 5,000"                           format=f1.
      ER43548   LABEL="W6 PROFIT IF SOLD VEHICLES"                       format=f9.
      ER43549   LABEL="W7 WTR PROFIT GE 10,000"                          format=f1.
      ER43550   LABEL="W8 WTR PROFIT GE 25,000"                          format=f1.
      ER43551   LABEL="W9 WTR PROFIT GE 2,000"                           format=f1.
      ER43552   LABEL="W10 WTR OWN BUSINESS/FARM"                        format=f1.
      ER43553   LABEL="W11 PROFIT IF SOLD BUSINESS/FARM"                 format=f9.
      ER43554   LABEL="W12 WTR PROFIT GE 50,000"                         format=f1.
      ER43555   LABEL="W13 WTR PROFIT GE 200,000"                        format=f1.
      ER43556   LABEL="W14 WTR PROFIT GE 10,000"                         format=f1.
      ER43557   LABEL="W15 WTR OWN NON-IRA STOCK"                        format=f1.
      ER43558   LABEL="W16 PROFIT IF SOLD NON-IRA STOCK"                 format=f9.
      ER43559   LABEL="W17 WTR PROFIT GE 25,000"                         format=f1.
      ER43560   LABEL="W18 WTR PROFIT GE 50,000"                         format=f1.
      ER43561   LABEL="W19 WTR PROFIT GE 5,000"                          format=f1.
      ER43562   LABEL="W20 WTR PROFIT GE 100,000"                        format=f1.
      ER43563   LABEL="W20D WTR DIVIDEND AMT CORRECT"                    format=f1.
      ER43564   LABEL="W20E REVISED DIVIDENDS"                           format=f6.
      ER43565   LABEL="W20E REVISED DIVIDENDS PER"                       format=f1.
      ER43566   LABEL="W20F WTR REC REV DIVIDENDS IN JAN"                format=f1.
      ER43567   LABEL="W20F WTR REC REV DIVIDENDS IN FEB"                format=f1.
      ER43568   LABEL="W20F WTR REC REV DIVIDENDS IN MAR"                format=f1.
      ER43569   LABEL="W20F WTR REC REV DIVIDENDS IN APR"                format=f1.
      ER43570   LABEL="W20F WTR REC REV DIVIDENDS IN MAY"                format=f1.
      ER43571   LABEL="W20F WTR REC REV DIVIDENDS IN JUN"                format=f1.
      ER43572   LABEL="W20F WTR REC REV DIVIDENDS IN JUL"                format=f1.
      ER43573   LABEL="W20F WTR REC REV DIVIDENDS IN AUG"                format=f1.
      ER43574   LABEL="W20F WTR REC REV DIVIDENDS IN SEP"                format=f1.
      ER43575   LABEL="W20F WTR REC REV DIVIDENDS IN OCT"                format=f1.
      ER43576   LABEL="W20F WTR REC REV DIVIDENDS IN NOV"                format=f1.
      ER43577   LABEL="W20F WTR REC REV DIVIDENDS IN DEC"                format=f1.
      ER43578   LABEL="W21 WTR IRA/PRIVATE ANNUITY"                      format=f1.
      ER43579   LABEL="W21A HOW FUNDS INVESTED"                          format=f1.
      ER43580   LABEL="W22 VALUE OF IRA/ANNUITY"                         format=f9.
      ER43581   LABEL="W23 WTR VALUE GE 25,000"                          format=f1.
      ER43582   LABEL="W24 WTR VALUE GE 50,000"                          format=f1.
      ER43583   LABEL="W25 WTR VALUE GE 5,000"                           format=f1.
      ER43584   LABEL="W26 WTR VALUE GE 100,000"                         format=f1.
      ER43585   LABEL="W27 WTR CK/SAVINGS/CD, ETC"                       format=f1.
      ER43586   LABEL="W28 AMT ALL ACCOUNTS"                             format=f9.
      ER43587   LABEL="W29 WTR VALUE GE 5,000"                           format=f1.
      ER43588   LABEL="W30 WTR VALUE GE 10,000"                          format=f1.
      ER43589   LABEL="W31 WTR VALUE GE 50,000"                          format=f1.
      ER43590   LABEL="W31D WTR INTEREST AMT CORRECT"                    format=f1.
      ER43591   LABEL="W31E REVISED INTEREST"                            format=f6.
      ER43592   LABEL="W31E REVISED INTEREST PER"                        format=f1.
      ER43593   LABEL="W31F WTR REC REV INTEREST IN JAN"                 format=f1.
      ER43594   LABEL="W31F WTR REC REV INTEREST IN FEB"                 format=f1.
      ER43595   LABEL="W31F WTR REC REV INTEREST IN MAR"                 format=f1.
      ER43596   LABEL="W31F WTR REC REV INTEREST IN APR"                 format=f1.
      ER43597   LABEL="W31F WTR REC REV INTEREST IN MAY"                 format=f1.
      ER43598   LABEL="W31F WTR REC REV INTEREST IN JUN"                 format=f1.
      ER43599   LABEL="W31F WTR REC REV INTEREST IN JUL"                 format=f1.
      ER43600   LABEL="W31F WTR REC REV INTEREST IN AUG"                 format=f1.
      ER43601   LABEL="W31F WTR REC REV INTEREST IN SEP"                 format=f1.
      ER43602   LABEL="W31F WTR REC REV INTEREST IN OCT"                 format=f1.
      ER43603   LABEL="W31F WTR REC REV INTEREST IN NOV"                 format=f1.
      ER43604   LABEL="W31F WTR REC REV INTEREST IN DEC"                 format=f1.
      ER43605   LABEL="W32 WTR VALUE GE 1,000"                           format=f1.
      ER43606   LABEL="W33 WTR BONDS/INSURANCE, ETC."                    format=f1.
      ER43607   LABEL="W34 PROFIT IF SOLD BONDS/INSURANCE"               format=f9.
      ER43608   LABEL="W35 WTR PROFIT GE 10,000"                         format=f1.
      ER43609   LABEL="W36 WTR PROFIT GE 25,000"                         format=f1.
      ER43610   LABEL="W37 WTR PROFIT GE 2,000"                          format=f1.
      ER43611   LABEL="W38 WTR OTHER DEBTS"                              format=f1.
      ER43612   LABEL="W39 VALUE ALL DEBTS"                              format=f9.
      ER43613   LABEL="W40 WTR DEBTS GE 2,000"                           format=f1.
      ER43614   LABEL="W41 WTR DEBTS GE 5,000"                           format=f1.
      ER43615   LABEL="W42 WTR DEBTS GE 1,000"                           format=f1.
      ER43616   LABEL="W43 WTR PUT MONEY IN PRIVATE ANNUITY/IRA"         format=f1.
      ER43617   LABEL="W44 AMT INVESTED IN IRA/ANNUITY"                  format=f9.
      ER43618   LABEL="W45 WTR INVEST GE 10,000"                         format=f1.
      ER43619   LABEL="W46 WTR INVEST GE 50,000"                         format=f1.
      ER43620   LABEL="W47 WTR INVEST GE 5,000"                          format=f1.
      ER43621   LABEL="W48 WTR CASHED PNSN/ANNTY/IRA"                    format=f1.
      ER43622   LABEL="W49 VALUE PENSION/ANNUITY/IRA"                    format=f9.
      ER43623   LABEL="W50 WTR VALUE GE 10,000"                          format=f1.
      ER43624   LABEL="W51 WTR VALUE GE 50,000"                          format=f1.
      ER43625   LABEL="W52 WTR VALUE GE 100,000"                         format=f1.
      ER43626   LABEL="W53 WTR VALUE GE 5,000"                           format=f1.
      ER43627   LABEL="W54 WTR SOLD HOME"                                format=f1.
      ER43628   LABEL="W55 HOME SELLING PRICE"                           format=f9.
      ER43629   LABEL="W56 WTR PRICE GE 60,000"                          format=f1.
      ER43630   LABEL="W57 WTR PRICE GE 120,000"                         format=f1.
      ER43631   LABEL="W58 WTR PRICE GE 30,000"                          format=f1.
      ER43632   LABEL="W59 WTR BOUGHT OTR REAL ESTATE"                   format=f1.
      ER43633   LABEL="W60 AMT IN REAL ESTATE"                           format=f9.
      ER43634   LABEL="W61 WTR AMT GE 60,000"                            format=f1.
      ER43635   LABEL="W62 WTR AMT GE 120,000"                           format=f1.
      ER43636   LABEL="W63 WTR AMT GE 30,000"                            format=f1.
      ER43637   LABEL="W64 WTR SOLD OTR REAL ESTATE"                     format=f1.
      ER43638   LABEL="W65 AMT FROM OTR REAL ESTATE"                     format=f9.
      ER43639   LABEL="W66 WTR AMT GE 60,000"                            format=f1.
      ER43640   LABEL="W67 WTR AMT GE 120,000"                           format=f1.
      ER43641   LABEL="W68 WTR AMT GE 30,000"                            format=f1.
      ER43642   LABEL="W69 WTR MADE ADDITION/REPAIRS"                    format=f1.
      ER43643   LABEL="W70 COST OF ADDITION/REPAIRS"                     format=f9.
      ER43644   LABEL="W71 WTR COST GE 25,000"                           format=f1.
      ER43645   LABEL="W72 WTR COST GE 75,000"                           format=f1.
      ER43646   LABEL="W73 WTR INVESTED IN BUSNES/FARM"                  format=f1.
      ER43647   LABEL="W74 AMT INVESTED IN BUSINESS/FARM"                format=f9.
      ER43648   LABEL="W75 WTR AMT GE 25,000"                            format=f1.
      ER43649   LABEL="W76 WTR AMT GE 100,000"                           format=f1.
      ER43650   LABEL="W77 WTR AMT GE 10,000"                            format=f1.
      ER43651   LABEL="W78 WTR SOLD BUSINESS/FARM"                       format=f1.
      ER43652   LABEL="W79 AMT FROM BUSINESS/FARM"                       format=f9.
      ER43653   LABEL="W80 WTR AMT GE 25,000"                            format=f1.
      ER43654   LABEL="W81 WTR AMT GE 100,000"                           format=f1.
      ER43655   LABEL="W82 WTR AMT GE 10,000"                            format=f1.
      ER43656   LABEL="W83 WTR BOUGHT NON-IRA STOCK"                     format=f1.
      ER43657   LABEL="W84 WTR ALSO SOLD STOCK"                          format=f1.
      ER43658   LABEL="W85 WTR BOUGHT MORE/SOLD MORE"                    format=f1.
      ER43659   LABEL="W86 BALANCE IN/OUT STOCKS"                        format=f9.
      ER43660   LABEL="W87 WTR STOCKS GE 20,000"                         format=f1.
      ER43661   LABEL="W88 WTR STOCKS GE 50,000"                         format=f1.
      ER43662   LABEL="W90 WTR STOCKS GE 100,000"                        format=f1.
      ER43663   LABEL="W89 WTR STOCKS GE 5,000"                          format=f1.
      ER43664   LABEL="W91 AMT INVESTED IN STOCKS"                       format=f9.
      ER43665   LABEL="W92 WTR AMT GE 20,000"                            format=f1.
      ER43666   LABEL="W93 WTR AMT GE 50,000"                            format=f1.
      ER43667   LABEL="W94 WTR AMT GE 100,000"                           format=f1.
      ER43668   LABEL="W95 WTR AMT GE 5,000"                             format=f1.
      ER43669   LABEL="W96 WTR SOLD NON-IRA STOCK"                       format=f1.
      ER43670   LABEL="W97 AMT NON-IRA STOCK"                            format=f9.
      ER43671   LABEL="W98 WTR AMT GE 20,000"                            format=f1.
      ER43672   LABEL="W99 WTR AMT GE 50,000"                            format=f1.
      ER43673   LABEL="W100 WTR AMT GE 100,000"                          format=f1.
      ER43674   LABEL="W101 WTR AMT GE 5,000"                            format=f1.
      ER43675   LABEL="W102 WTR MOVER OUT W/ ASSETS OR DEBITS"           format=f1.
      ER43676   LABEL="W103 VALUE ASSETS MOVED OUT"                      format=f9.
      ER43677   LABEL="W104 WTR VALUE GE 10,000"                         format=f1.
      ER43678   LABEL="W105 WTR VALUE GE 25,000"                         format=f1.
      ER43679   LABEL="W106 WTR VALUE GE 100,000"                        format=f1.
      ER43680   LABEL="W107 WTR VALUE GE 5,000"                          format=f1.
      ER43681   LABEL="W108 VALUE DEBTS MOVED OUT"                       format=f9.
      ER43682   LABEL="W109 WTR VALUE GE 10,000"                         format=f1.
      ER43683   LABEL="W110 WTR VALUE GE 25,000"                         format=f1.
      ER43684   LABEL="W111 WTR VALUE GE 5,000"                          format=f1.
      ER43685   LABEL="W112 CKPT: FU COMPOSITION"                        format=f1.
      ER43686   LABEL="W113 WTR MOVER IN W/ ASSETS OR DEBITS"            format=f1.
      ER43687   LABEL="W114 VALUE ASSETS MOVED IN"                       format=f9.
      ER43688   LABEL="W115 WTR VALUE GE 10,000"                         format=f1.
      ER43689   LABEL="W116 WTR VALUE GE 25,000"                         format=f1.
      ER43690   LABEL="W117 WTR VALUE GE 100,000"                        format=f1.
      ER43691   LABEL="W118 WTR VALUE GE 5,000"                          format=f1.
      ER43692   LABEL="W119 VALUE DEBTS MOVE IN"                         format=f9.
      ER43693   LABEL="W120 WTR VALUE GE 10,000"                         format=f1.
      ER43694   LABEL="W121 WTR VALUE GE 25,000"                         format=f1.
      ER43695   LABEL="W122 WTR VALUE GE 5,000"                          format=f1.
      ER43696   LABEL="W123 WTR RECD GIFT/INHERITANCE"                   format=f1.
      ER43697   LABEL="W124 YR RECD GIFT/INHERIT-#1"                     format=f4.
      ER43698   LABEL="W125 VALUE GIFT/INHERIT-#1"                       format=f9.
      ER43699   LABEL="W126 WTR VALUE GE 25,000-#1"                      format=f1.
      ER43700   LABEL="W127 WTR VALUE GE 75,000-#1"                      format=f1.
      ER43701   LABEL="W123 WTR GIFT/INHERITANCE-#2"                     format=f1.
      ER43702   LABEL="W124 YR RECD GIFT/INHERIT-#2"                     format=f4.
      ER43703   LABEL="W125 VALUE GIFT/INHERIT-#2"                       format=f9.
      ER43704   LABEL="W126 WTR VALUE GE 25,000-#2"                      format=f1.
      ER43705   LABEL="W127 WTR VALUE GE 75,000-#2"                      format=f1.
      ER43706   LABEL="W123 WTR GIFT/INHERITANCE-#3"                     format=f1.
      ER43707   LABEL="W124 YR REC GIFT/INHERIT-#3"                      format=f4.
      ER43708   LABEL="W125 VALUE GIFT/INHERIT-#3"                       format=f9.
      ER43709   LABEL="W126 WTR VALUE GE 25,000-#3"                      format=f1.
      ER43710   LABEL="W127 WTR VALUE GE 75,000-#3"                      format=f1.
      ER43711   LABEL="P0 WTR WORKING NOW"                               format=f1.
      ER43712   LABEL="P1 WTR PNSN AT CURR JOB"                          format=f1.
      ER43713   LABEL="P6 # YRS IN PENSION PLAN"                         format=f2.
      ER43714   LABEL="P6 YR JOINED PENSION PLAN"                        format=f4.
      ER43715   LABEL="P7 WTR EVER ELIG FOR PLAN"                        format=f1.
      ER43716   LABEL="P8 # YRS TILL ELIGIBLE"                           format=f3.
      ER43717   LABEL="P9 WTR VESTED"                                    format=f1.
      ER43718   LABEL="P10 # YRS TILL VESTED"                            format=f2.
      ER43719   LABEL="P11 WTR CONTRIB TO PENSION"                       format=f1.
      ER43720   LABEL="P12 WTR CONTRIB REQUIRED"                         format=f1.
      ER43721   LABEL="P13 REQUIRED AMT"                                 format=f7.
      ER43722   LABEL="P13 REQUIRED AMT PER"                             format=f1.
      ER43723   LABEL="P13 REQUIRED PCT"                                 format=f3.
      ER43724   LABEL="P14 WTR VOLUNTARY CONTRIB"                        format=f1.
      ER43725   LABEL="P15 VOLUNTARY AMT"                                format=f7.
      ER43726   LABEL="P15 VOLUNTARY AMT PER"                            format=f1.
      ER43727   LABEL="P15 VOLUNTARY PCT"                                format=f3.
      ER43728   LABEL="P16 HOW BENEFIT FIGURED"                          format=f1.
      ER43729   LABEL="P17 WTR EMPLYR CONTRIB"                           format=f1.
      ER43730   LABEL="P18 AMT EMPLYR CONTRIB"                           format=f7.
      ER43731   LABEL="P18 EMPLYR AMT PER"                               format=f1.
      ER43732   LABEL="P18 PCT EMPLYR CONTRIB"                           format=f3.
      ER43733   LABEL="P19 AGE PENSION INCL EMPLYR CONTRIB"              format=f3.
      ER43734   LABEL="P20 AMT IN PENSION ACCT NOW"                      format=f9.
      ER43735   LABEL="P20B WTR AMT GE 10,000"                           format=f1.
      ER43736   LABEL="P20C WTR AMT GE 20,000"                           format=f1.
      ER43737   LABEL="P20D WTR AMT GE 50,000"                           format=f1.
      ER43738   LABEL="P20E WTR AMT GE 150,000"                          format=f1.
      ER43739   LABEL="P20A HOW FUNDS INVESTED"                          format=f1.
      ER43740   LABEL="P21 AMT COULD TAKE IF LEAVE EMPLYR"               format=f9.
      ER43741   LABEL="P21 AMT PER IF LEAVE EMPLYR"                      format=f1.
      ER43742   LABEL="P21 PCT COULD TAKE IF LEAVE EMPLYR"               format=f3.
      ER43743   LABEL="P22 CKPT: TYPE PENSION"                           format=f1.
      ER43744   LABEL="P23 BENEFIT FORMULA"                              format=f1.
      ER43745   LABEL="P24 AGE FULL BENEFITS"                            format=f3.
      ER43746   LABEL="P25 # YRS NEC FOR FULL BENEFITS"                  format=f3.
      ER43747   LABEL="P26 AGE IF AGE+YRS"                               format=f3.
      ER43748   LABEL="P26 # YRS IF AGE+YRS"                             format=f3.
      ER43749   LABEL="P27 WTR REC PART PNSN IF RETIRE EARLY"            format=f1.
      ER43750   LABEL="P28 EARLY RETRMT FORMULA"                         format=f1.
      ER43751   LABEL="P29 AGE ELIG PART BENEFITS"                       format=f3.
      ER43752   LABEL="P30 # YRS ELIG PART BENEFITS"                     format=f2.
      ER43753   LABEL="P31 AGE IF AGE+YRS"                               format=f3.
      ER43754   LABEL="P31 # YRS IF AGE+YRS"                             format=f3.
      ER43755   LABEL="P32 AGE EXPECT RECEIVE BENEFITS"                  format=f3.
      ER43756   LABEL="P33 WTR CAN ESTIMATE BENEFIT"                     format=f1.
      ER43757   LABEL="P34 ESTIMATED BENEFIT AMT"                        format=f7.
      ER43758   LABEL="P34 ESTIMATED BENEFIT PER"                        format=f1.
      ER43759   LABEL="P34 ESTIMATED BENEFIT PCT"                        format=f3.
      ER43760   LABEL="P34 ESTIMATED LUMP SUM BENEFIT"                   format=f9.
      ER43761   LABEL="P34B WTR AMT GE 1,000 PER MONTH"                  format=f1.
      ER43762   LABEL="P34C WTR AMT GE 2,000 PER MONTH"                  format=f1.
      ER43763   LABEL="P34D WTR AMT GE 3,000 PER MONTH"                  format=f1.
      ER43764   LABEL="P34E WTR AMT GE 500 PER MONTH"                    format=f1.
      ER43765   LABEL="P35 WTR BENEFICIARY"                              format=f1.
      ER43766   LABEL="P36 AMT BENEFICIARY RECEIVES"                     format=f1.
      ER43767   LABEL="P37 WTR PNSN LESSENED BY SOC SEC"                 format=f1.
      ER43768   LABEL="P38 WHEN SOC SEC CHG PNSN AMT"                    format=f1.
      ER43769   LABEL="P39 USUAL RETIREMNT AGE OF OTRS"                  format=f2.
      ER43770   LABEL="P39 USUAL # YRS OTRS RETIRE"                      format=f2.
      ER43771   LABEL="P40 AGE PLAN STOP WORK"                           format=f3.
      ER43772   LABEL="P40 YR PLAN STOP WORK"                            format=f4.
      ER43773   LABEL="P41 AGE WILL STOP WORK"                           format=f3.
      ER43774   LABEL="P41 YR WILL STOP WORK"                            format=f4.
      ER43775   LABEL="P42 WTR TAX-DEFER PLAN"                           format=f1.
      ER43776   LABEL="P43 WTR EMPLYR CONTRIB"                           format=f1.
      ER43777   LABEL="P44 AMT EMPLYR CONTRIB"                           format=f7.
      ER43778   LABEL="P44 EMPLYR CONTRIB PER"                           format=f1.
      ER43779   LABEL="P44 PCT EMPLYR CONTRIB"                           format=f3.
      ER43780   LABEL="P45 WTR PNSN W/PREV EMPLYR"                       format=f1.
      ER43781   LABEL="P46 TYPE PREV PENSION-#1"                         format=f1.
      ER43782   LABEL="P47 ACCT AMT WHEN LEFT PREV EMPLYR-#1"            format=f8.
      ER43783   LABEL="P47B WTR AMT GE 20,000-#1"                        format=f1.
      ER43784   LABEL="P47C WTR AMT GE 50,000-#1"                        format=f1.
      ER43785   LABEL="P47D WTR AMT GE 150,000-#1"                       format=f1.
      ER43786   LABEL="P47E WTR AMT GE 5,000-#1"                         format=f1.
      ER43787   LABEL="P48 WHAT DID W/PREV PNSN-#1"                      format=f1.
      ER43788   LABEL="P49 AMT NOW PREV PNSN ACCT-#1"                    format=f8.
      ER43789   LABEL="P49B WTR AMT GE 10,000-#1"                        format=f1.
      ER43790   LABEL="P49C WTR AMT GE 20,000-#1"                        format=f1.
      ER43791   LABEL="P49D WTR AMT GE 50,000-#1"                        format=f1.
      ER43792   LABEL="P49E WTR AMT GE 150,000-#1"                       format=f1.
      ER43793   LABEL="P50 AGE REC IF ANNUITY-#1"                        format=f2.
      ER43794   LABEL="P51 AMT PREV ANNUITY-#1"                          format=f7.
      ER43795   LABEL="P51 PREV ANNUITY PER-#1"                          format=f1.
      ER43796   LABEL="P51B WTR AMT GE 400 PER MONTH-#1"                 format=f1.
      ER43797   LABEL="P51C WTR AMT GE 1,200 PER MONTH-#1"               format=f1.
      ER43798   LABEL="P51D WTR AMT GE 1,600 PER MONTH-#1"               format=f1.
      ER43799   LABEL="P51E WTR AMT GE 200 PER MONTH-#1"                 format=f1.
      ER43800   LABEL="P52 STATUS PREV PNSN MEN1-#1"                     format=f1.
      ER43801   LABEL="P52 STATUS PREV PNSN MEN2-#1"                     format=f1.
      ER43802   LABEL="P52 STATUS PREV PNSN MEN3-#1"                     format=f1.
      ER43803   LABEL="P52 STATUS PREV PNSN MEN4-#1"                     format=f1.
      ER43804   LABEL="P52 STATUS PREV PNSN MEN5-#1"                     format=f1.
      ER43805   LABEL="P52 STATUS PREV PNSN MEN6-#1"                     format=f1.
      ER43806   LABEL="P53 MO REC PREV PNSN-#1"                          format=f2.
      ER43807   LABEL="P53 YR REC PREV PNSN-#1"                          format=f4.
      ER43808   LABEL="P54 PREV PNSN BENEFIT AMT-#1"                     format=f7.
      ER43809   LABEL="P54 BENEFIT PER-#1"                               format=f1.
      ER43810   LABEL="P54B WTR AMT GE 400 PER MONTH-#1"                 format=f1.
      ER43811   LABEL="P54C WTR AMT GE 1,200 PER MONTH-#1"               format=f1.
      ER43812   LABEL="P54D WTR AMT GE 1,600 PER MONTH-#1"               format=f1.
      ER43813   LABEL="P54E WTR AMT GE 200 PER MONTH-#1"                 format=f1.
      ER43814   LABEL="P55 WTR BENEFITS COLA-#1"                         format=f1.
      ER43815   LABEL="P56 WTR BENEFITS EVER COLA-#1"                    format=f1.
      ER43816   LABEL="P57 PREV PNSN CASH SETTLEMNT AMT-#1"              format=f7.
      ER43817   LABEL="P57B WTR AMT GE 6,000-#1"                         format=f1.
      ER43818   LABEL="P57C WTR AMT GE 60,000-#1"                        format=f1.
      ER43819   LABEL="P57D WTR AMT GE 250,000-#1"                       format=f1.
      ER43820   LABEL="P57E WTR AMT GE 2,000-#1"                         format=f1.
      ER43821   LABEL="P58 WHAT DID W/CASH MEN1-#1"                      format=f1.
      ER43822   LABEL="P58 WHAT DID W/CASH MEN2-#1"                      format=f1.
      ER43823   LABEL="P58 WHAT DID W/CASH MEN3-#1"                      format=f1.
      ER43824   LABEL="P58 WHAT DID W/CASH MEN4-#1"                      format=f1.
      ER43825   LABEL="P58 WHAT DID W/CASH MEN5-#1"                      format=f1.
      ER43826   LABEL="P58 WHAT DID W/CASH MEN6-#1"                      format=f1.
      ER43827   LABEL="P59 PREV PNSN IRA AMT-#1"                         format=f7.
      ER43828   LABEL="P59B WTR AMT GE 6,000-#1"                         format=f1.
      ER43829   LABEL="P59C WTR AMT GE 60,000-#1"                        format=f1.
      ER43830   LABEL="P59D WTR AMT GE 250,000-#1"                       format=f1.
      ER43831   LABEL="P59E WTR AMT GE 2,000-#1"                         format=f1.
      ER43832   LABEL="P60 # YRS IN PREV PLAN-#1"                        format=f2.
      ER43833   LABEL="P61 AGE EXPECT REC PREV PNSN-#1"                  format=f2.
      ER43834   LABEL="P62 AMT EXPECT REC PREV PNSN-#1"                  format=f6.
      ER43835   LABEL="P62 PREV PNSN PER-#1"                             format=f1.
      ER43836   LABEL="P62 PCT EXPECT REC PREV PNSN-#1"                  format=f3.
      ER43837   LABEL="P62 LUMP SUM EXPECT PREV PNSN-#1"                 format=f8.
      ER43838   LABEL="P62B WTR AMT GE 1,000-#1"                         format=f1.
      ER43839   LABEL="P62C WTR AMT GE 2,000-#1"                         format=f1.
      ER43840   LABEL="P62D WTR AMT GE 3,000-#1"                         format=f1.
      ER43841   LABEL="P62E WTR AMT GE 500-#1"                           format=f1.
      ER43842   LABEL="P63 ACCT AMT WHEN LEFT PREV EMPLYR-#1"            format=f7.
      ER43843   LABEL="P63B WTR AMT GE 20,000-#1"                        format=f1.
      ER43844   LABEL="P63C WTR AMT GE 50,000-#1"                        format=f1.
      ER43845   LABEL="P63D WTR AMT GE 150,000-#1"                       format=f1.
      ER43846   LABEL="P63E WTR AMT GE 5,000-#1"                         format=f1.
      ER43847   LABEL="P64 WHAT DID W/PREV PNSN-#1"                      format=f1.
      ER43848   LABEL="P65 ACCT AMT PREV PNSN NOW-#1"                    format=f8.
      ER43849   LABEL="P65B WTR AMT GE 10,000-#1"                        format=f1.
      ER43850   LABEL="P65C WTR AMT GE 20,000-#1"                        format=f1.
      ER43851   LABEL="P65D WTR AMT GE 50,000-#1"                        format=f1.
      ER43852   LABEL="P65E WTR AMT GE 150,000-#1"                       format=f1.
      ER43853   LABEL="P66 AGE BEGAN REC ANNUITY-#1"                     format=f2.
      ER43854   LABEL="P67 AMT PREV ANNUITY-#1"                          format=f7.
      ER43855   LABEL="P67 PREV ANNUITY PER-#1"                          format=f1.
      ER43856   LABEL="P67B WTR AMT GE 400 PER MONTH-#1"                 format=f1.
      ER43857   LABEL="P67C WTR AMT GE 1,200 PER MONTH-#1"               format=f1.
      ER43858   LABEL="P67D WTR AMT GE 1,600 PER MONTH-#1"               format=f1.
      ER43859   LABEL="P67E WTR AMT GE 200 PER MONTH-#1"                 format=f1.
      ER43860   LABEL="P68 AGE ELIG PREV PNSN-#1"                        format=f2.
      ER43861   LABEL="P69 WTR SECOND PREV PENSION"                      format=f1.
      ER43862   LABEL="P46 TYPE PREV PENSION-#2"                         format=f1.
      ER43863   LABEL="P47 ACCT AMT WHEN LEFT PREV EMPLYR-#2"            format=f8.
      ER43864   LABEL="P47B WTR AMT GE 20,000-#2"                        format=f1.
      ER43865   LABEL="P47C WTR AMT GE 50,000-#2"                        format=f1.
      ER43866   LABEL="P47D WTR AMT GE 150,000-#2"                       format=f1.
      ER43867   LABEL="P47E WTR AMT GE 5,000-#2"                         format=f1.
      ER43868   LABEL="P48 WHAT DID W/PREV PNSN-#2"                      format=f1.
      ER43869   LABEL="P49 AMT NOW PREV PNSN ACCT-#2"                    format=f8.
      ER43870   LABEL="P49B WTR AMT GE 10,000-#2"                        format=f1.
      ER43871   LABEL="P49C WTR AMT GE 20,000-#2"                        format=f1.
      ER43872   LABEL="P49D WTR AMT GE 50,000-#2"                        format=f1.
      ER43873   LABEL="P49E WTR AMT GE 150,000-#2"                       format=f1.
      ER43874   LABEL="P50 AGE REC IF ANNUITY-#2"                        format=f2.
      ER43875   LABEL="P51 AMT PREV ANNUITY-#2"                          format=f7.
      ER43876   LABEL="P51 PREV ANNUITY PER-#2"                          format=f1.
      ER43877   LABEL="P51B WTR AMT GE 400 PER MONTH-#2"                 format=f1.
      ER43878   LABEL="P51C WTR AMT GE 1,200 PER MONTH-#2"               format=f1.
      ER43879   LABEL="P51D WTR AMT GE 1,600 PER MONTH-#2"               format=f1.
      ER43880   LABEL="P51E WTR AMT GE 200 PER MONTH-#2"                 format=f1.
      ER43881   LABEL="P52 STATUS PREV PNSN MEN1-#2"                     format=f1.
      ER43882   LABEL="P52 STATUS PREV PNSN MEN2-#2"                     format=f1.
      ER43883   LABEL="P52 STATUS PREV PNSN MEN3-#2"                     format=f1.
      ER43884   LABEL="P52 STATUS PREV PNSN MEN4-#2"                     format=f1.
      ER43885   LABEL="P52 STATUS PREV PNSN MEN5-#2"                     format=f1.
      ER43886   LABEL="P52 STATUS PREV PNSN MEN6-#2"                     format=f1.
      ER43887   LABEL="P53 MO REC PREV PNSN-#2"                          format=f2.
      ER43888   LABEL="P53 YR REC PREV PNSN-#2"                          format=f4.
      ER43889   LABEL="P54 PREV PNSN BENEFIT AMT-#2"                     format=f7.
      ER43890   LABEL="P54 BENEFIT PER-#2"                               format=f1.
      ER43891   LABEL="P54B WTR AMT GE 400 PER MONTH-#2"                 format=f1.
      ER43892   LABEL="P54C WTR AMT GE 1,200 PER MONTH-#2"               format=f1.
      ER43893   LABEL="P54D WTR AMT GE 1,600 PER MONTH-#2"               format=f1.
      ER43894   LABEL="P54E WTR AMT GE 200 PER MONTH-#2"                 format=f1.
      ER43895   LABEL="P55 WTR BENEFITS COLA-#2"                         format=f1.
      ER43896   LABEL="P56 WTR BENEFITS EVER COLA-#2"                    format=f1.
      ER43897   LABEL="P57 PREV PNSN CASH SETTLEMNT AMT-#2"              format=f7.
      ER43898   LABEL="P57B WTR AMT GE 6,000-#2"                         format=f1.
      ER43899   LABEL="P57C WTR AMT GE 60,000-#2"                        format=f1.
      ER43900   LABEL="P57D WTR AMT GE 250,000-#2"                       format=f1.
      ER43901   LABEL="P57E WTR AMT GE 2,000-#2"                         format=f1.
      ER43902   LABEL="P58 WHAT DID W/CASH MEN1-#2"                      format=f1.
      ER43903   LABEL="P58 WHAT DID W/CASH MEN2-#2"                      format=f1.
      ER43904   LABEL="P58 WHAT DID W/CASH MEN3-#2"                      format=f1.
      ER43905   LABEL="P58 WHAT DID W/CASH MEN4-#2"                      format=f1.
      ER43906   LABEL="P58 WHAT DID W/CASH MEN5-#2"                      format=f1.
      ER43907   LABEL="P58 WHAT DID W/CASH MEN6-#2"                      format=f1.
      ER43908   LABEL="P59 PREV PNSN IRA AMT-#2"                         format=f7.
      ER43909   LABEL="P59B WTR AMT GE 6,000-#2"                         format=f1.
      ER43910   LABEL="P59C WTR AMT GE 60,000-#2"                        format=f1.
      ER43911   LABEL="P59D WTR AMT GE 250,000-#2"                       format=f1.
      ER43912   LABEL="P59E WTR AMT GE 2,000-#2"                         format=f1.
      ER43913   LABEL="P60 # YRS IN PREV PLAN-#2"                        format=f2.
      ER43914   LABEL="P61 AGE EXPECT REC PREV PNSN-#2"                  format=f2.
      ER43915   LABEL="P62 AMT EXPECT REC PREV PNSN-#2"                  format=f6.
      ER43916   LABEL="P62 PREV PNSN PER-#2"                             format=f1.
      ER43917   LABEL="P62 PCT EXPECT REC PREV PNSN-#2"                  format=f3.
      ER43918   LABEL="P62 LUMP SUM EXPECT PREV PNSN-#2"                 format=f8.
      ER43919   LABEL="P62B WTR AMT GE 1,000-#2"                         format=f1.
      ER43920   LABEL="P62C WTR AMT GE 2,000-#2"                         format=f1.
      ER43921   LABEL="P62D WTR AMT GE 3,000-#2"                         format=f1.
      ER43922   LABEL="P62E WTR AMT GE 500-#2"                           format=f1.
      ER43923   LABEL="P63 ACCT AMT WHEN LEFT PREV EMPLYR-#2"            format=f7.
      ER43924   LABEL="P63B WTR AMT GE 20,000-#2"                        format=f1.
      ER43925   LABEL="P63C WTR AMT GE 50,000-#2"                        format=f1.
      ER43926   LABEL="P63D WTR AMT GE 150,000-#2"                       format=f1.
      ER43927   LABEL="P63E WTR AMT GE 5,000-#2"                         format=f1.
      ER43928   LABEL="P64 WHAT DID W/PREV PNSN-#2"                      format=f1.
      ER43929   LABEL="P65 ACCT AMT PREV PNSN NOW-#2"                    format=f8.
      ER43930   LABEL="P65B WTR AMT GE 10,000-#2"                        format=f1.
      ER43931   LABEL="P65C WTR AMT GE 20,000-#2"                        format=f1.
      ER43932   LABEL="P65D WTR AMT GE 50,000-#2"                        format=f1.
      ER43933   LABEL="P65E WTR AMT GE 150,000-#2"                       format=f1.
      ER43934   LABEL="P66 AGE BEGAN REC ANNUITY-#2"                     format=f2.
      ER43935   LABEL="P67 AMT PREV ANNUITY-#2"                          format=f7.
      ER43936   LABEL="P67 PREV ANNUITY PER-#2"                          format=f1.
      ER43937   LABEL="P67B WTR AMT GE 400 PER MONTH-#2"                 format=f1.
      ER43938   LABEL="P67C WTR AMT GE 1,200 PER MONTH-#2"               format=f1.
      ER43939   LABEL="P67D WTR AMT GE 1,600 PER MONTH-#2"               format=f1.
      ER43940   LABEL="P67E WTR AMT GE 200 PER MONTH-#2"                 format=f1.
      ER43941   LABEL="P68 AGE ELIG PREV PNSN-#2"                        format=f2.
      ER43942   LABEL="P69 WTR 3RD PREV PENSION"                         format=f1.
      ER43943   LABEL="P70 WTR WORKING NOW"                              format=f1.
      ER43944   LABEL="P71 WTR PNSN AT CURR JOB"                         format=f1.
      ER43945   LABEL="P76 # YRS IN PENSION PLAN"                        format=f2.
      ER43946   LABEL="P76 YR JOINED PENSION PLAN"                       format=f4.
      ER43947   LABEL="P77 WTR EVER ELIG FOR PLAN"                       format=f1.
      ER43948   LABEL="P78 # YRS TILL ELIGIBLE"                          format=f3.
      ER43949   LABEL="P79 WTR VESTED"                                   format=f1.
      ER43950   LABEL="P80 # YRS TILL VESTED"                            format=f2.
      ER43951   LABEL="P81 WTR CONTRIB TO PENSION"                       format=f1.
      ER43952   LABEL="P82 WTR CONTRIB REQUIRED"                         format=f1.
      ER43953   LABEL="P83 REQUIRED AMT"                                 format=f7.
      ER43954   LABEL="P83 REQUIRED AMT PER"                             format=f1.
      ER43955   LABEL="P83 REQUIRED PCT"                                 format=f3.
      ER43956   LABEL="P84 WTR VOLUNTARY CONTRIB"                        format=f1.
      ER43957   LABEL="P85 VOLUNTARY AMT"                                format=f7.
      ER43958   LABEL="P85 VOLUNTARY AMT PER"                            format=f1.
      ER43959   LABEL="P85 VOLUNTARY PCT"                                format=f3.
      ER43960   LABEL="P86 HOW BENEFIT FIGURED"                          format=f1.
      ER43961   LABEL="P87 WTR EMPLYR CONTRIB"                           format=f1.
      ER43962   LABEL="P88 AMT EMPLYR CONTRIB"                           format=f7.
      ER43963   LABEL="P88 EMPLYR AMT PER"                               format=f1.
      ER43964   LABEL="P88 PCT EMPLYR CONTRIB"                           format=f3.
      ER43965   LABEL="P89 AGE PENSION INCL EMPLYR CONTRIB"              format=f3.
      ER43966   LABEL="P90 AMT IN PENSION ACCT NOW"                      format=f9.
      ER43967   LABEL="P90B WTR AMT GE 10,000"                           format=f1.
      ER43968   LABEL="P90C WTR AMT GE 20,000"                           format=f1.
      ER43969   LABEL="P90D WTR AMT GE 50,000"                           format=f1.
      ER43970   LABEL="P90E WTR AMT GE 150,000"                          format=f1.
      ER43971   LABEL="P90A HOW FUNDS INVESTED"                          format=f1.
      ER43972   LABEL="P91 AMT COULD TAKE IF LEAVE EMPLYR"               format=f9.
      ER43973   LABEL="P91 AMT PER IF LEAVE EMPLYR"                      format=f1.
      ER43974   LABEL="P91 PCT COULD TAKE IF LEAVE EMPLYR"               format=f3.
      ER43975   LABEL="P92 CKPT: TYPE PENSION"                           format=f1.
      ER43976   LABEL="P93 BENEFIT FORMULA"                              format=f1.
      ER43977   LABEL="P94 AGE FULL BENEFITS"                            format=f3.
      ER43978   LABEL="P95 # YRS NEC FOR FULL BENEFITS"                  format=f3.
      ER43979   LABEL="P96 AGE IF AGE+YRS"                               format=f3.
      ER43980   LABEL="P96 # YRS IF AGE+YRS"                             format=f3.
      ER43981   LABEL="P97 WTR REC PART PNSN IF RETIRE EARLY"            format=f1.
      ER43982   LABEL="P98 EARLY RETRMT FORMULA"                         format=f1.
      ER43983   LABEL="P99 AGE ELIG PART BENEFITS"                       format=f3.
      ER43984   LABEL="P100 # YRS ELIG PART BENEFITS"                    format=f2.
      ER43985   LABEL="P101 AGE IF AGE+YRS"                              format=f3.
      ER43986   LABEL="P101 # YRS IF AGE+YRS"                            format=f3.
      ER43987   LABEL="P102 AGE EXPECT RECEIVE BENEFITS"                 format=f3.
      ER43988   LABEL="P103 WTR CAN ESTIMATE BENEFIT"                    format=f1.
      ER43989   LABEL="P104 ESTIMATED BENEFIT AMT"                       format=f7.
      ER43990   LABEL="P104 ESTIMATED BENEFIT PER"                       format=f1.
      ER43991   LABEL="P104 ESTIMATED BENEFIT PCT"                       format=f3.
      ER43992   LABEL="P104 ESTIMATED LUMP SUM BENEFIT"                  format=f9.
      ER43993   LABEL="P104B WTR AMT GE 1,000 PER MONTH"                 format=f1.
      ER43994   LABEL="P104C WTR AMT GE 2,000 PER MONTH"                 format=f1.
      ER43995   LABEL="P104D WTR AMT GE 3,000 PER MONTH"                 format=f1.
      ER43996   LABEL="P104E WTR AMT GE 500 PER MONTH"                   format=f1.
      ER43997   LABEL="P105 WTR BENEFICIARY"                             format=f1.
      ER43998   LABEL="P106 AMT BENEFICIARY RECEIVES"                    format=f1.
      ER43999   LABEL="P107 WTR PNSN LESSENED BY SOC SEC"                format=f1.
      ER44000   LABEL="P108 WHEN SOC SEC CHG PNSN AMT"                   format=f1.
      ER44001   LABEL="P109 USUAL RETIRMNT AGE OF OTRS"                  format=f2.
      ER44002   LABEL="P109 USUAL # YRS OTRS RETIRE"                     format=f2.
      ER44003   LABEL="P110 AGE PLAN STOP WORK"                          format=f3.
      ER44004   LABEL="P110 YR PLAN STOP WORK"                           format=f4.
      ER44005   LABEL="P111 AGE WILL STOP WORK"                          format=f3.
      ER44006   LABEL="P111 YR WILL STOP WORK"                           format=f4.
      ER44007   LABEL="P112 WTR TAX-DEFER PLAN"                          format=f1.
      ER44008   LABEL="P113 WTR EMPLYR CONTRIB"                          format=f1.
      ER44009   LABEL="P114 AMT EMPLYR CONTRIB"                          format=f7.
      ER44010   LABEL="P114 EMPLYR CONTRIB PER"                          format=f1.
      ER44011   LABEL="P114 PCT EMPLYR CONTRIB"                          format=f3.
      ER44012   LABEL="P115 WTR PNSN W/PREV EMPLYR"                      format=f1.
      ER44013   LABEL="P116 TYPE PREV PENSION-#1"                        format=f1.
      ER44014   LABEL="P117 ACCT AMT WHEN LEFT PREV EMPLYR-#1"           format=f8.
      ER44015   LABEL="P117B WTR AMT GE 20,000-#1"                       format=f1.
      ER44016   LABEL="P117C WTR AMT GE 50,000-#1"                       format=f1.
      ER44017   LABEL="P117D WTR AMT GE 150,000-#1"                      format=f1.
      ER44018   LABEL="P117E WTR AMT GE 5,000-#1"                        format=f1.
      ER44019   LABEL="P118 WHAT DID W/PREV PNSN-#1"                     format=f1.
      ER44020   LABEL="P119 AMT NOW PREV PNSN ACCT-#1"                   format=f8.
      ER44021   LABEL="P119B WTR AMT GE 10,000-#1"                       format=f1.
      ER44022   LABEL="P119C WTR AMT GE 20,000-#1"                       format=f1.
      ER44023   LABEL="P119D WTR AMT GE 50,000-#1"                       format=f1.
      ER44024   LABEL="P119E WTR AMT GE 150,000-#1"                      format=f1.
      ER44025   LABEL="P120 AGE REC IF ANNUITY-#1"                       format=f2.
      ER44026   LABEL="P121 AMT PREV ANNUITY-#1"                         format=f7.
      ER44027   LABEL="P121 PREV ANNUITY PER-#1"                         format=f1.
      ER44028   LABEL="P121B WTR AMT GE 400 PER MONTH-#1"                format=f1.
      ER44029   LABEL="P121C WTR AMT GE 1,200 PER MONTH-#1"              format=f1.
      ER44030   LABEL="P121D WTR AMT GE 1,600 PER MONTH-#1"              format=f1.
      ER44031   LABEL="P121E WTR AMT GE 200 PER MONTH-#1"                format=f1.
      ER44032   LABEL="P122 STATUS PREV PNSN MEN1-#1"                    format=f1.
      ER44033   LABEL="P122 STATUS PREV PNSN MEN2-#1"                    format=f1.
      ER44034   LABEL="P122 STATUS PREV PNSN MEN3-#1"                    format=f1.
      ER44035   LABEL="P122 STATUS PREV PNSN MEN4-#1"                    format=f1.
      ER44036   LABEL="P122 STATUS PREV PNSN MEN5-#1"                    format=f1.
      ER44037   LABEL="P122 STATUS PREV PNSN MEN6-#1"                    format=f1.
      ER44038   LABEL="P123 MO REC PREV PNSN-#1"                         format=f2.
      ER44039   LABEL="P123 YR REC PREV PNSN-#1"                         format=f4.
      ER44040   LABEL="P124 PREV PNSN BENEFIT AMT-#1"                    format=f7.
      ER44041   LABEL="P124 BENEFIT PER-#1"                              format=f1.
      ER44042   LABEL="P124B WTR AMT GE 400 PER MONTH-#1"                format=f1.
      ER44043   LABEL="P124C WTR AMT GE 1,200 PER MONTH-#1"              format=f1.
      ER44044   LABEL="P124D WTR AMT GE 1,600 PER MONTH-#1"              format=f1.
      ER44045   LABEL="P124E WTR AMT GE 200 PER MONTH-#1"                format=f1.
      ER44046   LABEL="P125 WTR BENEFITS COLA-#1"                        format=f1.
      ER44047   LABEL="P126 WTR BENEFITS EVER COLA-#1"                   format=f1.
      ER44048   LABEL="P127 PREV PNSN CASH SETTLEMNT AMT-#1"             format=f7.
      ER44049   LABEL="P127B WTR AMT GE 6,000-#1"                        format=f1.
      ER44050   LABEL="P127C WTR AMT GE 60,000-#1"                       format=f1.
      ER44051   LABEL="P127D WTR AMT GE 250,000-#1"                      format=f1.
      ER44052   LABEL="P127E WTR AMT GE 2,000-#1"                        format=f1.
      ER44053   LABEL="P128 WHAT DID W/CASH MEN1-#1"                     format=f1.
      ER44054   LABEL="P128 WHAT DID W/CASH MEN2-#1"                     format=f1.
      ER44055   LABEL="P128 WHAT DID W/CASH MEN3-#1"                     format=f1.
      ER44056   LABEL="P128 WHAT DID W/CASH MEN4-#1"                     format=f1.
      ER44057   LABEL="P128 WHAT DID W/CASH MEN5-#1"                     format=f1.
      ER44058   LABEL="P128 WHAT DID W/CASH MEN6-#1"                     format=f1.
      ER44059   LABEL="P129 PREV PNSN IRA AMT-#1"                        format=f7.
      ER44060   LABEL="P129B WTR AMT GE 6,000-#1"                        format=f1.
      ER44061   LABEL="P129C WTR AMT GE 60,000-#1"                       format=f1.
      ER44062   LABEL="P129D WTR AMT GE 250,000-#1"                      format=f1.
      ER44063   LABEL="P129E WTR AMT GE 2,000-#1"                        format=f1.
      ER44064   LABEL="P130 # YRS IN PREV PLAN-#1"                       format=f2.
      ER44065   LABEL="P131 AGE EXPECT REC PREV PNSN-#1"                 format=f2.
      ER44066   LABEL="P132 AMT EXPECT REC PREV PNSN-#1"                 format=f6.
      ER44067   LABEL="P132 PREV PNSN PER-#1"                            format=f1.
      ER44068   LABEL="P132 PCT EXPECT REC PREV PNSN-#1"                 format=f3.
      ER44069   LABEL="P132 LUMP SUM EXPECT PREV PNSN-#1"                format=f8.
      ER44070   LABEL="P132B WTR AMT GE 1,000-#1"                        format=f1.
      ER44071   LABEL="P132C WTR AMT GE 2,000-#1"                        format=f1.
      ER44072   LABEL="P132D WTR AMT GE 3,000-#1"                        format=f1.
      ER44073   LABEL="P132E WTR AMT GE 500-#1"                          format=f1.
      ER44074   LABEL="P133 ACCT AMT WHEN LEFT PREV EMPLYR-#1"           format=f7.
      ER44075   LABEL="P133B WTR AMT GE 20,000-#1"                       format=f1.
      ER44076   LABEL="P133C WTR AMT GE 50,000-#1"                       format=f1.
      ER44077   LABEL="P133D WTR AMT GE 150,000-#1"                      format=f1.
      ER44078   LABEL="P133E WTR AMT GE 5,000-#1"                        format=f1.
      ER44079   LABEL="P134 WHAT DID W/PREV PNSN-#1"                     format=f1.
      ER44080   LABEL="P135 ACCT AMT PREV PNSN NOW-#1"                   format=f8.
      ER44081   LABEL="P135B WTR AMT GE 10,000-#1"                       format=f1.
      ER44082   LABEL="P135C WTR AMT GE 20,000-#1"                       format=f1.
      ER44083   LABEL="P135D WTR AMT GE 50,000-#1"                       format=f1.
      ER44084   LABEL="P135E WTR AMT GE 150,000-#1"                      format=f1.
      ER44085   LABEL="P136 AGE BEGAN REC ANNUITY-#1"                    format=f2.
      ER44086   LABEL="P137 AMT PREV ANNUITY-#1"                         format=f7.
      ER44087   LABEL="P137 PREV ANNUITY PER-#1"                         format=f1.
      ER44088   LABEL="P137B WTR AMT GE 400 PER MONTH-#1"                format=f1.
      ER44089   LABEL="P137C WTR AMT GE 1,200 PER MONTH-#1"              format=f1.
      ER44090   LABEL="P137D WTR AMT GE 1,600 PER MONTH-#1"              format=f1.
      ER44091   LABEL="P137E WTR AMT GE 200 PER MONTH-#1"                format=f1.
      ER44092   LABEL="P138 AGE ELIG PREV PNSN-#1"                       format=f2.
      ER44093   LABEL="P139 WTR SECOND PREV PENSION"                     format=f1.
      ER44094   LABEL="P116 TYPE PREV PENSION-#2"                        format=f1.
      ER44095   LABEL="P117 ACCT AMT WHEN LEFT PREV EMPLYR-#2"           format=f8.
      ER44096   LABEL="P117B WTR AMT GE 20,000-#2"                       format=f1.
      ER44097   LABEL="P117C WTR AMT GE 50,000-#2"                       format=f1.
      ER44098   LABEL="P117D WTR AMT GE 150,000-#2"                      format=f1.
      ER44099   LABEL="P117E WTR AMT GE 5,000-#2"                        format=f1.
      ER44100   LABEL="P118 WHAT DID W/PREV PNSN-#2"                     format=f1.
      ER44101   LABEL="P119 AMT NOW PREV PNSN ACCT-#2"                   format=f8.
      ER44102   LABEL="P119B WTR AMT GE 10,000-#2"                       format=f1.
      ER44103   LABEL="P119C WTR AMT GE 20,000-#2"                       format=f1.
      ER44104   LABEL="P119D WTR AMT GE 50,000-#2"                       format=f1.
      ER44105   LABEL="P119E WTR AMT GE 150,000-#2"                      format=f1.
      ER44106   LABEL="P120 AGE REC IF ANNUITY-#2"                       format=f2.
      ER44107   LABEL="P121 AMT PREV ANNUITY-#2"                         format=f7.
      ER44108   LABEL="P121 PREV ANNUITY PER-#2"                         format=f1.
      ER44109   LABEL="P121B WTR AMT GE 400 PER MONTH-#2"                format=f1.
      ER44110   LABEL="P121C WTR AMT GE 1,200 PER MONTH-#2"              format=f1.
      ER44111   LABEL="P121D WTR AMT GE 1,600 PER MONTH-#2"              format=f1.
      ER44112   LABEL="P121E WTR AMT GE 200 PER MONTH-#2"                format=f1.
      ER44113   LABEL="P122 STATUS PREV PNSN MEN1-#2"                    format=f1.
      ER44114   LABEL="P122 STATUS PREV PNSN MEN2-#2"                    format=f1.
      ER44115   LABEL="P122 STATUS PREV PNSN MEN3-#2"                    format=f1.
      ER44116   LABEL="P122 STATUS PREV PNSN MEN4-#2"                    format=f1.
      ER44117   LABEL="P122 STATUS PREV PNSN MEN5-#2"                    format=f1.
      ER44118   LABEL="P122 STATUS PREV PNSN MEN6-#2"                    format=f1.
      ER44119   LABEL="P123 MO REC PREV PNSN-#2"                         format=f2.
      ER44120   LABEL="P123 YR REC PREV PNSN-#2"                         format=f4.
      ER44121   LABEL="P124 PREV PNSN BENEFIT AMT-#2"                    format=f7.
      ER44122   LABEL="P124 BENEFIT PER-#2"                              format=f1.
      ER44123   LABEL="P124B WTR AMT GE 400 PER MONTH-#2"                format=f1.
      ER44124   LABEL="P124C WTR AMT GE 1,200 PER MONTH-#2"              format=f1.
      ER44125   LABEL="P124D WTR AMT GE 1,600 PER MONTH-#2"              format=f1.
      ER44126   LABEL="P124E WTR AMT GE 200 PER MONTH-#2"                format=f1.
      ER44127   LABEL="P125 WTR BENEFITS COLA-#2"                        format=f1.
      ER44128   LABEL="P126 WTR BENEFITS EVER COLA-#2"                   format=f1.
      ER44129   LABEL="P127 PREV PNSN CASH SETTLEMNT AMT-#2"             format=f7.
      ER44130   LABEL="P127B WTR AMT GE 6,000-#2"                        format=f1.
      ER44131   LABEL="P127C WTR AMT GE 60,000-#2"                       format=f1.
      ER44132   LABEL="P127D WTR AMT GE 250,000-#2"                      format=f1.
      ER44133   LABEL="P127E WTR AMT GE 2,000-#2"                        format=f1.
      ER44134   LABEL="P128 WHAT DID W/CASH MEN1-#2"                     format=f1.
      ER44135   LABEL="P128 WHAT DID W/CASH MEN2-#2"                     format=f1.
      ER44136   LABEL="P128 WHAT DID W/CASH MEN3-#2"                     format=f1.
      ER44137   LABEL="P128 WHAT DID W/CASH MEN4-#2"                     format=f1.
      ER44138   LABEL="P128 WHAT DID W/CASH MEN5-#2"                     format=f1.
      ER44139   LABEL="P128 WHAT DID W/CASH MEN6-#2"                     format=f1.
      ER44140   LABEL="P129 PREV PNSN IRA AMT-#2"                        format=f7.
      ER44141   LABEL="P129B WTR AMT GE 6,000-#2"                        format=f1.
      ER44142   LABEL="P129C WTR AMT GE 60,000-#2"                       format=f1.
      ER44143   LABEL="P129D WTR AMT GE 250,000-#2"                      format=f1.
      ER44144   LABEL="P129E WTR AMT GE 2,000-#2"                        format=f1.
      ER44145   LABEL="P130 # YRS IN PREV PLAN-#2"                       format=f2.
      ER44146   LABEL="P131 AGE EXPECT REC PREV PNSN-#2"                 format=f2.
      ER44147   LABEL="P132 AMT EXPECT REC PREV PNSN-#2"                 format=f6.
      ER44148   LABEL="P132 PREV PNSN PER-#2"                            format=f1.
      ER44149   LABEL="P132 PCT EXPECT REC PREV PNSN-#2"                 format=f3.
      ER44150   LABEL="P132 LUMP SUM EXPECT PREV PNSN-#2"                format=f8.
      ER44151   LABEL="P132B WTR AMT GE 1,000-#2"                        format=f1.
      ER44152   LABEL="P132C WTR AMT GE 2,000-#2"                        format=f1.
      ER44153   LABEL="P132D WTR AMT GE 3,000-#2"                        format=f1.
      ER44154   LABEL="P132E WTR AMT GE 500-#2"                          format=f1.
      ER44155   LABEL="P133 ACCT AMT WHEN LEFT PREV EMPLYR-#2"           format=f7.
      ER44156   LABEL="P133B WTR AMT GE 20,000-#2"                       format=f1.
      ER44157   LABEL="P133C WTR AMT GE 50,000-#2"                       format=f1.
      ER44158   LABEL="P133D WTR AMT GE 150,000-#2"                      format=f1.
      ER44159   LABEL="P133E WTR AMT GE 5,000-#2"                        format=f1.
      ER44160   LABEL="P134 WHAT DID W/PREV PNSN-#2"                     format=f1.
      ER44161   LABEL="P135 ACCT AMT PREV PNSN NOW-#2"                   format=f8.
      ER44162   LABEL="P135B WTR AMT GE 10,000-#2"                       format=f1.
      ER44163   LABEL="P135C WTR AMT GE 20,000-#2"                       format=f1.
      ER44164   LABEL="P135D WTR AMT GE 50,000-#2"                       format=f1.
      ER44165   LABEL="P135E WTR AMT GE 150,000-#2"                      format=f1.
      ER44166   LABEL="P136 AGE BEGAN REC ANNUITY-#2"                    format=f2.
      ER44167   LABEL="P137 AMT PREV ANNUITY-#2"                         format=f7.
      ER44168   LABEL="P137 PREV ANNUITY PER-#2"                         format=f1.
      ER44169   LABEL="P137B WTR AMT GE 400 PER MONTH-#2"                format=f1.
      ER44170   LABEL="P137C WTR AMT GE 1,200 PER MONTH-#2"              format=f1.
      ER44171   LABEL="P137D WTR AMT GE 1,600 PER MONTH-#2"              format=f1.
      ER44172   LABEL="P137E WTR AMT GE 200 PER MONTH-#2"                format=f1.
      ER44173   LABEL="P138 AGE ELIG PREV PNSN-#2"                       format=f2.
      ER44174   LABEL="P139 WTR 3RD PREV PENSION"                        format=f1.
      ER44175   LABEL="H1 HEALTH STATUS-HEAD"                            format=f1.
      ER44176   LABEL="H1A WTR HLTH BETTER/WORSE-HEAD"                   format=f1.
      ER44177   LABEL="H1B WTR HEALTH BETTER-HEAD"                       format=f1.
      ER44178   LABEL="H1C WTR HEALTH WORSE-HEAD"                        format=f1.
      ER44179   LABEL="H2 WTR LIMIT TYPE/AMT WRK- HEAD"                  format=f1.
      ER44180   LABEL="H3 WTR UNABLE TO DO SOME TYPES WORK-HD"           format=f1.
      ER44181   LABEL="H4 WTR LIMIT AMT WRK CAN DO-HEAD"                 format=f1.
      ER44182   LABEL="H5A WTR HAD STROKE-HEAD"                          format=f1.
      ER44183   LABEL="H6A1 AGE AT FIRST STROKE-HEAD"                    format=f3.
      ER44184   LABEL="H6A2 WTR SECOND STROKE-HEAD"                      format=f1.
      ER44185   LABEL="H7A WTR STROKE LIMIT DAILY ACTIVITY-HD"           format=f1.
      ER44186   LABEL="H5B WTR HEART ATTACK-HEAD"                        format=f1.
      ER44187   LABEL="H6B1 AGE AT FIRST HEART ATTACK-HD"                format=f3.
      ER44188   LABEL="H6B2 WTR SECOND HEART ATTACK-HD"                  format=f1.
      ER44189   LABEL="H7B WTR HEART ATTACK LIMIT ACTIVITY-HD"           format=f1.
      ER44190   LABEL="H5C WTR HEART DISEASE-HEAD"                       format=f1.
      ER44191   LABEL="H6C1 AGE FIRST HAD HEART DISEASE-HD"              format=f3.
      ER44192   LABEL="H6C2 WTR HRT DISEASE GOT WORSE-HD"                format=f1.
      ER44193   LABEL="H7C WTR HRT DISEASE LIMIT ACTIVITY-HD"            format=f1.
      ER44194   LABEL="H5D WTR HYPERTENSION-HEAD"                        format=f1.
      ER44195   LABEL="H6D1 AGE FIRST HAD HYPERTENSION-HD"               format=f3.
      ER44196   LABEL="H6D2 WTR HYPERTENSION GOT WORSE-HD"               format=f1.
      ER44197   LABEL="H7D WTR HYPERTENSION LIMIT ACTIVITY-HD"           format=f1.
      ER44198   LABEL="H5E WTR ASTHMA-HEAD"                              format=f1.
      ER44199   LABEL="H6E1 AGE FIRST HAD ASTHMA-HEAD"                   format=f3.
      ER44200   LABEL="H6E2 WTR ASTHMA GOT WORSE-HEAD"                   format=f1.
      ER44201   LABEL="H7E WTR ASTHMA LIMIT DAILY ACTIVITY-HD"           format=f1.
      ER44202   LABEL="H5F WTR LUNG DISEASE-HEAD"                        format=f1.
      ER44203   LABEL="H6F1 AGE FIRST HAD LUNG DISEASE-HD"               format=f3.
      ER44204   LABEL="H6F2 WTR LUNG DISEASE GOT WORSE-HD"               format=f1.
      ER44205   LABEL="H7F WTR LUNG DISEASE LIMIT ACTIVITY-HD"           format=f1.
      ER44206   LABEL="H5G WTR DIABETES-HEAD"                            format=f1.
      ER44207   LABEL="H6G1 AGE FIRST HAD DIABETES-HEAD"                 format=f3.
      ER44208   LABEL="H6G2 WTR DIABETES GOT WORSE-HEAD"                 format=f1.
      ER44209   LABEL="H7G WTR DIABETES LIMIT ACTIVITY-HD"               format=f1.
      ER44210   LABEL="H5H WTR ARTHRITIS-HEAD"                           format=f1.
      ER44211   LABEL="H6H1 AGE FIRST HAD ARTHRITIS-HEAD"                format=f3.
      ER44212   LABEL="H6H2 WTR ARTHRITIS GOT WORSE-HEAD"                format=f1.
      ER44213   LABEL="H7H WTR ARTHRITIS LIMIT ACTIVITY-HD"              format=f1.
      ER44214   LABEL="H5I WTR MEMORY LOSS-HEAD"                         format=f1.
      ER44215   LABEL="H6I1 AGE FIRST HAD MEMORY LOSS-HD"                format=f3.
      ER44216   LABEL="H6I2 WTR MEMORY LOSS GOT WORSE-HD"                format=f1.
      ER44217   LABEL="H7I WTR MEMORY LOSS LIMIT ACTIVITY-HD"            format=f1.
      ER44218   LABEL="H5J WTR LEARNING DISORDER-HEAD"                   format=f1.
      ER44219   LABEL="H6J1 AGE FIRST HAD LRNG DISORDER-HD"              format=f3.
      ER44220   LABEL="H6J2 WTR LRNG DISORDER GOT WORSE-HD"              format=f1.
      ER44221   LABEL="H7J WTR LRNG DISORDR LIMIT ACTIVITY-HD"           format=f1.
      ER44222   LABEL="H5K WTR CANCER-HEAD"                              format=f1.
      ER44223   LABEL="H6K1 AGE FIRST HAD CANCER-HEAD"                   format=f3.
      ER44224   LABEL="H6K2 WTR CANCER GOT WORSE-HEAD"                   format=f1.
      ER44225   LABEL="H6K3 WTR TREATING, RMSSN, OR CURED-HD"            format=f1.
      ER44226   LABEL="H6K4 TYPE OF CANCER MENTION 1-HEAD"               format=f2.
      ER44227   LABEL="H6K4 TYPE OF CANCER MENTION 2-HEAD"               format=f2.
      ER44228   LABEL="H7K WTR CANCER LIMIT ACTIVITY-HEAD"               format=f1.
      ER44229   LABEL="H5L WTR PSYCH PROBLEM-HEAD"                       format=f1.
      ER44230   LABEL="H6L1 AGE FIRST HAD PSYCH PROB-HEAD"               format=f3.
      ER44231   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 1-HD"             format=f2.
      ER44232   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 2-HD"             format=f2.
      ER44233   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 3-HD"             format=f2.
      ER44234   LABEL="H6L3 WTR PSYCH PROB GOT WORSE-HD"                 format=f1.
      ER44235   LABEL="H7L WTR PSYCH PROB LIMIT ACTIVITY-HD"             format=f1.
      ER44236   LABEL="H5M WTR OTR CHRONIC CONDITION-HD"                 format=f1.
      ER44237   LABEL="H6M2 AGE FIRST HAD CHRON COND-HEAD"               format=f3.
      ER44238   LABEL="H6M3 WTR CHRON COND GOT WORSE-HD"                 format=f1.
      ER44239   LABEL="H7M WTR CHRON COND LIMIT ACTIVITY-HD"             format=f1.
      ER44240   LABEL="H8 WTR HOSPITALIZED IN 2004-HEAD"                 format=f1.
      ER44241   LABEL="H8A # NIGHTS IN HOSPITAL-HEAD"                    format=f3.
      ER44242   LABEL="H8A # WEEKS IN HOSPITAL-HEAD"                     format=f2.
      ER44243   LABEL="H9A WTR PROBLEM BATHING-HEAD"                     format=f1.
      ER44244   LABEL="H10A1 WTR SOMEONE HELPS BATHE-HD"                 format=f1.
      ER44245   LABEL="H10A2 WTR NEED EQUIP TO BATHE-HD"                 format=f1.
      ER44246   LABEL="H9B WTR PROBLEM DRESSING-HEAD"                    format=f1.
      ER44247   LABEL="H10B1 WTR SOMEONE HELPS DRESS-HD"                 format=f1.
      ER44248   LABEL="H10B2 WTR NEED EQUIP TO DRESS-HD"                 format=f1.
      ER44249   LABEL="H9C WTR PROBLEM EATING-HEAD"                      format=f1.
      ER44250   LABEL="H10C1 WTR SOMEONE HELPS EATNG-HD"                 format=f1.
      ER44251   LABEL="H10C2 WTR NEED EQUIP TO EAT-HD"                   format=f1.
      ER44252   LABEL="H9D WTR PROB GET IN/OUT BED/CHAIR-HD"             format=f1.
      ER44253   LABEL="H10D1 WTR SOMEONE HELPS BED/CHAIR-HD"             format=f1.
      ER44254   LABEL="H10D2 WTR NEED EQUIP FOR BED/CHAIR-HD"            format=f1.
      ER44255   LABEL="H9E WTR PROBLEM WALKING-HEAD"                     format=f1.
      ER44256   LABEL="H10E1 WTR SOMEONE HELPS WALK-HD"                  format=f1.
      ER44257   LABEL="H10E2 WTR NEED EQUIP TO WALK-HD"                  format=f1.
      ER44258   LABEL="H9F WTR PROBLEM GETTING OUTSIDE-HD"               format=f1.
      ER44259   LABEL="H10F1 WTR SOMEONE HELPS GET OUT-HD"               format=f1.
      ER44260   LABEL="H10F2 WTR NEED EQUIP TO GO OUTSIDE-HD"            format=f1.
      ER44261   LABEL="H9G WTR PROBLEM USE TOILET-HD"                    format=f1.
      ER44262   LABEL="H10G1 WTR SOMEONE HELPS TOILET-HD"                format=f1.
      ER44263   LABEL="H10G2 WTR NEED EQUIP TO USE TOILET-HD"            format=f1.
      ER44264   LABEL="H11A WTR DIFFICULT PREPARE MEALS-HD"              format=f1.
      ER44265   LABEL="H11B HEALTH/PHYSICAL PROBLEM?-HD"                 format=f1.
      ER44266   LABEL="H11C WTR DIFFICULT SHOPPING-HD"                   format=f1.
      ER44267   LABEL="H11D HEALTH/PHYSICAL PROBLEM?-HD"                 format=f1.
      ER44268   LABEL="H11E WTR DIFFICULT MANAGE MONEY-HD"               format=f1.
      ER44269   LABEL="H11F HEALTH/PHYSICAL PROBLEM?-HD"                 format=f1.
      ER44270   LABEL="H11G WTR TELEPHONE DIFFICULT-HD"                  format=f1.
      ER44271   LABEL="H11H HEALTH/PHYSICAL PROBLEM?-HD"                 format=f1.
      ER44272   LABEL="H11J WTR HEAVY HSWRK DIFFICULT-HD"                format=f1.
      ER44273   LABEL="H11K HEALTH/PHYSICAL PROBLEM?-HD"                 format=f1.
      ER44274   LABEL="H11L WTR LIGHT HSWRK DIFFICULT-HD"                format=f1.
      ER44275   LABEL="H11M HEALTH/PHYSICAL PROBLEM?-HD"                 format=f1.
      ER44276   LABEL="H12A FREQ OF HVY PHYSICAL ACTIVITY-HD"            format=f3.
      ER44277   LABEL="H12A TIME UNIT FOR HVY PHYS ACTIVITY-HD"          format=f1.
      ER44278   LABEL="H12B FREQ OF LITE PHYSICAL ACTIVITY-HD"           format=f3.
      ER44279   LABEL="H12B TIME UNIT FOR LITE PHYS ACTIVITY-HD"         format=f1.
      ER44280   LABEL="H12C FREQ OF STRENGTH PHYS ACTIVITY-HD"           format=f3.
      ER44281   LABEL="H12C TIME UNIT STRNGTH PHYS ACTVTY-HD"            format=f1.
      ER44282   LABEL="H13 WTR SMOKE CIGARETTES-HD"                      format=f1.
      ER44283   LABEL="H14 # CIGARETTES PER DAY-HD"                      format=f3.
      ER44284   LABEL="H15 AGE WHEN FIRST SMOKED-HD"                     format=f2.
      ER44285   LABEL="H16 WTR EVER SMOKED CIGARETTES-HD"                format=f1.
      ER44286   LABEL="H17 # CIGARETTES PER DAY-HD"                      format=f3.
      ER44287   LABEL="H18 AGE LAST SMOKED REGULARLY-HD"                 format=f2.
      ER44288   LABEL="H19 AGE FIRST SMOKED REGULARLY-HD"                format=f2.
      ER44289   LABEL="H20 WTR DRINK ALCOHOL-HEAD"                       format=f1.
      ER44290   LABEL="H21A HOW OFTEN HAVE DRINKS-HD"                    format=f1.
      ER44291   LABEL="H21B # ALCOHOLIC DRINKS PER DAY-HD"               format=f2.
      ER44292   LABEL="H21C # DAYS HAD 4-5 DRINKS-HEAD"                  format=f3.
      ER44293   LABEL="H22 WEIGHT-HEAD"                                  format=f3.
      ER44294   LABEL="H23 HEIGHT-FEET-HEAD"                             format=f1.
      ER44295   LABEL="H23 HEIGHT-INCHES-HEAD"                           format=f2.
      ER44296   LABEL="H25H HEALTH STATUS B4 AGE 17--HD"                 format=f1.
      ER44297   LABEL="H26H WTR MISSED MO OR MORE SCHOOL--HD"            format=f1.
      ER44298   LABEL="H27H WTR MEASLES B4 AGE 17--HD"                   format=f1.
      ER44299   LABEL="H28H WTR MUMPS B4 AGE 17--HD"                     format=f1.
      ER44300   LABEL="H29H WTR CHICKEN POX B4 AGE 17--HD"               format=f1.
      ER44301   LABEL="H30H WTR DIFF SEEING B4 AGE 17--HD"               format=f1.
      ER44302   LABEL="H31H PARENTS SMOKED B4 HD AGE 17?--HD"            format=f1.
      ER44303   LABEL="H32H WTR ASTHMA B4 AGE 17--HD"                    format=f1.
      ER44304   LABEL="H33H WTR DIABETES B4 AGE 17--HD"                  format=f1.
      ER44305   LABEL="H34H WTR RESP DIS B4 AGE 17--HD"                  format=f1.
      ER44306   LABEL="H35H WTR SPCH IMPAIR B4 AGE 17--HD"               format=f1.
      ER44307   LABEL="H36H WTR ALLERGY B4 AGE 17--HD"                   format=f1.
      ER44308   LABEL="H37H WTR HEART TRBL B4 AGE 17--HD"                format=f1.
      ER44309   LABEL="H38H WTR EAR PROB B4 AGE 17--HD"                  format=f1.
      ER44310   LABEL="H39H WTR EPILEPSY B4 AGE 17--HD"                  format=f1.
      ER44311   LABEL="H40H WTR HEADACHE B4 AGE 17--HD"                  format=f1.
      ER44312   LABEL="H41H WTR STOM PROB B4 AGE 17--HD"                 format=f1.
      ER44313   LABEL="H42H WTR HGH BLOOD PR B4 AGE 17--HD"              format=f1.
      ER44314   LABEL="H43H WTR DEPRESSION B4 AGE 17--HD"                format=f1.
      ER44315   LABEL="H44H WTR DRUG/AL PROB B4 AGE 17--HD"              format=f1.
      ER44316   LABEL="H45H WTR OTR PSYCH PROB B4 AGE 17--HD"            format=f1.
      ER44317   LABEL="HEHC SLF RPT: YEAR 1ST REPORT--HD"                format=f4.
      ER44318   LABEL="HEHC SLF RPT: PAR SEP B4 AGE 1--HD"               format=f1.
      ER44319   LABEL="HEHC SLF RPT: PAR SEP AGE 1--HD"                  format=f1.
      ER44320   LABEL="HEHC SLF RPT: PAR SEP AGE 2--HD"                  format=f1.
      ER44321   LABEL="HEHC SLF RPT: PAR SEP AGE 3--HD"                  format=f1.
      ER44322   LABEL="HEHC SLF RPT: PAR SEP AGE 4--HD"                  format=f1.
      ER44323   LABEL="HEHC SLF RPT: PAR SEP AGE 5--HD"                  format=f1.
      ER44324   LABEL="HEHC SLF RPT: PAR SEP AGE 6--HD"                  format=f1.
      ER44325   LABEL="HEHC SLF RPT: PAR SEP AGE 7--HD"                  format=f1.
      ER44326   LABEL="HEHC SLF RPT: PAR SEP AGE 8--HD"                  format=f1.
      ER44327   LABEL="HEHC SLF RPT: PAR SEP AGE 9--HD"                  format=f1.
      ER44328   LABEL="HEHC SLF RPT: PAR SEP AGE 10--HD"                 format=f1.
      ER44329   LABEL="HEHC SLF RPT: PAR SEP AGE 11--HD"                 format=f1.
      ER44330   LABEL="HEHC SLF RPT: PAR SEP AGE 12--HD"                 format=f1.
      ER44331   LABEL="HEHC SLF RPT: PAR SEP AGE 13--HD"                 format=f1.
      ER44332   LABEL="HEHC SLF RPT: PAR SEP AGE 14--HD"                 format=f1.
      ER44333   LABEL="HEHC SLF RPT: PAR SEP AGE 15--HD"                 format=f1.
      ER44334   LABEL="HEHC SLF RPT: PAR SEP AGE 16--HD"                 format=f1.
      ER44335   LABEL="HEHC SLF RPT: MOVE B4 AGE 1--HD"                  format=f1.
      ER44336   LABEL="HEHC SLF RPT: MOVE AGE 1--HD"                     format=f1.
      ER44337   LABEL="HEHC SLF RPT: MOVE AGE 2--HD"                     format=f1.
      ER44338   LABEL="HEHC SLF RPT: MOVE AGE 3--HD"                     format=f1.
      ER44339   LABEL="HEHC SLF RPT: MOVE AGE 4--HD"                     format=f1.
      ER44340   LABEL="HEHC SLF RPT: MOVE AGE 5--HD"                     format=f1.
      ER44341   LABEL="HEHC SLF RPT: MOVE AGE 6--HD"                     format=f1.
      ER44342   LABEL="HEHC SLF RPT: MOVE AGE 7--HD"                     format=f1.
      ER44343   LABEL="HEHC SLF RPT: MOVE AGE 8--HD"                     format=f1.
      ER44344   LABEL="HEHC SLF RPT: MOVE AGE 9--HD"                     format=f1.
      ER44345   LABEL="HEHC SLF RPT: MOVE AGE 10--HD"                    format=f1.
      ER44346   LABEL="HEHC SLF RPT: MOVE AGE 11--HD"                    format=f1.
      ER44347   LABEL="HEHC SLF RPT: MOVE AGE 12--HD"                    format=f1.
      ER44348   LABEL="HEHC SLF RPT: MOVE AGE 13--HD"                    format=f1.
      ER44349   LABEL="HEHC SLF RPT: MOVE AGE 14--HD"                    format=f1.
      ER44350   LABEL="HEHC SLF RPT: MOVE AGE 15--HD"                    format=f1.
      ER44351   LABEL="HEHC SLF RPT: MOVE AGE 16--HD"                    format=f1.
      ER44352   LABEL="HEHC SLF RPT: SCHOOL B4 AGE 1--HD"                format=f1.
      ER44353   LABEL="HEHC SLF RPT: SCHOOL AGE 1--HD"                   format=f1.
      ER44354   LABEL="HEHC SLF RPT: SCHOOL AGE 2--HD"                   format=f1.
      ER44355   LABEL="HEHC SLF RPT: SCHOOL AGE 3--HD"                   format=f1.
      ER44356   LABEL="HEHC SLF RPT: SCHOOL AGE 4--HD"                   format=f1.
      ER44357   LABEL="HEHC SLF RPT: SCHOOL AGE 5--HD"                   format=f1.
      ER44358   LABEL="HEHC SLF RPT: SCHOOL AGE 6--HD"                   format=f1.
      ER44359   LABEL="HEHC SLF RPT: SCHOOL AGE 7--HD"                   format=f1.
      ER44360   LABEL="HEHC SLF RPT: SCHOOL AGE 8--HD"                   format=f1.
      ER44361   LABEL="HEHC SLF RPT: SCHOOL AGE 9--HD"                   format=f1.
      ER44362   LABEL="HEHC SLF RPT: SCHOOL AGE 10--HD"                  format=f1.
      ER44363   LABEL="HEHC SLF RPT: SCHOOL AGE 11--HD"                  format=f1.
      ER44364   LABEL="HEHC SLF RPT: SCHOOL AGE 12--HD"                  format=f1.
      ER44365   LABEL="HEHC SLF RPT: SCHOOL AGE 13--HD"                  format=f1.
      ER44366   LABEL="HEHC SLF RPT: SCHOOL AGE 14--HD"                  format=f1.
      ER44367   LABEL="HEHC SLF RPT: SCHOOL AGE 15--HD"                  format=f1.
      ER44368   LABEL="HEHC SLF RPT: SCHOOL AGE 16--HD"                  format=f1.
      ER44369   LABEL="HEHC SLF RPT: ASTHMA B4 AGE 1--HD"                format=f1.
      ER44370   LABEL="HEHC SLF RPT: ASTHMA AGE 1--HD"                   format=f1.
      ER44371   LABEL="HEHC SLF RPT: ASTHMA AGE 2--HD"                   format=f1.
      ER44372   LABEL="HEHC SLF RPT: ASTHMA AGE 3--HD"                   format=f1.
      ER44373   LABEL="HEHC SLF RPT: ASTHMA AGE 4--HD"                   format=f1.
      ER44374   LABEL="HEHC SLF RPT: ASTHMA AGE 5--HD"                   format=f1.
      ER44375   LABEL="HEHC SLF RPT: ASTHMA AGE 6--HD"                   format=f1.
      ER44376   LABEL="HEHC SLF RPT: ASTHMA AGE 7--HD"                   format=f1.
      ER44377   LABEL="HEHC SLF RPT: ASTHMA AGE 8--HD"                   format=f1.
      ER44378   LABEL="HEHC SLF RPT: ASTHMA AGE 9--HD"                   format=f1.
      ER44379   LABEL="HEHC SLF RPT: ASTHMA AGE 10--HD"                  format=f1.
      ER44380   LABEL="HEHC SLF RPT: ASTHMA AGE 11--HD"                  format=f1.
      ER44381   LABEL="HEHC SLF RPT: ASTHMA AGE 12--HD"                  format=f1.
      ER44382   LABEL="HEHC SLF RPT: ASTHMA AGE 13--HD"                  format=f1.
      ER44383   LABEL="HEHC SLF RPT: ASTHMA AGE 14--HD"                  format=f1.
      ER44384   LABEL="HEHC SLF RPT: ASTHMA AGE 15--HD"                  format=f1.
      ER44385   LABEL="HEHC SLF RPT: ASTHMA AGE 16--HD"                  format=f1.
      ER44386   LABEL="HEHC SLF RPT: ASTHMA AGE 17+--HD"                 format=f1.
      ER44387   LABEL="HEHC SLF RPT: AGE END ASTHMA--HD"                 format=f3.
      ER44388   LABEL="HEHC SLF RPT: DIABETES B4 AGE 1--HD"              format=f1.
      ER44389   LABEL="HEHC SLF RPT: DIABETES AGE 1--HD"                 format=f1.
      ER44390   LABEL="HEHC SLF RPT: DIABETES AGE 2--HD"                 format=f1.
      ER44391   LABEL="HEHC SLF RPT: DIABETES AGE 3--HD"                 format=f1.
      ER44392   LABEL="HEHC SLF RPT: DIABETES AGE 4--HD"                 format=f1.
      ER44393   LABEL="HEHC SLF RPT: DIABETES AGE 5--HD"                 format=f1.
      ER44394   LABEL="HEHC SLF RPT: DIABETES AGE 6--HD"                 format=f1.
      ER44395   LABEL="HEHC SLF RPT: DIABETES AGE 7--HD"                 format=f1.
      ER44396   LABEL="HEHC SLF RPT: DIABETES AGE 8--HD"                 format=f1.
      ER44397   LABEL="HEHC SLF RPT: DIABETES AGE 9--HD"                 format=f1.
      ER44398   LABEL="HEHC SLF RPT: DIABETES AGE 10--HD"                format=f1.
      ER44399   LABEL="HEHC SLF RPT: DIABETES AGE 11--HD"                format=f1.
      ER44400   LABEL="HEHC SLF RPT: DIABETES AGE 12--HD"                format=f1.
      ER44401   LABEL="HEHC SLF RPT: DIABETES AGE 13--HD"                format=f1.
      ER44402   LABEL="HEHC SLF RPT: DIABETES AGE 14--HD"                format=f1.
      ER44403   LABEL="HEHC SLF RPT: DIABETES AGE 15--HD"                format=f1.
      ER44404   LABEL="HEHC SLF RPT: DIABETES AGE 16--HD"                format=f1.
      ER44405   LABEL="HEHC SLF RPT: DIABETES AGE 17+--HD"               format=f1.
      ER44406   LABEL="HEHC SLF RPT: AGE END DIABETES--HD"               format=f3.
      ER44407   LABEL="HEHC SLF RPT: RESP DIS B4 AGE 1--HD"              format=f1.
      ER44408   LABEL="HEHC SLF RPT: RESP DIS AGE 1--HD"                 format=f1.
      ER44409   LABEL="HEHC SLF RPT: RESP DIS AGE 2--HD"                 format=f1.
      ER44410   LABEL="HEHC SLF RPT: RESP DIS AGE 3--HD"                 format=f1.
      ER44411   LABEL="HEHC SLF RPT: RESP DIS AGE 4--HD"                 format=f1.
      ER44412   LABEL="HEHC SLF RPT: RESP DIS AGE 5--HD"                 format=f1.
      ER44413   LABEL="HEHC SLF RPT: RESP DIS AGE 6--HD"                 format=f1.
      ER44414   LABEL="HEHC SLF RPT: RESP DIS AGE 7--HD"                 format=f1.
      ER44415   LABEL="HEHC SLF RPT: RESP DIS AGE 8--HD"                 format=f1.
      ER44416   LABEL="HEHC SLF RPT: RESP DIS AGE 9--HD"                 format=f1.
      ER44417   LABEL="HEHC SLF RPT: RESP DIS AGE 10--HD"                format=f1.
      ER44418   LABEL="HEHC SLF RPT: RESP DIS AGE 11--HD"                format=f1.
      ER44419   LABEL="HEHC SLF RPT: RESP DIS AGE 12--HD"                format=f1.
      ER44420   LABEL="HEHC SLF RPT: RESP DIS AGE 13--HD"                format=f1.
      ER44421   LABEL="HEHC SLF RPT: RESP DIS AGE 14--HD"                format=f1.
      ER44422   LABEL="HEHC SLF RPT: RESP DIS AGE 15--HD"                format=f1.
      ER44423   LABEL="HEHC SLF RPT: RESP DIS AGE 16--HD"                format=f1.
      ER44424   LABEL="HEHC SLF RPT: RESP DIS AGE 17+--HD"               format=f1.
      ER44425   LABEL="HEHC SLF RPT: AGE END RESP DIS--HD"               format=f3.
      ER44426   LABEL="HEHC SLF RPT: SPCH IMPAIR B4 AGE 1--HD"           format=f1.
      ER44427   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 1--HD"              format=f1.
      ER44428   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 2--HD"              format=f1.
      ER44429   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 3--HD"              format=f1.
      ER44430   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 4--HD"              format=f1.
      ER44431   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 5--HD"              format=f1.
      ER44432   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 6--HD"              format=f1.
      ER44433   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 7--HD"              format=f1.
      ER44434   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 8--HD"              format=f1.
      ER44435   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 9--HD"              format=f1.
      ER44436   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 10--HD"             format=f1.
      ER44437   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 11--HD"             format=f1.
      ER44438   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 12--HD"             format=f1.
      ER44439   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 13--HD"             format=f1.
      ER44440   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 14--HD"             format=f1.
      ER44441   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 15--HD"             format=f1.
      ER44442   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 16--HD"             format=f1.
      ER44443   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 17+--HD"            format=f1.
      ER44444   LABEL="HEHC SLF RPT: AGE END SPCH IMPAIR--HD"            format=f3.
      ER44445   LABEL="HEHC SLF RPT: ALLERGY B4 AGE 1--HD"               format=f1.
      ER44446   LABEL="HEHC SLF RPT: ALLERGY AGE 1--HD"                  format=f1.
      ER44447   LABEL="HEHC SLF RPT: ALLERGY AGE 2--HD"                  format=f1.
      ER44448   LABEL="HEHC SLF RPT: ALLERGY AGE 3--HD"                  format=f1.
      ER44449   LABEL="HEHC SLF RPT: ALLERGY AGE 4--HD"                  format=f1.
      ER44450   LABEL="HEHC SLF RPT: ALLERGY AGE 5--HD"                  format=f1.
      ER44451   LABEL="HEHC SLF RPT: ALLERGY AGE 6--HD"                  format=f1.
      ER44452   LABEL="HEHC SLF RPT: ALLERGY AGE 7--HD"                  format=f1.
      ER44453   LABEL="HEHC SLF RPT: ALLERGY AGE 8--HD"                  format=f1.
      ER44454   LABEL="HEHC SLF RPT: ALLERGY AGE 9--HD"                  format=f1.
      ER44455   LABEL="HEHC SLF RPT: ALLERGY AGE 10--HD"                 format=f1.
      ER44456   LABEL="HEHC SLF RPT: ALLERGY AGE 11--HD"                 format=f1.
      ER44457   LABEL="HEHC SLF RPT: ALLERGY AGE 12--HD"                 format=f1.
      ER44458   LABEL="HEHC SLF RPT: ALLERGY AGE 13--HD"                 format=f1.
      ER44459   LABEL="HEHC SLF RPT: ALLERGY AGE 14--HD"                 format=f1.
      ER44460   LABEL="HEHC SLF RPT: ALLERGY AGE 15--HD"                 format=f1.
      ER44461   LABEL="HEHC SLF RPT: ALLERGY AGE 16--HD"                 format=f1.
      ER44462   LABEL="HEHC SLF RPT: ALLERGY AGE 17+--HD"                format=f1.
      ER44463   LABEL="HEHC SLF RPT: AGE END ALLERGY--HD"                format=f3.
      ER44464   LABEL="HEHC SLF RPT: HEART TRBL B4 AGE 1--HD"            format=f1.
      ER44465   LABEL="HEHC SLF RPT: HEART TRBL AGE 1--HD"               format=f1.
      ER44466   LABEL="HEHC SLF RPT: HEART TRBL AGE 2--HD"               format=f1.
      ER44467   LABEL="HEHC SLF RPT: HEART TRBL AGE 3--HD"               format=f1.
      ER44468   LABEL="HEHC SLF RPT: HEART TRBL AGE 4--HD"               format=f1.
      ER44469   LABEL="HEHC SLF RPT: HEART TRBL AGE 5--HD"               format=f1.
      ER44470   LABEL="HEHC SLF RPT: HEART TRBL AGE 6--HD"               format=f1.
      ER44471   LABEL="HEHC SLF RPT: HEART TRBL AGE 7--HD"               format=f1.
      ER44472   LABEL="HEHC SLF RPT: HEART TRBL AGE 8--HD"               format=f1.
      ER44473   LABEL="HEHC SLF RPT: HEART TRBL AGE 9--HD"               format=f1.
      ER44474   LABEL="HEHC SLF RPT: HEART TRBL AGE 10--HD"              format=f1.
      ER44475   LABEL="HEHC SLF RPT: HEART TRBL AGE 11--HD"              format=f1.
      ER44476   LABEL="HEHC SLF RPT: HEART TRBL AGE 12--HD"              format=f1.
      ER44477   LABEL="HEHC SLF RPT: HEART TRBL AGE 13--HD"              format=f1.
      ER44478   LABEL="HEHC SLF RPT: HEART TRBL AGE 14--HD"              format=f1.
      ER44479   LABEL="HEHC SLF RPT: HEART TRBL AGE 15--HD"              format=f1.
      ER44480   LABEL="HEHC SLF RPT: HEART TRBL AGE 16--HD"              format=f1.
      ER44481   LABEL="HEHC SLF RPT: HEART TRBL AGE 17+--HD"             format=f1.
      ER44482   LABEL="HEHC SLF RPT: AGE END HEART TRBL--HD"             format=f3.
      ER44483   LABEL="HEHC SLF RPT: EAR PROBS B4 AGE 1--HD"             format=f1.
      ER44484   LABEL="HEHC SLF RPT: EAR PROBS AGE 1--HD"                format=f1.
      ER44485   LABEL="HEHC SLF RPT: EAR PROBS AGE 2--HD"                format=f1.
      ER44486   LABEL="HEHC SLF RPT: EAR PROBS AGE 3--HD"                format=f1.
      ER44487   LABEL="HEHC SLF RPT: EAR PROBS AGE 4--HD"                format=f1.
      ER44488   LABEL="HEHC SLF RPT: EAR PROBS AGE 5--HD"                format=f1.
      ER44489   LABEL="HEHC SLF RPT: EAR PROBS AGE 6--HD"                format=f1.
      ER44490   LABEL="HEHC SLF RPT: EAR PROBS AGE 7--HD"                format=f1.
      ER44491   LABEL="HEHC SLF RPT: EAR PROBS AGE 8--HD"                format=f1.
      ER44492   LABEL="HEHC SLF RPT: EAR PROBS AGE 9--HD"                format=f1.
      ER44493   LABEL="HEHC SLF RPT: EAR PROBS AGE 10--HD"               format=f1.
      ER44494   LABEL="HEHC SLF RPT: EAR PROBS AGE 11--HD"               format=f1.
      ER44495   LABEL="HEHC SLF RPT: EAR PROBS AGE 12--HD"               format=f1.
      ER44496   LABEL="HEHC SLF RPT: EAR PROBS AGE 13--HD"               format=f1.
      ER44497   LABEL="HEHC SLF RPT: EAR PROBS AGE 14--HD"               format=f1.
      ER44498   LABEL="HEHC SLF RPT: EAR PROBS AGE 15--HD"               format=f1.
      ER44499   LABEL="HEHC SLF RPT: EAR PROBS AGE 16--HD"               format=f1.
      ER44500   LABEL="HEHC SLF RPT: EAR PROBS AGE 17+--HD"              format=f1.
      ER44501   LABEL="HEHC SLF RPT: AGE END EAR PROBS--HD"              format=f3.
      ER44502   LABEL="HEHC SLF RPT: EPILEPSY B4 AGE 1--HD"              format=f1.
      ER44503   LABEL="HEHC SLF RPT: EPILEPSY AGE 1--HD"                 format=f1.
      ER44504   LABEL="HEHC SLF RPT: EPILEPSY AGE 2--HD"                 format=f1.
      ER44505   LABEL="HEHC SLF RPT: EPILEPSY AGE 3--HD"                 format=f1.
      ER44506   LABEL="HEHC SLF RPT: EPILEPSY AGE 4--HD"                 format=f1.
      ER44507   LABEL="HEHC SLF RPT: EPILEPSY AGE 5--HD"                 format=f1.
      ER44508   LABEL="HEHC SLF RPT: EPILEPSY AGE 6--HD"                 format=f1.
      ER44509   LABEL="HEHC SLF RPT: EPILEPSY AGE 7--HD"                 format=f1.
      ER44510   LABEL="HEHC SLF RPT: EPILEPSY AGE 8--HD"                 format=f1.
      ER44511   LABEL="HEHC SLF RPT: EPILEPSY AGE 9--HD"                 format=f1.
      ER44512   LABEL="HEHC SLF RPT: EPILEPSY AGE 10--HD"                format=f1.
      ER44513   LABEL="HEHC SLF RPT: EPILEPSY AGE 11--HD"                format=f1.
      ER44514   LABEL="HEHC SLF RPT: EPILEPSY AGE 12--HD"                format=f1.
      ER44515   LABEL="HEHC SLF RPT: EPILEPSY AGE 13--HD"                format=f1.
      ER44516   LABEL="HEHC SLF RPT: EPILEPSY AGE 14--HD"                format=f1.
      ER44517   LABEL="HEHC SLF RPT: EPILEPSY AGE 15--HD"                format=f1.
      ER44518   LABEL="HEHC SLF RPT: EPILEPSY AGE 16--HD"                format=f1.
      ER44519   LABEL="HEHC SLF RPT: EPILEPSY AGE 17+--HD"               format=f1.
      ER44520   LABEL="HEHC SLF RPT: AGE END EPILEPSY--HD"               format=f3.
      ER44521   LABEL="HEHC SLF RPT: HEADACHE B4 AGE 1--HD"              format=f1.
      ER44522   LABEL="HEHC SLF RPT: HEADACHE AGE 1--HD"                 format=f1.
      ER44523   LABEL="HEHC SLF RPT: HEADACHE AGE 2--HD"                 format=f1.
      ER44524   LABEL="HEHC SLF RPT: HEADACHE AGE 3--HD"                 format=f1.
      ER44525   LABEL="HEHC SLF RPT: HEADACHE AGE 4--HD"                 format=f1.
      ER44526   LABEL="HEHC SLF RPT: HEADACHE AGE 5--HD"                 format=f1.
      ER44527   LABEL="HEHC SLF RPT: HEADACHE AGE 6--HD"                 format=f1.
      ER44528   LABEL="HEHC SLF RPT: HEADACHE AGE 7--HD"                 format=f1.
      ER44529   LABEL="HEHC SLF RPT: HEADACHE AGE 8--HD"                 format=f1.
      ER44530   LABEL="HEHC SLF RPT: HEADACHE AGE 9--HD"                 format=f1.
      ER44531   LABEL="HEHC SLF RPT: HEADACHE AGE 10--HD"                format=f1.
      ER44532   LABEL="HEHC SLF RPT: HEADACHE AGE 11--HD"                format=f1.
      ER44533   LABEL="HEHC SLF RPT: HEADACHE AGE 12--HD"                format=f1.
      ER44534   LABEL="HEHC SLF RPT: HEADACHE AGE 13--HD"                format=f1.
      ER44535   LABEL="HEHC SLF RPT: HEADACHE AGE 14--HD"                format=f1.
      ER44536   LABEL="HEHC SLF RPT: HEADACHE AGE 15--HD"                format=f1.
      ER44537   LABEL="HEHC SLF RPT: HEADACHE AGE 16--HD"                format=f1.
      ER44538   LABEL="HEHC SLF RPT: HEADACHE AGE 17+--HD"               format=f1.
      ER44539   LABEL="HEHC SLF RPT: AGE END HEADACHE--HD"               format=f3.
      ER44540   LABEL="HEHC SLF RPT: STOM PROB B4 AGE 1--HD"             format=f1.
      ER44541   LABEL="HEHC SLF RPT: STOM PROB AGE 1--HD"                format=f1.
      ER44542   LABEL="HEHC SLF RPT: STOM PROB AGE 2--HD"                format=f1.
      ER44543   LABEL="HEHC SLF RPT: STOM PROB AGE 3--HD"                format=f1.
      ER44544   LABEL="HEHC SLF RPT: STOM PROB AGE 4--HD"                format=f1.
      ER44545   LABEL="HEHC SLF RPT: STOM PROB AGE 5--HD"                format=f1.
      ER44546   LABEL="HEHC SLF RPT: STOM PROB AGE 6--HD"                format=f1.
      ER44547   LABEL="HEHC SLF RPT: STOM PROB AGE 7--HD"                format=f1.
      ER44548   LABEL="HEHC SLF RPT: STOM PROB AGE 8--HD"                format=f1.
      ER44549   LABEL="HEHC SLF RPT: STOM PROB AGE 9--HD"                format=f1.
      ER44550   LABEL="HEHC SLF RPT: STOM PROB AGE 10--HD"               format=f1.
      ER44551   LABEL="HEHC SLF RPT: STOM PROB AGE 11--HD"               format=f1.
      ER44552   LABEL="HEHC SLF RPT: STOM PROB AGE 12--HD"               format=f1.
      ER44553   LABEL="HEHC SLF RPT: STOM PROB AGE 13--HD"               format=f1.
      ER44554   LABEL="HEHC SLF RPT: STOM PROB AGE 14--HD"               format=f1.
      ER44555   LABEL="HEHC SLF RPT: STOM PROB AGE 15--HD"               format=f1.
      ER44556   LABEL="HEHC SLF RPT: STOM PROB AGE 16--HD"               format=f1.
      ER44557   LABEL="HEHC SLF RPT: STOM PROB AGE 17+--HD"              format=f1.
      ER44558   LABEL="HEHC SLF RPT: AGE END STOM PROB--HD"              format=f3.
      ER44559   LABEL="HEHC SLF RPT: HGH BLOOD PR B4 AGE 1--HD"          format=f1.
      ER44560   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 1--HD"             format=f1.
      ER44561   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 2--HD"             format=f1.
      ER44562   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 3--HD"             format=f1.
      ER44563   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 4--HD"             format=f1.
      ER44564   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 5--HD"             format=f1.
      ER44565   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 6--HD"             format=f1.
      ER44566   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 7--HD"             format=f1.
      ER44567   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 8--HD"             format=f1.
      ER44568   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 9--HD"             format=f1.
      ER44569   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 10--HD"            format=f1.
      ER44570   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 11--HD"            format=f1.
      ER44571   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 12--HD"            format=f1.
      ER44572   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 13--HD"            format=f1.
      ER44573   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 14--HD"            format=f1.
      ER44574   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 15--HD"            format=f1.
      ER44575   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 16--HD"            format=f1.
      ER44576   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 17+--HD"           format=f1.
      ER44577   LABEL="HEHC SLF RPT: AGE END HGH BLD PR--HD"             format=f3.
      ER44578   LABEL="HEHC SLF RPT: DEPRESSION B4 AGE 1--HD"            format=f1.
      ER44579   LABEL="HEHC SLF RPT: DEPRESSION AGE 1--HD"               format=f1.
      ER44580   LABEL="HEHC SLF RPT: DEPRESSION AGE 2--HD"               format=f1.
      ER44581   LABEL="HEHC SLF RPT: DEPRESSION AGE 3--HD"               format=f1.
      ER44582   LABEL="HEHC SLF RPT: DEPRESSION AGE 4--HD"               format=f1.
      ER44583   LABEL="HEHC SLF RPT: DEPRESSION AGE 5--HD"               format=f1.
      ER44584   LABEL="HEHC SLF RPT: DEPRESSION AGE 6--HD"               format=f1.
      ER44585   LABEL="HEHC SLF RPT: DEPRESSION AGE 7--HD"               format=f1.
      ER44586   LABEL="HEHC SLF RPT: DEPRESSION AGE 8--HD"               format=f1.
      ER44587   LABEL="HEHC SLF RPT: DEPRESSION AGE 9--HD"               format=f1.
      ER44588   LABEL="HEHC SLF RPT: DEPRESSION AGE 10--HD"              format=f1.
      ER44589   LABEL="HEHC SLF RPT: DEPRESSION AGE 11--HD"              format=f1.
      ER44590   LABEL="HEHC SLF RPT: DEPRESSION AGE 12--HD"              format=f1.
      ER44591   LABEL="HEHC SLF RPT: DEPRESSION AGE 13--HD"              format=f1.
      ER44592   LABEL="HEHC SLF RPT: DEPRESSION AGE 14--HD"              format=f1.
      ER44593   LABEL="HEHC SLF RPT: DEPRESSION AGE 15--HD"              format=f1.
      ER44594   LABEL="HEHC SLF RPT: DEPRESSION AGE 16--HD"              format=f1.
      ER44595   LABEL="HEHC SLF RPT: DEPRESSION AGE 17+--HD"             format=f1.
      ER44596   LABEL="HEHC SLF RPT: AGE END DEPRESSION--HD"             format=f3.
      ER44597   LABEL="HEHC SLF RPT: DRUG/AL PROB B4 AGE 1--HD"          format=f1.
      ER44598   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 1--HD"             format=f1.
      ER44599   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 2--HD"             format=f1.
      ER44600   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 3--HD"             format=f1.
      ER44601   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 4--HD"             format=f1.
      ER44602   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 5--HD"             format=f1.
      ER44603   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 6--HD"             format=f1.
      ER44604   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 7--HD"             format=f1.
      ER44605   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 8--HD"             format=f1.
      ER44606   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 9--HD"             format=f1.
      ER44607   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 10--HD"            format=f1.
      ER44608   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 11--HD"            format=f1.
      ER44609   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 12--HD"            format=f1.
      ER44610   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 13--HD"            format=f1.
      ER44611   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 14--HD"            format=f1.
      ER44612   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 15--HD"            format=f1.
      ER44613   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 16--HD"            format=f1.
      ER44614   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 17+--HD"           format=f1.
      ER44615   LABEL="HEHC SLF RPT: AGE END DRUG/AL PROB--HD"           format=f3.
      ER44616   LABEL="HEHC SLF RPT: OTR PSYCH PROB B4 AGE 1--H"         format=f1.
      ER44617   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 1--HD"           format=f1.
      ER44618   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 2--HD"           format=f1.
      ER44619   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 3--HD"           format=f1.
      ER44620   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 4--HD"           format=f1.
      ER44621   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 5--HD"           format=f1.
      ER44622   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 6--HD"           format=f1.
      ER44623   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 7--HD"           format=f1.
      ER44624   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 8--HD"           format=f1.
      ER44625   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 9--HD"           format=f1.
      ER44626   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 10--HD"          format=f1.
      ER44627   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 11--HD"          format=f1.
      ER44628   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 12--HD"          format=f1.
      ER44629   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 13--HD"          format=f1.
      ER44630   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 14--HD"          format=f1.
      ER44631   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 15--HD"          format=f1.
      ER44632   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 16--HD"          format=f1.
      ER44633   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 17+--HD"         format=f1.
      ER44634   LABEL="HEHC SLF RPT: AGE END OTR PSYCH PROB--HD"         format=f3.
      ER44635   LABEL="HEHC SP REPORT: YEAR 1ST REPORT--HD"              format=f4.
      ER44636   LABEL="HEHC SP RPT: PAR SEP B4 AGE 1--HD"                format=f1.
      ER44637   LABEL="HEHC SP RPT: PAR SEP AGE 1--HD"                   format=f1.
      ER44638   LABEL="HEHC SP RPT: PAR SEP AGE 2--HD"                   format=f1.
      ER44639   LABEL="HEHC SP RPT: PAR SEP AGE 3--HD"                   format=f1.
      ER44640   LABEL="HEHC SP RPT: PAR SEP AGE 4--HD"                   format=f1.
      ER44641   LABEL="HEHC SP RPT: PAR SEP AGE 5--HD"                   format=f1.
      ER44642   LABEL="HEHC SP RPT: PAR SEP AGE 6--HD"                   format=f1.
      ER44643   LABEL="HEHC SP RPT: PAR SEP AGE 7--HD"                   format=f1.
      ER44644   LABEL="HEHC SP RPT: PAR SEP AGE 8--HD"                   format=f1.
      ER44645   LABEL="HEHC SP RPT: PAR SEP AGE 9--HD"                   format=f1.
      ER44646   LABEL="HEHC SP RPT: PAR SEP AGE 10--HD"                  format=f1.
      ER44647   LABEL="HEHC SP RPT: PAR SEP AGE 11--HD"                  format=f1.
      ER44648   LABEL="HEHC SP RPT: PAR SEP AGE 12--HD"                  format=f1.
      ER44649   LABEL="HEHC SP RPT: PAR SEP AGE 13--HD"                  format=f1.
      ER44650   LABEL="HEHC SP RPT: PAR SEP AGE 14--HD"                  format=f1.
      ER44651   LABEL="HEHC SP RPT: PAR SEP AGE 15--HD"                  format=f1.
      ER44652   LABEL="HEHC SP RPT: PAR SEP AGE 16--HD"                  format=f1.
      ER44653   LABEL="HEHC SP RPT: MOVE B4 AGE 1--HD"                   format=f1.
      ER44654   LABEL="HEHC SP RPT: MOVE AGE 1--HD"                      format=f1.
      ER44655   LABEL="HEHC SP RPT: MOVE AGE 2--HD"                      format=f1.
      ER44656   LABEL="HEHC SP RPT: MOVE AGE 3--HD"                      format=f1.
      ER44657   LABEL="HEHC SP RPT: MOVE AGE 4--HD"                      format=f1.
      ER44658   LABEL="HEHC SP RPT: MOVE AGE 5--HD"                      format=f1.
      ER44659   LABEL="HEHC SP RPT: MOVE AGE 6--HD"                      format=f1.
      ER44660   LABEL="HEHC SP RPT: MOVE AGE 7--HD"                      format=f1.
      ER44661   LABEL="HEHC SP RPT: MOVE AGE 8--HD"                      format=f1.
      ER44662   LABEL="HEHC SP RPT: MOVE AGE 9--HD"                      format=f1.
      ER44663   LABEL="HEHC SP RPT: MOVE AGE 10--HD"                     format=f1.
      ER44664   LABEL="HEHC SP RPT: MOVE AGE 11--HD"                     format=f1.
      ER44665   LABEL="HEHC SP RPT: MOVE AGE 12--HD"                     format=f1.
      ER44666   LABEL="HEHC SP RPT: MOVE AGE 13--HD"                     format=f1.
      ER44667   LABEL="HEHC SP RPT: MOVE AGE 14--HD"                     format=f1.
      ER44668   LABEL="HEHC SP RPT: MOVE AGE 15--HD"                     format=f1.
      ER44669   LABEL="HEHC SP RPT: MOVE AGE 16--HD"                     format=f1.
      ER44670   LABEL="HEHC SP RPT: SCHOOL B4 AGE 1--HD"                 format=f1.
      ER44671   LABEL="HEHC SP RPT: SCHOOL AGE 1--HD"                    format=f1.
      ER44672   LABEL="HEHC SP RPT: SCHOOL AGE 2--HD"                    format=f1.
      ER44673   LABEL="HEHC SP RPT: SCHOOL AGE 3--HD"                    format=f1.
      ER44674   LABEL="HEHC SP RPT: SCHOOL AGE 4--HD"                    format=f1.
      ER44675   LABEL="HEHC SP RPT: SCHOOL AGE 5--HD"                    format=f1.
      ER44676   LABEL="HEHC SP RPT: SCHOOL AGE 6--HD"                    format=f1.
      ER44677   LABEL="HEHC SP RPT: SCHOOL AGE 7--HD"                    format=f1.
      ER44678   LABEL="HEHC SP RPT: SCHOOL AGE 8--HD"                    format=f1.
      ER44679   LABEL="HEHC SP RPT: SCHOOL AGE 9--HD"                    format=f1.
      ER44680   LABEL="HEHC SP RPT: SCHOOL AGE 10--HD"                   format=f1.
      ER44681   LABEL="HEHC SP RPT: SCHOOL AGE 11--HD"                   format=f1.
      ER44682   LABEL="HEHC SP RPT: SCHOOL AGE 12--HD"                   format=f1.
      ER44683   LABEL="HEHC SP RPT: SCHOOL AGE 13--HD"                   format=f1.
      ER44684   LABEL="HEHC SP RPT: SCHOOL AGE 14--HD"                   format=f1.
      ER44685   LABEL="HEHC SP RPT: SCHOOL AGE 15--HD"                   format=f1.
      ER44686   LABEL="HEHC SP RPT: SCHOOL AGE 16--HD"                   format=f1.
      ER44687   LABEL="HEHC SP RPT: ASTHMA B4 AGE 1--HD"                 format=f1.
      ER44688   LABEL="HEHC SP RPT: ASTHMA AGE 1--HD"                    format=f1.
      ER44689   LABEL="HEHC SP RPT: ASTHMA AGE 2--HD"                    format=f1.
      ER44690   LABEL="HEHC SP RPT: ASTHMA AGE 3--HD"                    format=f1.
      ER44691   LABEL="HEHC SP RPT: ASTHMA AGE 4--HD"                    format=f1.
      ER44692   LABEL="HEHC SP RPT: ASTHMA AGE 5--HD"                    format=f1.
      ER44693   LABEL="HEHC SP RPT: ASTHMA AGE 6--HD"                    format=f1.
      ER44694   LABEL="HEHC SP RPT: ASTHMA AGE 7--HD"                    format=f1.
      ER44695   LABEL="HEHC SP RPT: ASTHMA AGE 8--HD"                    format=f1.
      ER44696   LABEL="HEHC SP RPT: ASTHMA AGE 9--HD"                    format=f1.
      ER44697   LABEL="HEHC SP RPT: ASTHMA AGE 10--HD"                   format=f1.
      ER44698   LABEL="HEHC SP RPT: ASTHMA AGE 11--HD"                   format=f1.
      ER44699   LABEL="HEHC SP RPT: ASTHMA AGE 12--HD"                   format=f1.
      ER44700   LABEL="HEHC SP RPT: ASTHMA AGE 13--HD"                   format=f1.
      ER44701   LABEL="HEHC SP RPT: ASTHMA AGE 14--HD"                   format=f1.
      ER44702   LABEL="HEHC SP RPT: ASTHMA AGE 15--HD"                   format=f1.
      ER44703   LABEL="HEHC SP RPT: ASTHMA AGE 16--HD"                   format=f1.
      ER44704   LABEL="HEHC SP RPT: ASTHMA AGE 17+--HD"                  format=f1.
      ER44705   LABEL="HEHC SP RPT: AGE END ASTHMA--HD"                  format=f3.
      ER44706   LABEL="HEHC SP RPT: DIABETES B4 AGE 1--HD"               format=f1.
      ER44707   LABEL="HEHC SP RPT: DIABETES AGE 1--HD"                  format=f1.
      ER44708   LABEL="HEHC SP RPT: DIABETES AGE 2--HD"                  format=f1.
      ER44709   LABEL="HEHC SP RPT: DIABETES AGE 3--HD"                  format=f1.
      ER44710   LABEL="HEHC SP RPT: DIABETES AGE 4--HD"                  format=f1.
      ER44711   LABEL="HEHC SP RPT: DIABETES AGE 5--HD"                  format=f1.
      ER44712   LABEL="HEHC SP RPT: DIABETES AGE 6--HD"                  format=f1.
      ER44713   LABEL="HEHC SP RPT: DIABETES AGE 7--HD"                  format=f1.
      ER44714   LABEL="HEHC SP RPT: DIABETES AGE 8--HD"                  format=f1.
      ER44715   LABEL="HEHC SP RPT: DIABETES AGE 9--HD"                  format=f1.
      ER44716   LABEL="HEHC SP RPT: DIABETES AGE 10--HD"                 format=f1.
      ER44717   LABEL="HEHC SP RPT: DIABETES AGE 11--HD"                 format=f1.
      ER44718   LABEL="HEHC SP RPT: DIABETES AGE 12--HD"                 format=f1.
      ER44719   LABEL="HEHC SP RPT: DIABETES AGE 13--HD"                 format=f1.
      ER44720   LABEL="HEHC SP RPT: DIABETES AGE 14--HD"                 format=f1.
      ER44721   LABEL="HEHC SP RPT: DIABETES AGE 15--HD"                 format=f1.
      ER44722   LABEL="HEHC SP RPT: DIABETES AGE 16--HD"                 format=f1.
      ER44723   LABEL="HEHC SP RPT: DIABETES AGE 17+--HD"                format=f1.
      ER44724   LABEL="HEHC SP RPT: AGE END DIABETES--HD"                format=f3.
      ER44725   LABEL="HEHC SP RPT: RESP DIS B4 AGE 1--HD"               format=f1.
      ER44726   LABEL="HEHC SP RPT: RESP DIS AGE 1--HD"                  format=f1.
      ER44727   LABEL="HEHC SP RPT: RESP DIS AGE 2--HD"                  format=f1.
      ER44728   LABEL="HEHC SP RPT: RESP DIS AGE 3--HD"                  format=f1.
      ER44729   LABEL="HEHC SP RPT: RESP DIS AGE 4--HD"                  format=f1.
      ER44730   LABEL="HEHC SP RPT: RESP DIS AGE 5--HD"                  format=f1.
      ER44731   LABEL="HEHC SP RPT: RESP DIS AGE 6--HD"                  format=f1.
      ER44732   LABEL="HEHC SP RPT: RESP DIS AGE 7--HD"                  format=f1.
      ER44733   LABEL="HEHC SP RPT: RESP DIS AGE 8--HD"                  format=f1.
      ER44734   LABEL="HEHC SP RPT: RESP DIS AGE 9--HD"                  format=f1.
      ER44735   LABEL="HEHC SP RPT: RESP DIS AGE 10--HD"                 format=f1.
      ER44736   LABEL="HEHC SP RPT: RESP DIS AGE 11--HD"                 format=f1.
      ER44737   LABEL="HEHC SP RPT: RESP DIS AGE 12--HD"                 format=f1.
      ER44738   LABEL="HEHC SP RPT: RESP DIS AGE 13--HD"                 format=f1.
      ER44739   LABEL="HEHC SP RPT: RESP DIS AGE 14--HD"                 format=f1.
      ER44740   LABEL="HEHC SP RPT: RESP DIS AGE 15--HD"                 format=f1.
      ER44741   LABEL="HEHC SP RPT: RESP DIS AGE 16--HD"                 format=f1.
      ER44742   LABEL="HEHC SP RPT: RESP DIS AGE 17+--HD"                format=f1.
      ER44743   LABEL="HEHC SP RPT: AGE END RESP DIS--HD"                format=f3.
      ER44744   LABEL="HEHC SP RPT: SPCH IMPAIR B4 AGE 1--HD"            format=f1.
      ER44745   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 1--HD"               format=f1.
      ER44746   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 2--HD"               format=f1.
      ER44747   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 3--HD"               format=f1.
      ER44748   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 4--HD"               format=f1.
      ER44749   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 5--HD"               format=f1.
      ER44750   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 6--HD"               format=f1.
      ER44751   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 7--HD"               format=f1.
      ER44752   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 8--HD"               format=f1.
      ER44753   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 9--HD"               format=f1.
      ER44754   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 10--HD"              format=f1.
      ER44755   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 11--HD"              format=f1.
      ER44756   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 12--HD"              format=f1.
      ER44757   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 13--HD"              format=f1.
      ER44758   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 14--HD"              format=f1.
      ER44759   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 15--HD"              format=f1.
      ER44760   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 16--HD"              format=f1.
      ER44761   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 17+--HD"             format=f1.
      ER44762   LABEL="HEHC SP RPT: AGE END SPCH IMPAIR--HD"             format=f3.
      ER44763   LABEL="HEHC SP RPT: ALLERGY B4 AGE 1--HD"                format=f1.
      ER44764   LABEL="HEHC SP RPT: ALLERGY AGE 1--HD"                   format=f1.
      ER44765   LABEL="HEHC SP RPT: ALLERGY AGE 2--HD"                   format=f1.
      ER44766   LABEL="HEHC SP RPT: ALLERGY AGE 3--HD"                   format=f1.
      ER44767   LABEL="HEHC SP RPT: ALLERGY AGE 4--HD"                   format=f1.
      ER44768   LABEL="HEHC SP RPT: ALLERGY AGE 5--HD"                   format=f1.
      ER44769   LABEL="HEHC SP RPT: ALLERGY AGE 6--HD"                   format=f1.
      ER44770   LABEL="HEHC SP RPT: ALLERGY AGE 7--HD"                   format=f1.
      ER44771   LABEL="HEHC SP RPT: ALLERGY AGE 8--HD"                   format=f1.
      ER44772   LABEL="HEHC SP RPT: ALLERGY AGE 9--HD"                   format=f1.
      ER44773   LABEL="HEHC SP RPT: ALLERGY AGE 10--HD"                  format=f1.
      ER44774   LABEL="HEHC SP RPT: ALLERGY AGE 11--HD"                  format=f1.
      ER44775   LABEL="HEHC SP RPT: ALLERGY AGE 12--HD"                  format=f1.
      ER44776   LABEL="HEHC SP RPT: ALLERGY AGE 13--HD"                  format=f1.
      ER44777   LABEL="HEHC SP RPT: ALLERGY AGE 14--HD"                  format=f1.
      ER44778   LABEL="HEHC SP RPT: ALLERGY AGE 15--HD"                  format=f1.
      ER44779   LABEL="HEHC SP RPT: ALLERGY AGE 16--HD"                  format=f1.
      ER44780   LABEL="HEHC SP RPT: ALLERGY AGE 17+--HD"                 format=f1.
      ER44781   LABEL="HEHC SP RPT: AGE END ALLERGY--HD"                 format=f3.
      ER44782   LABEL="HEHC SP RPT: HEART TRBL B4 AGE 1--HD"             format=f1.
      ER44783   LABEL="HEHC SP RPT: HEART TRBL AGE 1--HD"                format=f1.
      ER44784   LABEL="HEHC SP RPT: HEART TRBL AGE 2--HD"                format=f1.
      ER44785   LABEL="HEHC SP RPT: HEART TRBL AGE 3--HD"                format=f1.
      ER44786   LABEL="HEHC SP RPT: HEART TRBL AGE 4--HD"                format=f1.
      ER44787   LABEL="HEHC SP RPT: HEART TRBL AGE 5--HD"                format=f1.
      ER44788   LABEL="HEHC SP RPT: HEART TRBL AGE 6--HD"                format=f1.
      ER44789   LABEL="HEHC SP RPT: HEART TRBL AGE 7--HD"                format=f1.
      ER44790   LABEL="HEHC SP RPT: HEART TRBL AGE 8--HD"                format=f1.
      ER44791   LABEL="HEHC SP RPT: HEART TRBL AGE 9--HD"                format=f1.
      ER44792   LABEL="HEHC SP RPT: HEART TRBL AGE 10--HD"               format=f1.
      ER44793   LABEL="HEHC SP RPT: HEART TRBL AGE 11--HD"               format=f1.
      ER44794   LABEL="HEHC SP RPT: HEART TRBL AGE 12--HD"               format=f1.
      ER44795   LABEL="HEHC SP RPT: HEART TRBL AGE 13--HD"               format=f1.
      ER44796   LABEL="HEHC SP RPT: HEART TRBL AGE 14--HD"               format=f1.
      ER44797   LABEL="HEHC SP RPT: HEART TRBL AGE 15--HD"               format=f1.
      ER44798   LABEL="HEHC SP RPT: HEART TRBL AGE 16--HD"               format=f1.
      ER44799   LABEL="HEHC SP RPT: HEART TRBL AGE 17+--HD"              format=f1.
      ER44800   LABEL="HEHC SP RPT: AGE END HEART TRBL--HD"              format=f3.
      ER44801   LABEL="HEHC SP RPT: EAR PROBS B4 AGE 1--HD"              format=f1.
      ER44802   LABEL="HEHC SP RPT: EAR PROBS AGE 1--HD"                 format=f1.
      ER44803   LABEL="HEHC SP RPT: EAR PROBS AGE 2--HD"                 format=f1.
      ER44804   LABEL="HEHC SP RPT: EAR PROBS AGE 3--HD"                 format=f1.
      ER44805   LABEL="HEHC SP RPT: EAR PROBS AGE 4--HD"                 format=f1.
      ER44806   LABEL="HEHC SP RPT: EAR PROBS AGE 5--HD"                 format=f1.
      ER44807   LABEL="HEHC SP RPT: EAR PROBS AGE 6--HD"                 format=f1.
      ER44808   LABEL="HEHC SP RPT: EAR PROBS AGE 7--HD"                 format=f1.
      ER44809   LABEL="HEHC SP RPT: EAR PROBS AGE 8--HD"                 format=f1.
      ER44810   LABEL="HEHC SP RPT: EAR PROBS AGE 9--HD"                 format=f1.
      ER44811   LABEL="HEHC SP RPT: EAR PROBS AGE 10--HD"                format=f1.
      ER44812   LABEL="HEHC SP RPT: EAR PROBS AGE 11--HD"                format=f1.
      ER44813   LABEL="HEHC SP RPT: EAR PROBS AGE 12--HD"                format=f1.
      ER44814   LABEL="HEHC SP RPT: EAR PROBS AGE 13--HD"                format=f1.
      ER44815   LABEL="HEHC SP RPT: EAR PROBS AGE 14--HD"                format=f1.
      ER44816   LABEL="HEHC SP RPT: EAR PROBS AGE 15--HD"                format=f1.
      ER44817   LABEL="HEHC SP RPT: EAR PROBS AGE 16--HD"                format=f1.
      ER44818   LABEL="HEHC SP RPT: EAR PROBS AGE 17+--HD"               format=f1.
      ER44819   LABEL="HEHC SP RPT: AGE END EAR PROBS--HD"               format=f3.
      ER44820   LABEL="HEHC SP RPT: EPILEPSY B4 AGE 1--HD"               format=f1.
      ER44821   LABEL="HEHC SP RPT: EPILEPSY AGE 1--HD"                  format=f1.
      ER44822   LABEL="HEHC SP RPT: EPILEPSY AGE 2--HD"                  format=f1.
      ER44823   LABEL="HEHC SP RPT: EPILEPSY AGE 3--HD"                  format=f1.
      ER44824   LABEL="HEHC SP RPT: EPILEPSY AGE 4--HD"                  format=f1.
      ER44825   LABEL="HEHC SP RPT: EPILEPSY AGE 5--HD"                  format=f1.
      ER44826   LABEL="HEHC SP RPT: EPILEPSY AGE 6--HD"                  format=f1.
      ER44827   LABEL="HEHC SP RPT: EPILEPSY AGE 7--HD"                  format=f1.
      ER44828   LABEL="HEHC SP RPT: EPILEPSY AGE 8--HD"                  format=f1.
      ER44829   LABEL="HEHC SP RPT: EPILEPSY AGE 9--HD"                  format=f1.
      ER44830   LABEL="HEHC SP RPT: EPILEPSY AGE 10--HD"                 format=f1.
      ER44831   LABEL="HEHC SP RPT: EPILEPSY AGE 11--HD"                 format=f1.
      ER44832   LABEL="HEHC SP RPT: EPILEPSY AGE 12--HD"                 format=f1.
      ER44833   LABEL="HEHC SP RPT: EPILEPSY AGE 13--HD"                 format=f1.
      ER44834   LABEL="HEHC SP RPT: EPILEPSY AGE 14--HD"                 format=f1.
      ER44835   LABEL="HEHC SP RPT: EPILEPSY AGE 15--HD"                 format=f1.
      ER44836   LABEL="HEHC SP RPT: EPILEPSY AGE 16--HD"                 format=f1.
      ER44837   LABEL="HEHC SP RPT: EPILEPSY AGE 17+--HD"                format=f1.
      ER44838   LABEL="HEHC SP RPT: AGE END EPILEPSY--HD"                format=f3.
      ER44839   LABEL="HEHC SP RPT: HEADACHE B4 AGE 1--HD"               format=f1.
      ER44840   LABEL="HEHC SP RPT: HEADACHE AGE 1--HD"                  format=f1.
      ER44841   LABEL="HEHC SP RPT: HEADACHE AGE 2--HD"                  format=f1.
      ER44842   LABEL="HEHC SP RPT: HEADACHE AGE 3--HD"                  format=f1.
      ER44843   LABEL="HEHC SP RPT: HEADACHE AGE 4--HD"                  format=f1.
      ER44844   LABEL="HEHC SP RPT: HEADACHE AGE 5--HD"                  format=f1.
      ER44845   LABEL="HEHC SP RPT: HEADACHE AGE 6--HD"                  format=f1.
      ER44846   LABEL="HEHC SP RPT: HEADACHE AGE 7--HD"                  format=f1.
      ER44847   LABEL="HEHC SP RPT: HEADACHE AGE 8--HD"                  format=f1.
      ER44848   LABEL="HEHC SP RPT: HEADACHE AGE 9--HD"                  format=f1.
      ER44849   LABEL="HEHC SP RPT: HEADACHE AGE 10--HD"                 format=f1.
      ER44850   LABEL="HEHC SP RPT: HEADACHE AGE 11--HD"                 format=f1.
      ER44851   LABEL="HEHC SP RPT: HEADACHE AGE 12--HD"                 format=f1.
      ER44852   LABEL="HEHC SP RPT: HEADACHE AGE 13--HD"                 format=f1.
      ER44853   LABEL="HEHC SP RPT: HEADACHE AGE 14--HD"                 format=f1.
      ER44854   LABEL="HEHC SP RPT: HEADACHE AGE 15--HD"                 format=f1.
      ER44855   LABEL="HEHC SP RPT: HEADACHE AGE 16--HD"                 format=f1.
      ER44856   LABEL="HEHC SP RPT: HEADACHE AGE 17+--HD"                format=f1.
      ER44857   LABEL="HEHC SP RPT: AGE END HEADACHE--HD"                format=f3.
      ER44858   LABEL="HEHC SP RPT: STOM PROB B4 AGE 1--HD"              format=f1.
      ER44859   LABEL="HEHC SP RPT: STOM PROB AGE 1--HD"                 format=f1.
      ER44860   LABEL="HEHC SP RPT: STOM PROB AGE 2--HD"                 format=f1.
      ER44861   LABEL="HEHC SP RPT: STOM PROB AGE 3--HD"                 format=f1.
      ER44862   LABEL="HEHC SP RPT: STOM PROB AGE 4--HD"                 format=f1.
      ER44863   LABEL="HEHC SP RPT: STOM PROB AGE 5--HD"                 format=f1.
      ER44864   LABEL="HEHC SP RPT: STOM PROB AGE 6--HD"                 format=f1.
      ER44865   LABEL="HEHC SP RPT: STOM PROB AGE 7--HD"                 format=f1.
      ER44866   LABEL="HEHC SP RPT: STOM PROB AGE 8--HD"                 format=f1.
      ER44867   LABEL="HEHC SP RPT: STOM PROB AGE 9--HD"                 format=f1.
      ER44868   LABEL="HEHC SP RPT: STOM PROB AGE 10--HD"                format=f1.
      ER44869   LABEL="HEHC SP RPT: STOM PROB AGE 11--HD"                format=f1.
      ER44870   LABEL="HEHC SP RPT: STOM PROB AGE 12--HD"                format=f1.
      ER44871   LABEL="HEHC SP RPT: STOM PROB AGE 13--HD"                format=f1.
      ER44872   LABEL="HEHC SP RPT: STOM PROB AGE 14--HD"                format=f1.
      ER44873   LABEL="HEHC SP RPT: STOM PROB AGE 15--HD"                format=f1.
      ER44874   LABEL="HEHC SP RPT: STOM PROB AGE 16--HD"                format=f1.
      ER44875   LABEL="HEHC SP RPT: STOM PROB AGE 17+--HD"               format=f1.
      ER44876   LABEL="HEHC SP RPT: AGE END STOM PROB--HD"               format=f3.
      ER44877   LABEL="HEHC SP RPT: HGH BLOOD PR B4 AGE 1--HD"           format=f1.
      ER44878   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 1--HD"              format=f1.
      ER44879   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 2--HD"              format=f1.
      ER44880   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 3--HD"              format=f1.
      ER44881   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 4--HD"              format=f1.
      ER44882   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 5--HD"              format=f1.
      ER44883   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 6--HD"              format=f1.
      ER44884   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 7--HD"              format=f1.
      ER44885   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 8--HD"              format=f1.
      ER44886   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 9--HD"              format=f1.
      ER44887   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 10--HD"             format=f1.
      ER44888   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 11--HD"             format=f1.
      ER44889   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 12--HD"             format=f1.
      ER44890   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 13--HD"             format=f1.
      ER44891   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 14--HD"             format=f1.
      ER44892   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 15--HD"             format=f1.
      ER44893   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 16--HD"             format=f1.
      ER44894   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 17+--HD"            format=f1.
      ER44895   LABEL="HEHC SP RPT: AGE END HGH BLD PR--HD"              format=f3.
      ER44896   LABEL="HEHC SP RPT: DEPRESSION B4 AGE 1--HD"             format=f1.
      ER44897   LABEL="HEHC SP RPT: DEPRESSION AGE 1--HD"                format=f1.
      ER44898   LABEL="HEHC SP RPT: DEPRESSION AGE 2--HD"                format=f1.
      ER44899   LABEL="HEHC SP RPT: DEPRESSION AGE 3--HD"                format=f1.
      ER44900   LABEL="HEHC SP RPT: DEPRESSION AGE 4--HD"                format=f1.
      ER44901   LABEL="HEHC SP RPT: DEPRESSION AGE 5--HD"                format=f1.
      ER44902   LABEL="HEHC SP RPT: DEPRESSION AGE 6--HD"                format=f1.
      ER44903   LABEL="HEHC SP RPT: DEPRESSION AGE 7--HD"                format=f1.
      ER44904   LABEL="HEHC SP RPT: DEPRESSION AGE 8--HD"                format=f1.
      ER44905   LABEL="HEHC SP RPT: DEPRESSION AGE 9--HD"                format=f1.
      ER44906   LABEL="HEHC SP RPT: DEPRESSION AGE 10--HD"               format=f1.
      ER44907   LABEL="HEHC SP RPT: DEPRESSION AGE 11--HD"               format=f1.
      ER44908   LABEL="HEHC SP RPT: DEPRESSION AGE 12--HD"               format=f1.
      ER44909   LABEL="HEHC SP RPT: DEPRESSION AGE 13--HD"               format=f1.
      ER44910   LABEL="HEHC SP RPT: DEPRESSION AGE 14--HD"               format=f1.
      ER44911   LABEL="HEHC SP RPT: DEPRESSION AGE 15--HD"               format=f1.
      ER44912   LABEL="HEHC SP RPT: DEPRESSION AGE 16--HD"               format=f1.
      ER44913   LABEL="HEHC SP RPT: DEPRESSION AGE 17+--HD"              format=f1.
      ER44914   LABEL="HEHC SP RPT: AGE END DEPRESSION--HD"              format=f3.
      ER44915   LABEL="HEHC SP RPT: DRUG/AL PROB B4 AGE 1--HD"           format=f1.
      ER44916   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 1--HD"              format=f1.
      ER44917   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 2--HD"              format=f1.
      ER44918   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 3--HD"              format=f1.
      ER44919   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 4--HD"              format=f1.
      ER44920   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 5--HD"              format=f1.
      ER44921   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 6--HD"              format=f1.
      ER44922   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 7--HD"              format=f1.
      ER44923   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 8--HD"              format=f1.
      ER44924   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 9--HD"              format=f1.
      ER44925   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 10--HD"             format=f1.
      ER44926   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 11--HD"             format=f1.
      ER44927   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 12--HD"             format=f1.
      ER44928   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 13--HD"             format=f1.
      ER44929   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 14--HD"             format=f1.
      ER44930   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 15--HD"             format=f1.
      ER44931   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 16--HD"             format=f1.
      ER44932   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 17+--HD"            format=f1.
      ER44933   LABEL="HEHC SP RPT: AGE END DRUG/AL PROB--HD"            format=f3.
      ER44934   LABEL="HEHC SP RPT: OTR PSYCH PROB B4 AGE 1--HD"         format=f1.
      ER44935   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 1--HD"            format=f1.
      ER44936   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 2--HD"            format=f1.
      ER44937   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 3--HD"            format=f1.
      ER44938   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 4--HD"            format=f1.
      ER44939   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 5--HD"            format=f1.
      ER44940   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 6--HD"            format=f1.
      ER44941   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 7--HD"            format=f1.
      ER44942   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 8--HD"            format=f1.
      ER44943   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 9--HD"            format=f1.
      ER44944   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 10--HD"           format=f1.
      ER44945   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 11--HD"           format=f1.
      ER44946   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 12--HD"           format=f1.
      ER44947   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 13--HD"           format=f1.
      ER44948   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 14--HD"           format=f1.
      ER44949   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 15--HD"           format=f1.
      ER44950   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 16--HD"           format=f1.
      ER44951   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 17+--HD"          format=f1.
      ER44952   LABEL="HEHC SP RPT: AGE END OTR PSYCH PROB--HD"          format=f3.
      ER44953   LABEL="HEHC OTR RPT: YEAR 1ST REPORT--HD"                format=f4.
      ER44954   LABEL="HEHC OTR RPT: PAR SEP B4 AGE 1--HD"               format=f1.
      ER44955   LABEL="HEHC OTR RPT: PAR SEP AGE 1--HD"                  format=f1.
      ER44956   LABEL="HEHC OTR RPT: PAR SEP AGE 2--HD"                  format=f1.
      ER44957   LABEL="HEHC OTR RPT: PAR SEP AGE 3--HD"                  format=f1.
      ER44958   LABEL="HEHC OTR RPT: PAR SEP AGE 4--HD"                  format=f1.
      ER44959   LABEL="HEHC OTR RPT: PAR SEP AGE 5--HD"                  format=f1.
      ER44960   LABEL="HEHC OTR RPT: PAR SEP AGE 6--HD"                  format=f1.
      ER44961   LABEL="HEHC OTR RPT: PAR SEP AGE 7--HD"                  format=f1.
      ER44962   LABEL="HEHC OTR RPT: PAR SEP AGE 8--HD"                  format=f1.
      ER44963   LABEL="HEHC OTR RPT: PAR SEP AGE 9--HD"                  format=f1.
      ER44964   LABEL="HEHC OTR RPT: PAR SEP AGE 10--HD"                 format=f1.
      ER44965   LABEL="HEHC OTR RPT: PAR SEP AGE 11--HD"                 format=f1.
      ER44966   LABEL="HEHC OTR RPT: PAR SEP AGE 12--HD"                 format=f1.
      ER44967   LABEL="HEHC OTR RPT: PAR SEP AGE 13--HD"                 format=f1.
      ER44968   LABEL="HEHC OTR RPT: PAR SEP AGE 14--HD"                 format=f1.
      ER44969   LABEL="HEHC OTR RPT: PAR SEP AGE 15--HD"                 format=f1.
      ER44970   LABEL="HEHC OTR RPT: PAR SEP AGE 16--HD"                 format=f1.
      ER44971   LABEL="HEHC OTR RPT: MOVE B4 AGE 1--HD"                  format=f1.
      ER44972   LABEL="HEHC OTR RPT: MOVE AGE 1--HD"                     format=f1.
      ER44973   LABEL="HEHC OTR RPT: MOVE AGE 2--HD"                     format=f1.
      ER44974   LABEL="HEHC OTR RPT: MOVE AGE 3--HD"                     format=f1.
      ER44975   LABEL="HEHC OTR RPT: MOVE AGE 4--HD"                     format=f1.
      ER44976   LABEL="HEHC OTR RPT: MOVE AGE 5--HD"                     format=f1.
      ER44977   LABEL="HEHC OTR RPT: MOVE AGE 6--HD"                     format=f1.
      ER44978   LABEL="HEHC OTR RPT: MOVE AGE 7--HD"                     format=f1.
      ER44979   LABEL="HEHC OTR RPT: MOVE AGE 8--HD"                     format=f1.
      ER44980   LABEL="HEHC OTR RPT: MOVE AGE 9--HD"                     format=f1.
      ER44981   LABEL="HEHC OTR RPT: MOVE AGE 10--HD"                    format=f1.
      ER44982   LABEL="HEHC OTR RPT: MOVE AGE 11--HD"                    format=f1.
      ER44983   LABEL="HEHC OTR RPT: MOVE AGE 12--HD"                    format=f1.
      ER44984   LABEL="HEHC OTR RPT: MOVE AGE 13--HD"                    format=f1.
      ER44985   LABEL="HEHC OTR RPT: MOVE AGE 14--HD"                    format=f1.
      ER44986   LABEL="HEHC OTR RPT: MOVE AGE 15--HD"                    format=f1.
      ER44987   LABEL="HEHC OTR RPT: MOVE AGE 16--HD"                    format=f1.
      ER44988   LABEL="HEHC OTR RPT: SCHOOL B4 AGE 1--HD"                format=f1.
      ER44989   LABEL="HEHC OTR RPT: SCHOOL AGE 1--HD"                   format=f1.
      ER44990   LABEL="HEHC OTR RPT: SCHOOL AGE 2--HD"                   format=f1.
      ER44991   LABEL="HEHC OTR RPT: SCHOOL AGE 3--HD"                   format=f1.
      ER44992   LABEL="HEHC OTR RPT: SCHOOL AGE 4--HD"                   format=f1.
      ER44993   LABEL="HEHC OTR RPT: SCHOOL AGE 5--HD"                   format=f1.
      ER44994   LABEL="HEHC OTR RPT: SCHOOL AGE 6--HD"                   format=f1.
      ER44995   LABEL="HEHC OTR RPT: SCHOOL AGE 7--HD"                   format=f1.
      ER44996   LABEL="HEHC OTR RPT: SCHOOL AGE 8--HD"                   format=f1.
      ER44997   LABEL="HEHC OTR RPT: SCHOOL AGE 9--HD"                   format=f1.
      ER44998   LABEL="HEHC OTR RPT: SCHOOL AGE 10--HD"                  format=f1.
      ER44999   LABEL="HEHC OTR RPT: SCHOOL AGE 11--HD"                  format=f1.
      ER45000   LABEL="HEHC OTR RPT: SCHOOL AGE 12--HD"                  format=f1.
      ER45001   LABEL="HEHC OTR RPT: SCHOOL AGE 13--HD"                  format=f1.
      ER45002   LABEL="HEHC OTR RPT: SCHOOL AGE 14--HD"                  format=f1.
      ER45003   LABEL="HEHC OTR RPT: SCHOOL AGE 15--HD"                  format=f1.
      ER45004   LABEL="HEHC OTR RPT: SCHOOL AGE 16--HD"                  format=f1.
      ER45005   LABEL="HEHC OTR RPT: ASTHMA B4 AGE 1--HD"                format=f1.
      ER45006   LABEL="HEHC OTR RPT: ASTHMA AGE 1--HD"                   format=f1.
      ER45007   LABEL="HEHC OTR RPT: ASTHMA AGE 2--HD"                   format=f1.
      ER45008   LABEL="HEHC OTR RPT: ASTHMA AGE 3--HD"                   format=f1.
      ER45009   LABEL="HEHC OTR RPT: ASTHMA AGE 4--HD"                   format=f1.
      ER45010   LABEL="HEHC OTR RPT: ASTHMA AGE 5--HD"                   format=f1.
      ER45011   LABEL="HEHC OTR RPT: ASTHMA AGE 6--HD"                   format=f1.
      ER45012   LABEL="HEHC OTR RPT: ASTHMA AGE 7--HD"                   format=f1.
      ER45013   LABEL="HEHC OTR RPT: ASTHMA AGE 8--HD"                   format=f1.
      ER45014   LABEL="HEHC OTR RPT: ASTHMA AGE 9--HD"                   format=f1.
      ER45015   LABEL="HEHC OTR RPT: ASTHMA AGE 10--HD"                  format=f1.
      ER45016   LABEL="HEHC OTR RPT: ASTHMA AGE 11--HD"                  format=f1.
      ER45017   LABEL="HEHC OTR RPT: ASTHMA AGE 12--HD"                  format=f1.
      ER45018   LABEL="HEHC OTR RPT: ASTHMA AGE 13--HD"                  format=f1.
      ER45019   LABEL="HEHC OTR RPT: ASTHMA AGE 14--HD"                  format=f1.
      ER45020   LABEL="HEHC OTR RPT: ASTHMA AGE 15--HD"                  format=f1.
      ER45021   LABEL="HEHC OTR RPT: ASTHMA AGE 16--HD"                  format=f1.
      ER45022   LABEL="HEHC OTR RPT: ASTHMA AGE 17+--HD"                 format=f1.
      ER45023   LABEL="HEHC OTR RPT: AGE END ASTHMA--HD"                 format=f3.
      ER45024   LABEL="HEHC OTR RPT: DIABETES B4 AGE 1--HD"              format=f1.
      ER45025   LABEL="HEHC OTR RPT: DIABETES AGE 1--HD"                 format=f1.
      ER45026   LABEL="HEHC OTR RPT: DIABETES AGE 2--HD"                 format=f1.
      ER45027   LABEL="HEHC OTR RPT: DIABETES AGE 3--HD"                 format=f1.
      ER45028   LABEL="HEHC OTR RPT: DIABETES AGE 4--HD"                 format=f1.
      ER45029   LABEL="HEHC OTR RPT: DIABETES AGE 5--HD"                 format=f1.
      ER45030   LABEL="HEHC OTR RPT: DIABETES AGE 6--HD"                 format=f1.
      ER45031   LABEL="HEHC OTR RPT: DIABETES AGE 7--HD"                 format=f1.
      ER45032   LABEL="HEHC OTR RPT: DIABETES AGE 8--HD"                 format=f1.
      ER45033   LABEL="HEHC OTR RPT: DIABETES AGE 9--HD"                 format=f1.
      ER45034   LABEL="HEHC OTR RPT: DIABETES AGE 10--HD"                format=f1.
      ER45035   LABEL="HEHC OTR RPT: DIABETES AGE 11--HD"                format=f1.
      ER45036   LABEL="HEHC OTR RPT: DIABETES AGE 12--HD"                format=f1.
      ER45037   LABEL="HEHC OTR RPT: DIABETES AGE 13--HD"                format=f1.
      ER45038   LABEL="HEHC OTR RPT: DIABETES AGE 14--HD"                format=f1.
      ER45039   LABEL="HEHC OTR RPT: DIABETES AGE 15--HD"                format=f1.
      ER45040   LABEL="HEHC OTR RPT: DIABETES AGE 16--HD"                format=f1.
      ER45041   LABEL="HEHC OTR RPT: DIABETES AGE 17+--HD"               format=f1.
      ER45042   LABEL="HEHC OTR RPT: AGE END DIABETES--HD"               format=f3.
      ER45043   LABEL="HEHC OTR RPT: RESP DIS B4 AGE 1--HD"              format=f1.
      ER45044   LABEL="HEHC OTR RPT: RESP DIS AGE 1--HD"                 format=f1.
      ER45045   LABEL="HEHC OTR RPT: RESP DIS AGE 2--HD"                 format=f1.
      ER45046   LABEL="HEHC OTR RPT: RESP DIS AGE 3--HD"                 format=f1.
      ER45047   LABEL="HEHC OTR RPT: RESP DIS AGE 4--HD"                 format=f1.
      ER45048   LABEL="HEHC OTR RPT: RESP DIS AGE 5--HD"                 format=f1.
      ER45049   LABEL="HEHC OTR RPT: RESP DIS AGE 6--HD"                 format=f1.
      ER45050   LABEL="HEHC OTR RPT: RESP DIS AGE 7--HD"                 format=f1.
      ER45051   LABEL="HEHC OTR RPT: RESP DIS AGE 8--HD"                 format=f1.
      ER45052   LABEL="HEHC OTR RPT: RESP DIS AGE 9--HD"                 format=f1.
      ER45053   LABEL="HEHC OTR RPT: RESP DIS AGE 10--HD"                format=f1.
      ER45054   LABEL="HEHC OTR RPT: RESP DIS AGE 11--HD"                format=f1.
      ER45055   LABEL="HEHC OTR RPT: RESP DIS AGE 12--HD"                format=f1.
      ER45056   LABEL="HEHC OTR RPT: RESP DIS AGE 13--HD"                format=f1.
      ER45057   LABEL="HEHC OTR RPT: RESP DIS AGE 14--HD"                format=f1.
      ER45058   LABEL="HEHC OTR RPT: RESP DIS AGE 15--HD"                format=f1.
      ER45059   LABEL="HEHC OTR RPT: RESP DIS AGE 16--HD"                format=f1.
      ER45060   LABEL="HEHC OTR RPT: RESP DIS AGE 17+--HD"               format=f1.
      ER45061   LABEL="HEHC OTR RPT: AGE END RESP DIS--HD"               format=f3.
      ER45062   LABEL="HEHC OTR RPT: SPCH IMPAIR B4 AGE 1--HD"           format=f1.
      ER45063   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 1--HD"              format=f1.
      ER45064   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 2--HD"              format=f1.
      ER45065   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 3--HD"              format=f1.
      ER45066   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 4--HD"              format=f1.
      ER45067   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 5--HD"              format=f1.
      ER45068   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 6--HD"              format=f1.
      ER45069   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 7--HD"              format=f1.
      ER45070   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 8--HD"              format=f1.
      ER45071   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 9--HD"              format=f1.
      ER45072   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 10--HD"             format=f1.
      ER45073   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 11--HD"             format=f1.
      ER45074   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 12--HD"             format=f1.
      ER45075   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 13--HD"             format=f1.
      ER45076   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 14--HD"             format=f1.
      ER45077   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 15--HD"             format=f1.
      ER45078   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 16--HD"             format=f1.
      ER45079   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 17+--HD"            format=f1.
      ER45080   LABEL="HEHC OTR RPT: AGE END SPCH IMPAIR--HD"            format=f3.
      ER45081   LABEL="HEHC OTR RPT: ALLERGY B4 AGE 1--HD"               format=f1.
      ER45082   LABEL="HEHC OTR RPT: ALLERGY AGE 1--HD"                  format=f1.
      ER45083   LABEL="HEHC OTR RPT: ALLERGY AGE 2--HD"                  format=f1.
      ER45084   LABEL="HEHC OTR RPT: ALLERGY AGE 3--HD"                  format=f1.
      ER45085   LABEL="HEHC OTR RPT: ALLERGY AGE 4--HD"                  format=f1.
      ER45086   LABEL="HEHC OTR RPT: ALLERGY AGE 5--HD"                  format=f1.
      ER45087   LABEL="HEHC OTR RPT: ALLERGY AGE 6--HD"                  format=f1.
      ER45088   LABEL="HEHC OTR RPT: ALLERGY AGE 7--HD"                  format=f1.
      ER45089   LABEL="HEHC OTR RPT: ALLERGY AGE 8--HD"                  format=f1.
      ER45090   LABEL="HEHC OTR RPT: ALLERGY AGE 9--HD"                  format=f1.
      ER45091   LABEL="HEHC OTR RPT: ALLERGY AGE 10--HD"                 format=f1.
      ER45092   LABEL="HEHC OTR RPT: ALLERGY AGE 11--HD"                 format=f1.
      ER45093   LABEL="HEHC OTR RPT: ALLERGY AGE 12--HD"                 format=f1.
      ER45094   LABEL="HEHC OTR RPT: ALLERGY AGE 13--HD"                 format=f1.
      ER45095   LABEL="HEHC OTR RPT: ALLERGY AGE 14--HD"                 format=f1.
      ER45096   LABEL="HEHC OTR RPT: ALLERGY AGE 15--HD"                 format=f1.
      ER45097   LABEL="HEHC OTR RPT: ALLERGY AGE 16--HD"                 format=f1.
      ER45098   LABEL="HEHC OTR RPT: ALLERGY AGE 17+--HD"                format=f1.
      ER45099   LABEL="HEHC OTR RPT: AGE END ALLERGY--HD"                format=f3.
      ER45100   LABEL="HEHC OTR RPT: HEART TRBL B4 AGE 1--HD"            format=f1.
      ER45101   LABEL="HEHC OTR RPT: HEART TRBL AGE 1--HD"               format=f1.
      ER45102   LABEL="HEHC OTR RPT: HEART TRBL AGE 2--HD"               format=f1.
      ER45103   LABEL="HEHC OTR RPT: HEART TRBL AGE 3--HD"               format=f1.
      ER45104   LABEL="HEHC OTR RPT: HEART TRBL AGE 4--HD"               format=f1.
      ER45105   LABEL="HEHC OTR RPT: HEART TRBL AGE 5--HD"               format=f1.
      ER45106   LABEL="HEHC OTR RPT: HEART TRBL AGE 6--HD"               format=f1.
      ER45107   LABEL="HEHC OTR RPT: HEART TRBL AGE 7--HD"               format=f1.
      ER45108   LABEL="HEHC OTR RPT: HEART TRBL AGE 8--HD"               format=f1.
      ER45109   LABEL="HEHC OTR RPT: HEART TRBL AGE 9--HD"               format=f1.
      ER45110   LABEL="HEHC OTR RPT: HEART TRBL AGE 10--HD"              format=f1.
      ER45111   LABEL="HEHC OTR RPT: HEART TRBL AGE 11--HD"              format=f1.
      ER45112   LABEL="HEHC OTR RPT: HEART TRBL AGE 12--HD"              format=f1.
      ER45113   LABEL="HEHC OTR RPT: HEART TRBL AGE 13--HD"              format=f1.
      ER45114   LABEL="HEHC OTR RPT: HEART TRBL AGE 14--HD"              format=f1.
      ER45115   LABEL="HEHC OTR RPT: HEART TRBL AGE 15--HD"              format=f1.
      ER45116   LABEL="HEHC OTR RPT: HEART TRBL AGE 16--HD"              format=f1.
      ER45117   LABEL="HEHC OTR RPT: HEART TRBL AGE 17+--HD"             format=f1.
      ER45118   LABEL="HEHC OTR RPT: AGE END HEART TRBL--HD"             format=f3.
      ER45119   LABEL="HEHC OTR RPT: EAR PROBS B4 AGE 1--HD"             format=f1.
      ER45120   LABEL="HEHC OTR RPT: EAR PROBS AGE 1--HD"                format=f1.
      ER45121   LABEL="HEHC OTR RPT: EAR PROBS AGE 2--HD"                format=f1.
      ER45122   LABEL="HEHC OTR RPT: EAR PROBS AGE 3--HD"                format=f1.
      ER45123   LABEL="HEHC OTR RPT: EAR PROBS AGE 4--HD"                format=f1.
      ER45124   LABEL="HEHC OTR RPT: EAR PROBS AGE 5--HD"                format=f1.
      ER45125   LABEL="HEHC OTR RPT: EAR PROBS AGE 6--HD"                format=f1.
      ER45126   LABEL="HEHC OTR RPT: EAR PROBS AGE 7--HD"                format=f1.
      ER45127   LABEL="HEHC OTR RPT: EAR PROBS AGE 8--HD"                format=f1.
      ER45128   LABEL="HEHC OTR RPT: EAR PROBS AGE 9--HD"                format=f1.
      ER45129   LABEL="HEHC OTR RPT: EAR PROBS AGE 10--HD"               format=f1.
      ER45130   LABEL="HEHC OTR RPT: EAR PROBS AGE 11--HD"               format=f1.
      ER45131   LABEL="HEHC OTR RPT: EAR PROBS AGE 12--HD"               format=f1.
      ER45132   LABEL="HEHC OTR RPT: EAR PROBS AGE 13--HD"               format=f1.
      ER45133   LABEL="HEHC OTR RPT: EAR PROBS AGE 14--HD"               format=f1.
      ER45134   LABEL="HEHC OTR RPT: EAR PROBS AGE 15--HD"               format=f1.
      ER45135   LABEL="HEHC OTR RPT: EAR PROBS AGE 16--HD"               format=f1.
      ER45136   LABEL="HEHC OTR RPT: EAR PROBS AGE 17+--HD"              format=f1.
      ER45137   LABEL="HEHC OTR RPT: AGE END EAR PROBS--HD"              format=f3.
      ER45138   LABEL="HEHC OTR RPT: EPILEPSY B4 AGE 1--HD"              format=f1.
      ER45139   LABEL="HEHC OTR RPT: EPILEPSY AGE 1--HD"                 format=f1.
      ER45140   LABEL="HEHC OTR RPT: EPILEPSY AGE 2--HD"                 format=f1.
      ER45141   LABEL="HEHC OTR RPT: EPILEPSY AGE 3--HD"                 format=f1.
      ER45142   LABEL="HEHC OTR RPT: EPILEPSY AGE 4--HD"                 format=f1.
      ER45143   LABEL="HEHC OTR RPT: EPILEPSY AGE 5--HD"                 format=f1.
      ER45144   LABEL="HEHC OTR RPT: EPILEPSY AGE 6--HD"                 format=f1.
      ER45145   LABEL="HEHC OTR RPT: EPILEPSY AGE 7--HD"                 format=f1.
      ER45146   LABEL="HEHC OTR RPT: EPILEPSY AGE 8--HD"                 format=f1.
      ER45147   LABEL="HEHC OTR RPT: EPILEPSY AGE 9--HD"                 format=f1.
      ER45148   LABEL="HEHC OTR RPT: EPILEPSY AGE 10--HD"                format=f1.
      ER45149   LABEL="HEHC OTR RPT: EPILEPSY AGE 11--HD"                format=f1.
      ER45150   LABEL="HEHC OTR RPT: EPILEPSY AGE 12--HD"                format=f1.
      ER45151   LABEL="HEHC OTR RPT: EPILEPSY AGE 13--HD"                format=f1.
      ER45152   LABEL="HEHC OTR RPT: EPILEPSY AGE 14--HD"                format=f1.
      ER45153   LABEL="HEHC OTR RPT: EPILEPSY AGE 15--HD"                format=f1.
      ER45154   LABEL="HEHC OTR RPT: EPILEPSY AGE 16--HD"                format=f1.
      ER45155   LABEL="HEHC OTR RPT: EPILEPSY AGE 17+--HD"               format=f1.
      ER45156   LABEL="HEHC OTR RPT: AGE END EPILEPSY--HD"               format=f3.
      ER45157   LABEL="HEHC OTR RPT: HEADACHE B4 AGE 1--HD"              format=f1.
      ER45158   LABEL="HEHC OTR RPT: HEADACHE AGE 1--HD"                 format=f1.
      ER45159   LABEL="HEHC OTR RPT: HEADACHE AGE 2--HD"                 format=f1.
      ER45160   LABEL="HEHC OTR RPT: HEADACHE AGE 3--HD"                 format=f1.
      ER45161   LABEL="HEHC OTR RPT: HEADACHE AGE 4--HD"                 format=f1.
      ER45162   LABEL="HEHC OTR RPT: HEADACHE AGE 5--HD"                 format=f1.
      ER45163   LABEL="HEHC OTR RPT: HEADACHE AGE 6--HD"                 format=f1.
      ER45164   LABEL="HEHC OTR RPT: HEADACHE AGE 7--HD"                 format=f1.
      ER45165   LABEL="HEHC OTR RPT: HEADACHE AGE 8--HD"                 format=f1.
      ER45166   LABEL="HEHC OTR RPT: HEADACHE AGE 9--HD"                 format=f1.
      ER45167   LABEL="HEHC OTR RPT: HEADACHE AGE 10--HD"                format=f1.
      ER45168   LABEL="HEHC OTR RPT: HEADACHE AGE 11--HD"                format=f1.
      ER45169   LABEL="HEHC OTR RPT: HEADACHE AGE 12--HD"                format=f1.
      ER45170   LABEL="HEHC OTR RPT: HEADACHE AGE 13--HD"                format=f1.
      ER45171   LABEL="HEHC OTR RPT: HEADACHE AGE 14--HD"                format=f1.
      ER45172   LABEL="HEHC OTR RPT: HEADACHE AGE 15--HD"                format=f1.
      ER45173   LABEL="HEHC OTR RPT: HEADACHE AGE 16--HD"                format=f1.
      ER45174   LABEL="HEHC OTR RPT: HEADACHE AGE 17+--HD"               format=f1.
      ER45175   LABEL="HEHC OTR RPT: AGE END HEADACHE--HD"               format=f3.
      ER45176   LABEL="HEHC OTR RPT: STOM PROB B4 AGE 1--HD"             format=f1.
      ER45177   LABEL="HEHC OTR RPT: STOM PROB AGE 1--HD"                format=f1.
      ER45178   LABEL="HEHC OTR RPT: STOM PROB AGE 2--HD"                format=f1.
      ER45179   LABEL="HEHC OTR RPT: STOM PROB AGE 3--HD"                format=f1.
      ER45180   LABEL="HEHC OTR RPT: STOM PROB AGE 4--HD"                format=f1.
      ER45181   LABEL="HEHC OTR RPT: STOM PROB AGE 5--HD"                format=f1.
      ER45182   LABEL="HEHC OTR RPT: STOM PROB AGE 6--HD"                format=f1.
      ER45183   LABEL="HEHC OTR RPT: STOM PROB AGE 7--HD"                format=f1.
      ER45184   LABEL="HEHC OTR RPT: STOM PROB AGE 8--HD"                format=f1.
      ER45185   LABEL="HEHC OTR RPT: STOM PROB AGE 9--HD"                format=f1.
      ER45186   LABEL="HEHC OTR RPT: STOM PROB AGE 10--HD"               format=f1.
      ER45187   LABEL="HEHC OTR RPT: STOM PROB AGE 11--HD"               format=f1.
      ER45188   LABEL="HEHC OTR RPT: STOM PROB AGE 12--HD"               format=f1.
      ER45189   LABEL="HEHC OTR RPT: STOM PROB AGE 13--HD"               format=f1.
      ER45190   LABEL="HEHC OTR RPT: STOM PROB AGE 14--HD"               format=f1.
      ER45191   LABEL="HEHC OTR RPT: STOM PROB AGE 15--HD"               format=f1.
      ER45192   LABEL="HEHC OTR RPT: STOM PROB AGE 16--HD"               format=f1.
      ER45193   LABEL="HEHC OTR RPT: STOM PROB AGE 17+--HD"              format=f1.
      ER45194   LABEL="HEHC OTR RPT: AGE END STOM PROB--HD"              format=f3.
      ER45195   LABEL="HEHC OTR RPT: HGH BLOOD PR B4 AGE 1--HD"          format=f1.
      ER45196   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 1--HD"             format=f1.
      ER45197   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 2--HD"             format=f1.
      ER45198   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 3--HD"             format=f1.
      ER45199   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 4--HD"             format=f1.
      ER45200   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 5--HD"             format=f1.
      ER45201   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 6--HD"             format=f1.
      ER45202   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 7--HD"             format=f1.
      ER45203   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 8--HD"             format=f1.
      ER45204   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 9--HD"             format=f1.
      ER45205   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 10--HD"            format=f1.
      ER45206   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 11--HD"            format=f1.
      ER45207   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 12--HD"            format=f1.
      ER45208   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 13--HD"            format=f1.
      ER45209   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 14--HD"            format=f1.
      ER45210   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 15--HD"            format=f1.
      ER45211   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 16--HD"            format=f1.
      ER45212   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 17+--HD"           format=f1.
      ER45213   LABEL="HEHC OTR RPT: AGE END HGH BLD PR--HD"             format=f3.
      ER45214   LABEL="HEHC OTR RPT: DEPRESSION B4 AGE 1--HD"            format=f1.
      ER45215   LABEL="HEHC OTR RPT: DEPRESSION AGE 1--HD"               format=f1.
      ER45216   LABEL="HEHC OTR RPT: DEPRESSION AGE 2--HD"               format=f1.
      ER45217   LABEL="HEHC OTR RPT: DEPRESSION AGE 3--HD"               format=f1.
      ER45218   LABEL="HEHC OTR RPT: DEPRESSION AGE 4--HD"               format=f1.
      ER45219   LABEL="HEHC OTR RPT: DEPRESSION AGE 5--HD"               format=f1.
      ER45220   LABEL="HEHC OTR RPT: DEPRESSION AGE 6--HD"               format=f1.
      ER45221   LABEL="HEHC OTR RPT: DEPRESSION AGE 7--HD"               format=f1.
      ER45222   LABEL="HEHC OTR RPT: DEPRESSION AGE 8--HD"               format=f1.
      ER45223   LABEL="HEHC OTR RPT: DEPRESSION AGE 9--HD"               format=f1.
      ER45224   LABEL="HEHC OTR RPT: DEPRESSION AGE 10--HD"              format=f1.
      ER45225   LABEL="HEHC OTR RPT: DEPRESSION AGE 11--HD"              format=f1.
      ER45226   LABEL="HEHC OTR RPT: DEPRESSION AGE 12--HD"              format=f1.
      ER45227   LABEL="HEHC OTR RPT: DEPRESSION AGE 13--HD"              format=f1.
      ER45228   LABEL="HEHC OTR RPT: DEPRESSION AGE 14--HD"              format=f1.
      ER45229   LABEL="HEHC OTR RPT: DEPRESSION AGE 15--HD"              format=f1.
      ER45230   LABEL="HEHC OTR RPT: DEPRESSION AGE 16--HD"              format=f1.
      ER45231   LABEL="HEHC OTR RPT: DEPRESSION AGE 17+--HD"             format=f1.
      ER45232   LABEL="HEHC OTR RPT: AGE END DEPRESSION--HD"             format=f3.
      ER45233   LABEL="HEHC OTR RPT: DRUG/AL PROB B4 AGE 1--HD"          format=f1.
      ER45234   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 1--HD"             format=f1.
      ER45235   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 2--HD"             format=f1.
      ER45236   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 3--HD"             format=f1.
      ER45237   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 4--HD"             format=f1.
      ER45238   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 5--HD"             format=f1.
      ER45239   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 6--HD"             format=f1.
      ER45240   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 7--HD"             format=f1.
      ER45241   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 8--HD"             format=f1.
      ER45242   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 9--HD"             format=f1.
      ER45243   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 10--HD"            format=f1.
      ER45244   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 11--HD"            format=f1.
      ER45245   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 12--HD"            format=f1.
      ER45246   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 13--HD"            format=f1.
      ER45247   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 14--HD"            format=f1.
      ER45248   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 15--HD"            format=f1.
      ER45249   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 16--HD"            format=f1.
      ER45250   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 17+--HD"           format=f1.
      ER45251   LABEL="HEHC OTR RPT: AGE END DRUG/AL PROB--HD"           format=f3.
      ER45252   LABEL="HEHC OTR RPT: OTR PSYCH PROB B4 AGE 1--H"         format=f1.
      ER45253   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 1--HD"           format=f1.
      ER45254   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 2--HD"           format=f1.
      ER45255   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 3--HD"           format=f1.
      ER45256   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 4--HD"           format=f1.
      ER45257   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 5--HD"           format=f1.
      ER45258   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 6--HD"           format=f1.
      ER45259   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 7--HD"           format=f1.
      ER45260   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 8--HD"           format=f1.
      ER45261   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 9--HD"           format=f1.
      ER45262   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 10--HD"          format=f1.
      ER45263   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 11--HD"          format=f1.
      ER45264   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 12--HD"          format=f1.
      ER45265   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 13--HD"          format=f1.
      ER45266   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 14--HD"          format=f1.
      ER45267   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 15--HD"          format=f1.
      ER45268   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 16--HD"          format=f1.
      ER45269   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 17+--HD"         format=f1.
      ER45270   LABEL="HEHC OTR RPT: AGE END OTR PSYCH PROB--HD"         format=f3.
      ER45271   LABEL="H24 WTR WIFE IN FU NOW"                           format=f1.
      ER45272   LABEL="H1 HEALTH STATUS-WIFE"                            format=f1.
      ER45273   LABEL="H1A WTR HLTH BETTER/WORSE-WIFE"                   format=f1.
      ER45274   LABEL="H1B WTR  HEALTH BETTER-WIFE"                      format=f1.
      ER45275   LABEL="H1C WTR HEALTH WORSE-WIFE"                        format=f1.
      ER45276   LABEL="H2 WTR TYPE/AMT WORK LIMITED-WIFE"                format=f1.
      ER45277   LABEL="H3 WTR UNABLE TO DO SOME TYPES WORK-WF"           format=f1.
      ER45278   LABEL="H4 WTR LIMIT AMT WORK CAN DO-WIFE"                format=f1.
      ER45279   LABEL="H5A WTR HAD STROKE-WIFE"                          format=f1.
      ER45280   LABEL="H6A1 AGE AT FIRST STROKE-WIFE"                    format=f3.
      ER45281   LABEL="H6A2 WTR SECOND STROKE-WIFE"                      format=f1.
      ER45282   LABEL="H7A WTR STROKE LIMIT DAILY ACTIVITY-WF"           format=f1.
      ER45283   LABEL="H5B WTR HEART ATTACK-WIFE"                        format=f1.
      ER45284   LABEL="H6B1 AGE AT FIRST HEART ATTACK-WF"                format=f3.
      ER45285   LABEL="H6B2 WTR SECOND HEART ATTACK-WF"                  format=f1.
      ER45286   LABEL="H7B WTR HRT ATTACK LIMIT ACTIVITY-WF"             format=f1.
      ER45287   LABEL="H5C WTR HEART DISEASE-WIFE"                       format=f1.
      ER45288   LABEL="H6C1 AGE FIRST HAD HEART DISEASE-WF"              format=f3.
      ER45289   LABEL="H6C2 WTR HRT DISEASE GOT WORSE-WF"                format=f1.
      ER45290   LABEL="H7C WTR HRT DISEASE LIMIT ACTIVITY-WF"            format=f1.
      ER45291   LABEL="H5D WTR HYPERTENSION-WIFE"                        format=f1.
      ER45292   LABEL="H6D1 AGE FIRST HAD HYPERTENSION-WF"               format=f3.
      ER45293   LABEL="H6D2 WTR HYPERTENSION GOT WORSE-WF"               format=f1.
      ER45294   LABEL="H7D WTR HYPERTENSION LIMIT ACTIVITY-WF"           format=f1.
      ER45295   LABEL="H5E WTR ASTHMA-WIFE"                              format=f1.
      ER45296   LABEL="H6E1 AGE FIRST HAD ASTHMA-WIFE"                   format=f3.
      ER45297   LABEL="H6E2 WTR ASTHMA GOT WORSE-WIFE"                   format=f1.
      ER45298   LABEL="H7E WTR ASTHMA LIMIT DAILY ACTIVITY-WF"           format=f1.
      ER45299   LABEL="H5F WTR LUNG DISEASE-WIFE"                        format=f1.
      ER45300   LABEL="H6F1 AGE FIRST HAD LUNG DISEASE-WF"               format=f3.
      ER45301   LABEL="H6F2 WTR LUNG DISEASE GOT WORSE-WF"               format=f1.
      ER45302   LABEL="H7F WTR LUNG DISEASE LIMIT ACTIVITY-WF"           format=f1.
      ER45303   LABEL="H5G WTR DIABETES-WIFE"                            format=f1.
      ER45304   LABEL="H6G1 AGE FIRST HAD DIABETES-WIFE"                 format=f3.
      ER45305   LABEL="H6G2 WTR DIABETES GOT WORSE-WIFE"                 format=f1.
      ER45306   LABEL="H7G WTR DIABETES LIMIT ACTIVITY-WF"               format=f1.
      ER45307   LABEL="H5H WTR ARTHRITIS-WIFE"                           format=f1.
      ER45308   LABEL="H6H1 AGE FIRST HAD ARTHRITIS-WIFE"                format=f3.
      ER45309   LABEL="H6H2 WTR ARTHRITIS GOT WORSE-WIFE"                format=f1.
      ER45310   LABEL="H7H WTR ARTHRITIS LIMIT ACTIVITY-WF"              format=f1.
      ER45311   LABEL="H5I WTR MENTAL LOSS-WIFE"                         format=f1.
      ER45312   LABEL="H6I1 AGE FIRST HAD MEMORY LOSS-WF"                format=f3.
      ER45313   LABEL="H6I2 WTR MEMORY LOSS GOT WORSE-WF"                format=f1.
      ER45314   LABEL="H7I WTR MEMORY LOSS LIMIT ACTIVITY-WF"            format=f1.
      ER45315   LABEL="H5J WTR LEARNING DISORDER-WIFE"                   format=f1.
      ER45316   LABEL="H6J1 AGE FIRST HAD LRNG DISORDER-WF"              format=f3.
      ER45317   LABEL="H6J2 WTR LRNG DISORDER GOT WORSE-WF"              format=f1.
      ER45318   LABEL="H7J WTR LRNG DISORDR LIMIT ACTIVITY-WF"           format=f1.
      ER45319   LABEL="H5K WTR CANCER-WIFE"                              format=f1.
      ER45320   LABEL="H6K1 AGE FIRST HAD CANCER-WIFE"                   format=f3.
      ER45321   LABEL="H6K2 WTR CANCER GOT WORSE-WIFE"                   format=f1.
      ER45322   LABEL="H6K3 WTR TREATING, RMSSN, OR CURED-WF"            format=f1.
      ER45323   LABEL="H6K4 TYPE OF CANCER MENTION 1-WIFE"               format=f2.
      ER45324   LABEL="H6K4 TYPE OF CANCER MENTION 2-WIFE"               format=f2.
      ER45325   LABEL="H7K WTR CANCER LIMIT ACTIVITY-WIFE"               format=f1.
      ER45326   LABEL="H5L WTR PSYCH PROBLEM-WIFE"                       format=f1.
      ER45327   LABEL="H6L1 AGE FIRST HAD PSYCH PROB-WIFE"               format=f3.
      ER45328   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 1-WF"             format=f2.
      ER45329   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 2-WF"             format=f2.
      ER45330   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 3-WF"             format=f2.
      ER45331   LABEL="H6L3 WTR PSYCH PROB GOT WORSE-WF"                 format=f1.
      ER45332   LABEL="H7L WTR PSYCH PROB LIMIT ACTIVITY-WF"             format=f1.
      ER45333   LABEL="H5M WTR OTR CHRONIC CONDITION-WF"                 format=f1.
      ER45334   LABEL="H6M2 AGE FIRST HAD CHRON COND-WIFE"               format=f3.
      ER45335   LABEL="H6M3 WTR CHRON COND GOT WORSE-WF"                 format=f1.
      ER45336   LABEL="H7M WTR CHRON COND LIMIT ACTIVITY-WF"             format=f1.
      ER45337   LABEL="H8 WTR HOSPITALIZED IN 2004-WIFE"                 format=f1.
      ER45338   LABEL="H8A # NIGHTS HOSPITALIZED-WIFE"                   format=f3.
      ER45339   LABEL="H8A # WEEKS HOSPITALIZED-WIFE"                    format=f2.
      ER45340   LABEL="H9A WTR PROBLEM BATHING-WIFE"                     format=f1.
      ER45341   LABEL="H10A1 WTR SOMEONE HELPS BATHE-WF"                 format=f1.
      ER45342   LABEL="H10A2 WTR NEED EQUIP TO BATHE-WF"                 format=f1.
      ER45343   LABEL="H9B WTR PROBLEM DRESSING-WIFE"                    format=f1.
      ER45344   LABEL="H10B1 WTR SOMEONE HELPS DRESS-WF"                 format=f1.
      ER45345   LABEL="H10B2 WTR NEED EQUIP TO DRESS-WF"                 format=f1.
      ER45346   LABEL="H9C WTR PROBLEM EATING-WIFE"                      format=f1.
      ER45347   LABEL="H10C1 WTR SOMEONE HELPS EATNG-WF"                 format=f1.
      ER45348   LABEL="H10C2 WTR NEED EQUIP TO EAT-WF"                   format=f1.
      ER45349   LABEL="H9D WTR PROB GET IN/OUT BED/CHAIR-WF"             format=f1.
      ER45350   LABEL="H10D1 WTR SOMEONE HELPS BED/CHAIR-WF"             format=f1.
      ER45351   LABEL="H10D2 WTR NEED EQUIP FOR BED/CHAIR-WF"            format=f1.
      ER45352   LABEL="H9E WTR PROBLEM WALKING-WIFE"                     format=f1.
      ER45353   LABEL="H10E1 WTR SOMEONE HELPS WALK-WF"                  format=f1.
      ER45354   LABEL="H10E2 WTR NEED EQUIP TO WALK-WF"                  format=f1.
      ER45355   LABEL="H9F WTR PROBLEM GETTING OUTSIDE-WF"               format=f1.
      ER45356   LABEL="H10F1 WTR SOMEONE HELPS GET OUT-WF"               format=f1.
      ER45357   LABEL="H10F2 WTR NEED EQUIP TO GO OUTSIDE-WF"            format=f1.
      ER45358   LABEL="H9G WTR PROBLEM USE TOILET-WF"                    format=f1.
      ER45359   LABEL="H10G1 WTR SOMEONE HELPS TOILET-WF"                format=f1.
      ER45360   LABEL="H10G2 WTR NEED EQUIP TO USE TOILET-WF"            format=f1.
      ER45361   LABEL="H11A WTR DIFFICULT PREPARE MEALS-WF"              format=f1.
      ER45362   LABEL="H11B HEALTH/PHYSICAL PROBLEM?-WF"                 format=f1.
      ER45363   LABEL="H11C WTR DIFFICULT SHOPPING-WF"                   format=f1.
      ER45364   LABEL="H11D HEALTH/PHYSICAL PROBLEM?-WF"                 format=f1.
      ER45365   LABEL="H11E WTR DIFFICULT MANAGE MONEY-WF"               format=f1.
      ER45366   LABEL="H11F HEALTH/PHYSICAL PROBLEM?-WF"                 format=f1.
      ER45367   LABEL="H11G WTR TELEPHONE DIFFICULT-WF"                  format=f1.
      ER45368   LABEL="H11H HEALTH/PHYSICAL PROBLEM?-WF"                 format=f1.
      ER45369   LABEL="H11J WTR HEAVY HSWRK DIFFICULT-WF"                format=f1.
      ER45370   LABEL="H11K HEALTH/PHYSICAL PROBLEM?-WF"                 format=f1.
      ER45371   LABEL="H11L WTR LIGHT HSWRK DIFFICULT-WF"                format=f1.
      ER45372   LABEL="H11M HEALTH/PHYSICAL PROBLEM?-WF"                 format=f1.
      ER45373   LABEL="H12A FREQ OF HVY PHYSICAL ACTIVITY-WF"            format=f3.
      ER45374   LABEL="H12A TIME UNIT FOR HVY PHYS ACTIVITY-WF"          format=f1.
      ER45375   LABEL="H12B FREQ OF LITE PHYSICAL ACTIVITY-WF"           format=f3.
      ER45376   LABEL="H12B TIME UNIT FOR LITE PHYS ACTIVITY-WF"         format=f1.
      ER45377   LABEL="H12C FREQ OF STRENGTH PHYS ACTIVITY-WF"           format=f3.
      ER45378   LABEL="H12C TIME UNIT STRNGTH PHYS ACTVTY-WF"            format=f1.
      ER45379   LABEL="H13 WTR SMOKE CIGARETTES-WF"                      format=f1.
      ER45380   LABEL="H14 # CIGARETTES PER DAY-WF"                      format=f3.
      ER45381   LABEL="H15AGE WHEN FIRST SMOKED-WF"                      format=f2.
      ER45382   LABEL="H16 WTR EVER SMOKED CIGARETTES-WF"                format=f1.
      ER45383   LABEL="H17 # CIGARETTES PER DAY-WF"                      format=f3.
      ER45384   LABEL="H18 AGE LAST SMOKED REGULARLY-WF"                 format=f2.
      ER45385   LABEL="H19 AGE FIRST SMOKED REGULARLY-WF"                format=f2.
      ER45386   LABEL="H20 WTR DRINK ALCOHOL-WIFE"                       format=f1.
      ER45387   LABEL="H21A HOW OFTEN HAVE DRINKS-WF"                    format=f1.
      ER45388   LABEL="H21B # ALCOHOLIC DRINKS PER DAY-WF"               format=f2.
      ER45389   LABEL="H21C # DAYS HAD 4-5 DRINKS-WIFE"                  format=f3.
      ER45390   LABEL="H22 WEIGHT--WIFE"                                 format=f3.
      ER45391   LABEL="H23 HEIGHT-FEET--WIFE"                            format=f1.
      ER45392   LABEL="H23 HEIGHT-INCHES--WIFE"                          format=f2.
      ER45393   LABEL="H25W HEALTH STATUS B4 AGE 17--WF"                 format=f1.
      ER45394   LABEL="H26W WTR MISSED MO OR MORE SCHOOL--WF"            format=f1.
      ER45395   LABEL="H27W WTR MEASLES B4 AGE 17--WF"                   format=f1.
      ER45396   LABEL="H28W WTR MUMPS B4 AGE 17--WF"                     format=f1.
      ER45397   LABEL="H29W WTR CHICKEN POX B4 AGE 17--WF"               format=f1.
      ER45398   LABEL="H30W WTR DIFF SEEING B4 AGE 17--WF"               format=f1.
      ER45399   LABEL="H31W PARENTS SMOKED B4 WF AGE 17?--WF"            format=f1.
      ER45400   LABEL="H32W WTR ASTHMA B4 AGE 17--WF"                    format=f1.
      ER45401   LABEL="H33W WTR DIABETES B4 AGE 17--WF"                  format=f1.
      ER45402   LABEL="H34W WTR RESP DIS B4 AGE 17--WF"                  format=f1.
      ER45403   LABEL="H35W WTR SPCH IMPAIR B4 AGE 17--WF"               format=f1.
      ER45404   LABEL="H36W WTR ALLERGY B4 AGE 17--WF"                   format=f1.
      ER45405   LABEL="H37W WTR HEART TRBL B4 AGE 17--WF"                format=f1.
      ER45406   LABEL="H38W WTR EAR PROB B4 AGE 17--WF"                  format=f1.
      ER45407   LABEL="H39W WTR EPILEPSY B4 AGE 17--WF"                  format=f1.
      ER45408   LABEL="H40W WTR HEADACHE B4 AGE 17--WF"                  format=f1.
      ER45409   LABEL="H41W WTR STOM PROB B4 AGE 17--WF"                 format=f1.
      ER45410   LABEL="H42W WTR HGH BLOOD PR B4 AGE 17--WF"              format=f1.
      ER45411   LABEL="H43W WTR DEPRESSION B4 AGE 17--WF"                format=f1.
      ER45412   LABEL="H44W WTR DRUG/AL PROB B4 AGE 17--WF"              format=f1.
      ER45413   LABEL="H45W WTR OTR PSYCW PROB B4 AGE 17--WF"            format=f1.
      ER45414   LABEL="HEHC SLF RPT: YEAR 1ST REPORT--WF"                format=f4.
      ER45415   LABEL="HEHC SLF RPT: PAR SEP B4 AGE 1--WF"               format=f1.
      ER45416   LABEL="HEHC SLF RPT: PAR SEP AGE 1--WF"                  format=f1.
      ER45417   LABEL="HEHC SLF RPT: PAR SEP AGE 2--WF"                  format=f1.
      ER45418   LABEL="HEHC SLF RPT: PAR SEP AGE 3--WF"                  format=f1.
      ER45419   LABEL="HEHC SLF RPT: PAR SEP AGE 4--WF"                  format=f1.
      ER45420   LABEL="HEHC SLF RPT: PAR SEP AGE 5--WF"                  format=f1.
      ER45421   LABEL="HEHC SLF RPT: PAR SEP AGE 6--WF"                  format=f1.
      ER45422   LABEL="HEHC SLF RPT: PAR SEP AGE 7--WF"                  format=f1.
      ER45423   LABEL="HEHC SLF RPT: PAR SEP AGE 8--WF"                  format=f1.
      ER45424   LABEL="HEHC SLF RPT: PAR SEP AGE 9--WF"                  format=f1.
      ER45425   LABEL="HEHC SLF RPT: PAR SEP AGE 10--WF"                 format=f1.
      ER45426   LABEL="HEHC SLF RPT: PAR SEP AGE 11--WF"                 format=f1.
      ER45427   LABEL="HEHC SLF RPT: PAR SEP AGE 12--WF"                 format=f1.
      ER45428   LABEL="HEHC SLF RPT: PAR SEP AGE 13--WF"                 format=f1.
      ER45429   LABEL="HEHC SLF RPT: PAR SEP AGE 14--WF"                 format=f1.
      ER45430   LABEL="HEHC SLF RPT: PAR SEP AGE 15--WF"                 format=f1.
      ER45431   LABEL="HEHC SLF RPT: PAR SEP AGE 16--WF"                 format=f1.
      ER45432   LABEL="HEHC SLF RPT: MOVE B4 AGE 1--WF"                  format=f1.
      ER45433   LABEL="HEHC SLF RPT: MOVE AGE 1--WF"                     format=f1.
      ER45434   LABEL="HEHC SLF RPT: MOVE AGE 2--WF"                     format=f1.
      ER45435   LABEL="HEHC SLF RPT: MOVE AGE 3--WF"                     format=f1.
      ER45436   LABEL="HEHC SLF RPT: MOVE AGE 4--WF"                     format=f1.
      ER45437   LABEL="HEHC SLF RPT: MOVE AGE 5--WF"                     format=f1.
      ER45438   LABEL="HEHC SLF RPT: MOVE AGE 6--WF"                     format=f1.
      ER45439   LABEL="HEHC SLF RPT: MOVE AGE 7--WF"                     format=f1.
      ER45440   LABEL="HEHC SLF RPT: MOVE AGE 8--WF"                     format=f1.
      ER45441   LABEL="HEHC SLF RPT: MOVE AGE 9--WF"                     format=f1.
      ER45442   LABEL="HEHC SLF RPT: MOVE AGE 10--WF"                    format=f1.
      ER45443   LABEL="HEHC SLF RPT: MOVE AGE 11--WF"                    format=f1.
      ER45444   LABEL="HEHC SLF RPT: MOVE AGE 12--WF"                    format=f1.
      ER45445   LABEL="HEHC SLF RPT: MOVE AGE 13--WF"                    format=f1.
      ER45446   LABEL="HEHC SLF RPT: MOVE AGE 14--WF"                    format=f1.
      ER45447   LABEL="HEHC SLF RPT: MOVE AGE 15--WF"                    format=f1.
      ER45448   LABEL="HEHC SLF RPT: MOVE AGE 16--WF"                    format=f1.
      ER45449   LABEL="HEHC SLF RPT: SCHOOL B4 AGE 1--WF"                format=f1.
      ER45450   LABEL="HEHC SLF RPT: SCHOOL AGE 1--WF"                   format=f1.
      ER45451   LABEL="HEHC SLF RPT: SCHOOL AGE 2--WF"                   format=f1.
      ER45452   LABEL="HEHC SLF RPT: SCHOOL AGE 3--WF"                   format=f1.
      ER45453   LABEL="HEHC SLF RPT: SCHOOL AGE 4--WF"                   format=f1.
      ER45454   LABEL="HEHC SLF RPT: SCHOOL AGE 5--WF"                   format=f1.
      ER45455   LABEL="HEHC SLF RPT: SCHOOL AGE 6--WF"                   format=f1.
      ER45456   LABEL="HEHC SLF RPT: SCHOOL AGE 7--WF"                   format=f1.
      ER45457   LABEL="HEHC SLF RPT: SCHOOL AGE 8--WF"                   format=f1.
      ER45458   LABEL="HEHC SLF RPT: SCHOOL AGE 9--WF"                   format=f1.
      ER45459   LABEL="HEHC SLF RPT: SCHOOL AGE 10--WF"                  format=f1.
      ER45460   LABEL="HEHC SLF RPT: SCHOOL AGE 11--WF"                  format=f1.
      ER45461   LABEL="HEHC SLF RPT: SCHOOL AGE 12--WF"                  format=f1.
      ER45462   LABEL="HEHC SLF RPT: SCHOOL AGE 13--WF"                  format=f1.
      ER45463   LABEL="HEHC SLF RPT: SCHOOL AGE 14--WF"                  format=f1.
      ER45464   LABEL="HEHC SLF RPT: SCHOOL AGE 15--WF"                  format=f1.
      ER45465   LABEL="HEHC SLF RPT: SCHOOL AGE 16--WF"                  format=f1.
      ER45466   LABEL="HEHC SLF RPT: ASTHMA B4 AGE 1--WF"                format=f1.
      ER45467   LABEL="HEHC SLF RPT: ASTHMA AGE 1--WF"                   format=f1.
      ER45468   LABEL="HEHC SLF RPT: ASTHMA AGE 2--WF"                   format=f1.
      ER45469   LABEL="HEHC SLF RPT: ASTHMA AGE 3--WF"                   format=f1.
      ER45470   LABEL="HEHC SLF RPT: ASTHMA AGE 4--WF"                   format=f1.
      ER45471   LABEL="HEHC SLF RPT: ASTHMA AGE 5--WF"                   format=f1.
      ER45472   LABEL="HEHC SLF RPT: ASTHMA AGE 6--WF"                   format=f1.
      ER45473   LABEL="HEHC SLF RPT: ASTHMA AGE 7--WF"                   format=f1.
      ER45474   LABEL="HEHC SLF RPT: ASTHMA AGE 8--WF"                   format=f1.
      ER45475   LABEL="HEHC SLF RPT: ASTHMA AGE 9--WF"                   format=f1.
      ER45476   LABEL="HEHC SLF RPT: ASTHMA AGE 10--WF"                  format=f1.
      ER45477   LABEL="HEHC SLF RPT: ASTHMA AGE 11--WF"                  format=f1.
      ER45478   LABEL="HEHC SLF RPT: ASTHMA AGE 12--WF"                  format=f1.
      ER45479   LABEL="HEHC SLF RPT: ASTHMA AGE 13--WF"                  format=f1.
      ER45480   LABEL="HEHC SLF RPT: ASTHMA AGE 14--WF"                  format=f1.
      ER45481   LABEL="HEHC SLF RPT: ASTHMA AGE 15--WF"                  format=f1.
      ER45482   LABEL="HEHC SLF RPT: ASTHMA AGE 16--WF"                  format=f1.
      ER45483   LABEL="HEHC SLF RPT: ASTHMA AGE 17+--WF"                 format=f1.
      ER45484   LABEL="HEHC SLF RPT: AGE END ASTHMA--WF"                 format=f3.
      ER45485   LABEL="HEHC SLF RPT: DIABETES B4 AGE 1--WF"              format=f1.
      ER45486   LABEL="HEHC SLF RPT: DIABETES AGE 1--WF"                 format=f1.
      ER45487   LABEL="HEHC SLF RPT: DIABETES AGE 2--WF"                 format=f1.
      ER45488   LABEL="HEHC SLF RPT: DIABETES AGE 3--WF"                 format=f1.
      ER45489   LABEL="HEHC SLF RPT: DIABETES AGE 4--WF"                 format=f1.
      ER45490   LABEL="HEHC SLF RPT: DIABETES AGE 5--WF"                 format=f1.
      ER45491   LABEL="HEHC SLF RPT: DIABETES AGE 6--WF"                 format=f1.
      ER45492   LABEL="HEHC SLF RPT: DIABETES AGE 7--WF"                 format=f1.
      ER45493   LABEL="HEHC SLF RPT: DIABETES AGE 8--WF"                 format=f1.
      ER45494   LABEL="HEHC SLF RPT: DIABETES AGE 9--WF"                 format=f1.
      ER45495   LABEL="HEHC SLF RPT: DIABETES AGE 10--WF"                format=f1.
      ER45496   LABEL="HEHC SLF RPT: DIABETES AGE 11--WF"                format=f1.
      ER45497   LABEL="HEHC SLF RPT: DIABETES AGE 12--WF"                format=f1.
      ER45498   LABEL="HEHC SLF RPT: DIABETES AGE 13--WF"                format=f1.
      ER45499   LABEL="HEHC SLF RPT: DIABETES AGE 14--WF"                format=f1.
      ER45500   LABEL="HEHC SLF RPT: DIABETES AGE 15--WF"                format=f1.
      ER45501   LABEL="HEHC SLF RPT: DIABETES AGE 16--WF"                format=f1.
      ER45502   LABEL="HEHC SLF RPT: DIABETES AGE 17+--WF"               format=f1.
      ER45503   LABEL="HEHC SLF RPT: AGE END DIABETES--WF"               format=f3.
      ER45504   LABEL="HEHC SLF RPT: RESP DIS B4 AGE 1--WF"              format=f1.
      ER45505   LABEL="HEHC SLF RPT: RESP DIS AGE 1--WF"                 format=f1.
      ER45506   LABEL="HEHC SLF RPT: RESP DIS AGE 2--WF"                 format=f1.
      ER45507   LABEL="HEHC SLF RPT: RESP DIS AGE 3--WF"                 format=f1.
      ER45508   LABEL="HEHC SLF RPT: RESP DIS AGE 4--WF"                 format=f1.
      ER45509   LABEL="HEHC SLF RPT: RESP DIS AGE 5--WF"                 format=f1.
      ER45510   LABEL="HEHC SLF RPT: RESP DIS AGE 6--WF"                 format=f1.
      ER45511   LABEL="HEHC SLF RPT: RESP DIS AGE 7--WF"                 format=f1.
      ER45512   LABEL="HEHC SLF RPT: RESP DIS AGE 8--WF"                 format=f1.
      ER45513   LABEL="HEHC SLF RPT: RESP DIS AGE 9--WF"                 format=f1.
      ER45514   LABEL="HEHC SLF RPT: RESP DIS AGE 10--WF"                format=f1.
      ER45515   LABEL="HEHC SLF RPT: RESP DIS AGE 11--WF"                format=f1.
      ER45516   LABEL="HEHC SLF RPT: RESP DIS AGE 12--WF"                format=f1.
      ER45517   LABEL="HEHC SLF RPT: RESP DIS AGE 13--WF"                format=f1.
      ER45518   LABEL="HEHC SLF RPT: RESP DIS AGE 14--WF"                format=f1.
      ER45519   LABEL="HEHC SLF RPT: RESP DIS AGE 15--WF"                format=f1.
      ER45520   LABEL="HEHC SLF RPT: RESP DIS AGE 16--WF"                format=f1.
      ER45521   LABEL="HEHC SLF RPT: RESP DIS AGE 17+--WF"               format=f1.
      ER45522   LABEL="HEHC SLF RPT: AGE END RESP DIS--WF"               format=f3.
      ER45523   LABEL="HEHC SLF RPT: SPCH IMPAIR B4 AGE 1--WF"           format=f1.
      ER45524   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 1--WF"              format=f1.
      ER45525   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 2--WF"              format=f1.
      ER45526   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 3--WF"              format=f1.
      ER45527   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 4--WF"              format=f1.
      ER45528   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 5--WF"              format=f1.
      ER45529   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 6--WF"              format=f1.
      ER45530   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 7--WF"              format=f1.
      ER45531   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 8--WF"              format=f1.
      ER45532   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 9--WF"              format=f1.
      ER45533   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 10--WF"             format=f1.
      ER45534   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 11--WF"             format=f1.
      ER45535   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 12--WF"             format=f1.
      ER45536   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 13--WF"             format=f1.
      ER45537   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 14--WF"             format=f1.
      ER45538   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 15--WF"             format=f1.
      ER45539   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 16--WF"             format=f1.
      ER45540   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 17+--WF"            format=f1.
      ER45541   LABEL="HEHC SLF RPT: AGE END SPCH IMPAIR--WF"            format=f3.
      ER45542   LABEL="HEHC SLF RPT: ALLERGY B4 AGE 1--WF"               format=f1.
      ER45543   LABEL="HEHC SLF RPT: ALLERGY AGE 1--WF"                  format=f1.
      ER45544   LABEL="HEHC SLF RPT: ALLERGY AGE 2--WF"                  format=f1.
      ER45545   LABEL="HEHC SLF RPT: ALLERGY AGE 3--WF"                  format=f1.
      ER45546   LABEL="HEHC SLF RPT: ALLERGY AGE 4--WF"                  format=f1.
      ER45547   LABEL="HEHC SLF RPT: ALLERGY AGE 5--WF"                  format=f1.
      ER45548   LABEL="HEHC SLF RPT: ALLERGY AGE 6--WF"                  format=f1.
      ER45549   LABEL="HEHC SLF RPT: ALLERGY AGE 7--WF"                  format=f1.
      ER45550   LABEL="HEHC SLF RPT: ALLERGY AGE 8--WF"                  format=f1.
      ER45551   LABEL="HEHC SLF RPT: ALLERGY AGE 9--WF"                  format=f1.
      ER45552   LABEL="HEHC SLF RPT: ALLERGY AGE 10--WF"                 format=f1.
      ER45553   LABEL="HEHC SLF RPT: ALLERGY AGE 11--WF"                 format=f1.
      ER45554   LABEL="HEHC SLF RPT: ALLERGY AGE 12--WF"                 format=f1.
      ER45555   LABEL="HEHC SLF RPT: ALLERGY AGE 13--WF"                 format=f1.
      ER45556   LABEL="HEHC SLF RPT: ALLERGY AGE 14--WF"                 format=f1.
      ER45557   LABEL="HEHC SLF RPT: ALLERGY AGE 15--WF"                 format=f1.
      ER45558   LABEL="HEHC SLF RPT: ALLERGY AGE 16--WF"                 format=f1.
      ER45559   LABEL="HEHC SLF RPT: ALLERGY AGE 17+--WF"                format=f1.
      ER45560   LABEL="HEHC SLF RPT: AGE END ALLERGY--WF"                format=f3.
      ER45561   LABEL="HEHC SLF RPT: HEART TRBL B4 AGE 1--WF"            format=f1.
      ER45562   LABEL="HEHC SLF RPT: HEART TRBL AGE 1--WF"               format=f1.
      ER45563   LABEL="HEHC SLF RPT: HEART TRBL AGE 2--WF"               format=f1.
      ER45564   LABEL="HEHC SLF RPT: HEART TRBL AGE 3--WF"               format=f1.
      ER45565   LABEL="HEHC SLF RPT: HEART TRBL AGE 4--WF"               format=f1.
      ER45566   LABEL="HEHC SLF RPT: HEART TRBL AGE 5--WF"               format=f1.
      ER45567   LABEL="HEHC SLF RPT: HEART TRBL AGE 6--WF"               format=f1.
      ER45568   LABEL="HEHC SLF RPT: HEART TRBL AGE 7--WF"               format=f1.
      ER45569   LABEL="HEHC SLF RPT: HEART TRBL AGE 8--WF"               format=f1.
      ER45570   LABEL="HEHC SLF RPT: HEART TRBL AGE 9--WF"               format=f1.
      ER45571   LABEL="HEHC SLF RPT: HEART TRBL AGE 10--WF"              format=f1.
      ER45572   LABEL="HEHC SLF RPT: HEART TRBL AGE 11--WF"              format=f1.
      ER45573   LABEL="HEHC SLF RPT: HEART TRBL AGE 12--WF"              format=f1.
      ER45574   LABEL="HEHC SLF RPT: HEART TRBL AGE 13--WF"              format=f1.
      ER45575   LABEL="HEHC SLF RPT: HEART TRBL AGE 14--WF"              format=f1.
      ER45576   LABEL="HEHC SLF RPT: HEART TRBL AGE 15--WF"              format=f1.
      ER45577   LABEL="HEHC SLF RPT: HEART TRBL AGE 16--WF"              format=f1.
      ER45578   LABEL="HEHC SLF RPT: HEART TRBL AGE 17+--WF"             format=f1.
      ER45579   LABEL="HEHC SLF RPT: AGE END HEART TRBL--WF"             format=f3.
      ER45580   LABEL="HEHC SLF RPT: EAR PROBS B4 AGE 1--WF"             format=f1.
      ER45581   LABEL="HEHC SLF RPT: EAR PROBS AGE 1--WF"                format=f1.
      ER45582   LABEL="HEHC SLF RPT: EAR PROBS AGE 2--WF"                format=f1.
      ER45583   LABEL="HEHC SLF RPT: EAR PROBS AGE 3--WF"                format=f1.
      ER45584   LABEL="HEHC SLF RPT: EAR PROBS AGE 4--WF"                format=f1.
      ER45585   LABEL="HEHC SLF RPT: EAR PROBS AGE 5--WF"                format=f1.
      ER45586   LABEL="HEHC SLF RPT: EAR PROBS AGE 6--WF"                format=f1.
      ER45587   LABEL="HEHC SLF RPT: EAR PROBS AGE 7--WF"                format=f1.
      ER45588   LABEL="HEHC SLF RPT: EAR PROBS AGE 8--WF"                format=f1.
      ER45589   LABEL="HEHC SLF RPT: EAR PROBS AGE 9--WF"                format=f1.
      ER45590   LABEL="HEHC SLF RPT: EAR PROBS AGE 10--WF"               format=f1.
      ER45591   LABEL="HEHC SLF RPT: EAR PROBS AGE 11--WF"               format=f1.
      ER45592   LABEL="HEHC SLF RPT: EAR PROBS AGE 12--WF"               format=f1.
      ER45593   LABEL="HEHC SLF RPT: EAR PROBS AGE 13--WF"               format=f1.
      ER45594   LABEL="HEHC SLF RPT: EAR PROBS AGE 14--WF"               format=f1.
      ER45595   LABEL="HEHC SLF RPT: EAR PROBS AGE 15--WF"               format=f1.
      ER45596   LABEL="HEHC SLF RPT: EAR PROBS AGE 16--WF"               format=f1.
      ER45597   LABEL="HEHC SLF RPT: EAR PROBS AGE 17+--WF"              format=f1.
      ER45598   LABEL="HEHC SLF RPT: AGE END EAR PROBS--WF"              format=f3.
      ER45599   LABEL="HEHC SLF RPT: EPILEPSY B4 AGE 1--WF"              format=f1.
      ER45600   LABEL="HEHC SLF RPT: EPILEPSY AGE 1--WF"                 format=f1.
      ER45601   LABEL="HEHC SLF RPT: EPILEPSY AGE 2--WF"                 format=f1.
      ER45602   LABEL="HEHC SLF RPT: EPILEPSY AGE 3--WF"                 format=f1.
      ER45603   LABEL="HEHC SLF RPT: EPILEPSY AGE 4--WF"                 format=f1.
      ER45604   LABEL="HEHC SLF RPT: EPILEPSY AGE 5--WF"                 format=f1.
      ER45605   LABEL="HEHC SLF RPT: EPILEPSY AGE 6--WF"                 format=f1.
      ER45606   LABEL="HEHC SLF RPT: EPILEPSY AGE 7--WF"                 format=f1.
      ER45607   LABEL="HEHC SLF RPT: EPILEPSY AGE 8--WF"                 format=f1.
      ER45608   LABEL="HEHC SLF RPT: EPILEPSY AGE 9--WF"                 format=f1.
      ER45609   LABEL="HEHC SLF RPT: EPILEPSY AGE 10--WF"                format=f1.
      ER45610   LABEL="HEHC SLF RPT: EPILEPSY AGE 11--WF"                format=f1.
      ER45611   LABEL="HEHC SLF RPT: EPILEPSY AGE 12--WF"                format=f1.
      ER45612   LABEL="HEHC SLF RPT: EPILEPSY AGE 13--WF"                format=f1.
      ER45613   LABEL="HEHC SLF RPT: EPILEPSY AGE 14--WF"                format=f1.
      ER45614   LABEL="HEHC SLF RPT: EPILEPSY AGE 15--WF"                format=f1.
      ER45615   LABEL="HEHC SLF RPT: EPILEPSY AGE 16--WF"                format=f1.
      ER45616   LABEL="HEHC SLF RPT: EPILEPSY AGE 17+--WF"               format=f1.
      ER45617   LABEL="HEHC SLF RPT: AGE END EPILEPSY--WF"               format=f3.
      ER45618   LABEL="HEHC SLF RPT: HEADACHE B4 AGE 1--WF"              format=f1.
      ER45619   LABEL="HEHC SLF RPT: HEADACHE AGE 1--WF"                 format=f1.
      ER45620   LABEL="HEHC SLF RPT: HEADACHE AGE 2--WF"                 format=f1.
      ER45621   LABEL="HEHC SLF RPT: HEADACHE AGE 3--WF"                 format=f1.
      ER45622   LABEL="HEHC SLF RPT: HEADACHE AGE 4--WF"                 format=f1.
      ER45623   LABEL="HEHC SLF RPT: HEADACHE AGE 5--WF"                 format=f1.
      ER45624   LABEL="HEHC SLF RPT: HEADACHE AGE 6--WF"                 format=f1.
      ER45625   LABEL="HEHC SLF RPT: HEADACHE AGE 7--WF"                 format=f1.
      ER45626   LABEL="HEHC SLF RPT: HEADACHE AGE 8--WF"                 format=f1.
      ER45627   LABEL="HEHC SLF RPT: HEADACHE AGE 9--WF"                 format=f1.
      ER45628   LABEL="HEHC SLF RPT: HEADACHE AGE 10--WF"                format=f1.
      ER45629   LABEL="HEHC SLF RPT: HEADACHE AGE 11--WF"                format=f1.
      ER45630   LABEL="HEHC SLF RPT: HEADACHE AGE 12--WF"                format=f1.
      ER45631   LABEL="HEHC SLF RPT: HEADACHE AGE 13--WF"                format=f1.
      ER45632   LABEL="HEHC SLF RPT: HEADACHE AGE 14--WF"                format=f1.
      ER45633   LABEL="HEHC SLF RPT: HEADACHE AGE 15--WF"                format=f1.
      ER45634   LABEL="HEHC SLF RPT: HEADACHE AGE 16--WF"                format=f1.
      ER45635   LABEL="HEHC SLF RPT: HEADACHE AGE 17+--WF"               format=f1.
      ER45636   LABEL="HEHC SLF RPT: AGE END HEADACHE--WF"               format=f3.
      ER45637   LABEL="HEHC SLF RPT: STOM PROB B4 AGE 1--WF"             format=f1.
      ER45638   LABEL="HEHC SLF RPT: STOM PROB AGE 1--WF"                format=f1.
      ER45639   LABEL="HEHC SLF RPT: STOM PROB AGE 2--WF"                format=f1.
      ER45640   LABEL="HEHC SLF RPT: STOM PROB AGE 3--WF"                format=f1.
      ER45641   LABEL="HEHC SLF RPT: STOM PROB AGE 4--WF"                format=f1.
      ER45642   LABEL="HEHC SLF RPT: STOM PROB AGE 5--WF"                format=f1.
      ER45643   LABEL="HEHC SLF RPT: STOM PROB AGE 6--WF"                format=f1.
      ER45644   LABEL="HEHC SLF RPT: STOM PROB AGE 7--WF"                format=f1.
      ER45645   LABEL="HEHC SLF RPT: STOM PROB AGE 8--WF"                format=f1.
      ER45646   LABEL="HEHC SLF RPT: STOM PROB AGE 9--WF"                format=f1.
      ER45647   LABEL="HEHC SLF RPT: STOM PROB AGE 10--WF"               format=f1.
      ER45648   LABEL="HEHC SLF RPT: STOM PROB AGE 11--WF"               format=f1.
      ER45649   LABEL="HEHC SLF RPT: STOM PROB AGE 12--WF"               format=f1.
      ER45650   LABEL="HEHC SLF RPT: STOM PROB AGE 13--WF"               format=f1.
      ER45651   LABEL="HEHC SLF RPT: STOM PROB AGE 14--WF"               format=f1.
      ER45652   LABEL="HEHC SLF RPT: STOM PROB AGE 15--WF"               format=f1.
      ER45653   LABEL="HEHC SLF RPT: STOM PROB AGE 16--WF"               format=f1.
      ER45654   LABEL="HEHC SLF RPT: STOM PROB AGE 17+--WF"              format=f1.
      ER45655   LABEL="HEHC SLF RPT: AGE END STOM PROB--WF"              format=f3.
      ER45656   LABEL="HEHC SLF RPT: HGH BLOOD PR B4 AGE 1--WF"          format=f1.
      ER45657   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 1--WF"             format=f1.
      ER45658   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 2--WF"             format=f1.
      ER45659   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 3--WF"             format=f1.
      ER45660   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 4--WF"             format=f1.
      ER45661   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 5--WF"             format=f1.
      ER45662   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 6--WF"             format=f1.
      ER45663   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 7--WF"             format=f1.
      ER45664   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 8--WF"             format=f1.
      ER45665   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 9--WF"             format=f1.
      ER45666   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 10--WF"            format=f1.
      ER45667   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 11--WF"            format=f1.
      ER45668   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 12--WF"            format=f1.
      ER45669   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 13--WF"            format=f1.
      ER45670   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 14--WF"            format=f1.
      ER45671   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 15--WF"            format=f1.
      ER45672   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 16--WF"            format=f1.
      ER45673   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 17+--WF"           format=f1.
      ER45674   LABEL="HEHC SLF RPT: AGE END HGH BLOOD PR--WF"           format=f3.
      ER45675   LABEL="HEHC SLF RPT: DEPRESSION B4 AGE 1--WF"            format=f1.
      ER45676   LABEL="HEHC SLF RPT: DEPRESSION AGE 1--WF"               format=f1.
      ER45677   LABEL="HEHC SLF RPT: DEPRESSION AGE 2--WF"               format=f1.
      ER45678   LABEL="HEHC SLF RPT: DEPRESSION AGE 3--WF"               format=f1.
      ER45679   LABEL="HEHC SLF RPT: DEPRESSION AGE 4--WF"               format=f1.
      ER45680   LABEL="HEHC SLF RPT: DEPRESSION AGE 5--WF"               format=f1.
      ER45681   LABEL="HEHC SLF RPT: DEPRESSION AGE 6--WF"               format=f1.
      ER45682   LABEL="HEHC SLF RPT: DEPRESSION AGE 7--WF"               format=f1.
      ER45683   LABEL="HEHC SLF RPT: DEPRESSION AGE 8--WF"               format=f1.
      ER45684   LABEL="HEHC SLF RPT: DEPRESSION AGE 9--WF"               format=f1.
      ER45685   LABEL="HEHC SLF RPT: DEPRESSION AGE 10--WF"              format=f1.
      ER45686   LABEL="HEHC SLF RPT: DEPRESSION AGE 11--WF"              format=f1.
      ER45687   LABEL="HEHC SLF RPT: DEPRESSION AGE 12--WF"              format=f1.
      ER45688   LABEL="HEHC SLF RPT: DEPRESSION AGE 13--WF"              format=f1.
      ER45689   LABEL="HEHC SLF RPT: DEPRESSION AGE 14--WF"              format=f1.
      ER45690   LABEL="HEHC SLF RPT: DEPRESSION AGE 15--WF"              format=f1.
      ER45691   LABEL="HEHC SLF RPT: DEPRESSION AGE 16--WF"              format=f1.
      ER45692   LABEL="HEHC SLF RPT: DEPRESSION AGE 17+--WF"             format=f1.
      ER45693   LABEL="HEHC SLF RPT: AGE END DEPRESSION--WF"             format=f3.
      ER45694   LABEL="HEHC SLF RPT: DRUG/AL PROB B4 AGE 1--WF"          format=f1.
      ER45695   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 1--WF"             format=f1.
      ER45696   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 2--WF"             format=f1.
      ER45697   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 3--WF"             format=f1.
      ER45698   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 4--WF"             format=f1.
      ER45699   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 5--WF"             format=f1.
      ER45700   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 6--WF"             format=f1.
      ER45701   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 7--WF"             format=f1.
      ER45702   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 8--WF"             format=f1.
      ER45703   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 9--WF"             format=f1.
      ER45704   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 10--WF"            format=f1.
      ER45705   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 11--WF"            format=f1.
      ER45706   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 12--WF"            format=f1.
      ER45707   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 13--WF"            format=f1.
      ER45708   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 14--WF"            format=f1.
      ER45709   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 15--WF"            format=f1.
      ER45710   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 16--WF"            format=f1.
      ER45711   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 17+--WF"           format=f1.
      ER45712   LABEL="HEHC SLF RPT: AGE END DRUG/AL PROB--WF"           format=f3.
      ER45713   LABEL="HEHC SLF RPT: OTR PSYCH PROB B4 AGE 1--W"         format=f1.
      ER45714   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 1--WF"           format=f1.
      ER45715   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 2--WF"           format=f1.
      ER45716   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 3--WF"           format=f1.
      ER45717   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 4--WF"           format=f1.
      ER45718   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 5--WF"           format=f1.
      ER45719   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 6--WF"           format=f1.
      ER45720   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 7--WF"           format=f1.
      ER45721   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 8--WF"           format=f1.
      ER45722   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 9--WF"           format=f1.
      ER45723   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 10--WF"          format=f1.
      ER45724   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 11--WF"          format=f1.
      ER45725   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 12--WF"          format=f1.
      ER45726   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 13--WF"          format=f1.
      ER45727   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 14--WF"          format=f1.
      ER45728   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 15--WF"          format=f1.
      ER45729   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 16--WF"          format=f1.
      ER45730   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 17+--WF"         format=f1.
      ER45731   LABEL="HEHC SLF RPT: AGE END OTR PSYCH PROB--WF"         format=f3.
      ER45732   LABEL="HEHC SP RPT: YEAR 1ST REPORT--WF"                 format=f4.
      ER45733   LABEL="HEHC SP RPT: PAR SEP B4 AGE 1--WF"                format=f1.
      ER45734   LABEL="HEHC SP RPT: PAR SEP AGE 1--WF"                   format=f1.
      ER45735   LABEL="HEHC SP RPT: PAR SEP AGE 2--WF"                   format=f1.
      ER45736   LABEL="HEHC SP RPT: PAR SEP AGE 3--WF"                   format=f1.
      ER45737   LABEL="HEHC SP RPT: PAR SEP AGE 4--WF"                   format=f1.
      ER45738   LABEL="HEHC SP RPT: PAR SEP AGE 5--WF"                   format=f1.
      ER45739   LABEL="HEHC SP RPT: PAR SEP AGE 6--WF"                   format=f1.
      ER45740   LABEL="HEHC SP RPT: PAR SEP AGE 7--WF"                   format=f1.
      ER45741   LABEL="HEHC SP RPT: PAR SEP AGE 8--WF"                   format=f1.
      ER45742   LABEL="HEHC SP RPT: PAR SEP AGE 9--WF"                   format=f1.
      ER45743   LABEL="HEHC SP RPT: PAR SEP AGE 10--WF"                  format=f1.
      ER45744   LABEL="HEHC SP RPT: PAR SEP AGE 11--WF"                  format=f1.
      ER45745   LABEL="HEHC SP RPT: PAR SEP AGE 12--WF"                  format=f1.
      ER45746   LABEL="HEHC SP RPT: PAR SEP AGE 13--WF"                  format=f1.
      ER45747   LABEL="HEHC SP RPT: PAR SEP AGE 14--WF"                  format=f1.
      ER45748   LABEL="HEHC SP RPT: PAR SEP AGE 15--WF"                  format=f1.
      ER45749   LABEL="HEHC SP RPT: PAR SEP AGE 16--WF"                  format=f1.
      ER45750   LABEL="HEHC SP RPT: MOVE B4 AGE 1--WF"                   format=f1.
      ER45751   LABEL="HEHC SP RPT: MOVE AGE 1--WF"                      format=f1.
      ER45752   LABEL="HEHC SP RPT: MOVE AGE 2--WF"                      format=f1.
      ER45753   LABEL="HEHC SP RPT: MOVE AGE 3--WF"                      format=f1.
      ER45754   LABEL="HEHC SP RPT: MOVE AGE 4--WF"                      format=f1.
      ER45755   LABEL="HEHC SP RPT: MOVE AGE 5--WF"                      format=f1.
      ER45756   LABEL="HEHC SP RPT: MOVE AGE 6--WF"                      format=f1.
      ER45757   LABEL="HEHC SP RPT: MOVE AGE 7--WF"                      format=f1.
      ER45758   LABEL="HEHC SP RPT: MOVE AGE 8--WF"                      format=f1.
      ER45759   LABEL="HEHC SP RPT: MOVE AGE 9--WF"                      format=f1.
      ER45760   LABEL="HEHC SP RPT: MOVE AGE 10--WF"                     format=f1.
      ER45761   LABEL="HEHC SP RPT: MOVE AGE 11--WF"                     format=f1.
      ER45762   LABEL="HEHC SP RPT: MOVE AGE 12--WF"                     format=f1.
      ER45763   LABEL="HEHC SP RPT: MOVE AGE 13--WF"                     format=f1.
      ER45764   LABEL="HEHC SP RPT: MOVE AGE 14--WF"                     format=f1.
      ER45765   LABEL="HEHC SP RPT: MOVE AGE 15--WF"                     format=f1.
      ER45766   LABEL="HEHC SP RPT: MOVE AGE 16--WF"                     format=f1.
      ER45767   LABEL="HEHC SP RPT: SCHOOL B4 AGE 1--WF"                 format=f1.
      ER45768   LABEL="HEHC SP RPT: SCHOOL AGE 1--WF"                    format=f1.
      ER45769   LABEL="HEHC SP RPT: SCHOOL AGE 2--WF"                    format=f1.
      ER45770   LABEL="HEHC SP RPT: SCHOOL AGE 3--WF"                    format=f1.
      ER45771   LABEL="HEHC SP RPT: SCHOOL AGE 4--WF"                    format=f1.
      ER45772   LABEL="HEHC SP RPT: SCHOOL AGE 5--WF"                    format=f1.
      ER45773   LABEL="HEHC SP RPT: SCHOOL AGE 6--WF"                    format=f1.
      ER45774   LABEL="HEHC SP RPT: SCHOOL AGE 7--WF"                    format=f1.
      ER45775   LABEL="HEHC SP RPT: SCHOOL AGE 8--WF"                    format=f1.
      ER45776   LABEL="HEHC SP RPT: SCHOOL AGE 9--WF"                    format=f1.
      ER45777   LABEL="HEHC SP RPT: SCHOOL AGE 10--WF"                   format=f1.
      ER45778   LABEL="HEHC SP RPT: SCHOOL AGE 11--WF"                   format=f1.
      ER45779   LABEL="HEHC SP RPT: SCHOOL AGE 12--WF"                   format=f1.
      ER45780   LABEL="HEHC SP RPT: SCHOOL AGE 13--WF"                   format=f1.
      ER45781   LABEL="HEHC SP RPT: SCHOOL AGE 14--WF"                   format=f1.
      ER45782   LABEL="HEHC SP RPT: SCHOOL AGE 15--WF"                   format=f1.
      ER45783   LABEL="HEHC SP RPT: SCHOOL AGE 16--WF"                   format=f1.
      ER45784   LABEL="HEHC SP RPT: ASTHMA B4 AGE 1--WF"                 format=f1.
      ER45785   LABEL="HEHC SP RPT: ASTHMA AGE 1--WF"                    format=f1.
      ER45786   LABEL="HEHC SP RPT: ASTHMA AGE 2--WF"                    format=f1.
      ER45787   LABEL="HEHC SP RPT: ASTHMA AGE 3--WF"                    format=f1.
      ER45788   LABEL="HEHC SP RPT: ASTHMA AGE 4--WF"                    format=f1.
      ER45789   LABEL="HEHC SP RPT: ASTHMA AGE 5--WF"                    format=f1.
      ER45790   LABEL="HEHC SP RPT: ASTHMA AGE 6--WF"                    format=f1.
      ER45791   LABEL="HEHC SP RPT: ASTHMA AGE 7--WF"                    format=f1.
      ER45792   LABEL="HEHC SP RPT: ASTHMA AGE 8--WF"                    format=f1.
      ER45793   LABEL="HEHC SP RPT: ASTHMA AGE 9--WF"                    format=f1.
      ER45794   LABEL="HEHC SP RPT: ASTHMA AGE 10--WF"                   format=f1.
      ER45795   LABEL="HEHC SP RPT: ASTHMA AGE 11--WF"                   format=f1.
      ER45796   LABEL="HEHC SP RPT: ASTHMA AGE 12--WF"                   format=f1.
      ER45797   LABEL="HEHC SP RPT: ASTHMA AGE 13--WF"                   format=f1.
      ER45798   LABEL="HEHC SP RPT: ASTHMA AGE 14--WF"                   format=f1.
      ER45799   LABEL="HEHC SP RPT: ASTHMA AGE 15--WF"                   format=f1.
      ER45800   LABEL="HEHC SP RPT: ASTHMA AGE 16--WF"                   format=f1.
      ER45801   LABEL="HEHC SP RPT: ASTHMA AGE 17+--WF"                  format=f1.
      ER45802   LABEL="HEHC SP RPT: AGE END ASTHMA--WF"                  format=f3.
      ER45803   LABEL="HEHC SP RPT: DIABETES B4 AGE 1--WF"               format=f1.
      ER45804   LABEL="HEHC SP RPT: DIABETES AGE 1--WF"                  format=f1.
      ER45805   LABEL="HEHC SP RPT: DIABETES AGE 2--WF"                  format=f1.
      ER45806   LABEL="HEHC SP RPT: DIABETES AGE 3--WF"                  format=f1.
      ER45807   LABEL="HEHC SP RPT: DIABETES AGE 4--WF"                  format=f1.
      ER45808   LABEL="HEHC SP RPT: DIABETES AGE 5--WF"                  format=f1.
      ER45809   LABEL="HEHC SP RPT: DIABETES AGE 6--WF"                  format=f1.
      ER45810   LABEL="HEHC SP RPT: DIABETES AGE 7--WF"                  format=f1.
      ER45811   LABEL="HEHC SP RPT: DIABETES AGE 8--WF"                  format=f1.
      ER45812   LABEL="HEHC SP RPT: DIABETES AGE 9--WF"                  format=f1.
      ER45813   LABEL="HEHC SP RPT: DIABETES AGE 10--WF"                 format=f1.
      ER45814   LABEL="HEHC SP RPT: DIABETES AGE 11--WF"                 format=f1.
      ER45815   LABEL="HEHC SP RPT: DIABETES AGE 12--WF"                 format=f1.
      ER45816   LABEL="HEHC SP RPT: DIABETES AGE 13--WF"                 format=f1.
      ER45817   LABEL="HEHC SP RPT: DIABETES AGE 14--WF"                 format=f1.
      ER45818   LABEL="HEHC SP RPT: DIABETES AGE 15--WF"                 format=f1.
      ER45819   LABEL="HEHC SP RPT: DIABETES AGE 16--WF"                 format=f1.
      ER45820   LABEL="HEHC SP RPT: DIABETES AGE 17+--WF"                format=f1.
      ER45821   LABEL="HEHC SP RPT: AGE END DIABETES--WF"                format=f3.
      ER45822   LABEL="HEHC SP RPT: RESP DIS B4 AGE 1--WF"               format=f1.
      ER45823   LABEL="HEHC SP RPT: RESP DIS AGE 1--WF"                  format=f1.
      ER45824   LABEL="HEHC SP RPT: RESP DIS AGE 2--WF"                  format=f1.
      ER45825   LABEL="HEHC SP RPT: RESP DIS AGE 3--WF"                  format=f1.
      ER45826   LABEL="HEHC SP RPT: RESP DIS AGE 4--WF"                  format=f1.
      ER45827   LABEL="HEHC SP RPT: RESP DIS AGE 5--WF"                  format=f1.
      ER45828   LABEL="HEHC SP RPT: RESP DIS AGE 6--WF"                  format=f1.
      ER45829   LABEL="HEHC SP RPT: RESP DIS AGE 7--WF"                  format=f1.
      ER45830   LABEL="HEHC SP RPT: RESP DIS AGE 8--WF"                  format=f1.
      ER45831   LABEL="HEHC SP RPT: RESP DIS AGE 9--WF"                  format=f1.
      ER45832   LABEL="HEHC SP RPT: RESP DIS AGE 10--WF"                 format=f1.
      ER45833   LABEL="HEHC SP RPT: RESP DIS AGE 11--WF"                 format=f1.
      ER45834   LABEL="HEHC SP RPT: RESP DIS AGE 12--WF"                 format=f1.
      ER45835   LABEL="HEHC SP RPT: RESP DIS AGE 13--WF"                 format=f1.
      ER45836   LABEL="HEHC SP RPT: RESP DIS AGE 14--WF"                 format=f1.
      ER45837   LABEL="HEHC SP RPT: RESP DIS AGE 15--WF"                 format=f1.
      ER45838   LABEL="HEHC SP RPT: RESP DIS AGE 16--WF"                 format=f1.
      ER45839   LABEL="HEHC SP RPT: RESP DIS AGE 17+--WF"                format=f1.
      ER45840   LABEL="HEHC SP RPT: AGE END RESP DIS--WF"                format=f3.
      ER45841   LABEL="HEHC SP RPT: SPCH IMPAIR B4 AGE 1--WF"            format=f1.
      ER45842   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 1--WF"               format=f1.
      ER45843   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 2--WF"               format=f1.
      ER45844   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 3--WF"               format=f1.
      ER45845   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 4--WF"               format=f1.
      ER45846   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 5--WF"               format=f1.
      ER45847   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 6--WF"               format=f1.
      ER45848   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 7--WF"               format=f1.
      ER45849   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 8--WF"               format=f1.
      ER45850   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 9--WF"               format=f1.
      ER45851   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 10--WF"              format=f1.
      ER45852   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 11--WF"              format=f1.
      ER45853   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 12--WF"              format=f1.
      ER45854   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 13--WF"              format=f1.
      ER45855   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 14--WF"              format=f1.
      ER45856   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 15--WF"              format=f1.
      ER45857   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 16--WF"              format=f1.
      ER45858   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 17+--WF"             format=f1.
      ER45859   LABEL="HEHC SP RPT: AGE END SPCH IMPAIR--WF"             format=f3.
      ER45860   LABEL="HEHC SP RPT: ALLERGY B4 AGE 1--WF"                format=f1.
      ER45861   LABEL="HEHC SP RPT: ALLERGY AGE 1--WF"                   format=f1.
      ER45862   LABEL="HEHC SP RPT: ALLERGY AGE 2--WF"                   format=f1.
      ER45863   LABEL="HEHC SP RPT: ALLERGY AGE 3--WF"                   format=f1.
      ER45864   LABEL="HEHC SP RPT: ALLERGY AGE 4--WF"                   format=f1.
      ER45865   LABEL="HEHC SP RPT: ALLERGY AGE 5--WF"                   format=f1.
      ER45866   LABEL="HEHC SP RPT: ALLERGY AGE 6--WF"                   format=f1.
      ER45867   LABEL="HEHC SP RPT: ALLERGY AGE 7--WF"                   format=f1.
      ER45868   LABEL="HEHC SP RPT: ALLERGY AGE 8--WF"                   format=f1.
      ER45869   LABEL="HEHC SP RPT: ALLERGY AGE 9--WF"                   format=f1.
      ER45870   LABEL="HEHC SP RPT: ALLERGY AGE 10--WF"                  format=f1.
      ER45871   LABEL="HEHC SP RPT: ALLERGY AGE 11--WF"                  format=f1.
      ER45872   LABEL="HEHC SP RPT: ALLERGY AGE 12--WF"                  format=f1.
      ER45873   LABEL="HEHC SP RPT: ALLERGY AGE 13--WF"                  format=f1.
      ER45874   LABEL="HEHC SP RPT: ALLERGY AGE 14--WF"                  format=f1.
      ER45875   LABEL="HEHC SP RPT: ALLERGY AGE 15--WF"                  format=f1.
      ER45876   LABEL="HEHC SP RPT: ALLERGY AGE 16--WF"                  format=f1.
      ER45877   LABEL="HEHC SP RPT: ALLERGY AGE 17+--WF"                 format=f1.
      ER45878   LABEL="HEHC SP RPT: AGE END ALLERGY--WF"                 format=f3.
      ER45879   LABEL="HEHC SP RPT: HEART TRBL B4 AGE 1--WF"             format=f1.
      ER45880   LABEL="HEHC SP RPT: HEART TRBL AGE 1--WF"                format=f1.
      ER45881   LABEL="HEHC SP RPT: HEART TRBL AGE 2--WF"                format=f1.
      ER45882   LABEL="HEHC SP RPT: HEART TRBL AGE 3--WF"                format=f1.
      ER45883   LABEL="HEHC SP RPT: HEART TRBL AGE 4--WF"                format=f1.
      ER45884   LABEL="HEHC SP RPT: HEART TRBL AGE 5--WF"                format=f1.
      ER45885   LABEL="HEHC SP RPT: HEART TRBL AGE 6--WF"                format=f1.
      ER45886   LABEL="HEHC SP RPT: HEART TRBL AGE 7--WF"                format=f1.
      ER45887   LABEL="HEHC SP RPT: HEART TRBL AGE 8--WF"                format=f1.
      ER45888   LABEL="HEHC SP RPT: HEART TRBL AGE 9--WF"                format=f1.
      ER45889   LABEL="HEHC SP RPT: HEART TRBL AGE 10--WF"               format=f1.
      ER45890   LABEL="HEHC SP RPT: HEART TRBL AGE 11--WF"               format=f1.
      ER45891   LABEL="HEHC SP RPT: HEART TRBL AGE 12--WF"               format=f1.
      ER45892   LABEL="HEHC SP RPT: HEART TRBL AGE 13--WF"               format=f1.
      ER45893   LABEL="HEHC SP RPT: HEART TRBL AGE 14--WF"               format=f1.
      ER45894   LABEL="HEHC SP RPT: HEART TRBL AGE 15--WF"               format=f1.
      ER45895   LABEL="HEHC SP RPT: HEART TRBL AGE 16--WF"               format=f1.
      ER45896   LABEL="HEHC SP RPT: HEART TRBL AGE 17+--WF"              format=f1.
      ER45897   LABEL="HEHC SP RPT: AGE END HEART TRBL--WF"              format=f3.
      ER45898   LABEL="HEHC SP RPT: EAR PROBS B4 AGE 1--WF"              format=f1.
      ER45899   LABEL="HEHC SP RPT: EAR PROBS AGE 1--WF"                 format=f1.
      ER45900   LABEL="HEHC SP RPT: EAR PROBS AGE 2--WF"                 format=f1.
      ER45901   LABEL="HEHC SP RPT: EAR PROBS AGE 3--WF"                 format=f1.
      ER45902   LABEL="HEHC SP RPT: EAR PROBS AGE 4--WF"                 format=f1.
      ER45903   LABEL="HEHC SP RPT: EAR PROBS AGE 5--WF"                 format=f1.
      ER45904   LABEL="HEHC SP RPT: EAR PROBS AGE 6--WF"                 format=f1.
      ER45905   LABEL="HEHC SP RPT: EAR PROBS AGE 7--WF"                 format=f1.
      ER45906   LABEL="HEHC SP RPT: EAR PROBS AGE 8--WF"                 format=f1.
      ER45907   LABEL="HEHC SP RPT: EAR PROBS AGE 9--WF"                 format=f1.
      ER45908   LABEL="HEHC SP RPT: EAR PROBS AGE 10--WF"                format=f1.
      ER45909   LABEL="HEHC SP RPT: EAR PROBS AGE 11--WF"                format=f1.
      ER45910   LABEL="HEHC SP RPT: EAR PROBS AGE 12--WF"                format=f1.
      ER45911   LABEL="HEHC SP RPT: EAR PROBS AGE 13--WF"                format=f1.
      ER45912   LABEL="HEHC SP RPT: EAR PROBS AGE 14--WF"                format=f1.
      ER45913   LABEL="HEHC SP RPT: EAR PROBS AGE 15--WF"                format=f1.
      ER45914   LABEL="HEHC SP RPT: EAR PROBS AGE 16--WF"                format=f1.
      ER45915   LABEL="HEHC SP RPT: EAR PROBS AGE 17+--WF"               format=f1.
      ER45916   LABEL="HEHC SP RPT: AGE END EAR PROBS--WF"               format=f3.
      ER45917   LABEL="HEHC SP RPT: EPILEPSY B4 AGE 1--WF"               format=f1.
      ER45918   LABEL="HEHC SP RPT: EPILEPSY AGE 1--WF"                  format=f1.
      ER45919   LABEL="HEHC SP RPT: EPILEPSY AGE 2--WF"                  format=f1.
      ER45920   LABEL="HEHC SP RPT: EPILEPSY AGE 3--WF"                  format=f1.
      ER45921   LABEL="HEHC SP RPT: EPILEPSY AGE 4--WF"                  format=f1.
      ER45922   LABEL="HEHC SP RPT: EPILEPSY AGE 5--WF"                  format=f1.
      ER45923   LABEL="HEHC SP RPT: EPILEPSY AGE 6--WF"                  format=f1.
      ER45924   LABEL="HEHC SP RPT: EPILEPSY AGE 7--WF"                  format=f1.
      ER45925   LABEL="HEHC SP RPT: EPILEPSY AGE 8--WF"                  format=f1.
      ER45926   LABEL="HEHC SP RPT: EPILEPSY AGE 9--WF"                  format=f1.
      ER45927   LABEL="HEHC SP RPT: EPILEPSY AGE 10--WF"                 format=f1.
      ER45928   LABEL="HEHC SP RPT: EPILEPSY AGE 11--WF"                 format=f1.
      ER45929   LABEL="HEHC SP RPT: EPILEPSY AGE 12--WF"                 format=f1.
      ER45930   LABEL="HEHC SP RPT: EPILEPSY AGE 13--WF"                 format=f1.
      ER45931   LABEL="HEHC SP RPT: EPILEPSY AGE 14--WF"                 format=f1.
      ER45932   LABEL="HEHC SP RPT: EPILEPSY AGE 15--WF"                 format=f1.
      ER45933   LABEL="HEHC SP RPT: EPILEPSY AGE 16--WF"                 format=f1.
      ER45934   LABEL="HEHC SP RPT: EPILEPSY AGE 17+--WF"                format=f1.
      ER45935   LABEL="HEHC SP RPT: AGE END EPILEPSY--WF"                format=f3.
      ER45936   LABEL="HEHC SP RPT: HEADACHE B4 AGE 1--WF"               format=f1.
      ER45937   LABEL="HEHC SP RPT: HEADACHE AGE 1--WF"                  format=f1.
      ER45938   LABEL="HEHC SP RPT: HEADACHE AGE 2--WF"                  format=f1.
      ER45939   LABEL="HEHC SP RPT: HEADACHE AGE 3--WF"                  format=f1.
      ER45940   LABEL="HEHC SP RPT: HEADACHE AGE 4--WF"                  format=f1.
      ER45941   LABEL="HEHC SP RPT: HEADACHE AGE 5--WF"                  format=f1.
      ER45942   LABEL="HEHC SP RPT: HEADACHE AGE 6--WF"                  format=f1.
      ER45943   LABEL="HEHC SP RPT: HEADACHE AGE 7--WF"                  format=f1.
      ER45944   LABEL="HEHC SP RPT: HEADACHE AGE 8--WF"                  format=f1.
      ER45945   LABEL="HEHC SP RPT: HEADACHE AGE 9--WF"                  format=f1.
      ER45946   LABEL="HEHC SP RPT: HEADACHE AGE 10--WF"                 format=f1.
      ER45947   LABEL="HEHC SP RPT: HEADACHE AGE 11--WF"                 format=f1.
      ER45948   LABEL="HEHC SP RPT: HEADACHE AGE 12--WF"                 format=f1.
      ER45949   LABEL="HEHC SP RPT: HEADACHE AGE 13--WF"                 format=f1.
      ER45950   LABEL="HEHC SP RPT: HEADACHE AGE 14--WF"                 format=f1.
      ER45951   LABEL="HEHC SP RPT: HEADACHE AGE 15--WF"                 format=f1.
      ER45952   LABEL="HEHC SP RPT: HEADACHE AGE 16--WF"                 format=f1.
      ER45953   LABEL="HEHC SP RPT: HEADACHE AGE 17+--WF"                format=f1.
      ER45954   LABEL="HEHC SP RPT: AGE END HEADACHE--WF"                format=f3.
      ER45955   LABEL="HEHC SP RPT: STOM PROB B4 AGE 1--WF"              format=f1.
      ER45956   LABEL="HEHC SP RPT: STOM PROB AGE 1--WF"                 format=f1.
      ER45957   LABEL="HEHC SP RPT: STOM PROB AGE 2--WF"                 format=f1.
      ER45958   LABEL="HEHC SP RPT: STOM PROB AGE 3--WF"                 format=f1.
      ER45959   LABEL="HEHC SP RPT: STOM PROB AGE 4--WF"                 format=f1.
      ER45960   LABEL="HEHC SP RPT: STOM PROB AGE 5--WF"                 format=f1.
      ER45961   LABEL="HEHC SP RPT: STOM PROB AGE 6--WF"                 format=f1.
      ER45962   LABEL="HEHC SP RPT: STOM PROB AGE 7--WF"                 format=f1.
      ER45963   LABEL="HEHC SP RPT: STOM PROB AGE 8--WF"                 format=f1.
      ER45964   LABEL="HEHC SP RPT: STOM PROB AGE 9--WF"                 format=f1.
      ER45965   LABEL="HEHC SP RPT: STOM PROB AGE 10--WF"                format=f1.
      ER45966   LABEL="HEHC SP RPT: STOM PROB AGE 11--WF"                format=f1.
      ER45967   LABEL="HEHC SP RPT: STOM PROB AGE 12--WF"                format=f1.
      ER45968   LABEL="HEHC SP RPT: STOM PROB AGE 13--WF"                format=f1.
      ER45969   LABEL="HEHC SP RPT: STOM PROB AGE 14--WF"                format=f1.
      ER45970   LABEL="HEHC SP RPT: STOM PROB AGE 15--WF"                format=f1.
      ER45971   LABEL="HEHC SP RPT: STOM PROB AGE 16--WF"                format=f1.
      ER45972   LABEL="HEHC SP RPT: STOM PROB AGE 17+--WF"               format=f1.
      ER45973   LABEL="HEHC SP RPT: AGE END STOM PROB--WF"               format=f3.
      ER45974   LABEL="HEHC SP RPT: HGH BLOOD PR B4 AGE 1--WF"           format=f1.
      ER45975   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 1--WF"              format=f1.
      ER45976   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 2--WF"              format=f1.
      ER45977   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 3--WF"              format=f1.
      ER45978   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 4--WF"              format=f1.
      ER45979   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 5--WF"              format=f1.
      ER45980   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 6--WF"              format=f1.
      ER45981   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 7--WF"              format=f1.
      ER45982   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 8--WF"              format=f1.
      ER45983   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 9--WF"              format=f1.
      ER45984   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 10--WF"             format=f1.
      ER45985   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 11--WF"             format=f1.
      ER45986   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 12--WF"             format=f1.
      ER45987   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 13--WF"             format=f1.
      ER45988   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 14--WF"             format=f1.
      ER45989   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 15--WF"             format=f1.
      ER45990   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 16--WF"             format=f1.
      ER45991   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 17+--WF"            format=f1.
      ER45992   LABEL="HEHC SP RPT: AGE END HGH BLOOD PR--WF"            format=f3.
      ER45993   LABEL="HEHC SP RPT: DEPRESSION B4 AGE 1--WF"             format=f1.
      ER45994   LABEL="HEHC SP RPT: DEPRESSION AGE 1--WF"                format=f1.
      ER45995   LABEL="HEHC SP RPT: DEPRESSION AGE 2--WF"                format=f1.
      ER45996   LABEL="HEHC SP RPT: DEPRESSION AGE 3--WF"                format=f1.
      ER45997   LABEL="HEHC SP RPT: DEPRESSION AGE 4--WF"                format=f1.
      ER45998   LABEL="HEHC SP RPT: DEPRESSION AGE 5--WF"                format=f1.
      ER45999   LABEL="HEHC SP RPT: DEPRESSION AGE 6--WF"                format=f1.
      ER46000   LABEL="HEHC SP RPT: DEPRESSION AGE 7--WF"                format=f1.
      ER46001   LABEL="HEHC SP RPT: DEPRESSION AGE 8--WF"                format=f1.
      ER46002   LABEL="HEHC SP RPT: DEPRESSION AGE 9--WF"                format=f1.
      ER46003   LABEL="HEHC SP RPT: DEPRESSION AGE 10--WF"               format=f1.
      ER46004   LABEL="HEHC SP RPT: DEPRESSION AGE 11--WF"               format=f1.
      ER46005   LABEL="HEHC SP RPT: DEPRESSION AGE 12--WF"               format=f1.
      ER46006   LABEL="HEHC SP RPT: DEPRESSION AGE 13--WF"               format=f1.
      ER46007   LABEL="HEHC SP RPT: DEPRESSION AGE 14--WF"               format=f1.
      ER46008   LABEL="HEHC SP RPT: DEPRESSION AGE 15--WF"               format=f1.
      ER46009   LABEL="HEHC SP RPT: DEPRESSION AGE 16--WF"               format=f1.
      ER46010   LABEL="HEHC SP RPT: DEPRESSION AGE 17+--WF"              format=f1.
      ER46011   LABEL="HEHC SP RPT: AGE END DEPRESSION--WF"              format=f3.
      ER46012   LABEL="HEHC SP RPT: DRUG/AL PROB B4 AGE 1--WF"           format=f1.
      ER46013   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 1--WF"              format=f1.
      ER46014   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 2--WF"              format=f1.
      ER46015   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 3--WF"              format=f1.
      ER46016   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 4--WF"              format=f1.
      ER46017   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 5--WF"              format=f1.
      ER46018   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 6--WF"              format=f1.
      ER46019   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 7--WF"              format=f1.
      ER46020   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 8--WF"              format=f1.
      ER46021   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 9--WF"              format=f1.
      ER46022   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 10--WF"             format=f1.
      ER46023   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 11--WF"             format=f1.
      ER46024   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 12--WF"             format=f1.
      ER46025   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 13--WF"             format=f1.
      ER46026   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 14--WF"             format=f1.
      ER46027   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 15--WF"             format=f1.
      ER46028   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 16--WF"             format=f1.
      ER46029   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 17+--WF"            format=f1.
      ER46030   LABEL="HEHC SP RPT: AGE END DRUG/AL PROB--WF"            format=f3.
      ER46031   LABEL="HEHC SP RPT: OTR PSYCH PROB B4 AGE 1--WF"         format=f1.
      ER46032   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 1--WF"            format=f1.
      ER46033   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 2--WF"            format=f1.
      ER46034   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 3--WF"            format=f1.
      ER46035   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 4--WF"            format=f1.
      ER46036   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 5--WF"            format=f1.
      ER46037   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 6--WF"            format=f1.
      ER46038   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 7--WF"            format=f1.
      ER46039   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 8--WF"            format=f1.
      ER46040   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 9--WF"            format=f1.
      ER46041   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 10--WF"           format=f1.
      ER46042   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 11--WF"           format=f1.
      ER46043   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 12--WF"           format=f1.
      ER46044   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 13--WF"           format=f1.
      ER46045   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 14--WF"           format=f1.
      ER46046   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 15--WF"           format=f1.
      ER46047   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 16--WF"           format=f1.
      ER46048   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 17+--WF"          format=f1.
      ER46049   LABEL="HEHC SP RPT: AGE END OTR PSYCH PROB--WF"          format=f3.
      ER46050   LABEL="HEHC OTR RPT: YEAR 1ST REPORT--WF"                format=f4.
      ER46051   LABEL="HEHC OTR RPT: PAR SEP B4 AGE 1--WF"               format=f1.
      ER46052   LABEL="HEHC OTR RPT: PAR SEP AGE 1--WF"                  format=f1.
      ER46053   LABEL="HEHC OTR RPT: PAR SEP AGE 2--WF"                  format=f1.
      ER46054   LABEL="HEHC OTR RPT: PAR SEP AGE 3--WF"                  format=f1.
      ER46055   LABEL="HEHC OTR RPT: PAR SEP AGE 4--WF"                  format=f1.
      ER46056   LABEL="HEHC OTR RPT: PAR SEP AGE 5--WF"                  format=f1.
      ER46057   LABEL="HEHC OTR RPT: PAR SEP AGE 6--WF"                  format=f1.
      ER46058   LABEL="HEHC OTR RPT: PAR SEP AGE 7--WF"                  format=f1.
      ER46059   LABEL="HEHC OTR RPT: PAR SEP AGE 8--WF"                  format=f1.
      ER46060   LABEL="HEHC OTR RPT: PAR SEP AGE 9--WF"                  format=f1.
      ER46061   LABEL="HEHC OTR RPT: PAR SEP AGE 10--WF"                 format=f1.
      ER46062   LABEL="HEHC OTR RPT: PAR SEP AGE 11--WF"                 format=f1.
      ER46063   LABEL="HEHC OTR RPT: PAR SEP AGE 12--WF"                 format=f1.
      ER46064   LABEL="HEHC OTR RPT: PAR SEP AGE 13--WF"                 format=f1.
      ER46065   LABEL="HEHC OTR RPT: PAR SEP AGE 14--WF"                 format=f1.
      ER46066   LABEL="HEHC OTR RPT: PAR SEP AGE 15--WF"                 format=f1.
      ER46067   LABEL="HEHC OTR RPT: PAR SEP AGE 16--WF"                 format=f1.
      ER46068   LABEL="HEHC OTR RPT: MOVE B4 AGE 1--WF"                  format=f1.
      ER46069   LABEL="HEHC OTR RPT: MOVE AGE 1--WF"                     format=f1.
      ER46070   LABEL="HEHC OTR RPT: MOVE AGE 2--WF"                     format=f1.
      ER46071   LABEL="HEHC OTR RPT: MOVE AGE 3--WF"                     format=f1.
      ER46072   LABEL="HEHC OTR RPT: MOVE AGE 4--WF"                     format=f1.
      ER46073   LABEL="HEHC OTR RPT: MOVE AGE 5--WF"                     format=f1.
      ER46074   LABEL="HEHC OTR RPT: MOVE AGE 6--WF"                     format=f1.
      ER46075   LABEL="HEHC OTR RPT: MOVE AGE 7--WF"                     format=f1.
      ER46076   LABEL="HEHC OTR RPT: MOVE AGE 8--WF"                     format=f1.
      ER46077   LABEL="HEHC OTR RPT: MOVE AGE 9--WF"                     format=f1.
      ER46078   LABEL="HEHC OTR RPT: MOVE AGE 10--WF"                    format=f1.
      ER46079   LABEL="HEHC OTR RPT: MOVE AGE 11--WF"                    format=f1.
      ER46080   LABEL="HEHC OTR RPT: MOVE AGE 12--WF"                    format=f1.
      ER46081   LABEL="HEHC OTR RPT: MOVE AGE 13--WF"                    format=f1.
      ER46082   LABEL="HEHC OTR RPT: MOVE AGE 14--WF"                    format=f1.
      ER46083   LABEL="HEHC OTR RPT: MOVE AGE 15--WF"                    format=f1.
      ER46084   LABEL="HEHC OTR RPT: MOVE AGE 16--WF"                    format=f1.
      ER46085   LABEL="HEHC OTR RPT: SCHOOL B4 AGE 1--WF"                format=f1.
      ER46086   LABEL="HEHC OTR RPT: SCHOOL AGE 1--WF"                   format=f1.
      ER46087   LABEL="HEHC OTR RPT: SCHOOL AGE 2--WF"                   format=f1.
      ER46088   LABEL="HEHC OTR RPT: SCHOOL AGE 3--WF"                   format=f1.
      ER46089   LABEL="HEHC OTR RPT: SCHOOL AGE 4--WF"                   format=f1.
      ER46090   LABEL="HEHC OTR RPT: SCHOOL AGE 5--WF"                   format=f1.
      ER46091   LABEL="HEHC OTR RPT: SCHOOL AGE 6--WF"                   format=f1.
      ER46092   LABEL="HEHC OTR RPT: SCHOOL AGE 7--WF"                   format=f1.
      ER46093   LABEL="HEHC OTR RPT: SCHOOL AGE 8--WF"                   format=f1.
      ER46094   LABEL="HEHC OTR RPT: SCHOOL AGE 9--WF"                   format=f1.
      ER46095   LABEL="HEHC OTR RPT: SCHOOL AGE 10--WF"                  format=f1.
      ER46096   LABEL="HEHC OTR RPT: SCHOOL AGE 11--WF"                  format=f1.
      ER46097   LABEL="HEHC OTR RPT: SCHOOL AGE 12--WF"                  format=f1.
      ER46098   LABEL="HEHC OTR RPT: SCHOOL AGE 13--WF"                  format=f1.
      ER46099   LABEL="HEHC OTR RPT: SCHOOL AGE 14--WF"                  format=f1.
      ER46100   LABEL="HEHC OTR RPT: SCHOOL AGE 15--WF"                  format=f1.
      ER46101   LABEL="HEHC OTR RPT: SCHOOL AGE 16--WF"                  format=f1.
      ER46102   LABEL="HEHC OTR RPT: ASTHMA B4 AGE 1--WF"                format=f1.
      ER46103   LABEL="HEHC OTR RPT: ASTHMA AGE 1--WF"                   format=f1.
      ER46104   LABEL="HEHC OTR RPT: ASTHMA AGE 2--WF"                   format=f1.
      ER46105   LABEL="HEHC OTR RPT: ASTHMA AGE 3--WF"                   format=f1.
      ER46106   LABEL="HEHC OTR RPT: ASTHMA AGE 4--WF"                   format=f1.
      ER46107   LABEL="HEHC OTR RPT: ASTHMA AGE 5--WF"                   format=f1.
      ER46108   LABEL="HEHC OTR RPT: ASTHMA AGE 6--WF"                   format=f1.
      ER46109   LABEL="HEHC OTR RPT: ASTHMA AGE 7--WF"                   format=f1.
      ER46110   LABEL="HEHC OTR RPT: ASTHMA AGE 8--WF"                   format=f1.
      ER46111   LABEL="HEHC OTR RPT: ASTHMA AGE 9--WF"                   format=f1.
      ER46112   LABEL="HEHC OTR RPT: ASTHMA AGE 10--WF"                  format=f1.
      ER46113   LABEL="HEHC OTR RPT: ASTHMA AGE 11--WF"                  format=f1.
      ER46114   LABEL="HEHC OTR RPT: ASTHMA AGE 12--WF"                  format=f1.
      ER46115   LABEL="HEHC OTR RPT: ASTHMA AGE 13--WF"                  format=f1.
      ER46116   LABEL="HEHC OTR RPT: ASTHMA AGE 14--WF"                  format=f1.
      ER46117   LABEL="HEHC OTR RPT: ASTHMA AGE 15--WF"                  format=f1.
      ER46118   LABEL="HEHC OTR RPT: ASTHMA AGE 16--WF"                  format=f1.
      ER46119   LABEL="HEHC OTR RPT: ASTHMA AGE 17+--WF"                 format=f1.
      ER46120   LABEL="HEHC OTR RPT: AGE END ASTHMA--WF"                 format=f3.
      ER46121   LABEL="HEHC OTR RPT: DIABETES B4 AGE 1--WF"              format=f1.
      ER46122   LABEL="HEHC OTR RPT: DIABETES AGE 1--WF"                 format=f1.
      ER46123   LABEL="HEHC OTR RPT: DIABETES AGE 2--WF"                 format=f1.
      ER46124   LABEL="HEHC OTR RPT: DIABETES AGE 3--WF"                 format=f1.
      ER46125   LABEL="HEHC OTR RPT: DIABETES AGE 4--WF"                 format=f1.
      ER46126   LABEL="HEHC OTR RPT: DIABETES AGE 5--WF"                 format=f1.
      ER46127   LABEL="HEHC OTR RPT: DIABETES AGE 6--WF"                 format=f1.
      ER46128   LABEL="HEHC OTR RPT: DIABETES AGE 7--WF"                 format=f1.
      ER46129   LABEL="HEHC OTR RPT: DIABETES AGE 8--WF"                 format=f1.
      ER46130   LABEL="HEHC OTR RPT: DIABETES AGE 9--WF"                 format=f1.
      ER46131   LABEL="HEHC OTR RPT: DIABETES AGE 10--WF"                format=f1.
      ER46132   LABEL="HEHC OTR RPT: DIABETES AGE 11--WF"                format=f1.
      ER46133   LABEL="HEHC OTR RPT: DIABETES AGE 12--WF"                format=f1.
      ER46134   LABEL="HEHC OTR RPT: DIABETES AGE 13--WF"                format=f1.
      ER46135   LABEL="HEHC OTR RPT: DIABETES AGE 14--WF"                format=f1.
      ER46136   LABEL="HEHC OTR RPT: DIABETES AGE 15--WF"                format=f1.
      ER46137   LABEL="HEHC OTR RPT: DIABETES AGE 16--WF"                format=f1.
      ER46138   LABEL="HEHC OTR RPT: DIABETES AGE 17+--WF"               format=f1.
      ER46139   LABEL="HEHC OTR RPT: AGE END DIABETES--WF"               format=f3.
      ER46140   LABEL="HEHC OTR RPT: RESP DIS B4 AGE 1--WF"              format=f1.
      ER46141   LABEL="HEHC OTR RPT: RESP DIS AGE 1--WF"                 format=f1.
      ER46142   LABEL="HEHC OTR RPT: RESP DIS AGE 2--WF"                 format=f1.
      ER46143   LABEL="HEHC OTR RPT: RESP DIS AGE 3--WF"                 format=f1.
      ER46144   LABEL="HEHC OTR RPT: RESP DIS AGE 4--WF"                 format=f1.
      ER46145   LABEL="HEHC OTR RPT: RESP DIS AGE 5--WF"                 format=f1.
      ER46146   LABEL="HEHC OTR RPT: RESP DIS AGE 6--WF"                 format=f1.
      ER46147   LABEL="HEHC OTR RPT: RESP DIS AGE 7--WF"                 format=f1.
      ER46148   LABEL="HEHC OTR RPT: RESP DIS AGE 8--WF"                 format=f1.
      ER46149   LABEL="HEHC OTR RPT: RESP DIS AGE 9--WF"                 format=f1.
      ER46150   LABEL="HEHC OTR RPT: RESP DIS AGE 10--WF"                format=f1.
      ER46151   LABEL="HEHC OTR RPT: RESP DIS AGE 11--WF"                format=f1.
      ER46152   LABEL="HEHC OTR RPT: RESP DIS AGE 12--WF"                format=f1.
      ER46153   LABEL="HEHC OTR RPT: RESP DIS AGE 13--WF"                format=f1.
      ER46154   LABEL="HEHC OTR RPT: RESP DIS AGE 14--WF"                format=f1.
      ER46155   LABEL="HEHC OTR RPT: RESP DIS AGE 15--WF"                format=f1.
      ER46156   LABEL="HEHC OTR RPT: RESP DIS AGE 16--WF"                format=f1.
      ER46157   LABEL="HEHC OTR RPT: RESP DIS AGE 17+--WF"               format=f1.
      ER46158   LABEL="HEHC OTR RPT: AGE END RESP DIS--WF"               format=f3.
      ER46159   LABEL="HEHC OTR RPT: SPCH IMPAIR B4 AGE 1--WF"           format=f1.
      ER46160   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 1--WF"              format=f1.
      ER46161   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 2--WF"              format=f1.
      ER46162   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 3--WF"              format=f1.
      ER46163   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 4--WF"              format=f1.
      ER46164   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 5--WF"              format=f1.
      ER46165   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 6--WF"              format=f1.
      ER46166   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 7--WF"              format=f1.
      ER46167   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 8--WF"              format=f1.
      ER46168   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 9--WF"              format=f1.
      ER46169   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 10--WF"             format=f1.
      ER46170   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 11--WF"             format=f1.
      ER46171   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 12--WF"             format=f1.
      ER46172   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 13--WF"             format=f1.
      ER46173   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 14--WF"             format=f1.
      ER46174   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 15--WF"             format=f1.
      ER46175   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 16--WF"             format=f1.
      ER46176   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 17+--WF"            format=f1.
      ER46177   LABEL="HEHC OTR RPT: AGE END SPCH IMPAIR--WF"            format=f3.
      ER46178   LABEL="HEHC OTR RPT: ALLERGY B4 AGE 1--WF"               format=f1.
      ER46179   LABEL="HEHC OTR RPT: ALLERGY AGE 1--WF"                  format=f1.
      ER46180   LABEL="HEHC OTR RPT: ALLERGY AGE 2--WF"                  format=f1.
      ER46181   LABEL="HEHC OTR RPT: ALLERGY AGE 3--WF"                  format=f1.
      ER46182   LABEL="HEHC OTR RPT: ALLERGY AGE 4--WF"                  format=f1.
      ER46183   LABEL="HEHC OTR RPT: ALLERGY AGE 5--WF"                  format=f1.
      ER46184   LABEL="HEHC OTR RPT: ALLERGY AGE 6--WF"                  format=f1.
      ER46185   LABEL="HEHC OTR RPT: ALLERGY AGE 7--WF"                  format=f1.
      ER46186   LABEL="HEHC OTR RPT: ALLERGY AGE 8--WF"                  format=f1.
      ER46187   LABEL="HEHC OTR RPT: ALLERGY AGE 9--WF"                  format=f1.
      ER46188   LABEL="HEHC OTR RPT: ALLERGY AGE 10--WF"                 format=f1.
      ER46189   LABEL="HEHC OTR RPT: ALLERGY AGE 11--WF"                 format=f1.
      ER46190   LABEL="HEHC OTR RPT: ALLERGY AGE 12--WF"                 format=f1.
      ER46191   LABEL="HEHC OTR RPT: ALLERGY AGE 13--WF"                 format=f1.
      ER46192   LABEL="HEHC OTR RPT: ALLERGY AGE 14--WF"                 format=f1.
      ER46193   LABEL="HEHC OTR RPT: ALLERGY AGE 15--WF"                 format=f1.
      ER46194   LABEL="HEHC OTR RPT: ALLERGY AGE 16--WF"                 format=f1.
      ER46195   LABEL="HEHC OTR RPT: ALLERGY AGE 17+--WF"                format=f1.
      ER46196   LABEL="HEHC OTR RPT: AGE END ALLERGY--WF"                format=f3.
      ER46197   LABEL="HEHC OTR RPT: HEART TRBL B4 AGE 1--WF"            format=f1.
      ER46198   LABEL="HEHC OTR RPT: HEART TRBL AGE 1--WF"               format=f1.
      ER46199   LABEL="HEHC OTR RPT: HEART TRBL AGE 2--WF"               format=f1.
      ER46200   LABEL="HEHC OTR RPT: HEART TRBL AGE 3--WF"               format=f1.
      ER46201   LABEL="HEHC OTR RPT: HEART TRBL AGE 4--WF"               format=f1.
      ER46202   LABEL="HEHC OTR RPT: HEART TRBL AGE 5--WF"               format=f1.
      ER46203   LABEL="HEHC OTR RPT: HEART TRBL AGE 6--WF"               format=f1.
      ER46204   LABEL="HEHC OTR RPT: HEART TRBL AGE 7--WF"               format=f1.
      ER46205   LABEL="HEHC OTR RPT: HEART TRBL AGE 8--WF"               format=f1.
      ER46206   LABEL="HEHC OTR RPT: HEART TRBL AGE 9--WF"               format=f1.
      ER46207   LABEL="HEHC OTR RPT: HEART TRBL AGE 10--WF"              format=f1.
      ER46208   LABEL="HEHC OTR RPT: HEART TRBL AGE 11--WF"              format=f1.
      ER46209   LABEL="HEHC OTR RPT: HEART TRBL AGE 12--WF"              format=f1.
      ER46210   LABEL="HEHC OTR RPT: HEART TRBL AGE 13--WF"              format=f1.
      ER46211   LABEL="HEHC OTR RPT: HEART TRBL AGE 14--WF"              format=f1.
      ER46212   LABEL="HEHC OTR RPT: HEART TRBL AGE 15--WF"              format=f1.
      ER46213   LABEL="HEHC OTR RPT: HEART TRBL AGE 16--WF"              format=f1.
      ER46214   LABEL="HEHC OTR RPT: HEART TRBL AGE 17+--WF"             format=f1.
      ER46215   LABEL="HEHC OTR RPT: AGE END HEART TRBL--WF"             format=f3.
      ER46216   LABEL="HEHC OTR RPT: EAR PROBS B4 AGE 1--WF"             format=f1.
      ER46217   LABEL="HEHC OTR RPT: EAR PROBS AGE 1--WF"                format=f1.
      ER46218   LABEL="HEHC OTR RPT: EAR PROBS AGE 2--WF"                format=f1.
      ER46219   LABEL="HEHC OTR RPT: EAR PROBS AGE 3--WF"                format=f1.
      ER46220   LABEL="HEHC OTR RPT: EAR PROBS AGE 4--WF"                format=f1.
      ER46221   LABEL="HEHC OTR RPT: EAR PROBS AGE 5--WF"                format=f1.
      ER46222   LABEL="HEHC OTR RPT: EAR PROBS AGE 6--WF"                format=f1.
      ER46223   LABEL="HEHC OTR RPT: EAR PROBS AGE 7--WF"                format=f1.
      ER46224   LABEL="HEHC OTR RPT: EAR PROBS AGE 8--WF"                format=f1.
      ER46225   LABEL="HEHC OTR RPT: EAR PROBS AGE 9--WF"                format=f1.
      ER46226   LABEL="HEHC OTR RPT: EAR PROBS AGE 10--WF"               format=f1.
      ER46227   LABEL="HEHC OTR RPT: EAR PROBS AGE 11--WF"               format=f1.
      ER46228   LABEL="HEHC OTR RPT: EAR PROBS AGE 12--WF"               format=f1.
      ER46229   LABEL="HEHC OTR RPT: EAR PROBS AGE 13--WF"               format=f1.
      ER46230   LABEL="HEHC OTR RPT: EAR PROBS AGE 14--WF"               format=f1.
      ER46231   LABEL="HEHC OTR RPT: EAR PROBS AGE 15--WF"               format=f1.
      ER46232   LABEL="HEHC OTR RPT: EAR PROBS AGE 16--WF"               format=f1.
      ER46233   LABEL="HEHC OTR RPT: EAR PROBS AGE 17+--WF"              format=f1.
      ER46234   LABEL="HEHC OTR RPT: AGE END EAR PROBS--WF"              format=f3.
      ER46235   LABEL="HEHC OTR RPT: EPILEPSY B4 AGE 1--WF"              format=f1.
      ER46236   LABEL="HEHC OTR RPT: EPILEPSY AGE 1--WF"                 format=f1.
      ER46237   LABEL="HEHC OTR RPT: EPILEPSY AGE 2--WF"                 format=f1.
      ER46238   LABEL="HEHC OTR RPT: EPILEPSY AGE 3--WF"                 format=f1.
      ER46239   LABEL="HEHC OTR RPT: EPILEPSY AGE 4--WF"                 format=f1.
      ER46240   LABEL="HEHC OTR RPT: EPILEPSY AGE 5--WF"                 format=f1.
      ER46241   LABEL="HEHC OTR RPT: EPILEPSY AGE 6--WF"                 format=f1.
      ER46242   LABEL="HEHC OTR RPT: EPILEPSY AGE 7--WF"                 format=f1.
      ER46243   LABEL="HEHC OTR RPT: EPILEPSY AGE 8--WF"                 format=f1.
      ER46244   LABEL="HEHC OTR RPT: EPILEPSY AGE 9--WF"                 format=f1.
      ER46245   LABEL="HEHC OTR RPT: EPILEPSY AGE 10--WF"                format=f1.
      ER46246   LABEL="HEHC OTR RPT: EPILEPSY AGE 11--WF"                format=f1.
      ER46247   LABEL="HEHC OTR RPT: EPILEPSY AGE 12--WF"                format=f1.
      ER46248   LABEL="HEHC OTR RPT: EPILEPSY AGE 13--WF"                format=f1.
      ER46249   LABEL="HEHC OTR RPT: EPILEPSY AGE 14--WF"                format=f1.
      ER46250   LABEL="HEHC OTR RPT: EPILEPSY AGE 15--WF"                format=f1.
      ER46251   LABEL="HEHC OTR RPT: EPILEPSY AGE 16--WF"                format=f1.
      ER46252   LABEL="HEHC OTR RPT: EPILEPSY AGE 17+--WF"               format=f1.
      ER46253   LABEL="HEHC OTR RPT: AGE END EPILEPSY--WF"               format=f3.
      ER46254   LABEL="HEHC OTR RPT: HEADACHE B4 AGE 1--WF"              format=f1.
      ER46255   LABEL="HEHC OTR RPT: HEADACHE AGE 1--WF"                 format=f1.
      ER46256   LABEL="HEHC OTR RPT: HEADACHE AGE 2--WF"                 format=f1.
      ER46257   LABEL="HEHC OTR RPT: HEADACHE AGE 3--WF"                 format=f1.
      ER46258   LABEL="HEHC OTR RPT: HEADACHE AGE 4--WF"                 format=f1.
      ER46259   LABEL="HEHC OTR RPT: HEADACHE AGE 5--WF"                 format=f1.
      ER46260   LABEL="HEHC OTR RPT: HEADACHE AGE 6--WF"                 format=f1.
      ER46261   LABEL="HEHC OTR RPT: HEADACHE AGE 7--WF"                 format=f1.
      ER46262   LABEL="HEHC OTR RPT: HEADACHE AGE 8--WF"                 format=f1.
      ER46263   LABEL="HEHC OTR RPT: HEADACHE AGE 9--WF"                 format=f1.
      ER46264   LABEL="HEHC OTR RPT: HEADACHE AGE 10--WF"                format=f1.
      ER46265   LABEL="HEHC OTR RPT: HEADACHE AGE 11--WF"                format=f1.
      ER46266   LABEL="HEHC OTR RPT: HEADACHE AGE 12--WF"                format=f1.
      ER46267   LABEL="HEHC OTR RPT: HEADACHE AGE 13--WF"                format=f1.
      ER46268   LABEL="HEHC OTR RPT: HEADACHE AGE 14--WF"                format=f1.
      ER46269   LABEL="HEHC OTR RPT: HEADACHE AGE 15--WF"                format=f1.
      ER46270   LABEL="HEHC OTR RPT: HEADACHE AGE 16--WF"                format=f1.
      ER46271   LABEL="HEHC OTR RPT: HEADACHE AGE 17+--WF"               format=f1.
      ER46272   LABEL="HEHC OTR RPT: AGE END HEADACHE--WF"               format=f3.
      ER46273   LABEL="HEHC OTR RPT: STOM PROB B4 AGE 1--WF"             format=f1.
      ER46274   LABEL="HEHC OTR RPT: STOM PROB AGE 1--WF"                format=f1.
      ER46275   LABEL="HEHC OTR RPT: STOM PROB AGE 2--WF"                format=f1.
      ER46276   LABEL="HEHC OTR RPT: STOM PROB AGE 3--WF"                format=f1.
      ER46277   LABEL="HEHC OTR RPT: STOM PROB AGE 4--WF"                format=f1.
      ER46278   LABEL="HEHC OTR RPT: STOM PROB AGE 5--WF"                format=f1.
      ER46279   LABEL="HEHC OTR RPT: STOM PROB AGE 6--WF"                format=f1.
      ER46280   LABEL="HEHC OTR RPT: STOM PROB AGE 7--WF"                format=f1.
      ER46281   LABEL="HEHC OTR RPT: STOM PROB AGE 8--WF"                format=f1.
      ER46282   LABEL="HEHC OTR RPT: STOM PROB AGE 9--WF"                format=f1.
      ER46283   LABEL="HEHC OTR RPT: STOM PROB AGE 10--WF"               format=f1.
      ER46284   LABEL="HEHC OTR RPT: STOM PROB AGE 11--WF"               format=f1.
      ER46285   LABEL="HEHC OTR RPT: STOM PROB AGE 12--WF"               format=f1.
      ER46286   LABEL="HEHC OTR RPT: STOM PROB AGE 13--WF"               format=f1.
      ER46287   LABEL="HEHC OTR RPT: STOM PROB AGE 14--WF"               format=f1.
      ER46288   LABEL="HEHC OTR RPT: STOM PROB AGE 15--WF"               format=f1.
      ER46289   LABEL="HEHC OTR RPT: STOM PROB AGE 16--WF"               format=f1.
      ER46290   LABEL="HEHC OTR RPT: STOM PROB AGE 17+--WF"              format=f1.
      ER46291   LABEL="HEHC OTR RPT: AGE END STOM PROB--WF"              format=f3.
      ER46292   LABEL="HEHC OTR RPT: HGH BLOOD PR B4 AGE 1--WF"          format=f1.
      ER46293   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 1--WF"             format=f1.
      ER46294   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 2--WF"             format=f1.
      ER46295   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 3--WF"             format=f1.
      ER46296   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 4--WF"             format=f1.
      ER46297   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 5--WF"             format=f1.
      ER46298   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 6--WF"             format=f1.
      ER46299   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 7--WF"             format=f1.
      ER46300   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 8--WF"             format=f1.
      ER46301   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 9--WF"             format=f1.
      ER46302   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 10--WF"            format=f1.
      ER46303   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 11--WF"            format=f1.
      ER46304   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 12--WF"            format=f1.
      ER46305   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 13--WF"            format=f1.
      ER46306   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 14--WF"            format=f1.
      ER46307   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 15--WF"            format=f1.
      ER46308   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 16--WF"            format=f1.
      ER46309   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 17+--WF"           format=f1.
      ER46310   LABEL="HEHC OTR RPT: AGE END HGH BLOOD PR--WF"           format=f3.
      ER46311   LABEL="HEHC OTR RPT: DEPRESSION B4 AGE 1--WF"            format=f1.
      ER46312   LABEL="HEHC OTR RPT: DEPRESSION AGE 1--WF"               format=f1.
      ER46313   LABEL="HEHC OTR RPT: DEPRESSION AGE 2--WF"               format=f1.
      ER46314   LABEL="HEHC OTR RPT: DEPRESSION AGE 3--WF"               format=f1.
      ER46315   LABEL="HEHC OTR RPT: DEPRESSION AGE 4--WF"               format=f1.
      ER46316   LABEL="HEHC OTR RPT: DEPRESSION AGE 5--WF"               format=f1.
      ER46317   LABEL="HEHC OTR RPT: DEPRESSION AGE 6--WF"               format=f1.
      ER46318   LABEL="HEHC OTR RPT: DEPRESSION AGE 7--WF"               format=f1.
      ER46319   LABEL="HEHC OTR RPT: DEPRESSION AGE 8--WF"               format=f1.
      ER46320   LABEL="HEHC OTR RPT: DEPRESSION AGE 9--WF"               format=f1.
      ER46321   LABEL="HEHC OTR RPT: DEPRESSION AGE 10--WF"              format=f1.
      ER46322   LABEL="HEHC OTR RPT: DEPRESSION AGE 11--WF"              format=f1.
      ER46323   LABEL="HEHC OTR RPT: DEPRESSION AGE 12--WF"              format=f1.
      ER46324   LABEL="HEHC OTR RPT: DEPRESSION AGE 13--WF"              format=f1.
      ER46325   LABEL="HEHC OTR RPT: DEPRESSION AGE 14--WF"              format=f1.
      ER46326   LABEL="HEHC OTR RPT: DEPRESSION AGE 15--WF"              format=f1.
      ER46327   LABEL="HEHC OTR RPT: DEPRESSION AGE 16--WF"              format=f1.
      ER46328   LABEL="HEHC OTR RPT: DEPRESSION AGE 17+--WF"             format=f1.
      ER46329   LABEL="HEHC OTR RPT: AGE END DEPRESSION--WF"             format=f3.
      ER46330   LABEL="HEHC OTR RPT: DRUG/AL PROB B4 AGE 1--WF"          format=f1.
      ER46331   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 1--WF"             format=f1.
      ER46332   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 2--WF"             format=f1.
      ER46333   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 3--WF"             format=f1.
      ER46334   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 4--WF"             format=f1.
      ER46335   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 5--WF"             format=f1.
      ER46336   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 6--WF"             format=f1.
      ER46337   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 7--WF"             format=f1.
      ER46338   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 8--WF"             format=f1.
      ER46339   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 9--WF"             format=f1.
      ER46340   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 10--WF"            format=f1.
      ER46341   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 11--WF"            format=f1.
      ER46342   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 12--WF"            format=f1.
      ER46343   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 13--WF"            format=f1.
      ER46344   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 14--WF"            format=f1.
      ER46345   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 15--WF"            format=f1.
      ER46346   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 16--WF"            format=f1.
      ER46347   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 17+--WF"           format=f1.
      ER46348   LABEL="HEHC OTR RPT: AGE END DRUG/AL PROB--WF"           format=f3.
      ER46349   LABEL="HEHC OTR RPT: OTR PSYCH PROB B4 AGE 1--W"         format=f1.
      ER46350   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 1--WF"           format=f1.
      ER46351   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 2--WF"           format=f1.
      ER46352   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 3--WF"           format=f1.
      ER46353   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 4--WF"           format=f1.
      ER46354   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 5--WF"           format=f1.
      ER46355   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 6--WF"           format=f1.
      ER46356   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 7--WF"           format=f1.
      ER46357   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 8--WF"           format=f1.
      ER46358   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 9--WF"           format=f1.
      ER46359   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 10--WF"          format=f1.
      ER46360   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 11--WF"          format=f1.
      ER46361   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 12--WF"          format=f1.
      ER46362   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 13--WF"          format=f1.
      ER46363   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 14--WF"          format=f1.
      ER46364   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 15--WF"          format=f1.
      ER46365   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 16--WF"          format=f1.
      ER46366   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 17+--WF"         format=f1.
      ER46367   LABEL="HEHC OTR RPT: AGE END OTR PSYCH PROB--WF"         format=f3.
      ER46368   LABEL="H49 WTR OTHERS IN FU IN POOR HEALTH"              format=f1.
      ER46369   LABEL="H59A SADNESS IN PAST 30 DAYS"                     format=f1.
      ER46370   LABEL="H59B NERVOUS IN PAST 30 DAYS"                     format=f1.
      ER46371   LABEL="H59C RESTLESS IN PAST 30 DAYS"                    format=f1.
      ER46372   LABEL="H59D HOPELESS IN PAST 30 DAYS"                    format=f1.
      ER46373   LABEL="H59E EVERYTHING EFFORT IN PAST 30 DAYS"           format=f1.
      ER46374   LABEL="H59F WORTHLESS IN PAST 30 DAYS"                   format=f1.
      ER46375   LABEL="K-6 NON-SPEC PSYCHOL DISTRESS SCALE"              format=f2.
      ER46376   LABEL="H59G MORE/LESS OFTEN THAN USUAL"                  format=f1.
      ER46377   LABEL="H59H LOT/SOMEWHAT/LITTLE MORE THAN USUAL"         format=f1.
      ER46378   LABEL="H59I LOT/SOMEWHAT/LITTLE LESS THAN USUAL"         format=f1.
      ER46379   LABEL="H59J HOW MUCH FEELINGS INTERFERE W/LIFE"          format=f1.
      ER46380   LABEL="H59K NUMBER OF DAYS UNABLE TO WORK"               format=f2.
      ER46381   LABEL="H59L NUMBER OF DAYS REDUCED WORK"                 format=f2.
      ER46382   LABEL="H60 WTR FU MEMBER W/HLTH INS LAST 2 YRS"          format=f1.
      ER46383   LABEL="H63 TOTAL PAID FOR HLTH INS LAST 2 YRS"           format=f6.
      ER46384   LABEL="H63A WTR AMT GE 2,500"                            format=f1.
      ER46385   LABEL="H63B WTR AMT GE 5,000"                            format=f1.
      ER46386   LABEL="H63C WTR AMT GE 1,000"                            format=f1.
      ER46387   LABEL="H64 TOTAL HOSPITAL/NURSNG HOME EXPENSES"          format=f6.
      ER46388   LABEL="H65 WTR TOTAL EXPENSE GE 1,000"                   format=f1.
      ER46389   LABEL="H66 WTR TOTAL EXPENSE GE 2,000"                   format=f1.
      ER46390   LABEL="H67 WTR TOTAL EXPENSE GE 8,000"                   format=f1.
      ER46391   LABEL="H68 WTR TOTAL EXPENSE GE 25,000"                  format=f1.
      ER46392   LABEL="H69 WTR TOTAL EXPENSE GE 500"                     format=f1.
      ER46393   LABEL="H70 TOT DR/OUTPT SURGRY/DENTAL EXPENSES"          format=f6.
      ER46394   LABEL="H71 WTR TOTAL EXPENSE GE 1,000"                   format=f1.
      ER46395   LABEL="H72 WTR TOTAL EXPENSE GE 2,500"                   format=f1.
      ER46396   LABEL="H73 WTR TOTAL EXPENSE GE 10,000"                  format=f1.
      ER46397   LABEL="H74 WTR TOTAL EXPENSE GE 500"                     format=f1.
      ER46398   LABEL="H75 WTR TOTAL EXPENSE GE 250"                     format=f1.
      ER46399   LABEL="H76 TOTAL PRESCRIPTN/OTR SVCS EXPENSES"           format=f6.
      ER46400   LABEL="H77 WTR TOTAL EXPENSE GE 500"                     format=f1.
      ER46401   LABEL="H78 WTR TOTAL EXPENSE GE 2,500"                   format=f1.
      ER46402   LABEL="H79 WTR TOTAL EXPENSE GE 10,000"                  format=f1.
      ER46403   LABEL="H81 WTR TOTAL EXPENSE GE 200"                     format=f1.
      ER46404   LABEL="H82 TOTAL COST ALL MEDICAL CARE"                  format=f8.
      ER46405   LABEL="H83 WTR TOTAL COST GE 10,000"                     format=f1.
      ER46406   LABEL="H84 WTR TOTAL COST GE 25,000"                     format=f1.
      ER46407   LABEL="H85 WTR TOTAL COST GE 75,000"                     format=f1.
      ER46408   LABEL="H86 WTR TOTAL COST GE 3,000"                      format=f1.
      ER46409   LABEL="H87 WTR TOTAL COST GE 1,000"                      format=f1.
      ER46410   LABEL="K1 CKPT: WTR NEW WIFE IN FU"                      format=f1.
      ER46411   LABEL="K2 STATE WHERE FATHER BORN-WF"                    format=f2.
      ER46412   LABEL="K3 STATE FATHER GREW UP-WF"                       format=f2.
      ER46413   LABEL="K4 WTR FATHER EDUCATED IN US-WF"                  format=f1.
      ER46414   LABEL="K5 EDUCATION OF FATHER IN US-WF"                  format=f2.
      ER46415   LABEL="K6 WTR FATHER READ/WRITE-WF"                      format=f1.
      ER46416   LABEL="K7 CKPT:  WTR FATHER ED ALL IN US-WF"             format=f1.
      ER46417   LABEL="K8 YRS FOREIGN EDUCATION OF FATHR-WF"             format=f2.
      ER46418   LABEL="K9 FOREIGN DEGREES OF FATHER-WF"                  format=f1.
      ER46419   LABEL="K10-10A OCCUPATION OF FATHER-WF"                  format=f3.
      ER46420   LABEL="K11 INDUSTRY OF FATHER-WF"                        format=f3.
      ER46421   LABEL="K12 STATE WHERE MOTHER BORN-WF"                   format=f2.
      ER46422   LABEL="K13 STATE MOTHER GREW UP-WF"                      format=f2.
      ER46423   LABEL="K14 WTR MOTHER EDUCATED IN US-WF"                 format=f1.
      ER46424   LABEL="K15 EDUCATION OF MOTHER IN US-WF"                 format=f2.
      ER46425   LABEL="K16 WTR MOTHER READ/WRITE-WF"                     format=f1.
      ER46426   LABEL="K17 CKPT:  WTR MOTHER ED ALL IN US-WF"            format=f1.
      ER46427   LABEL="K18 YRS FOREIGN EDUCATION OF MOTHR-WF"            format=f2.
      ER46428   LABEL="K19 FOREIGN DEGREES OF MOTHER-WF"                 format=f1.
      ER46429   LABEL="K20-20A OCCUPATION OF MOTHER-WF"                  format=f3.
      ER46430   LABEL="K21 INDUSTRY OF MOTHER-WF"                        format=f3.
      ER46431   LABEL="K22 WHETHER BROTHERS-WF"                          format=f1.
      ER46432   LABEL="K23 # BROTHERS-WIFE"                              format=f2.
      ER46433   LABEL="K24 WTR ONLY BRO STILL ALIVE-WF"                  format=f1.
      ER46434   LABEL="K25 WTR ONLY BRO OLDER THAN WIFE"                 format=f1.
      ER46435   LABEL="K26 # BROTHERS STILL ALIVE-WF"                    format=f2.
      ER46436   LABEL="K27 WTR ANY BRO OLDER THAN WIFE"                  format=f1.
      ER46437   LABEL="K28 WHETHER SISTERS-WF"                           format=f1.
      ER46438   LABEL="K29 # SISTERS-WIFE"                               format=f2.
      ER46439   LABEL="K30 WTR ONLY SIS STILL ALIVE-WF"                  format=f1.
      ER46440   LABEL="K31 WTR ONLY SIS OLDER THAN WIFE"                 format=f1.
      ER46441   LABEL="K32 # SISTERS STILL ALIVE-WF"                     format=f2.
      ER46442   LABEL="K33 WTR ANY SIS OLDER THAN WIFE"                  format=f1.
      ER46443   LABEL="K34 GREW UP FARM OR?-WF"                          format=f1.
      ER46444   LABEL="K35 STATE WHERE WIFE GREW UP"                     format=f2.
      ER46445   LABEL="K36 WTR EVER LIVED IN OTR STATE-WF"               format=f1.
      ER46446   LABEL="K37 PARENTS POOR OR?--WF"                         format=f1.
      ER46447   LABEL="K38 WTR LIVED W/BOTH PARENTS-WF"                  format=f1.
      ER46448   LABEL="K39 SPANISH DESCENT-WIFE"                         format=f1.
      ER46449   LABEL="K40 RACE OF WIFE-MENTION 1"                       format=f1.
      ER46450   LABEL="K40 RACE OF WIFE-MENTION 2"                       format=f1.
      ER46451   LABEL="K40 RACE OF WIFE-MENTION 3"                       format=f1.
      ER46452   LABEL="K40 RACE OF WIFE-MENTION 4"                       format=f1.
      ER46453   LABEL="K41 ETHNIC GROUP-WF"                              format=f1.
      ER46454   LABEL="K41 NATIONALITY MENTION 1-WF"                     format=f2.
      ER46455   LABEL="K41 NATIONALITY MENTION 2-WF"                     format=f2.
      ER46456   LABEL="K42 WTR EVER IN MILITARY-WF"                      format=f1.
      ER46457   LABEL="K43 WTR WIFE EDUCATED IN US"                      format=f1.
      ER46458   LABEL="K44 WTR GRADUATED HS-WF"                          format=f1.
      ER46459   LABEL="K45 MO GRADUATED HS-WF"                           format=f2.
      ER46460   LABEL="K45 YR GRADUATED HS-WF"                           format=f4.
      ER46461   LABEL="K46 GRADE LEVEL IF GED-WF"                        format=f2.
      ER46462   LABEL="K47 MO LAST IN SCHOOL IF GED-WF"                  format=f2.
      ER46463   LABEL="K47 YR LAST IN SCHOOL IF GED-WF"                  format=f4.
      ER46464   LABEL="K48 MO RECEIVED GED-WF"                           format=f2.
      ER46465   LABEL="K48 YR RECEIVED GED-WF"                           format=f4.
      ER46466   LABEL="K49 GRADE OF SCHOOL FINISHED-W"                   format=f2.
      ER46467   LABEL="K50 MO LAST IN SCHOOL-WF"                         format=f2.
      ER46468   LABEL="K50 YR LAST IN SCHOOL-WF"                         format=f4.
      ER46469   LABEL="K51 WTR ATTENDED COLLEGE-WF"                      format=f1.
      ER46470   LABEL="K52 MO LAST ATTENDED COLLEGE-WF"                  format=f2.
      ER46471   LABEL="K52 YR LAST ATTENDED COLLEGE-WF"                  format=f4.
      ER46472   LABEL="K53 HGHST YR COLL COMPLETED-WF"                   format=f1.
      ER46473   LABEL="K54 WTR RECD COLLEGE DEGREE-WF"                   format=f1.
      ER46474   LABEL="K55 HGHST COLLEGE DEGREE RECD-WF"                 format=f2.
      ER46475   LABEL="K58 MO RECD COLLEGE DEGREE-WF"                    format=f2.
      ER46476   LABEL="K58 YR RECD COLLEGE DEGREE-WF"                    format=f4.
      ER46477   LABEL="K60 YRS FOREIGN EDUCATION-WF"                     format=f2.
      ER46478   LABEL="K61 FOREIGN DEGREES-WIFE"                         format=f1.
      ER46479   LABEL="K62 WTR RECD OTR DEG/CERT-WF"                     format=f1.
      ER46480   LABEL="K63 TYPE 1ST OTR DEG/CERT-WF"                     format=f1.
      ER46481   LABEL="K64 FIELD 1ST OTR DEG/CERT-WF"                    format=f2.
      ER46482   LABEL="K65 INST/ORG OF 1ST OTR DEG/CERT-WF"              format=f2.
      ER46483   LABEL="K66 MO RECD 1ST OTR DEG/CERT-WF"                  format=f2.
      ER46484   LABEL="K66 YR RECD 1ST OTR DEG/CERT-WF"                  format=f4.
      ER46485   LABEL="K67 WTR 2ND DEGREE/CERT-WF"                       format=f1.
      ER46486   LABEL="K63 TYPE 2ND OTR DEG/CERT-WF"                     format=f1.
      ER46487   LABEL="K64 FIELD 2ND OTR DEG/CERT-WF"                    format=f2.
      ER46488   LABEL="K65 INST/ORG OF 2ND OTR DEG/CERT-WF"              format=f2.
      ER46489   LABEL="K66 MO RECD 2ND OTR DEG/CERT-WF"                  format=f2.
      ER46490   LABEL="K66 YR RECD 2ND OTR DEG/CERT-WF"                  format=f4.
      ER46491   LABEL="K67 WTR 3RD DEGREE/CERT-WF"                       format=f1.
      ER46492   LABEL="K63 TYPE 3RD OTR DEG/CERT-WF"                     format=f1.
      ER46493   LABEL="K64 FIELD 3RD OTR DEG/CERT-WF"                    format=f2.
      ER46494   LABEL="K65 INST/ORG OF 3RD OTR DEG/CERT-WF"              format=f2.
      ER46495   LABEL="K66 MO RECD 3RD OTR DEG/CERT-WF"                  format=f2.
      ER46496   LABEL="K66 YR RECD 3RD OTR DEG/CERT-WF"                  format=f4.
      ER46497   LABEL="K67 WTR 4TH DEGREE/CERT-WF"                       format=f1.
      ER46498   LABEL="K68 RELIGIOUS PREFERENCE-WF"                      format=f2.
      ER46499   LABEL="K69 RELIG DENOMINATION-WF"                        format=f2.
      ER46500   LABEL="K70 #YRS WRKD SINCE 18-WF"                        format=f2.
      ER46501   LABEL="K71 #YR WRKED FULLTIME-WF"                        format=f2.
      ER46502   LABEL="K72 OCCUPATION 1ST FULL TIME JOB-WF"              format=f3.
      ER46503   LABEL="K73 INDUSTRY 1ST FULL-TIME JOB-WF"                format=f3.
      ER46504   LABEL="L1 CKPT: WTR NEW HEAD IN FU"                      format=f1.
      ER46505   LABEL="L2 STATE WHERE FATHER BORN-HD"                    format=f2.
      ER46506   LABEL="L3 STATE FATHER GREW UP-HD"                       format=f2.
      ER46507   LABEL="L4 WTR FATHER EDUCATED IN US-HD"                  format=f1.
      ER46508   LABEL="L5 EDUCATION OF FATHER IN US-HD"                  format=f2.
      ER46509   LABEL="L6 WTR FATHER READ/WRITE-HD"                      format=f1.
      ER46510   LABEL="L7 CKPT:  WTR FATHER ED ALL IN US-HD"             format=f1.
      ER46511   LABEL="L8 YRS FOREIGN EDUCATION OF FATHR-HD"             format=f2.
      ER46512   LABEL="L9 FOREIGN DEGREES OF FATHER-HD"                  format=f1.
      ER46513   LABEL="L10-10A OCCUPATION OF FATHER-HD"                  format=f3.
      ER46514   LABEL="L11 INDUSTRY OF FATHER-HD"                        format=f3.
      ER46515   LABEL="L12 STATE WHERE MOTHER BORN-HD"                   format=f2.
      ER46516   LABEL="L13 STATE MOTHER GREW UP-HD"                      format=f2.
      ER46517   LABEL="L14 WTR MOTHER EDUCATED IN US-H"                  format=f1.
      ER46518   LABEL="L15 EDUCATION OF MOTHER IN US-HD"                 format=f2.
      ER46519   LABEL="L16 WTR MOTHER READ/WRITE-HD"                     format=f1.
      ER46520   LABEL="L17 CKPT:  WTR MOTHER ED ALL IN US-HD"            format=f1.
      ER46521   LABEL="L18 YRS FOREIGN EDUCATION OF MOTHR-HD"            format=f2.
      ER46522   LABEL="L19 FOREIGN DEGREES OF MOTHER-HD"                 format=f1.
      ER46523   LABEL="L20-20A OCCUPATION OF MOTHER-HD"                  format=f3.
      ER46524   LABEL="L21 INDUSTRY OF MOTHER-HD"                        format=f3.
      ER46525   LABEL="L22 WHETHER BROTHERS-HD"                          format=f1.
      ER46526   LABEL="L23 # BROTHERS-HEAD"                              format=f2.
      ER46527   LABEL="L24 WTR ONLY BRO STILL ALIVE-HD"                  format=f1.
      ER46528   LABEL="L25 WTR ONLY BRO OLDER THAN HEAD"                 format=f1.
      ER46529   LABEL="L26 # BROTHERS STILL ALIVE-HD"                    format=f2.
      ER46530   LABEL="L27 WTR ANY BRO OLDER THAN HEAD"                  format=f1.
      ER46531   LABEL="L28 WHETHER SISTERS-HD"                           format=f1.
      ER46532   LABEL="L29 # SISTERS-HEAD"                               format=f2.
      ER46533   LABEL="L30 WTR ONLY SIS STILL ALIVE-HD"                  format=f1.
      ER46534   LABEL="L31 WTR ONLY SIS OLDER THAN HEAD"                 format=f1.
      ER46535   LABEL="L32 # SISTERS STILL ALIVE-HD"                     format=f2.
      ER46536   LABEL="L33 WTR ANY SIS OLDER THAN HEAD"                  format=f1.
      ER46537   LABEL="L34 GREW UP FARM OR?-HD"                          format=f1.
      ER46538   LABEL="L35 STATE WHERE HEAD GREW UP"                     format=f2.
      ER46539   LABEL="L36 WTR EVER LIVED IN OTR STATE-HD"               format=f1.
      ER46540   LABEL="L37 PARENTS POOR OR?--HD"                         format=f1.
      ER46541   LABEL="L38 WTR LIVED W/BOTH PARENTS-HD"                  format=f1.
      ER46542   LABEL="L39 SPANISH DESCENT-HEAD"                         format=f1.
      ER46543   LABEL="L40 RACE OF HEAD-MENTION 1"                       format=f1.
      ER46544   LABEL="L40 RACE OF HEAD-MENTION 2"                       format=f1.
      ER46545   LABEL="L40 RACE OF HEAD-MENTION 3"                       format=f1.
      ER46546   LABEL="L40 RACE OF HEAD-MENTION 4"                       format=f1.
      ER46547   LABEL="L41 ETHNIC GROUP-HD"                              format=f1.
      ER46548   LABEL="L41 NATIONALITY MENTION 1-HD"                     format=f2.
      ER46549   LABEL="L41 NATIONALITY MENTION 2-HD"                     format=f2.
      ER46550   LABEL="L42 WTR EVER IN MILITARY-HD"                      format=f1.
      ER46551   LABEL="L43 WTR HEAD EDUCATED IN US"                      format=f1.
      ER46552   LABEL="L44 WTR GRADUATED HS-HD"                          format=f1.
      ER46553   LABEL="L45 MO GRADUATED HS-HD"                           format=f2.
      ER46554   LABEL="L45 YR GRADUATED HS-HD"                           format=f4.
      ER46555   LABEL="L46 GRADE LEVEL IF GED-HD"                        format=f2.
      ER46556   LABEL="L47 MO LAST IN SCHOOL IF GED-HD"                  format=f2.
      ER46557   LABEL="L47 YR LAST IN SCHOOL IF GED-HD"                  format=f4.
      ER46558   LABEL="L48 MO RECEIVED GED-HD"                           format=f2.
      ER46559   LABEL="L48 YR RECEIVED GED-HD"                           format=f4.
      ER46560   LABEL="L49 GRADE OF SCHOOL FINISHED-HD"                  format=f2.
      ER46561   LABEL="L50 MO LAST IN SCHOOL-HD"                         format=f2.
      ER46562   LABEL="L50 YR LAST IN SCHOOL-HD"                         format=f4.
      ER46563   LABEL="L51 WTR ATTENDED COLLEGE-HD"                      format=f1.
      ER46564   LABEL="L52 MO LAST ATTENDED COLLEGE-HD"                  format=f2.
      ER46565   LABEL="L52 YR LAST ATTENDED COLLEGE-HD"                  format=f4.
      ER46566   LABEL="L53 HGHST YR COLL COMPLETED-HD"                   format=f1.
      ER46567   LABEL="L54 WTR RECD COLLEGE DEGREE-HD"                   format=f1.
      ER46568   LABEL="L55 HGHST COLLEGE DEGREE RECD-HD"                 format=f2.
      ER46569   LABEL="L58 MO RECD COLLEGE DEGREE-HD"                    format=f2.
      ER46570   LABEL="L58 YR RECD COLLEGE DEGREE-HD"                    format=f4.
      ER46571   LABEL="L60 YRS FOREIGN EDUCATION-HD"                     format=f2.
      ER46572   LABEL="L61 FOREIGN DEGREES-HEAD"                         format=f1.
      ER46573   LABEL="L62 WTR REC OTR DEG/CERT-HD"                      format=f1.
      ER46574   LABEL="L63 TYPE 1ST OTR DEG/CERT-HD"                     format=f1.
      ER46575   LABEL="L64 FIELD 1ST OTR DEG/CERT-HD"                    format=f2.
      ER46576   LABEL="L65 INST/ORG OF 1ST OTR DEG/CERT-HD"              format=f2.
      ER46577   LABEL="L66 MO RECD 1ST OTR DEG/CERT-HD"                  format=f2.
      ER46578   LABEL="L66 YR RECD 1ST OTR DEG/CERT-HD"                  format=f4.
      ER46579   LABEL="L67 WTR 2ND DEGREE/CERT-HD"                       format=f1.
      ER46580   LABEL="L63 TYPE 2ND OTR DEG/CERT-HD"                     format=f1.
      ER46581   LABEL="L64 FIELD 2ND OTR DEG/CERT-HD"                    format=f2.
      ER46582   LABEL="L65 INST/ORG OF 2ND OTR DEG/CERT-HD"              format=f2.
      ER46583   LABEL="L66 MO RECD 2ND OTR DEG/CERT-HD"                  format=f2.
      ER46584   LABEL="L66 YR RECD 2ND OTR DEG/CERT-HD"                  format=f4.
      ER46585   LABEL="L67 WTR 3RD DEGREE/CERT-HD"                       format=f1.
      ER46586   LABEL="L63 TYPE 3RD OTR DEG/CERT-HD"                     format=f1.
      ER46587   LABEL="L64 FIELD 3RD OTR DEG/CERT-HD"                    format=f2.
      ER46588   LABEL="L65 INST/ORG OF 3RD OTR DEG/CERT-HD"              format=f2.
      ER46589   LABEL="L66 MO RECD 3RD OTR DEG/CERT-HD"                  format=f2.
      ER46590   LABEL="L66 YR RECD 3RD OTR DEG/CERT-HD"                  format=f4.
      ER46591   LABEL="L67 WTR 4TH DEGREE/CERT-HD"                       format=f1.
      ER46592   LABEL="L68 RELIGIOUS PREFERENCE-HD"                      format=f2.
      ER46593   LABEL="L69 RELIG DENOMINATION-HD"                        format=f2.
      ER46594   LABEL="L70 #YRS WRKD SINCE 18-HD"                        format=f2.
      ER46595   LABEL="L71 #YR WRKED FULLTIME-HD"                        format=f2.
      ER46596   LABEL="L72-72A OCCUPATION 1ST FULL TIME JOB-HD"          format=f3.
      ER46597   LABEL="L73 INDUSTRY 1ST FULL TIME JOB-HD"                format=f3.
      ER46598   LABEL="M1 WTR DONATION>25 TO CHARITY LAST YEAR"          format=f1.
      ER46599   LABEL="M2 WTR DONATED TO RELIGIOUS ORGANIZATION"         format=f1.
      ER46600   LABEL="M2A DOLLAR AMT OF RELIGIOUS DONATIONS"            format=f6.
      ER46601   LABEL="M2B WTR RELIGIOUS DONATIONS GE 300"               format=f1.
      ER46602   LABEL="M2C WTR RELIGIOUS DONATIONS GE 1,000"             format=f1.
      ER46603   LABEL="M2D WTR RELIGIOUS DONATIONS GE 2,500"             format=f1.
      ER46604   LABEL="M2E WTR RELIGIOUS DONATIONS GE 100"               format=f1.
      ER46605   LABEL="M3 WTR DONATD TO COMBO PURPOSE ORGANIZTN"         format=f1.
      ER46606   LABEL="M3A DOLLAR AMT OF COMBO DONATIONS"                format=f6.
      ER46607   LABEL="M3B WTR COMBO DONATIONS GE 200"                   format=f1.
      ER46608   LABEL="M3C WTR COMBO DONATIONS GE 500"                   format=f1.
      ER46609   LABEL="M3D WTR COMBO DONATIONS GE 1,000"                 format=f1.
      ER46610   LABEL="M3E WTR COMBO DONATIONS GE 100"                   format=f1.
      ER46611   LABEL="M4 WTR DONATED TO ORGANIZATION FOR NEEDY"         format=f1.
      ER46612   LABEL="M4A DOLLAR AMT OF NEEDY DONATIONS"                format=f5.
      ER46613   LABEL="M4B WTR NEEDY DONATIONS GE 200"                   format=f1.
      ER46614   LABEL="M4C WTR NEEDY DONATIONS GE 500"                   format=f1.
      ER46615   LABEL="M4D WTR NEEDY DONATIONS GE 1,000"                 format=f1.
      ER46616   LABEL="M4E WTR NEEDY DONATIONS GE 100"                   format=f1.
      ER46617   LABEL="M5 WTR DONATED TO ORGANIZATN FOR HEALTH"          format=f1.
      ER46618   LABEL="M5A DOLLAR AMT OF HEALTH DONATIONS"               format=f5.
      ER46619   LABEL="M5B WTR HEALTH DONATIONS GE 200"                  format=f1.
      ER46620   LABEL="M5C WTR HEALTH DONATIONS GE 500"                  format=f1.
      ER46621   LABEL="M5D WTR HEALTH DONATIONS GE 1,000"                format=f1.
      ER46622   LABEL="M5E WTR HEALTH DONATIONS GE 100"                  format=f1.
      ER46623   LABEL="M6 WTR DONATED TO ORGANZTION FOR EDUCATN"         format=f1.
      ER46624   LABEL="M6A DOLLAR AMT OF EDUCATION DONATIONS"            format=f5.
      ER46625   LABEL="M6B WTR EDUCATION DONATIONS GE 200"               format=f1.
      ER46626   LABEL="M6C WTR EDUCATION DONATIONS GE 500"               format=f1.
      ER46627   LABEL="M6D WTR EDUCATION DONATIONS GE 1,000"             format=f1.
      ER46628   LABEL="M6E WTR EDUCATION DONATIONS GE 100"               format=f1.
      ER46629   LABEL="M7 WTR DONATED TO YOUTH ORGANIZATIONS"            format=f1.
      ER46630   LABEL="M7A DOLLAR AMT OF YOUTH ORG DONATIONS"            format=f5.
      ER46631   LABEL="M7B WTR YOUTH ORG DONATIONS GE 200"               format=f1.
      ER46632   LABEL="M7C WTR YOUTH ORG DONATIONS GE 500"               format=f1.
      ER46633   LABEL="M7D WTR YOUTH ORG DONATIONS GE 1,000"             format=f1.
      ER46634   LABEL="M7E WTR YOUTH ORG DONATIONS GE 100"               format=f1.
      ER46635   LABEL="M8 WTR DONATED TO CULTURAL ORGS"                  format=f1.
      ER46636   LABEL="M8A DOLLAR AMT OF CULTURAL DONATIONS"             format=f5.
      ER46637   LABEL="M8B WTR CULTURAL DONATIONS GE 200"                format=f1.
      ER46638   LABEL="M8C WTR CULTURAL DONATIONS GE 500"                format=f1.
      ER46639   LABEL="M8D WTR CULTURAL DONATIONS GE 1,000"              format=f1.
      ER46640   LABEL="M8E WTR CULTURAL DONATIONS GE 100"                format=f1.
      ER46641   LABEL="M9 WTR DONATED TO COMMUNITY ORGS"                 format=f1.
      ER46642   LABEL="M9A DOLLAR AMT OF COMMUNITY DONATIONS"            format=f5.
      ER46643   LABEL="M9B WTR COMMUNITY DONATIONS GE 200"               format=f1.
      ER46644   LABEL="M9C WTR COMMUNITY DONATIONS GE 500"               format=f1.
      ER46645   LABEL="M9D WTR COMMUNITY DONATIONS GE 1,000"             format=f1.
      ER46646   LABEL="M9E WTR COMMUNITY DONATIONS GE 100"               format=f1.
      ER46647   LABEL="M10 WTR DONATED TO ENVIRONMENT ORGS"              format=f1.
      ER46648   LABEL="M10A DOLLAR AMT OF ENVIRONMENT DONATION"          format=f5.
      ER46649   LABEL="M10B WTR ENVIRONMENT DONATIONS GE 200"            format=f1.
      ER46650   LABEL="M10C WTR ENVIRONMENT DONATIONS GE 500"            format=f1.
      ER46651   LABEL="M10D WTR ENVIRONMENT DONATIONS GE 1,000"          format=f1.
      ER46652   LABEL="M10E WTR ENVIRONMENT DONATIONS GE 100"            format=f1.
      ER46653   LABEL="M11 WTR DONATED TO INTERNATL/PEACE ORG"           format=f1.
      ER46654   LABEL="M11A DOLLAR AMT OF INTERNATL/PEACE DNTN"          format=f5.
      ER46655   LABEL="M11B WTR INTERNATL/PEACE DNTNS GE 200"            format=f1.
      ER46656   LABEL="M11C WTR INTERNATL/PEACE DNTNS GE 500"            format=f1.
      ER46657   LABEL="M11D WTR INTERNATL/PEACE DNTNS GE 1,000"          format=f1.
      ER46658   LABEL="M11E WTR INTERNATL/PEACE DNTNS GE 100"            format=f1.
      ER46659   LABEL="M12 WTR DONATED TO OTHER ORGANIZATIONS"           format=f1.
      ER46660   LABEL="M12B DOLLAR AMT OF OTHER DONATIONS"               format=f5.
      ER46661   LABEL="M12C WTR OTHER DONATIONS GE 200"                  format=f1.
      ER46662   LABEL="M12D WTR OTHER DONATIONS GE 500"                  format=f1.
      ER46663   LABEL="M12E WTR OTHER DONATIONS GE 1,000"                format=f1.
      ER46664   LABEL="M12F WTR OTHER DONATIONS GE 100"                  format=f1.
      ER46665   LABEL="BC8 WTR UNEMPLOYED IN 2007 (HD)"                  format=f1.
      ER46666   LABEL="BC8 WEEKS UNEMPLOYED IN 2007 (HD)"                format=f2.
      ER46667   LABEL="BC7 WTR OUT LAB FRC IN 2007 (HD)"                 format=f1.
      ER46668   LABEL="BC7WKS OUT LABOR FORCE IN 2007 (HD)"              format=f2.
      ER46669   LABEL="WTR EMPLOYED IN 2007 (HD)"                        format=f1.
      ER46670   LABEL="WEEKS EMPLOYED IN 2007 (HD)"                      format=f2.
      ER46671   LABEL="BC14EE HOURS/WK WORKED IN 2007 (HD)"              format=f3.
      ER46672   LABEL="ACCURACY OF HRS/WK WORKED IN 2007 (HD)"           format=f1.
      ER46673   LABEL="R2 LABOR INCOME 2007 (HD)"                        format=f10.2
      ER46674   LABEL="R2 PER FOR LABOR INCOME 2007 (HD)"                format=f1.
      ER46675   LABEL="ACCURACY OF LABOR INCOME 2007 (HD)"               format=f1.
      ER46676   LABEL="DE8 WTR UNEMPLOYED IN 2007 (WF)"                  format=f1.
      ER46677   LABEL="DE8 WEEKS UNEMPLOYED IN 2007 (WF)"                format=f2.
      ER46678   LABEL="DE7 WTR OUT LAB FRC IN 2007 (WF)"                 format=f1.
      ER46679   LABEL="DE7WKS OUT LABOR FORCE IN 2007 (WF)"              format=f2.
      ER46680   LABEL="WTR EMPLOYED IN 2007 (WF)"                        format=f1.
      ER46681   LABEL="WEEKS EMPLOYED IN 2007 (WF)"                      format=f2.
      ER46682   LABEL="DE14EE HOURS/WK WORKED IN 2007 (WF)"              format=f3.
      ER46683   LABEL="ACCURACY OF HRS/WK WORKED IN 2007 (WF)"           format=f1.
      ER46684   LABEL="R11 LABOR INCOME 2007 (WF)"                       format=f10.2
      ER46685   LABEL="R11 PER FOR LABOR INCOME 2007 (WF)"               format=f1.
      ER46686   LABEL="ACCURACY OF LABOR INCOME 2007 (WF)"               format=f1.
      ER46687   LABEL="R20 WTR RECD SOC SECURITY YR BEFORE LAST"         format=f1.
      ER46688   LABEL="R25 WTR RECD RETIREMENT YR BEFORE LAST"           format=f1.
      ER46689   LABEL="R29 WTR RECD VA PENSION YR BEFORE LAST"           format=f1.
      ER46690   LABEL="R33 WTR RECD UNEMP COMP YR BEFORE LAST"           format=f1.
      ER46691   LABEL="R37 WTR RECD WORKERS COMP YR BEFORE LAST"         format=f1.
      ER46692   LABEL="R41 WTR RECD TANF (ADC) YR B4 LAST"               format=f1.
      ER46693   LABEL="R47 WTR RECEIVED SSI YR BEFORE LAST"              format=f1.
      ER46694   LABEL="R51 WTR RECEIVED OTR WELFARE YR B4 LAST"          format=f1.
      ER46695   LABEL="R55 WTR REC CH SUPP/ALIMONY YR B4 LAST"           format=f1.
      ER46696   LABEL="WTR RECORD IN DUST SUPPLEMENT - 2009"             format=f1.
      ER46697   LABEL="WHO WAS RESPONDENT"                               format=f1.
      ER46698   LABEL="# CALLS FOR IW"                                   format=f3.
      ER46699   LABEL="LANGUAGE OF INTERVIEW"                            format=f1.
      ER46700   LABEL="IO26 WTR HOSTILE TO ASKING MED #"                 format=f1.
      ER46701   LABEL="IO26 WTR NOT TRUTHFUL TO ASKING MED #"            format=f1.
      ER46702   LABEL="IO26 WTR NOT ABLE TO REMEMBER MED #"              format=f1.
      ER46703   LABEL="IO26 WTR CONF/PRIV CRNS ABOUT MED #"              format=f1.
      ER46704   LABEL="IO26 WTR NO NEG TO ASKING MED #"                  format=f1.
      ER46705   LABEL="IO26 WTR OTR REACTION TO ASKING MED #"            format=f1.
      ER46706   LABEL="IO28 WTR HELP W SCT A - HLPR 1"                   format=f1.
      ER46707   LABEL="IO28 WTR HELP W SCT BC EHC - HLPR 1"              format=f1.
      ER46708   LABEL="IO28 WTR HELP W SCT BC OTHER - HLPR 1"            format=f1.
      ER46709   LABEL="IO28 WTR HELP W SCT DE EHC - HLPR 1"              format=f1.
      ER46710   LABEL="IO28 WTR HELP W SCT DE OTHER - HLPR 1"            format=f1.
      ER46711   LABEL="IO28 WTR HELP W SCT F - HLPR 1"                   format=f1.
      ER46712   LABEL="IO28 WTR HELP W SCT G - HLPR 1"                   format=f1.
      ER46713   LABEL="IO28 WTR HELP W SCT R - HLPR 1"                   format=f1.
      ER46714   LABEL="IO28 WTR HELP W SCT W - HLPR 1"                   format=f1.
      ER46715   LABEL="IO28 WTR HELP W SCT P - HLPR 1"                   format=f1.
      ER46716   LABEL="IO28 WTR HELP W SCT H - HLPR 1"                   format=f1.
      ER46717   LABEL="IO28 WTR HELP W SCT HEHC SCRN - HLPR 1"           format=f1.
      ER46718   LABEL="IO28 WTR HELP W SCT HEHC - HLPR 1"                format=f1.
      ER46719   LABEL="IO28 WTR HELP W SCT J - HLPR 1"                   format=f1.
      ER46720   LABEL="IO28 WTR HELP W SCT KL - HLPR 1"                  format=f1.
      ER46721   LABEL="IO28 WTR HELP W SCT M - HLPR 1"                   format=f1.
      ER46722   LABEL="IO28 WTR HELP W ADDR - HLPR 1"                    format=f1.
      ER46723   LABEL="IO28 WTR HELP W OTHER- HLPR 1"                    format=f1.
      ER46724   LABEL="IO28 WTR HELP W SCT A - HLPR 2"                   format=f1.
      ER46725   LABEL="IO28 WTR HELP W SCT BC EHC - HLPR 2"              format=f1.
      ER46726   LABEL="IO28 WTR HELP W SCT BC OTHER - HLPR 2"            format=f1.
      ER46727   LABEL="IO28 WTR HELP W SCT DE EHC - HLPR 2"              format=f1.
      ER46728   LABEL="IO28 WTR HELP W SCT DE OTHER - HLPR 2"            format=f1.
      ER46729   LABEL="IO28 WTR HELP W SCT F - HLPR 2"                   format=f1.
      ER46730   LABEL="IO28 WTR HELP W SCT G - HLPR 2"                   format=f1.
      ER46731   LABEL="IO28 WTR HELP W SCT R - HLPR 2"                   format=f1.
      ER46732   LABEL="IO28 WTR HELP W SCT W - HLPR 2"                   format=f1.
      ER46733   LABEL="IO28 WTR HELP W SCT P - HLPR 2"                   format=f1.
      ER46734   LABEL="IO28 WTR HELP W SCT H - HLPR 2"                   format=f1.
      ER46735   LABEL="IO28 WTR HELP W SCT HEHC SCRN - HLPR 2"           format=f1.
      ER46736   LABEL="IO28 WTR HELP W SCT HEHC - HLPR 2"                format=f1.
      ER46737   LABEL="IO28 WTR HELP W SCT J - HLPR 2"                   format=f1.
      ER46738   LABEL="IO28 WTR HELP W SCT KL - HLPR 2"                  format=f1.
      ER46739   LABEL="IO28 WTR HELP W SCT M - HLPR 2"                   format=f1.
      ER46740   LABEL="IO28 WTR HELP W ADDR - HLPR 2"                    format=f1.
      ER46741   LABEL="IO28 WTR HELP W OTHER- HLPR 2"                    format=f1.
      ER46742   LABEL="IO28 WTR HELP W SCT A - HLPR 3"                   format=f1.
      ER46743   LABEL="IO28 WTR HELP W SCT BC EHC - HLPR 3"              format=f1.
      ER46744   LABEL="IO28 WTR HELP W SCT BC OTHER - HLPR 3"            format=f1.
      ER46745   LABEL="IO28 WTR HELP W SCT DE EHC - HLPR 3"              format=f1.
      ER46746   LABEL="IO28 WTR HELP W SCT DE OTHER - HLPR 3"            format=f1.
      ER46747   LABEL="IO28 WTR HELP W SCT F - HLPR 3"                   format=f1.
      ER46748   LABEL="IO28 WTR HELP W SCT G - HLPR 3"                   format=f1.
      ER46749   LABEL="IO28 WTR HELP W SCT R - HLPR 3"                   format=f1.
      ER46750   LABEL="IO28 WTR HELP W SCT W - HLPR 3"                   format=f1.
      ER46751   LABEL="IO28 WTR HELP W SCT P - HLPR 3"                   format=f1.
      ER46752   LABEL="IO28 WTR HELP W SCT H - HLPR 3"                   format=f1.
      ER46753   LABEL="IO28 WTR HELP W SCT HEHC SCRN - HLPR 3"           format=f1.
      ER46754   LABEL="IO28 WTR HELP W SCT HEHC - HLPR 3"                format=f1.
      ER46755   LABEL="IO28 WTR HELP W SCT J - HLPR 3"                   format=f1.
      ER46756   LABEL="IO28 WTR HELP W SCT KL - HLPR 3"                  format=f1.
      ER46757   LABEL="IO28 WTR HELP W SCT M - HLPR 3"                   format=f1.
      ER46758   LABEL="IO28 WTR HELP W ADDR - HLPR 3"                    format=f1.
      ER46759   LABEL="IO28 WTR HELP W OTHER- HLPR 3"                    format=f1.
      ER46760   LABEL="# OF INDIVIDUAL RECORDS"                          format=f2.
      ER46761   LABEL="HEAD WORK WEEKS-2008"                             format=f4.1
      ER46762   LABEL="ACCURACY HEAD WORK WEEKS-2008"                    format=f1.
      ER46763   LABEL="HEAD WEEKLY WORK HOURS-2008"                      format=f3.
      ER46764   LABEL="ACCURACY HEAD WEEKLY WORK HOURS-2008"             format=f1.
      ER46765   LABEL="HD OVERTIME WORK HOURS-2008"                      format=f4.
      ER46766   LABEL="ACCURACY HD OVERTIME WORK HOURS-2008"             format=f1.
      ER46767   LABEL="HEAD TOTAL HOURS OF WORK-2008"                    format=f4.
      ER46768   LABEL="HD WEEKS MISSED FOR ILLNESS OF OTRS-2008"         format=f4.1
      ER46769   LABEL="ACC HD WKS MISSED ILLNESS OF OTRS-2008"           format=f1.
      ER46770   LABEL="HD WEEKS MISSED FOR OWN ILLNESS-2008"             format=f4.1
      ER46771   LABEL="ACC HD WKS MISSED FOR OWN ILLNESS-2008"           format=f1.
      ER46772   LABEL="HEAD WEEKS OFF FOR VACATION-2008"                 format=f4.1
      ER46773   LABEL="ACC HEAD WEEKS OFF FOR VACATION-2008"             format=f1.
      ER46774   LABEL="HEAD STRIKE WEEKS-2008"                           format=f4.1
      ER46775   LABEL="ACCURACYHEAD STRIKE WEEKS-2008"                   format=f1.
      ER46776   LABEL="HEAD WEEKS LAID OFF-2008"                         format=f4.1
      ER46777   LABEL="ACCURACY HEAD WEEKS LAID OFF-2008"                format=f1.
      ER46778   LABEL="HEAD UNEMPLOYMENT WEEKS-2008"                     format=f4.1
      ER46779   LABEL="ACCURACY HEAD UNEMPLOYMENT WEEKS-2008"            format=f1.
      ER46780   LABEL="HEAD WEEKS OUT OF LABOR FORCE-2008"               format=f4.1
      ER46781   LABEL="ACC HEAD WEEKS OUT OF LABOR FORCE-2008"           format=f1.
      ER46782   LABEL="WIFE WORK WEEKS-2008"                             format=f4.1
      ER46783   LABEL="ACCURACY WIFE WORK WEEKS-2008"                    format=f1.
      ER46784   LABEL="WIFE WEEKLY WORK HOURS-2008"                      format=f3.
      ER46785   LABEL="ACCURACY WIFE WEEKLY WORK HOURS-2008"             format=f1.
      ER46786   LABEL="WF OVERTIME WORK HOURS-2008"                      format=f4.
      ER46787   LABEL="ACCURACY WF OVERTIME WORK HOURS-2008"             format=f1.
      ER46788   LABEL="WIFE TOTAL HOURS OF WORK-2008"                    format=f4.
      ER46789   LABEL="WF WEEKS MISSED FOR ILLNESS OF OTRS-2008"         format=f4.1
      ER46790   LABEL="ACC WF WKS MISSED ILLNESS OF OTRS-2008"           format=f1.
      ER46791   LABEL="WF WEEKS MISSED FOR OWN ILLNESS-2008"             format=f4.1
      ER46792   LABEL="ACC WF WKS MISSED FOR OWN ILLNESS-2008"           format=f1.
      ER46793   LABEL="WIFE WEEKS OFF FOR VACATION-2008"                 format=f4.1
      ER46794   LABEL="ACC WIFE WEEKS OFF FOR VACATION-2008"             format=f1.
      ER46795   LABEL="WIFE STRIKE WEEKS-2008"                           format=f4.1
      ER46796   LABEL="ACCURACY WIFE STRIKE WEEKS-2008"                  format=f1.
      ER46797   LABEL="WIFE WEEKS LAID OFF-2008"                         format=f4.1
      ER46798   LABEL="ACCURACY WIFE WEEKS LAID OFF-2008"                format=f1.
      ER46799   LABEL="WIFE UNEMPLOYMENT WEEKS-2008"                     format=f4.1
      ER46800   LABEL="ACCURACY WIFE UNEMPLOYMENT WEEKS-2008"            format=f1.
      ER46801   LABEL="WIFE WEEKS OUT OF LABOR FORCE-2008"               format=f4.1
      ER46802   LABEL="ACC WIFE WEEKS OUT OF LABOR FORCE-2008"           format=f1.
      ER46803   LABEL="TOTAL BUSINESS INCOME-2008"                       format=f7.
      ER46804   LABEL="ACC BUSINESS INCOME-2008"                         format=f1.
      ER46805   LABEL="NUMBER OF BUSINESSES OWNED BY FU IN 2008"         format=f1.
      ER46806   LABEL="FARM INCOME OF HEAD-2008"                         format=f7.
      ER46807   LABEL="ACC FARM INCOME OF HEAD-2008"                     format=f1.
      ER46808   LABEL="HD LABOR INCOME FROM BUSINESS-2008"               format=f7.
      ER46809   LABEL="HD ASSET INCOME FROM BUSINESS-2008"               format=f7.
      ER46810   LABEL="NUMBER OF BUSINESSES OWNED BY HEAD"               format=f1.
      ER46811   LABEL="WAGES AND SALARIES OF HEAD-2008"                  format=f7.
      ER46812   LABEL="ACC WAGES AND SALARIES OF HEAD-2008"              format=f1.
      ER46813   LABEL="BONUS INCOME OF HEAD-2008"                        format=f6.
      ER46814   LABEL="ACC BONUS INCOME OF HEAD-2008"                    format=f1.
      ER46815   LABEL="OVERTIME INCOME OF HEAD-2008"                     format=f6.
      ER46816   LABEL="ACC OVERTIME INCOME OF HEAD-2008"                 format=f1.
      ER46817   LABEL="TIPS OF HEAD-2008"                                format=f6.
      ER46818   LABEL="ACC TIPS OF HEAD-2008"                            format=f1.
      ER46819   LABEL="COMMISSION INCOME OF HEAD-2008"                   format=f6.
      ER46820   LABEL="ACC COMMISSION INCOME OF HEAD-2008"               format=f1.
      ER46821   LABEL="PROFESSIONAL PRACTICE OF HEAD-2008"               format=f7.
      ER46822   LABEL="ACC PROFESSIONL PRACTICE OF HD-2008"              format=f1.
      ER46823   LABEL="MARKET GARDENING INCOME OF HD-2008"               format=f7.
      ER46824   LABEL="ACC MARKET GARDENING INCOME OF HEAD"              format=f1.
      ER46825   LABEL="HEAD ADDITIONAL JOB INCOME-2008"                  format=f7.
      ER46826   LABEL="ACC OF HEAD ADDITIONAL JOB INCOME"                format=f1.
      ER46827   LABEL="MISC LABOR INCOME OF HEAD-2008"                   format=f6.
      ER46828   LABEL="ACC MISC LABOR INCOME OF HEAD-2008"               format=f1.
      ER46829   LABEL="LABOR INCOME OF HEAD-2008"                        format=f7.
      ER46830   LABEL="HEAD RENT INCOME-2008"                            format=f6.
      ER46831   LABEL="ACCURACY OF HEAD RENT INCOME-2008"                format=f1.
      ER46832   LABEL="HEAD DIVIDENDS-2008"                              format=f6.
      ER46833   LABEL="ACCURACY OF HEAD DIVIDENDS-2008"                  format=f1.
      ER46834   LABEL="HEAD INTEREST INCOME-2008"                        format=f6.
      ER46835   LABEL="ACCURACY OF HEAD INTEREST INCOME-2008"            format=f1.
      ER46836   LABEL="HEAD INCOME FROM TRUSTS/ROYALTIES-2008"           format=f6.
      ER46837   LABEL="ACCURACY OF HD INCOME FROM TRUSTS-2008"           format=f1.
      ER46838   LABEL="WF LABOR INCOME FROM BUSINESS-2008"               format=f7.
      ER46839   LABEL="WF ASSET INCOME FROM BUSINESS-2008"               format=f7.
      ER46840   LABEL="NUMBER OF BUSINESSES OWNED BY WIFE"               format=f1.
      ER46841   LABEL="LABOR INCOME OF WIFE-2008"                        format=f7.
      ER46842   LABEL="ACC LABOR INCOME OF WIFE-2008"                    format=f1.
      ER46843   LABEL="WIFE RENT INCOME-2008"                            format=f6.
      ER46844   LABEL="ACCURACY OF WIFE RENT INCOME-2008"                format=f1.
      ER46845   LABEL="WIFE DIVIDENDS-2008"                              format=f6.
      ER46846   LABEL="ACCURACY OF WIFE DIVIDENDS-2008"                  format=f1.
      ER46847   LABEL="WIFE INTEREST INCOME-2008"                        format=f6.
      ER46848   LABEL="ACCURACY OF WIFE INTEREST INCOME-2008"            format=f1.
      ER46849   LABEL="WIFE INCOME FROM TRUSTS/ROYALTIES-2008"           format=f6.
      ER46850   LABEL="ACCURACY OF WF INCOME FROM TRUSTS-2008"           format=f1.
      ER46851   LABEL="HEAD AND WIFE TAXABLE INCOME-2008"                format=f7.
      ER46852   LABEL="HEAD INCOME FROM TANF, ETC.-2008"                 format=f6.
      ER46853   LABEL="ACCURACY OF HEAD INCOME FROM TANF-2008"           format=f1.
      ER46854   LABEL="HEAD SSI-2008"                                    format=f6.
      ER46855   LABEL="ACCURACY OF HEAD SSI-2008"                        format=f1.
      ER46856   LABEL="HEAD OTHER WELFARE-2008"                          format=f6.
      ER46857   LABEL="ACCURACY OF HEAD OTHER WELFARE-2008"              format=f1.
      ER46858   LABEL="HEAD VA PENSION-2008"                             format=f6.
      ER46859   LABEL="ACCURACY OF HEAD VA PENSION-2008"                 format=f1.
      ER46860   LABEL="HEAD RETIREMENT/PENSIONS-2008"                    format=f6.
      ER46861   LABEL="ACCURACY OF HEAD RETIREMENT-2008"                 format=f1.
      ER46862   LABEL="HEAD ANNUITIES-2008"                              format=f6.
      ER46863   LABEL="ACCURACY OF HEAD ANNUITIES-2008"                  format=f1.
      ER46864   LABEL="HEAD OTHER RETIREMENT-2008"                       format=f6.
      ER46865   LABEL="ACCURACY OF HEAD OTHER RETIREMENT-2008"           format=f1.
      ER46866   LABEL="HEAD UNEMPLOYMENT COMPENSATION-2008"              format=f6.
      ER46867   LABEL="ACCURACY OF HEAD UNEMPLOYMENT COMP-2008"          format=f1.
      ER46868   LABEL="HEAD WORKERS COMPENSATION-2008"                   format=f6.
      ER46869   LABEL="ACCURACY OF HEAD WORKERS COMP-2008"               format=f1.
      ER46870   LABEL="CHILD SUPPORT RECEIVED BY HEAD-2008"              format=f6.
      ER46871   LABEL="ACCURACY OF HEAD CHILD SUPPORT-2008"              format=f1.
      ER46872   LABEL="HEAD INCOME FROM ALIMONY-2008"                    format=f6.
      ER46873   LABEL="ACCURACY OF HEAD ALIMONY-2008"                    format=f1.
      ER46874   LABEL="HEAD HELP FROM RELATIVES-2008"                    format=f6.
      ER46875   LABEL="ACCURACY OF HEAD HELP FROM RELS-2008"             format=f1.
      ER46876   LABEL="HEAD HELP FROM OTHERS-2008"                       format=f6.
      ER46877   LABEL="ACCURACY OF HEAD HELP FROM OTHERS-2008"           format=f1.
      ER46878   LABEL="HEAD MISCELLANEOUS TRANSFERS-2008"                format=f6.
      ER46879   LABEL="ACCURACY OF HD MISC TRANSFERS-2008"               format=f1.
      ER46880   LABEL="WIFE INCOME FROM TANF, ETC.-2008"                 format=f6.
      ER46881   LABEL="ACCURACY OF WIFE INCOME FROM TANF-2008"           format=f1.
      ER46882   LABEL="WIFE SSI-2008"                                    format=f6.
      ER46883   LABEL="ACCURACY OF WIFE SSI-2008"                        format=f1.
      ER46884   LABEL="WIFE OTHER WELFARE-2008"                          format=f6.
      ER46885   LABEL="ACCURACY OF WIFE OTHER WELFARE-2008"              format=f1.
      ER46886   LABEL="WIFE RETIREMENT/ANNUITIES-2008"                   format=f6.
      ER46887   LABEL="ACCURACY OF WIFE RETIREMENT-2008"                 format=f1.
      ER46888   LABEL="WIFE UNEMPLOYMENT COMPENSATION-2008"              format=f6.
      ER46889   LABEL="ACCURACY OF WIFE UNEMPLOYMENT COMP-2008"          format=f1.
      ER46890   LABEL="WIFE WORKERS COMPENSATION-2008"                   format=f6.
      ER46891   LABEL="ACCURACY OF WIFE WORKERS COMP-2008"               format=f1.
      ER46892   LABEL="CHILD SUPPORT RECEIVED BY WIFE-2008"              format=f6.
      ER46893   LABEL="ACCURACY OF WIFE CHILD SUPPORT-2008"              format=f1.
      ER46894   LABEL="WIFE HELP FROM RELATIVES-2008"                    format=f6.
      ER46895   LABEL="ACCURACY OF WIFE HELP FROM RELS-2008"             format=f1.
      ER46896   LABEL="WIFE HELP FROM OTHERS-2008"                       format=f6.
      ER46897   LABEL="ACCURACY OF WIFE HELP FROM OTHERS-2008"           format=f1.
      ER46898   LABEL="WIFE MISCELLANEOUS TRANSFERS-2008"                format=f6.
      ER46899   LABEL="ACCURACY OF WF MISC TRANSFERS-2008"               format=f1.
      ER46900   LABEL="HEAD AND WIFE TRANSFER INCOME-2008"               format=f7.
      ER46901   LABEL="HEAD WAGE RATE-2008"                              format=f6.2
      ER46902   LABEL="WIFE WAGE RATE-2008"                              format=f6.2
      ER46903   LABEL="TOTAL LABOR INCOME OF OTR FU MEMBRS-2008"         format=f7.
      ER46904   LABEL="ACCURACY OF OTR FU MEMBR LABOR Y-2008"            format=f1.
      ER46905   LABEL="TOTAL ASSET INCOME OF OTR FU MEMBRS-2008"         format=f6.
      ER46906   LABEL="ACCURACY OF OTR FU MEMBR ASSET Y-2008"            format=f1.
      ER46907   LABEL="TAXABLE INCOME OF OTHER FU MEMBERS-2008"          format=f7.
      ER46908   LABEL="OTR FU MEMBR INCOME FROM TANF, ETC.-2008"         format=f6.
      ER46909   LABEL="ACCURACY OF OFUM INCOME FROM TANF-2008"           format=f1.
      ER46910   LABEL="OTR FU MEMBERS SSI-2008"                          format=f6.
      ER46911   LABEL="ACCURACY OF OTR FU MEMBERS SSI-2008"              format=f1.
      ER46912   LABEL="OTR FU MEMBERS OTHER WELFARE-2008"                format=f6.
      ER46913   LABEL="ACCURACY OF OFUM OTHER WELFARE-2008"              format=f1.
      ER46914   LABEL="OTHER FU MEMBERS VA PENSION-2008"                 format=f6.
      ER46915   LABEL="ACCURACY OF OTR FU MEMBR VA PENSION-2008"         format=f1.
      ER46916   LABEL="OTHER FU MEMBR RETIREMENT/ANNUITIES-2008"         format=f6.
      ER46917   LABEL="ACCURACY OF OFUM RETIREMENT-2008"                 format=f1.
      ER46918   LABEL="OFUM UNEMPLOYMENT COMPENSATION-2008"              format=f6.
      ER46919   LABEL="ACCURACY OF OFUM UNEMPLOYMENT COMP-2008"          format=f1.
      ER46920   LABEL="OTR FU MEMBERS WORKERS COMPENSATION-2008"         format=f6.
      ER46921   LABEL="ACCURACY OF OFUM WORKERS COMP-2008"               format=f1.
      ER46922   LABEL="OFUM INCOME FROM CHILD SUPPORT-2008"              format=f6.
      ER46923   LABEL="ACCURACY OF OFUM CHILD SUPPORT-2008"              format=f1.
      ER46924   LABEL="OTR FU MEMBERS HELP FROM RELATIVES-2008"          format=f6.
      ER46925   LABEL="ACCURACY OF OFUM HELP FROM RELS-2008"             format=f1.
      ER46926   LABEL="OFUM MISCELLANEOUS TRANSFERS-2008"                format=f6.
      ER46927   LABEL="ACCURACY OF OFUM MISC TRANSFERS-2008"             format=f1.
      ER46928   LABEL="TOTAL TRANSFER INCOME OF OFUMS-2008"              format=f6.
      ER46929   LABEL="HEAD SOCIAL SECURITY INCOME-2008"                 format=f6.
      ER46930   LABEL="ACCURACY OF HEAD SOCIAL SECURITY-2008"            format=f1.
      ER46931   LABEL="WIFE SOCIAL SECURITY INCOME-2008"                 format=f6.
      ER46932   LABEL="ACCURACY OF WIFE SOCIAL SECURITY-2008"            format=f1.
      ER46933   LABEL="OFUM SOCIAL SECURITY INCOME-2008"                 format=f6.
      ER46934   LABEL="ACCURACY OF OFUM SOCIAL SECURITY-2008"            format=f1.
      ER46935   LABEL="TOTAL FAMILY INCOME-2008"                         format=f7.
      ER46936   LABEL="IMP WTR FARM/BUS (W10) 09"                        format=f1.
      ER46937   LABEL="ACC WTR FARM/BUS (W10) 09"                        format=f1.
      ER46938   LABEL="IMP VALUE FARM/BUS (W11) 09"                      format=f9.
      ER46939   LABEL="ACC VALUE FARM/BUS (W11) 09"                      format=f1.
      ER46940   LABEL="IMP WTR CHECKING/SAVING (W27) 09"                 format=f1.
      ER46941   LABEL="ACC WTR CHECKING/SAVING (W27) 09"                 format=f1.
      ER46942   LABEL="IMP VAL CHECKING/SAVING (W28) 09"                 format=f9.
      ER46943   LABEL="ACC VAL CHECKING/SAVING (W28) 09"                 format=f1.
      ER46944   LABEL="IMP WTR OTH DEBT (W38) 09"                        format=f1.
      ER46945   LABEL="ACC WTR OTH DEBT (W38) 09"                        format=f1.
      ER46946   LABEL="IMP VALUE OTH DEBT (W39) 09"                      format=f9.
      ER46947   LABEL="ACC VALUE OTH DEBT (W39) 09"                      format=f1.
      ER46948   LABEL="IMP WTR OTH REAL ESTATE (W1) 09"                  format=f1.
      ER46949   LABEL="ACC WTR OTH REAL ESTATE (W1) 09"                  format=f1.
      ER46950   LABEL="IMP VAL OTH REAL ESTATE (W2) 09"                  format=f9.
      ER46951   LABEL="ACC VAL OTH REAL ESTATE (W2) 09"                  format=f1.
      ER46952   LABEL="IMP WTR STOCKS (W15) 09"                          format=f1.
      ER46953   LABEL="ACC WTR STOCKS (W15) 09"                          format=f1.
      ER46954   LABEL="IMP VALUE STOCKS (W16) 09"                        format=f9.
      ER46955   LABEL="ACC VALUE STOCKS (W16) 09"                        format=f1.
      ER46956   LABEL="IMP VALUE VEHICLES (W6) 09"                       format=f9.
      ER46957   LABEL="ACC VALUE VEHICLES (W6) 09"                       format=f1.
      ER46958   LABEL="IMP WTR OTH ASSETS (W33) 09"                      format=f1.
      ER46959   LABEL="ACC WTR OTH ASSETS (W33) 09"                      format=f1.
      ER46960   LABEL="IMP VALUE OTH ASSETS (W34) 09"                    format=f9.
      ER46961   LABEL="ACC VALUE OTH ASSETS (W34) 09"                    format=f1.
      ER46962   LABEL="IMP WTR ANNUITY/IRA (W21) 09"                     format=f1.
      ER46963   LABEL="ACC WTR ANNUITY/IRA (W21) 09"                     format=f1.
      ER46964   LABEL="IMP VALUE ANNUITY/IRA (W22) 09"                   format=f9.
      ER46965   LABEL="ACC VALUE ANNUITY/IRA (W22) 09"                   format=f1.
      ER46966   LABEL="IMP VALUE HOME EQUITY 09"                         format=f9.
      ER46967   LABEL="ACC VALUE HOME EQUITY 09"                         format=f1.
      ER46968   LABEL="IMP WEALTH W/O EQUITY (WEALTH1) 09"               format=f9.
      ER46969   LABEL="ACC WEALTH W/O EQUITY (WEALTH1) 09"               format=f1.
      ER46970   LABEL="IMP WEALTH W/ EQUITY (WEALTH2) 09"                format=f9.
      ER46971   LABEL="ACC WEALTH W/ EQUITY (WEALTH2) 09"                format=f1.
      ER46972   LABEL="CENSUS NEEDS STANDARD-2008"                       format=f5.
      ER46973   LABEL="CENSUS NEEDS STANDARD-2007"                       format=f5.
      ER46974   LABEL="CURRENT REGION"                                   format=f1.
      ER46975   LABEL="BEALE RURAL-URBAN CODE"                           format=f2.
      ER46976   LABEL="SIZE LARGEST CITY IN COUNTY"                      format=f1.
      ER46977   LABEL="REGION HD GREW UP"                                format=f1.
      ER46978   LABEL="HD GEOGRAPHIC MOBILITY"                           format=f1.
      ER46979   LABEL="REGION WF GREW UP"                                format=f1.
      ER46980   LABEL="WF GEOGRAPHIC MOBILITY"                           format=f1.
      ER46981   LABEL="COMPLETED ED-HD"                                  format=f2.
      ER46982   LABEL="COMPLETED ED-WF"                                  format=f2.
      ER46983   LABEL="MARITAL STATUS-GENERATED"                         format=f1.
      ER46984   LABEL="CHANGE IN MARITAL STATUS"                         format=f1.
      ER46985   LABEL="COUPLE STATUS OF HEAD"                            format=f1.
      ER46986   LABEL="YEAR NEW HEAD IN FU"                              format=f4.
      ER46987   LABEL="YEAR NEW WIFE IN FU"                              format=f4.
      ER46988   LABEL="HEAD-SPOUSE SAMPLE STATUS"                        format=f1.
      ER46989   LABEL="NUMBER OF SPLITOFFS FROM MAIN FAM"                format=f1.
      ER46990   LABEL="MAIN FAMILY ID FOR SPLITOFF"                      format=f5.
      ER46991   LABEL="CURRENT YR ID OF 1ST OTHER FU IN HU"              format=f5.
      ER46992   LABEL="REL OF 1ST OTHER FU"                              format=f1.
      ER46993   LABEL="SIZE OF 1ST OTHER FU"                             format=f2.
      ER46994   LABEL="CURRENT YR ID OF 2ND OTHER FU IN HU"              format=f5.
      ER46995   LABEL="REL OF 2ND OTHER FU"                              format=f1.
      ER46996   LABEL="SIZE OF 2ND OTHER FU"                             format=f2.
      ER46997   LABEL="CURRENT YR ID OF 3RD OTHER FU IN HU"              format=f5.
      ER46998   LABEL="REL OF 3RD OTHER FU"                              format=f1.
      ER46999   LABEL="SIZE OF 3RD OTHER FU"                             format=f2.
      ER47000   LABEL="CURRENT YR ID OF 4TH OTHER FU IN HU"              format=f5.
      ER47001   LABEL="REL OF 4TH OTHER FU"                              format=f1.
      ER47002   LABEL="SIZE OF 4TH OTHER FU"                             format=f2.
      ER47003   LABEL="HOUSEHOLD ID #"                                   format=f5.
      ER47004   LABEL="BIRTHS TO HEAD ONLY-2008"                         format=f1.
      ER47005   LABEL="BIRTHS TO WIFE ONLY-2008"                         format=f1.
      ER47006   LABEL="BIRTHS TO HEAD AND WIFE-2008"                     format=f1.
      ER47007   LABEL="BIRTHS TO OFUMS ONLY-2008"                        format=f1.
      ER47008   LABEL="BIRTHS TO HEAD ONLY-2007"                         format=f1.
      ER47009   LABEL="BIRTHS TO WIFE ONLY-2007"                         format=f1.
      ER47010   LABEL="BIRTHS TO HEAD AND WIFE-2007"                     format=f1.
      ER47011   LABEL="BIRTHS TO OFUMS ONLY-2007"                        format=f1.
      ER47012   LABEL="2009 CORE/IMMIGRANT FAM WEIGHT NUMBER 1"          format=f7.3
   ;
   infile 'F:\PSID\FAM2009ER.txt'  lrecl=8185 missover;
   INPUT 
      ER42001         1 - 1         ER42002         2 - 6         ER42003         7 - 8    
      ER42004         9 - 10        ER42005        11 - 11        ER42006        12 - 12   
      ER42007        13 - 13        ER42008        14 - 14        ER42009        15 - 18   
      ER42010        19 - 19        ER42011        20 - 27        ER42012        28 - 29   
      ER42013        30 - 31        ER42014        32 - 35        ER42015        36 - 38   
      ER42016        39 - 40        ER42017        41 - 43        ER42018        44 - 44   
      ER42019        45 - 47        ER42020        48 - 49        ER42021        50 - 52   
      ER42022        53 - 54        ER42023        55 - 55        ER42024        56 - 56   
      ER42025        57 - 57        ER42026        58 - 58        ER42027        59 - 59   
      ER42028        60 - 61        ER42029        62 - 62        ER42030        63 - 69   
      ER42031        70 - 70        ER42032        71 - 71        ER42033        72 - 72   
      ER42034        73 - 73        ER42035        74 - 74        ER42036        75 - 75   
      ER42037        76 - 80        ER42038        81 - 81        ER42039        82 - 85   
      ER42040        86 - 86        ER42041        87 - 87        ER42042        88 - 88   
      ER42043        89 - 95        ER42044        96 - 96        ER42045        97 - 101  
      ER42046       102 - 102       ER42047       103 - 104       ER42048       105 - 107  
      ER42049       108 - 108       ER42050       109 - 112       ER42051       113 - 114  
      ER42052       115 - 115       ER42053       116 - 117       ER42054       118 - 118  
      ER42055       119 - 120       ER42056       121 - 124       ER42057       125 - 125  
      ER42058       126 - 126       ER42059       127 - 127       ER42060       128 - 128  
      ER42061       129 - 129       ER42062       130 - 136       ER42063       137 - 137  
      ER42064       138 - 142       ER42065       143 - 143       ER42066       144 - 145  
      ER42067       146 - 148       ER42068       149 - 149       ER42069       150 - 153  
      ER42070       154 - 155       ER42071       156 - 156       ER42072       157 - 158  
      ER42073       159 - 159       ER42074       160 - 161       ER42075       162 - 165  
      ER42076       166 - 166       ER42077       167 - 167       ER42078       168 - 168  
      ER42079       169 - 169       ER42080       170 - 174       ER42081       175 - 175  
      ER42082       176 - 176       ER42083       177 - 177       ER42084       178 - 178  
      ER42085       179 - 179       ER42086       180 - 180       ER42087       181 - 184  
      ER42088       185 - 185       ER42089       186 - 186       ER42090       187 - 187  
      ER42091       188 - 188       ER42092       189 - 189       ER42093       190 - 191  
      ER42094       192 - 195       ER42095       196 - 196       ER42096       197 - 197  
      ER42097       198 - 198       ER42098       199 - 205       ER42099       206 - 206  
      ER42100       207 - 208       ER42101       209 - 212       ER42102       213 - 213  
      ER42103       214 - 214       ER42104       215 - 215       ER42105       216 - 222  
      ER42106       223 - 223       ER42107       224 - 224       ER42108       225 - 226  
      ER42109       227 - 228       ER42110       229 - 230       ER42111       231 - 231  
      ER42112       232 - 235       ER42113       236 - 236       ER42114       237 - 240  
      ER42115       241 - 241       ER42116       242 - 245       ER42117       246 - 246  
      ER42118       247 - 250       ER42119       251 - 251       ER42120       252 - 255  
      ER42121       256 - 256       ER42122       257 - 257       ER42123       258 - 258  
      ER42124       259 - 261       ER42125       262 - 262       ER42126       263 - 263  
      ER42127       264 - 267       ER42128       268 - 268       ER42129       269 - 269  
      ER42130       270 - 270       ER42131       271 - 271       ER42132       272 - 272  
      ER42133       273 - 274       ER42134       275 - 278       ER42135       279 - 279  
      ER42136       280 - 280       ER42137       281 - 281       ER42138       282 - 282  
      ER42139       283 - 283       ER42140       284 - 285       ER42141       286 - 287  
      ER42142       288 - 289       ER42143       290 - 293       ER42144       294 - 294  
      ER42145       295 - 295       ER42146       296 - 297       ER42147       298 - 298  
      ER42148       299 - 301       ER42149       302 - 302       ER42150       303 - 303  
      ER42151       304 - 305       ER42152       306 - 309       ER42153       310 - 311  
      ER42154       312 - 315       ER42155       316 - 316       ER42156       317 - 317  
      ER42157       318 - 318       ER42158       319 - 319       ER42159       320 - 320  
      ER42160       321 - 321       ER42161       322 - 322       ER42162       323 - 323  
      ER42163       324 - 324       ER42164       325 - 325       ER42165       326 - 326  
      ER42166       327 - 327       ER42167       328 - 330       ER42168       331 - 333  
      ER42169       334 - 334       ER42170       335 - 335       ER42171       336 - 336  
      ER42172       337 - 345       ER42173       346 - 346       ER42174       347 - 347  
      ER42175       348 - 348       ER42176       349 - 349       ER42177       350 - 350  
      ER42178       351 - 351       ER42179       352 - 352       ER42180       353 - 353  
      ER42181       354 - 354       ER42182       355 - 364       ER42183       365 - 365  
      ER42184       366 - 366       ER42185       367 - 367       ER42186       368 - 377  
      ER42187       378 - 378       ER42188       379 - 384       ER42189       385 - 385  
      ER42190       386 - 386       ER42191       387 - 387       ER42192       388 - 397  
      ER42193       398 - 398       ER42194       399 - 406       ER42195       407 - 407  
      ER42196       408 - 414       ER42197       415 - 415       ER42198       416 - 416  
      ER42199       417 - 425       ER42200       426 - 427       ER42201       428 - 429  
      ER42202       430 - 431       ER42203       432 - 434       ER42204       435 - 435  
      ER42205       436 - 436       ER42206       437 - 440       ER42207       441 - 441  
      ER42208       442 - 442       ER42209       443 - 452       ER42210       453 - 453  
      ER42211       454 - 454       ER42212       455 - 456       ER42213       457 - 460  
      ER42214       461 - 462       ER42215       463 - 466       ER42216       467 - 467  
      ER42217       468 - 468       ER42218       469 - 469       ER42219       470 - 470  
      ER42220       471 - 471       ER42221       472 - 472       ER42222       473 - 473  
      ER42223       474 - 474       ER42224       475 - 475       ER42225       476 - 476  
      ER42226       477 - 477       ER42227       478 - 478       ER42228       479 - 481  
      ER42229       482 - 484       ER42230       485 - 485       ER42231       486 - 486  
      ER42232       487 - 487       ER42233       488 - 490       ER42234       491 - 491  
      ER42235       492 - 492       ER42236       493 - 496       ER42237       497 - 497  
      ER42238       498 - 498       ER42239       499 - 508       ER42240       509 - 509  
      ER42241       510 - 510       ER42242       511 - 512       ER42243       513 - 516  
      ER42244       517 - 518       ER42245       519 - 522       ER42246       523 - 523  
      ER42247       524 - 524       ER42248       525 - 525       ER42249       526 - 526  
      ER42250       527 - 527       ER42251       528 - 528       ER42252       529 - 529  
      ER42253       530 - 530       ER42254       531 - 531       ER42255       532 - 532  
      ER42256       533 - 533       ER42257       534 - 534       ER42258       535 - 537  
      ER42259       538 - 540       ER42260       541 - 541       ER42261       542 - 542  
      ER42262       543 - 543       ER42263       544 - 546       ER42264       547 - 547  
      ER42265       548 - 548       ER42266       549 - 552       ER42267       553 - 553  
      ER42268       554 - 554       ER42269       555 - 564       ER42270       565 - 565  
      ER42271       566 - 566       ER42272       567 - 568       ER42273       569 - 572  
      ER42274       573 - 574       ER42275       575 - 578       ER42276       579 - 579  
      ER42277       580 - 580       ER42278       581 - 581       ER42279       582 - 582  
      ER42280       583 - 583       ER42281       584 - 584       ER42282       585 - 585  
      ER42283       586 - 586       ER42284       587 - 587       ER42285       588 - 588  
      ER42286       589 - 589       ER42287       590 - 590       ER42288       591 - 593  
      ER42289       594 - 596       ER42290       597 - 597       ER42291       598 - 598  
      ER42292       599 - 599       ER42293       600 - 602       ER42294       603 - 603  
      ER42295       604 - 604       ER42296       605 - 608       ER42297       609 - 609  
      ER42298       610 - 610       ER42299       611 - 620       ER42300       621 - 621  
      ER42301       622 - 622       ER42302       623 - 623       ER42303       624 - 624  
      ER42304       625 - 627       ER42305       628 - 628       ER42306       629 - 630  
      ER42307       631 - 631       ER42308       632 - 633       ER42309       634 - 634  
      ER42310       635 - 635       ER42311       636 - 638       ER42312       639 - 639  
      ER42313       640 - 641       ER42314       642 - 642       ER42315       643 - 644  
      ER42316       645 - 645       ER42317       646 - 646       ER42318       647 - 649  
      ER42319       650 - 650       ER42320       651 - 652       ER42321       653 - 653  
      ER42322       654 - 655       ER42323       656 - 656       ER42324       657 - 657  
      ER42325       658 - 660       ER42326       661 - 661       ER42327       662 - 663  
      ER42328       664 - 664       ER42329       665 - 666       ER42330       667 - 667  
      ER42331       668 - 668       ER42332       669 - 671       ER42333       672 - 672  
      ER42334       673 - 674       ER42335       675 - 675       ER42336       676 - 677  
      ER42337       678 - 678       ER42338       679 - 679       ER42339       680 - 682  
      ER42340       683 - 683       ER42341       684 - 685       ER42342       686 - 686  
      ER42343       687 - 688       ER42344       689 - 689       ER42345       690 - 690  
      ER42346       691 - 691       ER42347       692 - 692       ER42348       693 - 693  
      ER42349       694 - 694       ER42350       695 - 695       ER42351       696 - 696  
      ER42352       697 - 697       ER42353       698 - 698       ER42354       699 - 699  
      ER42355       700 - 700       ER42356       701 - 701       ER42357       702 - 702  
      ER42358       703 - 705       ER42359       706 - 706       ER42360       707 - 708  
      ER42361       709 - 709       ER42362       710 - 711       ER42363       712 - 712  
      ER42364       713 - 713       ER42365       714 - 714       ER42366       715 - 715  
      ER42367       716 - 716       ER42368       717 - 717       ER42369       718 - 718  
      ER42370       719 - 719       ER42371       720 - 720       ER42372       721 - 721  
      ER42373       722 - 722       ER42374       723 - 723       ER42375       724 - 724  
      ER42376       725 - 725       ER42377       726 - 727       ER42378       728 - 731  
      ER42379       732 - 732       ER42380       733 - 733       ER42381       734 - 734  
      ER42382       735 - 735       ER42383       736 - 736       ER42384       737 - 737  
      ER42385       738 - 738       ER42386       739 - 739       ER42387       740 - 740  
      ER42388       741 - 742       ER42389       743 - 744       ER42390       745 - 746  
      ER42391       747 - 747       ER42392       748 - 749       ER42393       750 - 751  
      ER42394       752 - 753       ER42395       754 - 757       ER42396       758 - 758  
      ER42397       759 - 759       ER42398       760 - 761       ER42399       762 - 762  
      ER42400       763 - 765       ER42401       766 - 766       ER42402       767 - 767  
      ER42403       768 - 769       ER42404       770 - 773       ER42405       774 - 775  
      ER42406       776 - 779       ER42407       780 - 780       ER42408       781 - 781  
      ER42409       782 - 782       ER42410       783 - 783       ER42411       784 - 784  
      ER42412       785 - 785       ER42413       786 - 786       ER42414       787 - 787  
      ER42415       788 - 788       ER42416       789 - 789       ER42417       790 - 790  
      ER42418       791 - 791       ER42419       792 - 794       ER42420       795 - 797  
      ER42421       798 - 798       ER42422       799 - 799       ER42423       800 - 800  
      ER42424       801 - 809       ER42425       810 - 810       ER42426       811 - 811  
      ER42427       812 - 812       ER42428       813 - 813       ER42429       814 - 814  
      ER42430       815 - 815       ER42431       816 - 816       ER42432       817 - 817  
      ER42433       818 - 818       ER42434       819 - 828       ER42435       829 - 829  
      ER42436       830 - 830       ER42437       831 - 831       ER42438       832 - 841  
      ER42439       842 - 842       ER42440       843 - 848       ER42441       849 - 849  
      ER42442       850 - 850       ER42443       851 - 851       ER42444       852 - 861  
      ER42445       862 - 862       ER42446       863 - 870       ER42447       871 - 871  
      ER42448       872 - 878       ER42449       879 - 879       ER42450       880 - 880  
      ER42451       881 - 889       ER42452       890 - 891       ER42453       892 - 893  
      ER42454       894 - 895       ER42455       896 - 898       ER42456       899 - 899  
      ER42457       900 - 900       ER42458       901 - 904       ER42459       905 - 905  
      ER42460       906 - 906       ER42461       907 - 916       ER42462       917 - 917  
      ER42463       918 - 918       ER42464       919 - 920       ER42465       921 - 924  
      ER42466       925 - 926       ER42467       927 - 930       ER42468       931 - 931  
      ER42469       932 - 932       ER42470       933 - 933       ER42471       934 - 934  
      ER42472       935 - 935       ER42473       936 - 936       ER42474       937 - 937  
      ER42475       938 - 938       ER42476       939 - 939       ER42477       940 - 940  
      ER42478       941 - 941       ER42479       942 - 942       ER42480       943 - 945  
      ER42481       946 - 948       ER42482       949 - 949       ER42483       950 - 950  
      ER42484       951 - 951       ER42485       952 - 954       ER42486       955 - 955  
      ER42487       956 - 956       ER42488       957 - 960       ER42489       961 - 961  
      ER42490       962 - 962       ER42491       963 - 972       ER42492       973 - 973  
      ER42493       974 - 974       ER42494       975 - 976       ER42495       977 - 980  
      ER42496       981 - 982       ER42497       983 - 986       ER42498       987 - 987  
      ER42499       988 - 988       ER42500       989 - 989       ER42501       990 - 990  
      ER42502       991 - 991       ER42503       992 - 992       ER42504       993 - 993  
      ER42505       994 - 994       ER42506       995 - 995       ER42507       996 - 996  
      ER42508       997 - 997       ER42509       998 - 998       ER42510       999 - 1001 
      ER42511      1002 - 1004      ER42512      1005 - 1005      ER42513      1006 - 1006 
      ER42514      1007 - 1007      ER42515      1008 - 1010      ER42516      1011 - 1011 
      ER42517      1012 - 1012      ER42518      1013 - 1016      ER42519      1017 - 1017 
      ER42520      1018 - 1018      ER42521      1019 - 1028      ER42522      1029 - 1029 
      ER42523      1030 - 1030      ER42524      1031 - 1032      ER42525      1033 - 1036 
      ER42526      1037 - 1038      ER42527      1039 - 1042      ER42528      1043 - 1043 
      ER42529      1044 - 1044      ER42530      1045 - 1045      ER42531      1046 - 1046 
      ER42532      1047 - 1047      ER42533      1048 - 1048      ER42534      1049 - 1049 
      ER42535      1050 - 1050      ER42536      1051 - 1051      ER42537      1052 - 1052 
      ER42538      1053 - 1053      ER42539      1054 - 1054      ER42540      1055 - 1057 
      ER42541      1058 - 1060      ER42542      1061 - 1061      ER42543      1062 - 1062 
      ER42544      1063 - 1063      ER42545      1064 - 1066      ER42546      1067 - 1067 
      ER42547      1068 - 1068      ER42548      1069 - 1072      ER42549      1073 - 1073 
      ER42550      1074 - 1074      ER42551      1075 - 1084      ER42552      1085 - 1085 
      ER42553      1086 - 1086      ER42554      1087 - 1087      ER42555      1088 - 1088 
      ER42556      1089 - 1091      ER42557      1092 - 1092      ER42558      1093 - 1094 
      ER42559      1095 - 1095      ER42560      1096 - 1097      ER42561      1098 - 1098 
      ER42562      1099 - 1099      ER42563      1100 - 1102      ER42564      1103 - 1103 
      ER42565      1104 - 1105      ER42566      1106 - 1106      ER42567      1107 - 1108 
      ER42568      1109 - 1109      ER42569      1110 - 1110      ER42570      1111 - 1113 
      ER42571      1114 - 1114      ER42572      1115 - 1116      ER42573      1117 - 1117 
      ER42574      1118 - 1119      ER42575      1120 - 1120      ER42576      1121 - 1121 
      ER42577      1122 - 1124      ER42578      1125 - 1125      ER42579      1126 - 1127 
      ER42580      1128 - 1128      ER42581      1129 - 1130      ER42582      1131 - 1131 
      ER42583      1132 - 1132      ER42584      1133 - 1135      ER42585      1136 - 1136 
      ER42586      1137 - 1138      ER42587      1139 - 1139      ER42588      1140 - 1141 
      ER42589      1142 - 1142      ER42590      1143 - 1143      ER42591      1144 - 1146 
      ER42592      1147 - 1147      ER42593      1148 - 1149      ER42594      1150 - 1150 
      ER42595      1151 - 1152      ER42596      1153 - 1153      ER42597      1154 - 1154 
      ER42598      1155 - 1155      ER42599      1156 - 1156      ER42600      1157 - 1157 
      ER42601      1158 - 1158      ER42602      1159 - 1159      ER42603      1160 - 1160 
      ER42604      1161 - 1161      ER42605      1162 - 1162      ER42606      1163 - 1163 
      ER42607      1164 - 1164      ER42608      1165 - 1165      ER42609      1166 - 1166 
      ER42610      1167 - 1169      ER42611      1170 - 1170      ER42612      1171 - 1172 
      ER42613      1173 - 1173      ER42614      1174 - 1175      ER42615      1176 - 1176 
      ER42616      1177 - 1177      ER42617      1178 - 1178      ER42618      1179 - 1179 
      ER42619      1180 - 1180      ER42620      1181 - 1181      ER42621      1182 - 1182 
      ER42622      1183 - 1183      ER42623      1184 - 1184      ER42624      1185 - 1185 
      ER42625      1186 - 1186      ER42626      1187 - 1187      ER42627      1188 - 1188 
      ER42628      1189 - 1189      ER42629      1190 - 1191      ER42630      1192 - 1195 
      ER42631      1196 - 1196      ER42632      1197 - 1197      ER42633      1198 - 1198 
      ER42634      1199 - 1199      ER42635      1200 - 1200      ER42636      1201 - 1201 
      ER42637      1202 - 1202      ER42638      1203 - 1203      ER42639      1204 - 1204 
      ER42640      1205 - 1206      ER42641      1207 - 1208      ER42642      1209 - 1210 
      ER42643      1211 - 1211      ER42644      1212 - 1214      ER42645      1215 - 1215 
      ER42646      1216 - 1218      ER42647      1219 - 1219      ER42648      1220 - 1220 
      ER42649      1221 - 1221      ER42650      1222 - 1222      ER42651      1223 - 1223 
      ER42652      1224 - 1229      ER42653      1230 - 1230      ER42654      1231 - 1231 
      ER42655      1232 - 1232      ER42656      1233 - 1233      ER42657      1234 - 1234 
      ER42658      1235 - 1235      ER42659      1236 - 1236      ER42660      1237 - 1237 
      ER42661      1238 - 1238      ER42662      1239 - 1239      ER42663      1240 - 1240 
      ER42664      1241 - 1241      ER42665      1242 - 1242      ER42666      1243 - 1243 
      ER42667      1244 - 1244      ER42668      1245 - 1245      ER42669      1246 - 1246 
      ER42670      1247 - 1247      ER42671      1248 - 1248      ER42672      1249 - 1254 
      ER42673      1255 - 1255      ER42674      1256 - 1256      ER42675      1257 - 1257 
      ER42676      1258 - 1263      ER42677      1264 - 1264      ER42678      1265 - 1265 
      ER42679      1266 - 1266      ER42680      1267 - 1267      ER42681      1268 - 1268 
      ER42682      1269 - 1269      ER42683      1270 - 1270      ER42684      1271 - 1271 
      ER42685      1272 - 1272      ER42686      1273 - 1273      ER42687      1274 - 1274 
      ER42688      1275 - 1275      ER42689      1276 - 1276      ER42690      1277 - 1277 
      ER42691      1278 - 1278      ER42692      1279 - 1284      ER42693      1285 - 1285 
      ER42694      1286 - 1286      ER42695      1287 - 1287      ER42696      1288 - 1288 
      ER42697      1289 - 1289      ER42698      1290 - 1290      ER42699      1291 - 1291 
      ER42700      1292 - 1292      ER42701      1293 - 1293      ER42702      1294 - 1294 
      ER42703      1295 - 1295      ER42704      1296 - 1296      ER42705      1297 - 1297 
      ER42706      1298 - 1298      ER42707      1299 - 1299      ER42708      1300 - 1300 
      ER42709      1301 - 1306      ER42710      1307 - 1307      ER42711      1308 - 1308 
      ER42712      1309 - 1316      ER42713      1317 - 1317      ER42714      1318 - 1318 
      ER42715      1319 - 1319      ER42716      1320 - 1327      ER42717      1328 - 1328 
      ER42718      1329 - 1329      ER42719      1330 - 1337      ER42720      1338 - 1338 
      ER42721      1339 - 1339      ER42722      1340 - 1347      ER42723      1348 - 1348 
      ER42724      1349 - 1349      ER42725      1350 - 1350      ER42726      1351 - 1358 
      ER42727      1359 - 1359      ER42728      1360 - 1360      ER42729      1361 - 1368 
      ER42730      1369 - 1369      ER42731      1370 - 1370      ER42732      1371 - 1371 
      ER42733      1372 - 1373      ER42734      1374 - 1375      ER42735      1376 - 1377 
      ER42736      1378 - 1381      ER42737      1382 - 1382      ER42738      1383 - 1383 
      ER42739      1384 - 1384      ER42740      1385 - 1388      ER42741      1389 - 1389 
      ER42742      1390 - 1390      ER42743      1391 - 1391      ER42744      1392 - 1397 
      ER42745      1398 - 1403      ER42746      1404 - 1404      ER42747      1405 - 1410 
      ER42748      1411 - 1416      ER42749      1417 - 1417      ER42750      1418 - 1420 
      ER42751      1421 - 1423      ER42752      1424 - 1429      ER42753      1430 - 1435 
      ER42754      1436 - 1436      ER42755      1437 - 1439      ER42756      1440 - 1442 
      ER42757      1443 - 1444      ER42758      1445 - 1446      ER42759      1447 - 1450 
      ER42760      1451 - 1451      ER42761      1452 - 1452      ER42762      1453 - 1453 
      ER42763      1454 - 1457      ER42764      1458 - 1458      ER42765      1459 - 1459 
      ER42766      1460 - 1460      ER42767      1461 - 1466      ER42768      1467 - 1472 
      ER42769      1473 - 1473      ER42770      1474 - 1479      ER42771      1480 - 1485 
      ER42772      1486 - 1486      ER42773      1487 - 1489      ER42774      1490 - 1492 
      ER42775      1493 - 1498      ER42776      1499 - 1504      ER42777      1505 - 1505 
      ER42778      1506 - 1508      ER42779      1509 - 1511      ER42780      1512 - 1513 
      ER42781      1514 - 1515      ER42782      1516 - 1519      ER42783      1520 - 1520 
      ER42784      1521 - 1521      ER42785      1522 - 1522      ER42786      1523 - 1526 
      ER42787      1527 - 1527      ER42788      1528 - 1528      ER42789      1529 - 1529 
      ER42790      1530 - 1535      ER42791      1536 - 1541      ER42792      1542 - 1542 
      ER42793      1543 - 1548      ER42794      1549 - 1554      ER42795      1555 - 1555 
      ER42796      1556 - 1558      ER42797      1559 - 1561      ER42798      1562 - 1567 
      ER42799      1568 - 1573      ER42800      1574 - 1574      ER42801      1575 - 1577 
      ER42802      1578 - 1580      ER42803      1581 - 1586      ER42804      1587 - 1587 
      ER42805      1588 - 1588      ER42806      1589 - 1594      ER42807      1595 - 1599 
      ER42808      1600 - 1604      ER42809      1605 - 1609      ER42810      1610 - 1614 
      ER42811      1615 - 1619      ER42812      1620 - 1624      ER42813      1625 - 1625 
      ER42814      1626 - 1631      ER42815      1632 - 1632      ER42816      1633 - 1638 
      ER42817      1639 - 1644      ER42818      1645 - 1645      ER42819      1646 - 1646 
      ER42820      1647 - 1647      ER42821      1648 - 1648      ER42822      1649 - 1654 
      ER42823      1655 - 1655      ER42824      1656 - 1656      ER42825      1657 - 1657 
      ER42826      1658 - 1658      ER42827      1659 - 1664      ER42828      1665 - 1665 
      ER42829      1666 - 1666      ER42830      1667 - 1667      ER42831      1668 - 1668 
      ER42832      1669 - 1674      ER42833      1675 - 1675      ER42834      1676 - 1676 
      ER42835      1677 - 1677      ER42836      1678 - 1678      ER42837      1679 - 1684 
      ER42838      1685 - 1685      ER42839      1686 - 1686      ER42840      1687 - 1687 
      ER42841      1688 - 1688      ER42842      1689 - 1689      ER42843      1690 - 1696 
      ER42844      1697 - 1703      ER42845      1704 - 1710      ER42846      1711 - 1711 
      ER42847      1712 - 1712      ER42848      1713 - 1714      ER42849      1715 - 1715 
      ER42850      1716 - 1716      ER42851      1717 - 1717      ER42852      1718 - 1718 
      ER42853      1719 - 1720      ER42854      1721 - 1722      ER42855      1723 - 1724 
      ER42856      1725 - 1726      ER42857      1727 - 1727      ER42858      1728 - 1734 
      ER42859      1735 - 1741      ER42860      1742 - 1748      ER42861      1749 - 1749 
      ER42862      1750 - 1751      ER42863      1752 - 1752      ER42864      1753 - 1753 
      ER42865      1754 - 1754      ER42866      1755 - 1755      ER42867      1756 - 1757 
      ER42868      1758 - 1759      ER42869      1760 - 1761      ER42870      1762 - 1763 
      ER42871      1764 - 1764      ER42872      1765 - 1771      ER42873      1772 - 1778 
      ER42874      1779 - 1785      ER42875      1786 - 1786      ER42876      1787 - 1788 
      ER42877      1789 - 1789      ER42878      1790 - 1790      ER42879      1791 - 1791 
      ER42880      1792 - 1792      ER42881      1793 - 1794      ER42882      1795 - 1796 
      ER42883      1797 - 1798      ER42884      1799 - 1800      ER42885      1801 - 1801 
      ER42886      1802 - 1808      ER42887      1809 - 1815      ER42888      1816 - 1822 
      ER42889      1823 - 1823      ER42890      1824 - 1825      ER42891      1826 - 1826 
      ER42892      1827 - 1827      ER42893      1828 - 1828      ER42894      1829 - 1829 
      ER42895      1830 - 1831      ER42896      1832 - 1833      ER42897      1834 - 1835 
      ER42898      1836 - 1837      ER42899      1838 - 1838      ER42900      1839 - 1845 
      ER42901      1846 - 1852      ER42902      1853 - 1859      ER42903      1860 - 1860 
      ER42904      1861 - 1862      ER42905      1863 - 1863      ER42906      1864 - 1864 
      ER42907      1865 - 1865      ER42908      1866 - 1866      ER42909      1867 - 1868 
      ER42910      1869 - 1870      ER42911      1871 - 1872      ER42912      1873 - 1874 
      ER42913      1875 - 1875      ER42914      1876 - 1882      ER42915      1883 - 1889 
      ER42916      1890 - 1896      ER42917      1897 - 1897      ER42918      1898 - 1898 
      ER42919      1899 - 1905      ER42920      1906 - 1906      ER42921      1907 - 1907 
      ER42922      1908 - 1908      ER42923      1909 - 1914      ER42924      1915 - 1915 
      ER42925      1916 - 1916      ER42926      1917 - 1922      ER42927      1923 - 1923 
      ER42928      1924 - 1924      ER42929      1925 - 1930      ER42930      1931 - 1931 
      ER42931      1932 - 1932      ER42932      1933 - 1938      ER42933      1939 - 1939 
      ER42934      1940 - 1940      ER42935      1941 - 1946      ER42936      1947 - 1947 
      ER42937      1948 - 1948      ER42938      1949 - 1949      ER42939      1950 - 1956 
      ER42940      1957 - 1957      ER42941      1958 - 1958      ER42942      1959 - 1959 
      ER42943      1960 - 1960      ER42944      1961 - 1961      ER42945      1962 - 1962 
      ER42946      1963 - 1963      ER42947      1964 - 1964      ER42948      1965 - 1965 
      ER42949      1966 - 1966      ER42950      1967 - 1967      ER42951      1968 - 1968 
      ER42952      1969 - 1969      ER42953      1970 - 1970      ER42954      1971 - 1971 
      ER42955      1972 - 1972      ER42956      1973 - 1979      ER42957      1980 - 1980 
      ER42958      1981 - 1981      ER42959      1982 - 1982      ER42960      1983 - 1983 
      ER42961      1984 - 1984      ER42962      1985 - 1985      ER42963      1986 - 1986 
      ER42964      1987 - 1987      ER42965      1988 - 1988      ER42966      1989 - 1989 
      ER42967      1990 - 1990      ER42968      1991 - 1991      ER42969      1992 - 1992 
      ER42970      1993 - 1993      ER42971      1994 - 1994      ER42972      1995 - 1995 
      ER42973      1996 - 2002      ER42974      2003 - 2003      ER42975      2004 - 2004 
      ER42976      2005 - 2005      ER42977      2006 - 2006      ER42978      2007 - 2007 
      ER42979      2008 - 2008      ER42980      2009 - 2009      ER42981      2010 - 2010 
      ER42982      2011 - 2011      ER42983      2012 - 2012      ER42984      2013 - 2013 
      ER42985      2014 - 2014      ER42986      2015 - 2015      ER42987      2016 - 2016 
      ER42988      2017 - 2017      ER42989      2018 - 2018      ER42990      2019 - 2025 
      ER42991      2026 - 2026      ER42992      2027 - 2027      ER42993      2028 - 2033 
      ER42994      2034 - 2034      ER42995      2035 - 2035      ER42996      2036 - 2036 
      ER42997      2037 - 2037      ER42998      2038 - 2038      ER42999      2039 - 2039 
      ER43000      2040 - 2040      ER43001      2041 - 2041      ER43002      2042 - 2042 
      ER43003      2043 - 2043      ER43004      2044 - 2044      ER43005      2045 - 2045 
      ER43006      2046 - 2046      ER43007      2047 - 2047      ER43008      2048 - 2048 
      ER43009      2049 - 2049      ER43010      2050 - 2055      ER43011      2056 - 2056 
      ER43012      2057 - 2057      ER43013      2058 - 2058      ER43014      2059 - 2059 
      ER43015      2060 - 2060      ER43016      2061 - 2061      ER43017      2062 - 2062 
      ER43018      2063 - 2063      ER43019      2064 - 2064      ER43020      2065 - 2065 
      ER43021      2066 - 2066      ER43022      2067 - 2067      ER43023      2068 - 2068 
      ER43024      2069 - 2069      ER43025      2070 - 2070      ER43026      2071 - 2071 
      ER43027      2072 - 2077      ER43028      2078 - 2078      ER43029      2079 - 2079 
      ER43030      2080 - 2080      ER43031      2081 - 2081      ER43032      2082 - 2082 
      ER43033      2083 - 2083      ER43034      2084 - 2084      ER43035      2085 - 2085 
      ER43036      2086 - 2086      ER43037      2087 - 2087      ER43038      2088 - 2088 
      ER43039      2089 - 2089      ER43040      2090 - 2090      ER43041      2091 - 2091 
      ER43042      2092 - 2092      ER43043      2093 - 2093      ER43044      2094 - 2099 
      ER43045      2100 - 2100      ER43046      2101 - 2101      ER43047      2102 - 2102 
      ER43048      2103 - 2103      ER43049      2104 - 2104      ER43050      2105 - 2105 
      ER43051      2106 - 2106      ER43052      2107 - 2107      ER43053      2108 - 2108 
      ER43054      2109 - 2109      ER43055      2110 - 2110      ER43056      2111 - 2111 
      ER43057      2112 - 2112      ER43058      2113 - 2113      ER43059      2114 - 2114 
      ER43060      2115 - 2120      ER43061      2121 - 2121      ER43062      2122 - 2122 
      ER43063      2123 - 2123      ER43064      2124 - 2124      ER43065      2125 - 2125 
      ER43066      2126 - 2126      ER43067      2127 - 2127      ER43068      2128 - 2128 
      ER43069      2129 - 2129      ER43070      2130 - 2130      ER43071      2131 - 2131 
      ER43072      2132 - 2132      ER43073      2133 - 2133      ER43074      2134 - 2134 
      ER43075      2135 - 2135      ER43076      2136 - 2136      ER43077      2137 - 2142 
      ER43078      2143 - 2143      ER43079      2144 - 2144      ER43080      2145 - 2145 
      ER43081      2146 - 2146      ER43082      2147 - 2147      ER43083      2148 - 2148 
      ER43084      2149 - 2149      ER43085      2150 - 2150      ER43086      2151 - 2151 
      ER43087      2152 - 2152      ER43088      2153 - 2153      ER43089      2154 - 2154 
      ER43090      2155 - 2155      ER43091      2156 - 2156      ER43092      2157 - 2157 
      ER43093      2158 - 2163      ER43094      2164 - 2164      ER43095      2165 - 2165 
      ER43096      2166 - 2166      ER43097      2167 - 2167      ER43098      2168 - 2168 
      ER43099      2169 - 2169      ER43100      2170 - 2170      ER43101      2171 - 2171 
      ER43102      2172 - 2172      ER43103      2173 - 2173      ER43104      2174 - 2174 
      ER43105      2175 - 2175      ER43106      2176 - 2176      ER43107      2177 - 2177 
      ER43108      2178 - 2178      ER43109      2179 - 2179      ER43110      2180 - 2185 
      ER43111      2186 - 2186      ER43112      2187 - 2187      ER43113      2188 - 2188 
      ER43114      2189 - 2189      ER43115      2190 - 2190      ER43116      2191 - 2191 
      ER43117      2192 - 2192      ER43118      2193 - 2193      ER43119      2194 - 2194 
      ER43120      2195 - 2195      ER43121      2196 - 2196      ER43122      2197 - 2197 
      ER43123      2198 - 2198      ER43124      2199 - 2199      ER43125      2200 - 2200 
      ER43126      2201 - 2206      ER43127      2207 - 2207      ER43128      2208 - 2208 
      ER43129      2209 - 2209      ER43130      2210 - 2210      ER43131      2211 - 2211 
      ER43132      2212 - 2212      ER43133      2213 - 2213      ER43134      2214 - 2214 
      ER43135      2215 - 2215      ER43136      2216 - 2216      ER43137      2217 - 2217 
      ER43138      2218 - 2218      ER43139      2219 - 2219      ER43140      2220 - 2220 
      ER43141      2221 - 2221      ER43142      2222 - 2227      ER43143      2228 - 2228 
      ER43144      2229 - 2229      ER43145      2230 - 2230      ER43146      2231 - 2231 
      ER43147      2232 - 2232      ER43148      2233 - 2233      ER43149      2234 - 2234 
      ER43150      2235 - 2235      ER43151      2236 - 2236      ER43152      2237 - 2237 
      ER43153      2238 - 2238      ER43154      2239 - 2239      ER43155      2240 - 2240 
      ER43156      2241 - 2241      ER43157      2242 - 2242      ER43158      2243 - 2248 
      ER43159      2249 - 2249      ER43160      2250 - 2250      ER43161      2251 - 2251 
      ER43162      2252 - 2252      ER43163      2253 - 2253      ER43164      2254 - 2254 
      ER43165      2255 - 2255      ER43166      2256 - 2256      ER43167      2257 - 2257 
      ER43168      2258 - 2258      ER43169      2259 - 2259      ER43170      2260 - 2260 
      ER43171      2261 - 2261      ER43172      2262 - 2262      ER43173      2263 - 2263 
      ER43174      2264 - 2264      ER43175      2265 - 2270      ER43176      2271 - 2271 
      ER43177      2272 - 2272      ER43178      2273 - 2273      ER43179      2274 - 2274 
      ER43180      2275 - 2275      ER43181      2276 - 2276      ER43182      2277 - 2277 
      ER43183      2278 - 2278      ER43184      2279 - 2279      ER43185      2280 - 2280 
      ER43186      2281 - 2281      ER43187      2282 - 2282      ER43188      2283 - 2283 
      ER43189      2284 - 2284      ER43190      2285 - 2285      ER43191      2286 - 2291 
      ER43192      2292 - 2292      ER43193      2293 - 2293      ER43194      2294 - 2294 
      ER43195      2295 - 2295      ER43196      2296 - 2296      ER43197      2297 - 2297 
      ER43198      2298 - 2298      ER43199      2299 - 2299      ER43200      2300 - 2300 
      ER43201      2301 - 2301      ER43202      2302 - 2302      ER43203      2303 - 2303 
      ER43204      2304 - 2304      ER43205      2305 - 2305      ER43206      2306 - 2306 
      ER43207      2307 - 2312      ER43208      2313 - 2313      ER43209      2314 - 2314 
      ER43210      2315 - 2315      ER43211      2316 - 2316      ER43212      2317 - 2317 
      ER43213      2318 - 2318      ER43214      2319 - 2319      ER43215      2320 - 2320 
      ER43216      2321 - 2321      ER43217      2322 - 2322      ER43218      2323 - 2323 
      ER43219      2324 - 2324      ER43220      2325 - 2325      ER43221      2326 - 2326 
      ER43222      2327 - 2327      ER43223      2328 - 2333      ER43224      2334 - 2334 
      ER43225      2335 - 2335      ER43226      2336 - 2336      ER43227      2337 - 2337 
      ER43228      2338 - 2338      ER43229      2339 - 2339      ER43230      2340 - 2340 
      ER43231      2341 - 2341      ER43232      2342 - 2342      ER43233      2343 - 2343 
      ER43234      2344 - 2344      ER43235      2345 - 2345      ER43236      2346 - 2346 
      ER43237      2347 - 2347      ER43238      2348 - 2348      ER43239      2349 - 2354 
      ER43240      2355 - 2355      ER43241      2356 - 2356      ER43242      2357 - 2357 
      ER43243      2358 - 2358      ER43244      2359 - 2359      ER43245      2360 - 2360 
      ER43246      2361 - 2361      ER43247      2362 - 2362      ER43248      2363 - 2363 
      ER43249      2364 - 2364      ER43250      2365 - 2365      ER43251      2366 - 2366 
      ER43252      2367 - 2367      ER43253      2368 - 2368      ER43254      2369 - 2369 
      ER43255      2370 - 2375      ER43256      2376 - 2376      ER43257      2377 - 2377 
      ER43258      2378 - 2378      ER43259      2379 - 2379      ER43260      2380 - 2380 
      ER43261      2381 - 2381      ER43262      2382 - 2382      ER43263      2383 - 2383 
      ER43264      2384 - 2384      ER43265      2385 - 2385      ER43266      2386 - 2386 
      ER43267      2387 - 2387      ER43268      2388 - 2388      ER43269      2389 - 2389 
      ER43270      2390 - 2390      ER43271      2391 - 2396      ER43272      2397 - 2397 
      ER43273      2398 - 2398      ER43274      2399 - 2399      ER43275      2400 - 2400 
      ER43276      2401 - 2401      ER43277      2402 - 2402      ER43278      2403 - 2403 
      ER43279      2404 - 2404      ER43280      2405 - 2405      ER43281      2406 - 2406 
      ER43282      2407 - 2407      ER43283      2408 - 2408      ER43284      2409 - 2409 
      ER43285      2410 - 2410      ER43286      2411 - 2411      ER43287      2412 - 2412 
      ER43288      2413 - 2413      ER43289      2414 - 2414      ER43290      2415 - 2421 
      ER43291      2422 - 2422      ER43292      2423 - 2423      ER43293      2424 - 2424 
      ER43294      2425 - 2430      ER43295      2431 - 2431      ER43296      2432 - 2432 
      ER43297      2433 - 2433      ER43298      2434 - 2434      ER43299      2435 - 2435 
      ER43300      2436 - 2436      ER43301      2437 - 2437      ER43302      2438 - 2438 
      ER43303      2439 - 2439      ER43304      2440 - 2440      ER43305      2441 - 2441 
      ER43306      2442 - 2442      ER43307      2443 - 2443      ER43308      2444 - 2444 
      ER43309      2445 - 2445      ER43310      2446 - 2451      ER43311      2452 - 2452 
      ER43312      2453 - 2453      ER43313      2454 - 2454      ER43314      2455 - 2455 
      ER43315      2456 - 2456      ER43316      2457 - 2457      ER43317      2458 - 2458 
      ER43318      2459 - 2459      ER43319      2460 - 2460      ER43320      2461 - 2461 
      ER43321      2462 - 2462      ER43322      2463 - 2463      ER43323      2464 - 2464 
      ER43324      2465 - 2465      ER43325      2466 - 2466      ER43326      2467 - 2472 
      ER43327      2473 - 2473      ER43328      2474 - 2474      ER43329      2475 - 2475 
      ER43330      2476 - 2476      ER43331      2477 - 2477      ER43332      2478 - 2478 
      ER43333      2479 - 2479      ER43334      2480 - 2480      ER43335      2481 - 2481 
      ER43336      2482 - 2482      ER43337      2483 - 2483      ER43338      2484 - 2484 
      ER43339      2485 - 2485      ER43340      2486 - 2486      ER43341      2487 - 2487 
      ER43342      2488 - 2488      ER43343      2489 - 2494      ER43344      2495 - 2495 
      ER43345      2496 - 2496      ER43346      2497 - 2497      ER43347      2498 - 2498 
      ER43348      2499 - 2499      ER43349      2500 - 2500      ER43350      2501 - 2501 
      ER43351      2502 - 2502      ER43352      2503 - 2503      ER43353      2504 - 2504 
      ER43354      2505 - 2505      ER43355      2506 - 2506      ER43356      2507 - 2507 
      ER43357      2508 - 2508      ER43358      2509 - 2509      ER43359      2510 - 2510 
      ER43360      2511 - 2516      ER43361      2517 - 2517      ER43362      2518 - 2518 
      ER43363      2519 - 2519      ER43364      2520 - 2520      ER43365      2521 - 2521 
      ER43366      2522 - 2522      ER43367      2523 - 2523      ER43368      2524 - 2524 
      ER43369      2525 - 2525      ER43370      2526 - 2526      ER43371      2527 - 2527 
      ER43372      2528 - 2528      ER43373      2529 - 2529      ER43374      2530 - 2530 
      ER43375      2531 - 2531      ER43376      2532 - 2532      ER43377      2533 - 2538 
      ER43378      2539 - 2539      ER43379      2540 - 2540      ER43380      2541 - 2541 
      ER43381      2542 - 2542      ER43382      2543 - 2543      ER43383      2544 - 2544 
      ER43384      2545 - 2545      ER43385      2546 - 2546      ER43386      2547 - 2547 
      ER43387      2548 - 2548      ER43388      2549 - 2549      ER43389      2550 - 2550 
      ER43390      2551 - 2551      ER43391      2552 - 2552      ER43392      2553 - 2553 
      ER43393      2554 - 2554      ER43394      2555 - 2560      ER43395      2561 - 2561 
      ER43396      2562 - 2562      ER43397      2563 - 2563      ER43398      2564 - 2564 
      ER43399      2565 - 2565      ER43400      2566 - 2566      ER43401      2567 - 2567 
      ER43402      2568 - 2568      ER43403      2569 - 2569      ER43404      2570 - 2570 
      ER43405      2571 - 2571      ER43406      2572 - 2572      ER43407      2573 - 2573 
      ER43408      2574 - 2574      ER43409      2575 - 2575      ER43410      2576 - 2581 
      ER43411      2582 - 2582      ER43412      2583 - 2583      ER43413      2584 - 2584 
      ER43414      2585 - 2585      ER43415      2586 - 2586      ER43416      2587 - 2587 
      ER43417      2588 - 2588      ER43418      2589 - 2589      ER43419      2590 - 2590 
      ER43420      2591 - 2591      ER43421      2592 - 2592      ER43422      2593 - 2593 
      ER43423      2594 - 2594      ER43424      2595 - 2595      ER43425      2596 - 2596 
      ER43426      2597 - 2602      ER43427      2603 - 2603      ER43428      2604 - 2604 
      ER43429      2605 - 2605      ER43430      2606 - 2606      ER43431      2607 - 2607 
      ER43432      2608 - 2608      ER43433      2609 - 2609      ER43434      2610 - 2610 
      ER43435      2611 - 2611      ER43436      2612 - 2612      ER43437      2613 - 2613 
      ER43438      2614 - 2614      ER43439      2615 - 2615      ER43440      2616 - 2616 
      ER43441      2617 - 2617      ER43442      2618 - 2623      ER43443      2624 - 2624 
      ER43444      2625 - 2625      ER43445      2626 - 2626      ER43446      2627 - 2627 
      ER43447      2628 - 2628      ER43448      2629 - 2629      ER43449      2630 - 2630 
      ER43450      2631 - 2631      ER43451      2632 - 2632      ER43452      2633 - 2633 
      ER43453      2634 - 2634      ER43454      2635 - 2635      ER43455      2636 - 2636 
      ER43456      2637 - 2637      ER43457      2638 - 2638      ER43458      2639 - 2644 
      ER43459      2645 - 2645      ER43460      2646 - 2646      ER43461      2647 - 2647 
      ER43462      2648 - 2648      ER43463      2649 - 2649      ER43464      2650 - 2650 
      ER43465      2651 - 2651      ER43466      2652 - 2652      ER43467      2653 - 2653 
      ER43468      2654 - 2654      ER43469      2655 - 2655      ER43470      2656 - 2656 
      ER43471      2657 - 2657      ER43472      2658 - 2658      ER43473      2659 - 2659 
      ER43474      2660 - 2665      ER43475      2666 - 2666      ER43476      2667 - 2667 
      ER43477      2668 - 2668      ER43478      2669 - 2669      ER43479      2670 - 2670 
      ER43480      2671 - 2671      ER43481      2672 - 2672      ER43482      2673 - 2673 
      ER43483      2674 - 2674      ER43484      2675 - 2675      ER43485      2676 - 2676 
      ER43486      2677 - 2677      ER43487      2678 - 2678      ER43488      2679 - 2679 
      ER43489      2680 - 2680      ER43490      2681 - 2686      ER43491      2687 - 2687 
      ER43492      2688 - 2688      ER43493      2689 - 2689      ER43494      2690 - 2690 
      ER43495      2691 - 2691      ER43496      2692 - 2692      ER43497      2693 - 2693 
      ER43498      2694 - 2694      ER43499      2695 - 2695      ER43500      2696 - 2696 
      ER43501      2697 - 2697      ER43502      2698 - 2698      ER43503      2699 - 2699 
      ER43504      2700 - 2700      ER43505      2701 - 2701      ER43506      2702 - 2707 
      ER43507      2708 - 2708      ER43508      2709 - 2709      ER43509      2710 - 2710 
      ER43510      2711 - 2711      ER43511      2712 - 2712      ER43512      2713 - 2713 
      ER43513      2714 - 2714      ER43514      2715 - 2715      ER43515      2716 - 2716 
      ER43516      2717 - 2717      ER43517      2718 - 2718      ER43518      2719 - 2719 
      ER43519      2720 - 2720      ER43520      2721 - 2721      ER43521      2722 - 2722 
      ER43522      2723 - 2729      ER43523      2730 - 2736      ER43524      2737 - 2737 
      ER43525      2738 - 2743      ER43526      2744 - 2749      ER43527      2750 - 2750 
      ER43528      2751 - 2752      ER43529      2753 - 2754      ER43530      2755 - 2756 
      ER43531      2757 - 2758      ER43532      2759 - 2760      ER43533      2761 - 2762 
      ER43534      2763 - 2769      ER43535      2770 - 2770      ER43536      2771 - 2777 
      ER43537      2778 - 2778      ER43538      2779 - 2785      ER43539      2786 - 2786 
      ER43540      2787 - 2788      ER43541      2789 - 2789      ER43542      2790 - 2790 
      ER43543      2791 - 2791      ER43544      2792 - 2800      ER43545      2801 - 2801 
      ER43546      2802 - 2802      ER43547      2803 - 2803      ER43548      2804 - 2812 
      ER43549      2813 - 2813      ER43550      2814 - 2814      ER43551      2815 - 2815 
      ER43552      2816 - 2816      ER43553      2817 - 2825      ER43554      2826 - 2826 
      ER43555      2827 - 2827      ER43556      2828 - 2828      ER43557      2829 - 2829 
      ER43558      2830 - 2838      ER43559      2839 - 2839      ER43560      2840 - 2840 
      ER43561      2841 - 2841      ER43562      2842 - 2842      ER43563      2843 - 2843 
      ER43564      2844 - 2849      ER43565      2850 - 2850      ER43566      2851 - 2851 
      ER43567      2852 - 2852      ER43568      2853 - 2853      ER43569      2854 - 2854 
      ER43570      2855 - 2855      ER43571      2856 - 2856      ER43572      2857 - 2857 
      ER43573      2858 - 2858      ER43574      2859 - 2859      ER43575      2860 - 2860 
      ER43576      2861 - 2861      ER43577      2862 - 2862      ER43578      2863 - 2863 
      ER43579      2864 - 2864      ER43580      2865 - 2873      ER43581      2874 - 2874 
      ER43582      2875 - 2875      ER43583      2876 - 2876      ER43584      2877 - 2877 
      ER43585      2878 - 2878      ER43586      2879 - 2887      ER43587      2888 - 2888 
      ER43588      2889 - 2889      ER43589      2890 - 2890      ER43590      2891 - 2891 
      ER43591      2892 - 2897      ER43592      2898 - 2898      ER43593      2899 - 2899 
      ER43594      2900 - 2900      ER43595      2901 - 2901      ER43596      2902 - 2902 
      ER43597      2903 - 2903      ER43598      2904 - 2904      ER43599      2905 - 2905 
      ER43600      2906 - 2906      ER43601      2907 - 2907      ER43602      2908 - 2908 
      ER43603      2909 - 2909      ER43604      2910 - 2910      ER43605      2911 - 2911 
      ER43606      2912 - 2912      ER43607      2913 - 2921      ER43608      2922 - 2922 
      ER43609      2923 - 2923      ER43610      2924 - 2924      ER43611      2925 - 2925 
      ER43612      2926 - 2934      ER43613      2935 - 2935      ER43614      2936 - 2936 
      ER43615      2937 - 2937      ER43616      2938 - 2938      ER43617      2939 - 2947 
      ER43618      2948 - 2948      ER43619      2949 - 2949      ER43620      2950 - 2950 
      ER43621      2951 - 2951      ER43622      2952 - 2960      ER43623      2961 - 2961 
      ER43624      2962 - 2962      ER43625      2963 - 2963      ER43626      2964 - 2964 
      ER43627      2965 - 2965      ER43628      2966 - 2974      ER43629      2975 - 2975 
      ER43630      2976 - 2976      ER43631      2977 - 2977      ER43632      2978 - 2978 
      ER43633      2979 - 2987      ER43634      2988 - 2988      ER43635      2989 - 2989 
      ER43636      2990 - 2990      ER43637      2991 - 2991      ER43638      2992 - 3000 
      ER43639      3001 - 3001      ER43640      3002 - 3002      ER43641      3003 - 3003 
      ER43642      3004 - 3004      ER43643      3005 - 3013      ER43644      3014 - 3014 
      ER43645      3015 - 3015      ER43646      3016 - 3016      ER43647      3017 - 3025 
      ER43648      3026 - 3026      ER43649      3027 - 3027      ER43650      3028 - 3028 
      ER43651      3029 - 3029      ER43652      3030 - 3038      ER43653      3039 - 3039 
      ER43654      3040 - 3040      ER43655      3041 - 3041      ER43656      3042 - 3042 
      ER43657      3043 - 3043      ER43658      3044 - 3044      ER43659      3045 - 3053 
      ER43660      3054 - 3054      ER43661      3055 - 3055      ER43662      3056 - 3056 
      ER43663      3057 - 3057      ER43664      3058 - 3066      ER43665      3067 - 3067 
      ER43666      3068 - 3068      ER43667      3069 - 3069      ER43668      3070 - 3070 
      ER43669      3071 - 3071      ER43670      3072 - 3080      ER43671      3081 - 3081 
      ER43672      3082 - 3082      ER43673      3083 - 3083      ER43674      3084 - 3084 
      ER43675      3085 - 3085      ER43676      3086 - 3094      ER43677      3095 - 3095 
      ER43678      3096 - 3096      ER43679      3097 - 3097      ER43680      3098 - 3098 
      ER43681      3099 - 3107      ER43682      3108 - 3108      ER43683      3109 - 3109 
      ER43684      3110 - 3110      ER43685      3111 - 3111      ER43686      3112 - 3112 
      ER43687      3113 - 3121      ER43688      3122 - 3122      ER43689      3123 - 3123 
      ER43690      3124 - 3124      ER43691      3125 - 3125      ER43692      3126 - 3134 
      ER43693      3135 - 3135      ER43694      3136 - 3136      ER43695      3137 - 3137 
      ER43696      3138 - 3138      ER43697      3139 - 3142      ER43698      3143 - 3151 
      ER43699      3152 - 3152      ER43700      3153 - 3153      ER43701      3154 - 3154 
      ER43702      3155 - 3158      ER43703      3159 - 3167      ER43704      3168 - 3168 
      ER43705      3169 - 3169      ER43706      3170 - 3170      ER43707      3171 - 3174 
      ER43708      3175 - 3183      ER43709      3184 - 3184      ER43710      3185 - 3185 
      ER43711      3186 - 3186      ER43712      3187 - 3187      ER43713      3188 - 3189 
      ER43714      3190 - 3193      ER43715      3194 - 3194      ER43716      3195 - 3197 
      ER43717      3198 - 3198      ER43718      3199 - 3200      ER43719      3201 - 3201 
      ER43720      3202 - 3202      ER43721      3203 - 3209      ER43722      3210 - 3210 
      ER43723      3211 - 3213      ER43724      3214 - 3214      ER43725      3215 - 3221 
      ER43726      3222 - 3222      ER43727      3223 - 3225      ER43728      3226 - 3226 
      ER43729      3227 - 3227      ER43730      3228 - 3234      ER43731      3235 - 3235 
      ER43732      3236 - 3238      ER43733      3239 - 3241      ER43734      3242 - 3250 
      ER43735      3251 - 3251      ER43736      3252 - 3252      ER43737      3253 - 3253 
      ER43738      3254 - 3254      ER43739      3255 - 3255      ER43740      3256 - 3264 
      ER43741      3265 - 3265      ER43742      3266 - 3268      ER43743      3269 - 3269 
      ER43744      3270 - 3270      ER43745      3271 - 3273      ER43746      3274 - 3276 
      ER43747      3277 - 3279      ER43748      3280 - 3282      ER43749      3283 - 3283 
      ER43750      3284 - 3284      ER43751      3285 - 3287      ER43752      3288 - 3289 
      ER43753      3290 - 3292      ER43754      3293 - 3295      ER43755      3296 - 3298 
      ER43756      3299 - 3299      ER43757      3300 - 3306      ER43758      3307 - 3307 
      ER43759      3308 - 3310      ER43760      3311 - 3319      ER43761      3320 - 3320 
      ER43762      3321 - 3321      ER43763      3322 - 3322      ER43764      3323 - 3323 
      ER43765      3324 - 3324      ER43766      3325 - 3325      ER43767      3326 - 3326 
      ER43768      3327 - 3327      ER43769      3328 - 3329      ER43770      3330 - 3331 
      ER43771      3332 - 3334      ER43772      3335 - 3338      ER43773      3339 - 3341 
      ER43774      3342 - 3345      ER43775      3346 - 3346      ER43776      3347 - 3347 
      ER43777      3348 - 3354      ER43778      3355 - 3355      ER43779      3356 - 3358 
      ER43780      3359 - 3359      ER43781      3360 - 3360      ER43782      3361 - 3368 
      ER43783      3369 - 3369      ER43784      3370 - 3370      ER43785      3371 - 3371 
      ER43786      3372 - 3372      ER43787      3373 - 3373      ER43788      3374 - 3381 
      ER43789      3382 - 3382      ER43790      3383 - 3383      ER43791      3384 - 3384 
      ER43792      3385 - 3385      ER43793      3386 - 3387      ER43794      3388 - 3394 
      ER43795      3395 - 3395      ER43796      3396 - 3396      ER43797      3397 - 3397 
      ER43798      3398 - 3398      ER43799      3399 - 3399      ER43800      3400 - 3400 
      ER43801      3401 - 3401      ER43802      3402 - 3402      ER43803      3403 - 3403 
      ER43804      3404 - 3404      ER43805      3405 - 3405      ER43806      3406 - 3407 
      ER43807      3408 - 3411      ER43808      3412 - 3418      ER43809      3419 - 3419 
      ER43810      3420 - 3420      ER43811      3421 - 3421      ER43812      3422 - 3422 
      ER43813      3423 - 3423      ER43814      3424 - 3424      ER43815      3425 - 3425 
      ER43816      3426 - 3432      ER43817      3433 - 3433      ER43818      3434 - 3434 
      ER43819      3435 - 3435      ER43820      3436 - 3436      ER43821      3437 - 3437 
      ER43822      3438 - 3438      ER43823      3439 - 3439      ER43824      3440 - 3440 
      ER43825      3441 - 3441      ER43826      3442 - 3442      ER43827      3443 - 3449 
      ER43828      3450 - 3450      ER43829      3451 - 3451      ER43830      3452 - 3452 
      ER43831      3453 - 3453      ER43832      3454 - 3455      ER43833      3456 - 3457 
      ER43834      3458 - 3463      ER43835      3464 - 3464      ER43836      3465 - 3467 
      ER43837      3468 - 3475      ER43838      3476 - 3476      ER43839      3477 - 3477 
      ER43840      3478 - 3478      ER43841      3479 - 3479      ER43842      3480 - 3486 
      ER43843      3487 - 3487      ER43844      3488 - 3488      ER43845      3489 - 3489 
      ER43846      3490 - 3490      ER43847      3491 - 3491      ER43848      3492 - 3499 
      ER43849      3500 - 3500      ER43850      3501 - 3501      ER43851      3502 - 3502 
      ER43852      3503 - 3503      ER43853      3504 - 3505      ER43854      3506 - 3512 
      ER43855      3513 - 3513      ER43856      3514 - 3514      ER43857      3515 - 3515 
      ER43858      3516 - 3516      ER43859      3517 - 3517      ER43860      3518 - 3519 
      ER43861      3520 - 3520      ER43862      3521 - 3521      ER43863      3522 - 3529 
      ER43864      3530 - 3530      ER43865      3531 - 3531      ER43866      3532 - 3532 
      ER43867      3533 - 3533      ER43868      3534 - 3534      ER43869      3535 - 3542 
      ER43870      3543 - 3543      ER43871      3544 - 3544      ER43872      3545 - 3545 
      ER43873      3546 - 3546      ER43874      3547 - 3548      ER43875      3549 - 3555 
      ER43876      3556 - 3556      ER43877      3557 - 3557      ER43878      3558 - 3558 
      ER43879      3559 - 3559      ER43880      3560 - 3560      ER43881      3561 - 3561 
      ER43882      3562 - 3562      ER43883      3563 - 3563      ER43884      3564 - 3564 
      ER43885      3565 - 3565      ER43886      3566 - 3566      ER43887      3567 - 3568 
      ER43888      3569 - 3572      ER43889      3573 - 3579      ER43890      3580 - 3580 
      ER43891      3581 - 3581      ER43892      3582 - 3582      ER43893      3583 - 3583 
      ER43894      3584 - 3584      ER43895      3585 - 3585      ER43896      3586 - 3586 
      ER43897      3587 - 3593      ER43898      3594 - 3594      ER43899      3595 - 3595 
      ER43900      3596 - 3596      ER43901      3597 - 3597      ER43902      3598 - 3598 
      ER43903      3599 - 3599      ER43904      3600 - 3600      ER43905      3601 - 3601 
      ER43906      3602 - 3602      ER43907      3603 - 3603      ER43908      3604 - 3610 
      ER43909      3611 - 3611      ER43910      3612 - 3612      ER43911      3613 - 3613 
      ER43912      3614 - 3614      ER43913      3615 - 3616      ER43914      3617 - 3618 
      ER43915      3619 - 3624      ER43916      3625 - 3625      ER43917      3626 - 3628 
      ER43918      3629 - 3636      ER43919      3637 - 3637      ER43920      3638 - 3638 
      ER43921      3639 - 3639      ER43922      3640 - 3640      ER43923      3641 - 3647 
      ER43924      3648 - 3648      ER43925      3649 - 3649      ER43926      3650 - 3650 
      ER43927      3651 - 3651      ER43928      3652 - 3652      ER43929      3653 - 3660 
      ER43930      3661 - 3661      ER43931      3662 - 3662      ER43932      3663 - 3663 
      ER43933      3664 - 3664      ER43934      3665 - 3666      ER43935      3667 - 3673 
      ER43936      3674 - 3674      ER43937      3675 - 3675      ER43938      3676 - 3676 
      ER43939      3677 - 3677      ER43940      3678 - 3678      ER43941      3679 - 3680 
      ER43942      3681 - 3681      ER43943      3682 - 3682      ER43944      3683 - 3683 
      ER43945      3684 - 3685      ER43946      3686 - 3689      ER43947      3690 - 3690 
      ER43948      3691 - 3693      ER43949      3694 - 3694      ER43950      3695 - 3696 
      ER43951      3697 - 3697      ER43952      3698 - 3698      ER43953      3699 - 3705 
      ER43954      3706 - 3706      ER43955      3707 - 3709      ER43956      3710 - 3710 
      ER43957      3711 - 3717      ER43958      3718 - 3718      ER43959      3719 - 3721 
      ER43960      3722 - 3722      ER43961      3723 - 3723      ER43962      3724 - 3730 
      ER43963      3731 - 3731      ER43964      3732 - 3734      ER43965      3735 - 3737 
      ER43966      3738 - 3746      ER43967      3747 - 3747      ER43968      3748 - 3748 
      ER43969      3749 - 3749      ER43970      3750 - 3750      ER43971      3751 - 3751 
      ER43972      3752 - 3760      ER43973      3761 - 3761      ER43974      3762 - 3764 
      ER43975      3765 - 3765      ER43976      3766 - 3766      ER43977      3767 - 3769 
      ER43978      3770 - 3772      ER43979      3773 - 3775      ER43980      3776 - 3778 
      ER43981      3779 - 3779      ER43982      3780 - 3780      ER43983      3781 - 3783 
      ER43984      3784 - 3785      ER43985      3786 - 3788      ER43986      3789 - 3791 
      ER43987      3792 - 3794      ER43988      3795 - 3795      ER43989      3796 - 3802 
      ER43990      3803 - 3803      ER43991      3804 - 3806      ER43992      3807 - 3815 
      ER43993      3816 - 3816      ER43994      3817 - 3817      ER43995      3818 - 3818 
      ER43996      3819 - 3819      ER43997      3820 - 3820      ER43998      3821 - 3821 
      ER43999      3822 - 3822      ER44000      3823 - 3823      ER44001      3824 - 3825 
      ER44002      3826 - 3827      ER44003      3828 - 3830      ER44004      3831 - 3834 
      ER44005      3835 - 3837      ER44006      3838 - 3841      ER44007      3842 - 3842 
      ER44008      3843 - 3843      ER44009      3844 - 3850      ER44010      3851 - 3851 
      ER44011      3852 - 3854      ER44012      3855 - 3855      ER44013      3856 - 3856 
      ER44014      3857 - 3864      ER44015      3865 - 3865      ER44016      3866 - 3866 
      ER44017      3867 - 3867      ER44018      3868 - 3868      ER44019      3869 - 3869 
      ER44020      3870 - 3877      ER44021      3878 - 3878      ER44022      3879 - 3879 
      ER44023      3880 - 3880      ER44024      3881 - 3881      ER44025      3882 - 3883 
      ER44026      3884 - 3890      ER44027      3891 - 3891      ER44028      3892 - 3892 
      ER44029      3893 - 3893      ER44030      3894 - 3894      ER44031      3895 - 3895 
      ER44032      3896 - 3896      ER44033      3897 - 3897      ER44034      3898 - 3898 
      ER44035      3899 - 3899      ER44036      3900 - 3900      ER44037      3901 - 3901 
      ER44038      3902 - 3903      ER44039      3904 - 3907      ER44040      3908 - 3914 
      ER44041      3915 - 3915      ER44042      3916 - 3916      ER44043      3917 - 3917 
      ER44044      3918 - 3918      ER44045      3919 - 3919      ER44046      3920 - 3920 
      ER44047      3921 - 3921      ER44048      3922 - 3928      ER44049      3929 - 3929 
      ER44050      3930 - 3930      ER44051      3931 - 3931      ER44052      3932 - 3932 
      ER44053      3933 - 3933      ER44054      3934 - 3934      ER44055      3935 - 3935 
      ER44056      3936 - 3936      ER44057      3937 - 3937      ER44058      3938 - 3938 
      ER44059      3939 - 3945      ER44060      3946 - 3946      ER44061      3947 - 3947 
      ER44062      3948 - 3948      ER44063      3949 - 3949      ER44064      3950 - 3951 
      ER44065      3952 - 3953      ER44066      3954 - 3959      ER44067      3960 - 3960 
      ER44068      3961 - 3963      ER44069      3964 - 3971      ER44070      3972 - 3972 
      ER44071      3973 - 3973      ER44072      3974 - 3974      ER44073      3975 - 3975 
      ER44074      3976 - 3982      ER44075      3983 - 3983      ER44076      3984 - 3984 
      ER44077      3985 - 3985      ER44078      3986 - 3986      ER44079      3987 - 3987 
      ER44080      3988 - 3995      ER44081      3996 - 3996      ER44082      3997 - 3997 
      ER44083      3998 - 3998      ER44084      3999 - 3999      ER44085      4000 - 4001 
      ER44086      4002 - 4008      ER44087      4009 - 4009      ER44088      4010 - 4010 
      ER44089      4011 - 4011      ER44090      4012 - 4012      ER44091      4013 - 4013 
      ER44092      4014 - 4015      ER44093      4016 - 4016      ER44094      4017 - 4017 
      ER44095      4018 - 4025      ER44096      4026 - 4026      ER44097      4027 - 4027 
      ER44098      4028 - 4028      ER44099      4029 - 4029      ER44100      4030 - 4030 
      ER44101      4031 - 4038      ER44102      4039 - 4039      ER44103      4040 - 4040 
      ER44104      4041 - 4041      ER44105      4042 - 4042      ER44106      4043 - 4044 
      ER44107      4045 - 4051      ER44108      4052 - 4052      ER44109      4053 - 4053 
      ER44110      4054 - 4054      ER44111      4055 - 4055      ER44112      4056 - 4056 
      ER44113      4057 - 4057      ER44114      4058 - 4058      ER44115      4059 - 4059 
      ER44116      4060 - 4060      ER44117      4061 - 4061      ER44118      4062 - 4062 
      ER44119      4063 - 4064      ER44120      4065 - 4068      ER44121      4069 - 4075 
      ER44122      4076 - 4076      ER44123      4077 - 4077      ER44124      4078 - 4078 
      ER44125      4079 - 4079      ER44126      4080 - 4080      ER44127      4081 - 4081 
      ER44128      4082 - 4082      ER44129      4083 - 4089      ER44130      4090 - 4090 
      ER44131      4091 - 4091      ER44132      4092 - 4092      ER44133      4093 - 4093 
      ER44134      4094 - 4094      ER44135      4095 - 4095      ER44136      4096 - 4096 
      ER44137      4097 - 4097      ER44138      4098 - 4098      ER44139      4099 - 4099 
      ER44140      4100 - 4106      ER44141      4107 - 4107      ER44142      4108 - 4108 
      ER44143      4109 - 4109      ER44144      4110 - 4110      ER44145      4111 - 4112 
      ER44146      4113 - 4114      ER44147      4115 - 4120      ER44148      4121 - 4121 
      ER44149      4122 - 4124      ER44150      4125 - 4132      ER44151      4133 - 4133 
      ER44152      4134 - 4134      ER44153      4135 - 4135      ER44154      4136 - 4136 
      ER44155      4137 - 4143      ER44156      4144 - 4144      ER44157      4145 - 4145 
      ER44158      4146 - 4146      ER44159      4147 - 4147      ER44160      4148 - 4148 
      ER44161      4149 - 4156      ER44162      4157 - 4157      ER44163      4158 - 4158 
      ER44164      4159 - 4159      ER44165      4160 - 4160      ER44166      4161 - 4162 
      ER44167      4163 - 4169      ER44168      4170 - 4170      ER44169      4171 - 4171 
      ER44170      4172 - 4172      ER44171      4173 - 4173      ER44172      4174 - 4174 
      ER44173      4175 - 4176      ER44174      4177 - 4177      ER44175      4178 - 4178 
      ER44176      4179 - 4179      ER44177      4180 - 4180      ER44178      4181 - 4181 
      ER44179      4182 - 4182      ER44180      4183 - 4183      ER44181      4184 - 4184 
      ER44182      4185 - 4185      ER44183      4186 - 4188      ER44184      4189 - 4189 
      ER44185      4190 - 4190      ER44186      4191 - 4191      ER44187      4192 - 4194 
      ER44188      4195 - 4195      ER44189      4196 - 4196      ER44190      4197 - 4197 
      ER44191      4198 - 4200      ER44192      4201 - 4201      ER44193      4202 - 4202 
      ER44194      4203 - 4203      ER44195      4204 - 4206      ER44196      4207 - 4207 
      ER44197      4208 - 4208      ER44198      4209 - 4209      ER44199      4210 - 4212 
      ER44200      4213 - 4213      ER44201      4214 - 4214      ER44202      4215 - 4215 
      ER44203      4216 - 4218      ER44204      4219 - 4219      ER44205      4220 - 4220 
      ER44206      4221 - 4221      ER44207      4222 - 4224      ER44208      4225 - 4225 
      ER44209      4226 - 4226      ER44210      4227 - 4227      ER44211      4228 - 4230 
      ER44212      4231 - 4231      ER44213      4232 - 4232      ER44214      4233 - 4233 
      ER44215      4234 - 4236      ER44216      4237 - 4237      ER44217      4238 - 4238 
      ER44218      4239 - 4239      ER44219      4240 - 4242      ER44220      4243 - 4243 
      ER44221      4244 - 4244      ER44222      4245 - 4245      ER44223      4246 - 4248 
      ER44224      4249 - 4249      ER44225      4250 - 4250      ER44226      4251 - 4252 
      ER44227      4253 - 4254      ER44228      4255 - 4255      ER44229      4256 - 4256 
      ER44230      4257 - 4259      ER44231      4260 - 4261      ER44232      4262 - 4263 
      ER44233      4264 - 4265      ER44234      4266 - 4266      ER44235      4267 - 4267 
      ER44236      4268 - 4268      ER44237      4269 - 4271      ER44238      4272 - 4272 
      ER44239      4273 - 4273      ER44240      4274 - 4274      ER44241      4275 - 4277 
      ER44242      4278 - 4279      ER44243      4280 - 4280      ER44244      4281 - 4281 
      ER44245      4282 - 4282      ER44246      4283 - 4283      ER44247      4284 - 4284 
      ER44248      4285 - 4285      ER44249      4286 - 4286      ER44250      4287 - 4287 
      ER44251      4288 - 4288      ER44252      4289 - 4289      ER44253      4290 - 4290 
      ER44254      4291 - 4291      ER44255      4292 - 4292      ER44256      4293 - 4293 
      ER44257      4294 - 4294      ER44258      4295 - 4295      ER44259      4296 - 4296 
      ER44260      4297 - 4297      ER44261      4298 - 4298      ER44262      4299 - 4299 
      ER44263      4300 - 4300      ER44264      4301 - 4301      ER44265      4302 - 4302 
      ER44266      4303 - 4303      ER44267      4304 - 4304      ER44268      4305 - 4305 
      ER44269      4306 - 4306      ER44270      4307 - 4307      ER44271      4308 - 4308 
      ER44272      4309 - 4309      ER44273      4310 - 4310      ER44274      4311 - 4311 
      ER44275      4312 - 4312      ER44276      4313 - 4315      ER44277      4316 - 4316 
      ER44278      4317 - 4319      ER44279      4320 - 4320      ER44280      4321 - 4323 
      ER44281      4324 - 4324      ER44282      4325 - 4325      ER44283      4326 - 4328 
      ER44284      4329 - 4330      ER44285      4331 - 4331      ER44286      4332 - 4334 
      ER44287      4335 - 4336      ER44288      4337 - 4338      ER44289      4339 - 4339 
      ER44290      4340 - 4340      ER44291      4341 - 4342      ER44292      4343 - 4345 
      ER44293      4346 - 4348      ER44294      4349 - 4349      ER44295      4350 - 4351 
      ER44296      4352 - 4352      ER44297      4353 - 4353      ER44298      4354 - 4354 
      ER44299      4355 - 4355      ER44300      4356 - 4356      ER44301      4357 - 4357 
      ER44302      4358 - 4358      ER44303      4359 - 4359      ER44304      4360 - 4360 
      ER44305      4361 - 4361      ER44306      4362 - 4362      ER44307      4363 - 4363 
      ER44308      4364 - 4364      ER44309      4365 - 4365      ER44310      4366 - 4366 
      ER44311      4367 - 4367      ER44312      4368 - 4368      ER44313      4369 - 4369 
      ER44314      4370 - 4370      ER44315      4371 - 4371      ER44316      4372 - 4372 
      ER44317      4373 - 4376      ER44318      4377 - 4377      ER44319      4378 - 4378 
      ER44320      4379 - 4379      ER44321      4380 - 4380      ER44322      4381 - 4381 
      ER44323      4382 - 4382      ER44324      4383 - 4383      ER44325      4384 - 4384 
      ER44326      4385 - 4385      ER44327      4386 - 4386      ER44328      4387 - 4387 
      ER44329      4388 - 4388      ER44330      4389 - 4389      ER44331      4390 - 4390 
      ER44332      4391 - 4391      ER44333      4392 - 4392      ER44334      4393 - 4393 
      ER44335      4394 - 4394      ER44336      4395 - 4395      ER44337      4396 - 4396 
      ER44338      4397 - 4397      ER44339      4398 - 4398      ER44340      4399 - 4399 
      ER44341      4400 - 4400      ER44342      4401 - 4401      ER44343      4402 - 4402 
      ER44344      4403 - 4403      ER44345      4404 - 4404      ER44346      4405 - 4405 
      ER44347      4406 - 4406      ER44348      4407 - 4407      ER44349      4408 - 4408 
      ER44350      4409 - 4409      ER44351      4410 - 4410      ER44352      4411 - 4411 
      ER44353      4412 - 4412      ER44354      4413 - 4413      ER44355      4414 - 4414 
      ER44356      4415 - 4415      ER44357      4416 - 4416      ER44358      4417 - 4417 
      ER44359      4418 - 4418      ER44360      4419 - 4419      ER44361      4420 - 4420 
      ER44362      4421 - 4421      ER44363      4422 - 4422      ER44364      4423 - 4423 
      ER44365      4424 - 4424      ER44366      4425 - 4425      ER44367      4426 - 4426 
      ER44368      4427 - 4427      ER44369      4428 - 4428      ER44370      4429 - 4429 
      ER44371      4430 - 4430      ER44372      4431 - 4431      ER44373      4432 - 4432 
      ER44374      4433 - 4433      ER44375      4434 - 4434      ER44376      4435 - 4435 
      ER44377      4436 - 4436      ER44378      4437 - 4437      ER44379      4438 - 4438 
      ER44380      4439 - 4439      ER44381      4440 - 4440      ER44382      4441 - 4441 
      ER44383      4442 - 4442      ER44384      4443 - 4443      ER44385      4444 - 4444 
      ER44386      4445 - 4445      ER44387      4446 - 4448      ER44388      4449 - 4449 
      ER44389      4450 - 4450      ER44390      4451 - 4451      ER44391      4452 - 4452 
      ER44392      4453 - 4453      ER44393      4454 - 4454      ER44394      4455 - 4455 
      ER44395      4456 - 4456      ER44396      4457 - 4457      ER44397      4458 - 4458 
      ER44398      4459 - 4459      ER44399      4460 - 4460      ER44400      4461 - 4461 
      ER44401      4462 - 4462      ER44402      4463 - 4463      ER44403      4464 - 4464 
      ER44404      4465 - 4465      ER44405      4466 - 4466      ER44406      4467 - 4469 
      ER44407      4470 - 4470      ER44408      4471 - 4471      ER44409      4472 - 4472 
      ER44410      4473 - 4473      ER44411      4474 - 4474      ER44412      4475 - 4475 
      ER44413      4476 - 4476      ER44414      4477 - 4477      ER44415      4478 - 4478 
      ER44416      4479 - 4479      ER44417      4480 - 4480      ER44418      4481 - 4481 
      ER44419      4482 - 4482      ER44420      4483 - 4483      ER44421      4484 - 4484 
      ER44422      4485 - 4485      ER44423      4486 - 4486      ER44424      4487 - 4487 
      ER44425      4488 - 4490      ER44426      4491 - 4491      ER44427      4492 - 4492 
      ER44428      4493 - 4493      ER44429      4494 - 4494      ER44430      4495 - 4495 
      ER44431      4496 - 4496      ER44432      4497 - 4497      ER44433      4498 - 4498 
      ER44434      4499 - 4499      ER44435      4500 - 4500      ER44436      4501 - 4501 
      ER44437      4502 - 4502      ER44438      4503 - 4503      ER44439      4504 - 4504 
      ER44440      4505 - 4505      ER44441      4506 - 4506      ER44442      4507 - 4507 
      ER44443      4508 - 4508      ER44444      4509 - 4511      ER44445      4512 - 4512 
      ER44446      4513 - 4513      ER44447      4514 - 4514      ER44448      4515 - 4515 
      ER44449      4516 - 4516      ER44450      4517 - 4517      ER44451      4518 - 4518 
      ER44452      4519 - 4519      ER44453      4520 - 4520      ER44454      4521 - 4521 
      ER44455      4522 - 4522      ER44456      4523 - 4523      ER44457      4524 - 4524 
      ER44458      4525 - 4525      ER44459      4526 - 4526      ER44460      4527 - 4527 
      ER44461      4528 - 4528      ER44462      4529 - 4529      ER44463      4530 - 4532 
      ER44464      4533 - 4533      ER44465      4534 - 4534      ER44466      4535 - 4535 
      ER44467      4536 - 4536      ER44468      4537 - 4537      ER44469      4538 - 4538 
      ER44470      4539 - 4539      ER44471      4540 - 4540      ER44472      4541 - 4541 
      ER44473      4542 - 4542      ER44474      4543 - 4543      ER44475      4544 - 4544 
      ER44476      4545 - 4545      ER44477      4546 - 4546      ER44478      4547 - 4547 
      ER44479      4548 - 4548      ER44480      4549 - 4549      ER44481      4550 - 4550 
      ER44482      4551 - 4553      ER44483      4554 - 4554      ER44484      4555 - 4555 
      ER44485      4556 - 4556      ER44486      4557 - 4557      ER44487      4558 - 4558 
      ER44488      4559 - 4559      ER44489      4560 - 4560      ER44490      4561 - 4561 
      ER44491      4562 - 4562      ER44492      4563 - 4563      ER44493      4564 - 4564 
      ER44494      4565 - 4565      ER44495      4566 - 4566      ER44496      4567 - 4567 
      ER44497      4568 - 4568      ER44498      4569 - 4569      ER44499      4570 - 4570 
      ER44500      4571 - 4571      ER44501      4572 - 4574      ER44502      4575 - 4575 
      ER44503      4576 - 4576      ER44504      4577 - 4577      ER44505      4578 - 4578 
      ER44506      4579 - 4579      ER44507      4580 - 4580      ER44508      4581 - 4581 
      ER44509      4582 - 4582      ER44510      4583 - 4583      ER44511      4584 - 4584 
      ER44512      4585 - 4585      ER44513      4586 - 4586      ER44514      4587 - 4587 
      ER44515      4588 - 4588      ER44516      4589 - 4589      ER44517      4590 - 4590 
      ER44518      4591 - 4591      ER44519      4592 - 4592      ER44520      4593 - 4595 
      ER44521      4596 - 4596      ER44522      4597 - 4597      ER44523      4598 - 4598 
      ER44524      4599 - 4599      ER44525      4600 - 4600      ER44526      4601 - 4601 
      ER44527      4602 - 4602      ER44528      4603 - 4603      ER44529      4604 - 4604 
      ER44530      4605 - 4605      ER44531      4606 - 4606      ER44532      4607 - 4607 
      ER44533      4608 - 4608      ER44534      4609 - 4609      ER44535      4610 - 4610 
      ER44536      4611 - 4611      ER44537      4612 - 4612      ER44538      4613 - 4613 
      ER44539      4614 - 4616      ER44540      4617 - 4617      ER44541      4618 - 4618 
      ER44542      4619 - 4619      ER44543      4620 - 4620      ER44544      4621 - 4621 
      ER44545      4622 - 4622      ER44546      4623 - 4623      ER44547      4624 - 4624 
      ER44548      4625 - 4625      ER44549      4626 - 4626      ER44550      4627 - 4627 
      ER44551      4628 - 4628      ER44552      4629 - 4629      ER44553      4630 - 4630 
      ER44554      4631 - 4631      ER44555      4632 - 4632      ER44556      4633 - 4633 
      ER44557      4634 - 4634      ER44558      4635 - 4637      ER44559      4638 - 4638 
      ER44560      4639 - 4639      ER44561      4640 - 4640      ER44562      4641 - 4641 
      ER44563      4642 - 4642      ER44564      4643 - 4643      ER44565      4644 - 4644 
      ER44566      4645 - 4645      ER44567      4646 - 4646      ER44568      4647 - 4647 
      ER44569      4648 - 4648      ER44570      4649 - 4649      ER44571      4650 - 4650 
      ER44572      4651 - 4651      ER44573      4652 - 4652      ER44574      4653 - 4653 
      ER44575      4654 - 4654      ER44576      4655 - 4655      ER44577      4656 - 4658 
      ER44578      4659 - 4659      ER44579      4660 - 4660      ER44580      4661 - 4661 
      ER44581      4662 - 4662      ER44582      4663 - 4663      ER44583      4664 - 4664 
      ER44584      4665 - 4665      ER44585      4666 - 4666      ER44586      4667 - 4667 
      ER44587      4668 - 4668      ER44588      4669 - 4669      ER44589      4670 - 4670 
      ER44590      4671 - 4671      ER44591      4672 - 4672      ER44592      4673 - 4673 
      ER44593      4674 - 4674      ER44594      4675 - 4675      ER44595      4676 - 4676 
      ER44596      4677 - 4679      ER44597      4680 - 4680      ER44598      4681 - 4681 
      ER44599      4682 - 4682      ER44600      4683 - 4683      ER44601      4684 - 4684 
      ER44602      4685 - 4685      ER44603      4686 - 4686      ER44604      4687 - 4687 
      ER44605      4688 - 4688      ER44606      4689 - 4689      ER44607      4690 - 4690 
      ER44608      4691 - 4691      ER44609      4692 - 4692      ER44610      4693 - 4693 
      ER44611      4694 - 4694      ER44612      4695 - 4695      ER44613      4696 - 4696 
      ER44614      4697 - 4697      ER44615      4698 - 4700      ER44616      4701 - 4701 
      ER44617      4702 - 4702      ER44618      4703 - 4703      ER44619      4704 - 4704 
      ER44620      4705 - 4705      ER44621      4706 - 4706      ER44622      4707 - 4707 
      ER44623      4708 - 4708      ER44624      4709 - 4709      ER44625      4710 - 4710 
      ER44626      4711 - 4711      ER44627      4712 - 4712      ER44628      4713 - 4713 
      ER44629      4714 - 4714      ER44630      4715 - 4715      ER44631      4716 - 4716 
      ER44632      4717 - 4717      ER44633      4718 - 4718      ER44634      4719 - 4721 
      ER44635      4722 - 4725      ER44636      4726 - 4726      ER44637      4727 - 4727 
      ER44638      4728 - 4728      ER44639      4729 - 4729      ER44640      4730 - 4730 
      ER44641      4731 - 4731      ER44642      4732 - 4732      ER44643      4733 - 4733 
      ER44644      4734 - 4734      ER44645      4735 - 4735      ER44646      4736 - 4736 
      ER44647      4737 - 4737      ER44648      4738 - 4738      ER44649      4739 - 4739 
      ER44650      4740 - 4740      ER44651      4741 - 4741      ER44652      4742 - 4742 
      ER44653      4743 - 4743      ER44654      4744 - 4744      ER44655      4745 - 4745 
      ER44656      4746 - 4746      ER44657      4747 - 4747      ER44658      4748 - 4748 
      ER44659      4749 - 4749      ER44660      4750 - 4750      ER44661      4751 - 4751 
      ER44662      4752 - 4752      ER44663      4753 - 4753      ER44664      4754 - 4754 
      ER44665      4755 - 4755      ER44666      4756 - 4756      ER44667      4757 - 4757 
      ER44668      4758 - 4758      ER44669      4759 - 4759      ER44670      4760 - 4760 
      ER44671      4761 - 4761      ER44672      4762 - 4762      ER44673      4763 - 4763 
      ER44674      4764 - 4764      ER44675      4765 - 4765      ER44676      4766 - 4766 
      ER44677      4767 - 4767      ER44678      4768 - 4768      ER44679      4769 - 4769 
      ER44680      4770 - 4770      ER44681      4771 - 4771      ER44682      4772 - 4772 
      ER44683      4773 - 4773      ER44684      4774 - 4774      ER44685      4775 - 4775 
      ER44686      4776 - 4776      ER44687      4777 - 4777      ER44688      4778 - 4778 
      ER44689      4779 - 4779      ER44690      4780 - 4780      ER44691      4781 - 4781 
      ER44692      4782 - 4782      ER44693      4783 - 4783      ER44694      4784 - 4784 
      ER44695      4785 - 4785      ER44696      4786 - 4786      ER44697      4787 - 4787 
      ER44698      4788 - 4788      ER44699      4789 - 4789      ER44700      4790 - 4790 
      ER44701      4791 - 4791      ER44702      4792 - 4792      ER44703      4793 - 4793 
      ER44704      4794 - 4794      ER44705      4795 - 4797      ER44706      4798 - 4798 
      ER44707      4799 - 4799      ER44708      4800 - 4800      ER44709      4801 - 4801 
      ER44710      4802 - 4802      ER44711      4803 - 4803      ER44712      4804 - 4804 
      ER44713      4805 - 4805      ER44714      4806 - 4806      ER44715      4807 - 4807 
      ER44716      4808 - 4808      ER44717      4809 - 4809      ER44718      4810 - 4810 
      ER44719      4811 - 4811      ER44720      4812 - 4812      ER44721      4813 - 4813 
      ER44722      4814 - 4814      ER44723      4815 - 4815      ER44724      4816 - 4818 
      ER44725      4819 - 4819      ER44726      4820 - 4820      ER44727      4821 - 4821 
      ER44728      4822 - 4822      ER44729      4823 - 4823      ER44730      4824 - 4824 
      ER44731      4825 - 4825      ER44732      4826 - 4826      ER44733      4827 - 4827 
      ER44734      4828 - 4828      ER44735      4829 - 4829      ER44736      4830 - 4830 
      ER44737      4831 - 4831      ER44738      4832 - 4832      ER44739      4833 - 4833 
      ER44740      4834 - 4834      ER44741      4835 - 4835      ER44742      4836 - 4836 
      ER44743      4837 - 4839      ER44744      4840 - 4840      ER44745      4841 - 4841 
      ER44746      4842 - 4842      ER44747      4843 - 4843      ER44748      4844 - 4844 
      ER44749      4845 - 4845      ER44750      4846 - 4846      ER44751      4847 - 4847 
      ER44752      4848 - 4848      ER44753      4849 - 4849      ER44754      4850 - 4850 
      ER44755      4851 - 4851      ER44756      4852 - 4852      ER44757      4853 - 4853 
      ER44758      4854 - 4854      ER44759      4855 - 4855      ER44760      4856 - 4856 
      ER44761      4857 - 4857      ER44762      4858 - 4860      ER44763      4861 - 4861 
      ER44764      4862 - 4862      ER44765      4863 - 4863      ER44766      4864 - 4864 
      ER44767      4865 - 4865      ER44768      4866 - 4866      ER44769      4867 - 4867 
      ER44770      4868 - 4868      ER44771      4869 - 4869      ER44772      4870 - 4870 
      ER44773      4871 - 4871      ER44774      4872 - 4872      ER44775      4873 - 4873 
      ER44776      4874 - 4874      ER44777      4875 - 4875      ER44778      4876 - 4876 
      ER44779      4877 - 4877      ER44780      4878 - 4878      ER44781      4879 - 4881 
      ER44782      4882 - 4882      ER44783      4883 - 4883      ER44784      4884 - 4884 
      ER44785      4885 - 4885      ER44786      4886 - 4886      ER44787      4887 - 4887 
      ER44788      4888 - 4888      ER44789      4889 - 4889      ER44790      4890 - 4890 
      ER44791      4891 - 4891      ER44792      4892 - 4892      ER44793      4893 - 4893 
      ER44794      4894 - 4894      ER44795      4895 - 4895      ER44796      4896 - 4896 
      ER44797      4897 - 4897      ER44798      4898 - 4898      ER44799      4899 - 4899 
      ER44800      4900 - 4902      ER44801      4903 - 4903      ER44802      4904 - 4904 
      ER44803      4905 - 4905      ER44804      4906 - 4906      ER44805      4907 - 4907 
      ER44806      4908 - 4908      ER44807      4909 - 4909      ER44808      4910 - 4910 
      ER44809      4911 - 4911      ER44810      4912 - 4912      ER44811      4913 - 4913 
      ER44812      4914 - 4914      ER44813      4915 - 4915      ER44814      4916 - 4916 
      ER44815      4917 - 4917      ER44816      4918 - 4918      ER44817      4919 - 4919 
      ER44818      4920 - 4920      ER44819      4921 - 4923      ER44820      4924 - 4924 
      ER44821      4925 - 4925      ER44822      4926 - 4926      ER44823      4927 - 4927 
      ER44824      4928 - 4928      ER44825      4929 - 4929      ER44826      4930 - 4930 
      ER44827      4931 - 4931      ER44828      4932 - 4932      ER44829      4933 - 4933 
      ER44830      4934 - 4934      ER44831      4935 - 4935      ER44832      4936 - 4936 
      ER44833      4937 - 4937      ER44834      4938 - 4938      ER44835      4939 - 4939 
      ER44836      4940 - 4940      ER44837      4941 - 4941      ER44838      4942 - 4944 
      ER44839      4945 - 4945      ER44840      4946 - 4946      ER44841      4947 - 4947 
      ER44842      4948 - 4948      ER44843      4949 - 4949      ER44844      4950 - 4950 
      ER44845      4951 - 4951      ER44846      4952 - 4952      ER44847      4953 - 4953 
      ER44848      4954 - 4954      ER44849      4955 - 4955      ER44850      4956 - 4956 
      ER44851      4957 - 4957      ER44852      4958 - 4958      ER44853      4959 - 4959 
      ER44854      4960 - 4960      ER44855      4961 - 4961      ER44856      4962 - 4962 
      ER44857      4963 - 4965      ER44858      4966 - 4966      ER44859      4967 - 4967 
      ER44860      4968 - 4968      ER44861      4969 - 4969      ER44862      4970 - 4970 
      ER44863      4971 - 4971      ER44864      4972 - 4972      ER44865      4973 - 4973 
      ER44866      4974 - 4974      ER44867      4975 - 4975      ER44868      4976 - 4976 
      ER44869      4977 - 4977      ER44870      4978 - 4978      ER44871      4979 - 4979 
      ER44872      4980 - 4980      ER44873      4981 - 4981      ER44874      4982 - 4982 
      ER44875      4983 - 4983      ER44876      4984 - 4986      ER44877      4987 - 4987 
      ER44878      4988 - 4988      ER44879      4989 - 4989      ER44880      4990 - 4990 
      ER44881      4991 - 4991      ER44882      4992 - 4992      ER44883      4993 - 4993 
      ER44884      4994 - 4994      ER44885      4995 - 4995      ER44886      4996 - 4996 
      ER44887      4997 - 4997      ER44888      4998 - 4998      ER44889      4999 - 4999 
      ER44890      5000 - 5000      ER44891      5001 - 5001      ER44892      5002 - 5002 
      ER44893      5003 - 5003      ER44894      5004 - 5004      ER44895      5005 - 5007 
      ER44896      5008 - 5008      ER44897      5009 - 5009      ER44898      5010 - 5010 
      ER44899      5011 - 5011      ER44900      5012 - 5012      ER44901      5013 - 5013 
      ER44902      5014 - 5014      ER44903      5015 - 5015      ER44904      5016 - 5016 
      ER44905      5017 - 5017      ER44906      5018 - 5018      ER44907      5019 - 5019 
      ER44908      5020 - 5020      ER44909      5021 - 5021      ER44910      5022 - 5022 
      ER44911      5023 - 5023      ER44912      5024 - 5024      ER44913      5025 - 5025 
      ER44914      5026 - 5028      ER44915      5029 - 5029      ER44916      5030 - 5030 
      ER44917      5031 - 5031      ER44918      5032 - 5032      ER44919      5033 - 5033 
      ER44920      5034 - 5034      ER44921      5035 - 5035      ER44922      5036 - 5036 
      ER44923      5037 - 5037      ER44924      5038 - 5038      ER44925      5039 - 5039 
      ER44926      5040 - 5040      ER44927      5041 - 5041      ER44928      5042 - 5042 
      ER44929      5043 - 5043      ER44930      5044 - 5044      ER44931      5045 - 5045 
      ER44932      5046 - 5046      ER44933      5047 - 5049      ER44934      5050 - 5050 
      ER44935      5051 - 5051      ER44936      5052 - 5052      ER44937      5053 - 5053 
      ER44938      5054 - 5054      ER44939      5055 - 5055      ER44940      5056 - 5056 
      ER44941      5057 - 5057      ER44942      5058 - 5058      ER44943      5059 - 5059 
      ER44944      5060 - 5060      ER44945      5061 - 5061      ER44946      5062 - 5062 
      ER44947      5063 - 5063      ER44948      5064 - 5064      ER44949      5065 - 5065 
      ER44950      5066 - 5066      ER44951      5067 - 5067      ER44952      5068 - 5070 
      ER44953      5071 - 5074      ER44954      5075 - 5075      ER44955      5076 - 5076 
      ER44956      5077 - 5077      ER44957      5078 - 5078      ER44958      5079 - 5079 
      ER44959      5080 - 5080      ER44960      5081 - 5081      ER44961      5082 - 5082 
      ER44962      5083 - 5083      ER44963      5084 - 5084      ER44964      5085 - 5085 
      ER44965      5086 - 5086      ER44966      5087 - 5087      ER44967      5088 - 5088 
      ER44968      5089 - 5089      ER44969      5090 - 5090      ER44970      5091 - 5091 
      ER44971      5092 - 5092      ER44972      5093 - 5093      ER44973      5094 - 5094 
      ER44974      5095 - 5095      ER44975      5096 - 5096      ER44976      5097 - 5097 
      ER44977      5098 - 5098      ER44978      5099 - 5099      ER44979      5100 - 5100 
      ER44980      5101 - 5101      ER44981      5102 - 5102      ER44982      5103 - 5103 
      ER44983      5104 - 5104      ER44984      5105 - 5105      ER44985      5106 - 5106 
      ER44986      5107 - 5107      ER44987      5108 - 5108      ER44988      5109 - 5109 
      ER44989      5110 - 5110      ER44990      5111 - 5111      ER44991      5112 - 5112 
      ER44992      5113 - 5113      ER44993      5114 - 5114      ER44994      5115 - 5115 
      ER44995      5116 - 5116      ER44996      5117 - 5117      ER44997      5118 - 5118 
      ER44998      5119 - 5119      ER44999      5120 - 5120      ER45000      5121 - 5121 
      ER45001      5122 - 5122      ER45002      5123 - 5123      ER45003      5124 - 5124 
      ER45004      5125 - 5125      ER45005      5126 - 5126      ER45006      5127 - 5127 
      ER45007      5128 - 5128      ER45008      5129 - 5129      ER45009      5130 - 5130 
      ER45010      5131 - 5131      ER45011      5132 - 5132      ER45012      5133 - 5133 
      ER45013      5134 - 5134      ER45014      5135 - 5135      ER45015      5136 - 5136 
      ER45016      5137 - 5137      ER45017      5138 - 5138      ER45018      5139 - 5139 
      ER45019      5140 - 5140      ER45020      5141 - 5141      ER45021      5142 - 5142 
      ER45022      5143 - 5143      ER45023      5144 - 5146      ER45024      5147 - 5147 
      ER45025      5148 - 5148      ER45026      5149 - 5149      ER45027      5150 - 5150 
      ER45028      5151 - 5151      ER45029      5152 - 5152      ER45030      5153 - 5153 
      ER45031      5154 - 5154      ER45032      5155 - 5155      ER45033      5156 - 5156 
      ER45034      5157 - 5157      ER45035      5158 - 5158      ER45036      5159 - 5159 
      ER45037      5160 - 5160      ER45038      5161 - 5161      ER45039      5162 - 5162 
      ER45040      5163 - 5163      ER45041      5164 - 5164      ER45042      5165 - 5167 
      ER45043      5168 - 5168      ER45044      5169 - 5169      ER45045      5170 - 5170 
      ER45046      5171 - 5171      ER45047      5172 - 5172      ER45048      5173 - 5173 
      ER45049      5174 - 5174      ER45050      5175 - 5175      ER45051      5176 - 5176 
      ER45052      5177 - 5177      ER45053      5178 - 5178      ER45054      5179 - 5179 
      ER45055      5180 - 5180      ER45056      5181 - 5181      ER45057      5182 - 5182 
      ER45058      5183 - 5183      ER45059      5184 - 5184      ER45060      5185 - 5185 
      ER45061      5186 - 5188      ER45062      5189 - 5189      ER45063      5190 - 5190 
      ER45064      5191 - 5191      ER45065      5192 - 5192      ER45066      5193 - 5193 
      ER45067      5194 - 5194      ER45068      5195 - 5195      ER45069      5196 - 5196 
      ER45070      5197 - 5197      ER45071      5198 - 5198      ER45072      5199 - 5199 
      ER45073      5200 - 5200      ER45074      5201 - 5201      ER45075      5202 - 5202 
      ER45076      5203 - 5203      ER45077      5204 - 5204      ER45078      5205 - 5205 
      ER45079      5206 - 5206      ER45080      5207 - 5209      ER45081      5210 - 5210 
      ER45082      5211 - 5211      ER45083      5212 - 5212      ER45084      5213 - 5213 
      ER45085      5214 - 5214      ER45086      5215 - 5215      ER45087      5216 - 5216 
      ER45088      5217 - 5217      ER45089      5218 - 5218      ER45090      5219 - 5219 
      ER45091      5220 - 5220      ER45092      5221 - 5221      ER45093      5222 - 5222 
      ER45094      5223 - 5223      ER45095      5224 - 5224      ER45096      5225 - 5225 
      ER45097      5226 - 5226      ER45098      5227 - 5227      ER45099      5228 - 5230 
      ER45100      5231 - 5231      ER45101      5232 - 5232      ER45102      5233 - 5233 
      ER45103      5234 - 5234      ER45104      5235 - 5235      ER45105      5236 - 5236 
      ER45106      5237 - 5237      ER45107      5238 - 5238      ER45108      5239 - 5239 
      ER45109      5240 - 5240      ER45110      5241 - 5241      ER45111      5242 - 5242 
      ER45112      5243 - 5243      ER45113      5244 - 5244      ER45114      5245 - 5245 
      ER45115      5246 - 5246      ER45116      5247 - 5247      ER45117      5248 - 5248 
      ER45118      5249 - 5251      ER45119      5252 - 5252      ER45120      5253 - 5253 
      ER45121      5254 - 5254      ER45122      5255 - 5255      ER45123      5256 - 5256 
      ER45124      5257 - 5257      ER45125      5258 - 5258      ER45126      5259 - 5259 
      ER45127      5260 - 5260      ER45128      5261 - 5261      ER45129      5262 - 5262 
      ER45130      5263 - 5263      ER45131      5264 - 5264      ER45132      5265 - 5265 
      ER45133      5266 - 5266      ER45134      5267 - 5267      ER45135      5268 - 5268 
      ER45136      5269 - 5269      ER45137      5270 - 5272      ER45138      5273 - 5273 
      ER45139      5274 - 5274      ER45140      5275 - 5275      ER45141      5276 - 5276 
      ER45142      5277 - 5277      ER45143      5278 - 5278      ER45144      5279 - 5279 
      ER45145      5280 - 5280      ER45146      5281 - 5281      ER45147      5282 - 5282 
      ER45148      5283 - 5283      ER45149      5284 - 5284      ER45150      5285 - 5285 
      ER45151      5286 - 5286      ER45152      5287 - 5287      ER45153      5288 - 5288 
      ER45154      5289 - 5289      ER45155      5290 - 5290      ER45156      5291 - 5293 
      ER45157      5294 - 5294      ER45158      5295 - 5295      ER45159      5296 - 5296 
      ER45160      5297 - 5297      ER45161      5298 - 5298      ER45162      5299 - 5299 
      ER45163      5300 - 5300      ER45164      5301 - 5301      ER45165      5302 - 5302 
      ER45166      5303 - 5303      ER45167      5304 - 5304      ER45168      5305 - 5305 
      ER45169      5306 - 5306      ER45170      5307 - 5307      ER45171      5308 - 5308 
      ER45172      5309 - 5309      ER45173      5310 - 5310      ER45174      5311 - 5311 
      ER45175      5312 - 5314      ER45176      5315 - 5315      ER45177      5316 - 5316 
      ER45178      5317 - 5317      ER45179      5318 - 5318      ER45180      5319 - 5319 
      ER45181      5320 - 5320      ER45182      5321 - 5321      ER45183      5322 - 5322 
      ER45184      5323 - 5323      ER45185      5324 - 5324      ER45186      5325 - 5325 
      ER45187      5326 - 5326      ER45188      5327 - 5327      ER45189      5328 - 5328 
      ER45190      5329 - 5329      ER45191      5330 - 5330      ER45192      5331 - 5331 
      ER45193      5332 - 5332      ER45194      5333 - 5335      ER45195      5336 - 5336 
      ER45196      5337 - 5337      ER45197      5338 - 5338      ER45198      5339 - 5339 
      ER45199      5340 - 5340      ER45200      5341 - 5341      ER45201      5342 - 5342 
      ER45202      5343 - 5343      ER45203      5344 - 5344      ER45204      5345 - 5345 
      ER45205      5346 - 5346      ER45206      5347 - 5347      ER45207      5348 - 5348 
      ER45208      5349 - 5349      ER45209      5350 - 5350      ER45210      5351 - 5351 
      ER45211      5352 - 5352      ER45212      5353 - 5353      ER45213      5354 - 5356 
      ER45214      5357 - 5357      ER45215      5358 - 5358      ER45216      5359 - 5359 
      ER45217      5360 - 5360      ER45218      5361 - 5361      ER45219      5362 - 5362 
      ER45220      5363 - 5363      ER45221      5364 - 5364      ER45222      5365 - 5365 
      ER45223      5366 - 5366      ER45224      5367 - 5367      ER45225      5368 - 5368 
      ER45226      5369 - 5369      ER45227      5370 - 5370      ER45228      5371 - 5371 
      ER45229      5372 - 5372      ER45230      5373 - 5373      ER45231      5374 - 5374 
      ER45232      5375 - 5377      ER45233      5378 - 5378      ER45234      5379 - 5379 
      ER45235      5380 - 5380      ER45236      5381 - 5381      ER45237      5382 - 5382 
      ER45238      5383 - 5383      ER45239      5384 - 5384      ER45240      5385 - 5385 
      ER45241      5386 - 5386      ER45242      5387 - 5387      ER45243      5388 - 5388 
      ER45244      5389 - 5389      ER45245      5390 - 5390      ER45246      5391 - 5391 
      ER45247      5392 - 5392      ER45248      5393 - 5393      ER45249      5394 - 5394 
      ER45250      5395 - 5395      ER45251      5396 - 5398      ER45252      5399 - 5399 
      ER45253      5400 - 5400      ER45254      5401 - 5401      ER45255      5402 - 5402 
      ER45256      5403 - 5403      ER45257      5404 - 5404      ER45258      5405 - 5405 
      ER45259      5406 - 5406      ER45260      5407 - 5407      ER45261      5408 - 5408 
      ER45262      5409 - 5409      ER45263      5410 - 5410      ER45264      5411 - 5411 
      ER45265      5412 - 5412      ER45266      5413 - 5413      ER45267      5414 - 5414 
      ER45268      5415 - 5415      ER45269      5416 - 5416      ER45270      5417 - 5419 
      ER45271      5420 - 5420      ER45272      5421 - 5421      ER45273      5422 - 5422 
      ER45274      5423 - 5423      ER45275      5424 - 5424      ER45276      5425 - 5425 
      ER45277      5426 - 5426      ER45278      5427 - 5427      ER45279      5428 - 5428 
      ER45280      5429 - 5431      ER45281      5432 - 5432      ER45282      5433 - 5433 
      ER45283      5434 - 5434      ER45284      5435 - 5437      ER45285      5438 - 5438 
      ER45286      5439 - 5439      ER45287      5440 - 5440      ER45288      5441 - 5443 
      ER45289      5444 - 5444      ER45290      5445 - 5445      ER45291      5446 - 5446 
      ER45292      5447 - 5449      ER45293      5450 - 5450      ER45294      5451 - 5451 
      ER45295      5452 - 5452      ER45296      5453 - 5455      ER45297      5456 - 5456 
      ER45298      5457 - 5457      ER45299      5458 - 5458      ER45300      5459 - 5461 
      ER45301      5462 - 5462      ER45302      5463 - 5463      ER45303      5464 - 5464 
      ER45304      5465 - 5467      ER45305      5468 - 5468      ER45306      5469 - 5469 
      ER45307      5470 - 5470      ER45308      5471 - 5473      ER45309      5474 - 5474 
      ER45310      5475 - 5475      ER45311      5476 - 5476      ER45312      5477 - 5479 
      ER45313      5480 - 5480      ER45314      5481 - 5481      ER45315      5482 - 5482 
      ER45316      5483 - 5485      ER45317      5486 - 5486      ER45318      5487 - 5487 
      ER45319      5488 - 5488      ER45320      5489 - 5491      ER45321      5492 - 5492 
      ER45322      5493 - 5493      ER45323      5494 - 5495      ER45324      5496 - 5497 
      ER45325      5498 - 5498      ER45326      5499 - 5499      ER45327      5500 - 5502 
      ER45328      5503 - 5504      ER45329      5505 - 5506      ER45330      5507 - 5508 
      ER45331      5509 - 5509      ER45332      5510 - 5510      ER45333      5511 - 5511 
      ER45334      5512 - 5514      ER45335      5515 - 5515      ER45336      5516 - 5516 
      ER45337      5517 - 5517      ER45338      5518 - 5520      ER45339      5521 - 5522 
      ER45340      5523 - 5523      ER45341      5524 - 5524      ER45342      5525 - 5525 
      ER45343      5526 - 5526      ER45344      5527 - 5527      ER45345      5528 - 5528 
      ER45346      5529 - 5529      ER45347      5530 - 5530      ER45348      5531 - 5531 
      ER45349      5532 - 5532      ER45350      5533 - 5533      ER45351      5534 - 5534 
      ER45352      5535 - 5535      ER45353      5536 - 5536      ER45354      5537 - 5537 
      ER45355      5538 - 5538      ER45356      5539 - 5539      ER45357      5540 - 5540 
      ER45358      5541 - 5541      ER45359      5542 - 5542      ER45360      5543 - 5543 
      ER45361      5544 - 5544      ER45362      5545 - 5545      ER45363      5546 - 5546 
      ER45364      5547 - 5547      ER45365      5548 - 5548      ER45366      5549 - 5549 
      ER45367      5550 - 5550      ER45368      5551 - 5551      ER45369      5552 - 5552 
      ER45370      5553 - 5553      ER45371      5554 - 5554      ER45372      5555 - 5555 
      ER45373      5556 - 5558      ER45374      5559 - 5559      ER45375      5560 - 5562 
      ER45376      5563 - 5563      ER45377      5564 - 5566      ER45378      5567 - 5567 
      ER45379      5568 - 5568      ER45380      5569 - 5571      ER45381      5572 - 5573 
      ER45382      5574 - 5574      ER45383      5575 - 5577      ER45384      5578 - 5579 
      ER45385      5580 - 5581      ER45386      5582 - 5582      ER45387      5583 - 5583 
      ER45388      5584 - 5585      ER45389      5586 - 5588      ER45390      5589 - 5591 
      ER45391      5592 - 5592      ER45392      5593 - 5594      ER45393      5595 - 5595 
      ER45394      5596 - 5596      ER45395      5597 - 5597      ER45396      5598 - 5598 
      ER45397      5599 - 5599      ER45398      5600 - 5600      ER45399      5601 - 5601 
      ER45400      5602 - 5602      ER45401      5603 - 5603      ER45402      5604 - 5604 
      ER45403      5605 - 5605      ER45404      5606 - 5606      ER45405      5607 - 5607 
      ER45406      5608 - 5608      ER45407      5609 - 5609      ER45408      5610 - 5610 
      ER45409      5611 - 5611      ER45410      5612 - 5612      ER45411      5613 - 5613 
      ER45412      5614 - 5614      ER45413      5615 - 5615      ER45414      5616 - 5619 
      ER45415      5620 - 5620      ER45416      5621 - 5621      ER45417      5622 - 5622 
      ER45418      5623 - 5623      ER45419      5624 - 5624      ER45420      5625 - 5625 
      ER45421      5626 - 5626      ER45422      5627 - 5627      ER45423      5628 - 5628 
      ER45424      5629 - 5629      ER45425      5630 - 5630      ER45426      5631 - 5631 
      ER45427      5632 - 5632      ER45428      5633 - 5633      ER45429      5634 - 5634 
      ER45430      5635 - 5635      ER45431      5636 - 5636      ER45432      5637 - 5637 
      ER45433      5638 - 5638      ER45434      5639 - 5639      ER45435      5640 - 5640 
      ER45436      5641 - 5641      ER45437      5642 - 5642      ER45438      5643 - 5643 
      ER45439      5644 - 5644      ER45440      5645 - 5645      ER45441      5646 - 5646 
      ER45442      5647 - 5647      ER45443      5648 - 5648      ER45444      5649 - 5649 
      ER45445      5650 - 5650      ER45446      5651 - 5651      ER45447      5652 - 5652 
      ER45448      5653 - 5653      ER45449      5654 - 5654      ER45450      5655 - 5655 
      ER45451      5656 - 5656      ER45452      5657 - 5657      ER45453      5658 - 5658 
      ER45454      5659 - 5659      ER45455      5660 - 5660      ER45456      5661 - 5661 
      ER45457      5662 - 5662      ER45458      5663 - 5663      ER45459      5664 - 5664 
      ER45460      5665 - 5665      ER45461      5666 - 5666      ER45462      5667 - 5667 
      ER45463      5668 - 5668      ER45464      5669 - 5669      ER45465      5670 - 5670 
      ER45466      5671 - 5671      ER45467      5672 - 5672      ER45468      5673 - 5673 
      ER45469      5674 - 5674      ER45470      5675 - 5675      ER45471      5676 - 5676 
      ER45472      5677 - 5677      ER45473      5678 - 5678      ER45474      5679 - 5679 
      ER45475      5680 - 5680      ER45476      5681 - 5681      ER45477      5682 - 5682 
      ER45478      5683 - 5683      ER45479      5684 - 5684      ER45480      5685 - 5685 
      ER45481      5686 - 5686      ER45482      5687 - 5687      ER45483      5688 - 5688 
      ER45484      5689 - 5691      ER45485      5692 - 5692      ER45486      5693 - 5693 
      ER45487      5694 - 5694      ER45488      5695 - 5695      ER45489      5696 - 5696 
      ER45490      5697 - 5697      ER45491      5698 - 5698      ER45492      5699 - 5699 
      ER45493      5700 - 5700      ER45494      5701 - 5701      ER45495      5702 - 5702 
      ER45496      5703 - 5703      ER45497      5704 - 5704      ER45498      5705 - 5705 
      ER45499      5706 - 5706      ER45500      5707 - 5707      ER45501      5708 - 5708 
      ER45502      5709 - 5709      ER45503      5710 - 5712      ER45504      5713 - 5713 
      ER45505      5714 - 5714      ER45506      5715 - 5715      ER45507      5716 - 5716 
      ER45508      5717 - 5717      ER45509      5718 - 5718      ER45510      5719 - 5719 
      ER45511      5720 - 5720      ER45512      5721 - 5721      ER45513      5722 - 5722 
      ER45514      5723 - 5723      ER45515      5724 - 5724      ER45516      5725 - 5725 
      ER45517      5726 - 5726      ER45518      5727 - 5727      ER45519      5728 - 5728 
      ER45520      5729 - 5729      ER45521      5730 - 5730      ER45522      5731 - 5733 
      ER45523      5734 - 5734      ER45524      5735 - 5735      ER45525      5736 - 5736 
      ER45526      5737 - 5737      ER45527      5738 - 5738      ER45528      5739 - 5739 
      ER45529      5740 - 5740      ER45530      5741 - 5741      ER45531      5742 - 5742 
      ER45532      5743 - 5743      ER45533      5744 - 5744      ER45534      5745 - 5745 
      ER45535      5746 - 5746      ER45536      5747 - 5747      ER45537      5748 - 5748 
      ER45538      5749 - 5749      ER45539      5750 - 5750      ER45540      5751 - 5751 
      ER45541      5752 - 5754      ER45542      5755 - 5755      ER45543      5756 - 5756 
      ER45544      5757 - 5757      ER45545      5758 - 5758      ER45546      5759 - 5759 
      ER45547      5760 - 5760      ER45548      5761 - 5761      ER45549      5762 - 5762 
      ER45550      5763 - 5763      ER45551      5764 - 5764      ER45552      5765 - 5765 
      ER45553      5766 - 5766      ER45554      5767 - 5767      ER45555      5768 - 5768 
      ER45556      5769 - 5769      ER45557      5770 - 5770      ER45558      5771 - 5771 
      ER45559      5772 - 5772      ER45560      5773 - 5775      ER45561      5776 - 5776 
      ER45562      5777 - 5777      ER45563      5778 - 5778      ER45564      5779 - 5779 
      ER45565      5780 - 5780      ER45566      5781 - 5781      ER45567      5782 - 5782 
      ER45568      5783 - 5783      ER45569      5784 - 5784      ER45570      5785 - 5785 
      ER45571      5786 - 5786      ER45572      5787 - 5787      ER45573      5788 - 5788 
      ER45574      5789 - 5789      ER45575      5790 - 5790      ER45576      5791 - 5791 
      ER45577      5792 - 5792      ER45578      5793 - 5793      ER45579      5794 - 5796 
      ER45580      5797 - 5797      ER45581      5798 - 5798      ER45582      5799 - 5799 
      ER45583      5800 - 5800      ER45584      5801 - 5801      ER45585      5802 - 5802 
      ER45586      5803 - 5803      ER45587      5804 - 5804      ER45588      5805 - 5805 
      ER45589      5806 - 5806      ER45590      5807 - 5807      ER45591      5808 - 5808 
      ER45592      5809 - 5809      ER45593      5810 - 5810      ER45594      5811 - 5811 
      ER45595      5812 - 5812      ER45596      5813 - 5813      ER45597      5814 - 5814 
      ER45598      5815 - 5817      ER45599      5818 - 5818      ER45600      5819 - 5819 
      ER45601      5820 - 5820      ER45602      5821 - 5821      ER45603      5822 - 5822 
      ER45604      5823 - 5823      ER45605      5824 - 5824      ER45606      5825 - 5825 
      ER45607      5826 - 5826      ER45608      5827 - 5827      ER45609      5828 - 5828 
      ER45610      5829 - 5829      ER45611      5830 - 5830      ER45612      5831 - 5831 
      ER45613      5832 - 5832      ER45614      5833 - 5833      ER45615      5834 - 5834 
      ER45616      5835 - 5835      ER45617      5836 - 5838      ER45618      5839 - 5839 
      ER45619      5840 - 5840      ER45620      5841 - 5841      ER45621      5842 - 5842 
      ER45622      5843 - 5843      ER45623      5844 - 5844      ER45624      5845 - 5845 
      ER45625      5846 - 5846      ER45626      5847 - 5847      ER45627      5848 - 5848 
      ER45628      5849 - 5849      ER45629      5850 - 5850      ER45630      5851 - 5851 
      ER45631      5852 - 5852      ER45632      5853 - 5853      ER45633      5854 - 5854 
      ER45634      5855 - 5855      ER45635      5856 - 5856      ER45636      5857 - 5859 
      ER45637      5860 - 5860      ER45638      5861 - 5861      ER45639      5862 - 5862 
      ER45640      5863 - 5863      ER45641      5864 - 5864      ER45642      5865 - 5865 
      ER45643      5866 - 5866      ER45644      5867 - 5867      ER45645      5868 - 5868 
      ER45646      5869 - 5869      ER45647      5870 - 5870      ER45648      5871 - 5871 
      ER45649      5872 - 5872      ER45650      5873 - 5873      ER45651      5874 - 5874 
      ER45652      5875 - 5875      ER45653      5876 - 5876      ER45654      5877 - 5877 
      ER45655      5878 - 5880      ER45656      5881 - 5881      ER45657      5882 - 5882 
      ER45658      5883 - 5883      ER45659      5884 - 5884      ER45660      5885 - 5885 
      ER45661      5886 - 5886      ER45662      5887 - 5887      ER45663      5888 - 5888 
      ER45664      5889 - 5889      ER45665      5890 - 5890      ER45666      5891 - 5891 
      ER45667      5892 - 5892      ER45668      5893 - 5893      ER45669      5894 - 5894 
      ER45670      5895 - 5895      ER45671      5896 - 5896      ER45672      5897 - 5897 
      ER45673      5898 - 5898      ER45674      5899 - 5901      ER45675      5902 - 5902 
      ER45676      5903 - 5903      ER45677      5904 - 5904      ER45678      5905 - 5905 
      ER45679      5906 - 5906      ER45680      5907 - 5907      ER45681      5908 - 5908 
      ER45682      5909 - 5909      ER45683      5910 - 5910      ER45684      5911 - 5911 
      ER45685      5912 - 5912      ER45686      5913 - 5913      ER45687      5914 - 5914 
      ER45688      5915 - 5915      ER45689      5916 - 5916      ER45690      5917 - 5917 
      ER45691      5918 - 5918      ER45692      5919 - 5919      ER45693      5920 - 5922 
      ER45694      5923 - 5923      ER45695      5924 - 5924      ER45696      5925 - 5925 
      ER45697      5926 - 5926      ER45698      5927 - 5927      ER45699      5928 - 5928 
      ER45700      5929 - 5929      ER45701      5930 - 5930      ER45702      5931 - 5931 
      ER45703      5932 - 5932      ER45704      5933 - 5933      ER45705      5934 - 5934 
      ER45706      5935 - 5935      ER45707      5936 - 5936      ER45708      5937 - 5937 
      ER45709      5938 - 5938      ER45710      5939 - 5939      ER45711      5940 - 5940 
      ER45712      5941 - 5943      ER45713      5944 - 5944      ER45714      5945 - 5945 
      ER45715      5946 - 5946      ER45716      5947 - 5947      ER45717      5948 - 5948 
      ER45718      5949 - 5949      ER45719      5950 - 5950      ER45720      5951 - 5951 
      ER45721      5952 - 5952      ER45722      5953 - 5953      ER45723      5954 - 5954 
      ER45724      5955 - 5955      ER45725      5956 - 5956      ER45726      5957 - 5957 
      ER45727      5958 - 5958      ER45728      5959 - 5959      ER45729      5960 - 5960 
      ER45730      5961 - 5961      ER45731      5962 - 5964      ER45732      5965 - 5968 
      ER45733      5969 - 5969      ER45734      5970 - 5970      ER45735      5971 - 5971 
      ER45736      5972 - 5972      ER45737      5973 - 5973      ER45738      5974 - 5974 
      ER45739      5975 - 5975      ER45740      5976 - 5976      ER45741      5977 - 5977 
      ER45742      5978 - 5978      ER45743      5979 - 5979      ER45744      5980 - 5980 
      ER45745      5981 - 5981      ER45746      5982 - 5982      ER45747      5983 - 5983 
      ER45748      5984 - 5984      ER45749      5985 - 5985      ER45750      5986 - 5986 
      ER45751      5987 - 5987      ER45752      5988 - 5988      ER45753      5989 - 5989 
      ER45754      5990 - 5990      ER45755      5991 - 5991      ER45756      5992 - 5992 
      ER45757      5993 - 5993      ER45758      5994 - 5994      ER45759      5995 - 5995 
      ER45760      5996 - 5996      ER45761      5997 - 5997      ER45762      5998 - 5998 
      ER45763      5999 - 5999      ER45764      6000 - 6000      ER45765      6001 - 6001 
      ER45766      6002 - 6002      ER45767      6003 - 6003      ER45768      6004 - 6004 
      ER45769      6005 - 6005      ER45770      6006 - 6006      ER45771      6007 - 6007 
      ER45772      6008 - 6008      ER45773      6009 - 6009      ER45774      6010 - 6010 
      ER45775      6011 - 6011      ER45776      6012 - 6012      ER45777      6013 - 6013 
      ER45778      6014 - 6014      ER45779      6015 - 6015      ER45780      6016 - 6016 
      ER45781      6017 - 6017      ER45782      6018 - 6018      ER45783      6019 - 6019 
      ER45784      6020 - 6020      ER45785      6021 - 6021      ER45786      6022 - 6022 
      ER45787      6023 - 6023      ER45788      6024 - 6024      ER45789      6025 - 6025 
      ER45790      6026 - 6026      ER45791      6027 - 6027      ER45792      6028 - 6028 
      ER45793      6029 - 6029      ER45794      6030 - 6030      ER45795      6031 - 6031 
      ER45796      6032 - 6032      ER45797      6033 - 6033      ER45798      6034 - 6034 
      ER45799      6035 - 6035      ER45800      6036 - 6036      ER45801      6037 - 6037 
      ER45802      6038 - 6040      ER45803      6041 - 6041      ER45804      6042 - 6042 
      ER45805      6043 - 6043      ER45806      6044 - 6044      ER45807      6045 - 6045 
      ER45808      6046 - 6046      ER45809      6047 - 6047      ER45810      6048 - 6048 
      ER45811      6049 - 6049      ER45812      6050 - 6050      ER45813      6051 - 6051 
      ER45814      6052 - 6052      ER45815      6053 - 6053      ER45816      6054 - 6054 
      ER45817      6055 - 6055      ER45818      6056 - 6056      ER45819      6057 - 6057 
      ER45820      6058 - 6058      ER45821      6059 - 6061      ER45822      6062 - 6062 
      ER45823      6063 - 6063      ER45824      6064 - 6064      ER45825      6065 - 6065 
      ER45826      6066 - 6066      ER45827      6067 - 6067      ER45828      6068 - 6068 
      ER45829      6069 - 6069      ER45830      6070 - 6070      ER45831      6071 - 6071 
      ER45832      6072 - 6072      ER45833      6073 - 6073      ER45834      6074 - 6074 
      ER45835      6075 - 6075      ER45836      6076 - 6076      ER45837      6077 - 6077 
      ER45838      6078 - 6078      ER45839      6079 - 6079      ER45840      6080 - 6082 
      ER45841      6083 - 6083      ER45842      6084 - 6084      ER45843      6085 - 6085 
      ER45844      6086 - 6086      ER45845      6087 - 6087      ER45846      6088 - 6088 
      ER45847      6089 - 6089      ER45848      6090 - 6090      ER45849      6091 - 6091 
      ER45850      6092 - 6092      ER45851      6093 - 6093      ER45852      6094 - 6094 
      ER45853      6095 - 6095      ER45854      6096 - 6096      ER45855      6097 - 6097 
      ER45856      6098 - 6098      ER45857      6099 - 6099      ER45858      6100 - 6100 
      ER45859      6101 - 6103      ER45860      6104 - 6104      ER45861      6105 - 6105 
      ER45862      6106 - 6106      ER45863      6107 - 6107      ER45864      6108 - 6108 
      ER45865      6109 - 6109      ER45866      6110 - 6110      ER45867      6111 - 6111 
      ER45868      6112 - 6112      ER45869      6113 - 6113      ER45870      6114 - 6114 
      ER45871      6115 - 6115      ER45872      6116 - 6116      ER45873      6117 - 6117 
      ER45874      6118 - 6118      ER45875      6119 - 6119      ER45876      6120 - 6120 
      ER45877      6121 - 6121      ER45878      6122 - 6124      ER45879      6125 - 6125 
      ER45880      6126 - 6126      ER45881      6127 - 6127      ER45882      6128 - 6128 
      ER45883      6129 - 6129      ER45884      6130 - 6130      ER45885      6131 - 6131 
      ER45886      6132 - 6132      ER45887      6133 - 6133      ER45888      6134 - 6134 
      ER45889      6135 - 6135      ER45890      6136 - 6136      ER45891      6137 - 6137 
      ER45892      6138 - 6138      ER45893      6139 - 6139      ER45894      6140 - 6140 
      ER45895      6141 - 6141      ER45896      6142 - 6142      ER45897      6143 - 6145 
      ER45898      6146 - 6146      ER45899      6147 - 6147      ER45900      6148 - 6148 
      ER45901      6149 - 6149      ER45902      6150 - 6150      ER45903      6151 - 6151 
      ER45904      6152 - 6152      ER45905      6153 - 6153      ER45906      6154 - 6154 
      ER45907      6155 - 6155      ER45908      6156 - 6156      ER45909      6157 - 6157 
      ER45910      6158 - 6158      ER45911      6159 - 6159      ER45912      6160 - 6160 
      ER45913      6161 - 6161      ER45914      6162 - 6162      ER45915      6163 - 6163 
      ER45916      6164 - 6166      ER45917      6167 - 6167      ER45918      6168 - 6168 
      ER45919      6169 - 6169      ER45920      6170 - 6170      ER45921      6171 - 6171 
      ER45922      6172 - 6172      ER45923      6173 - 6173      ER45924      6174 - 6174 
      ER45925      6175 - 6175      ER45926      6176 - 6176      ER45927      6177 - 6177 
      ER45928      6178 - 6178      ER45929      6179 - 6179      ER45930      6180 - 6180 
      ER45931      6181 - 6181      ER45932      6182 - 6182      ER45933      6183 - 6183 
      ER45934      6184 - 6184      ER45935      6185 - 6187      ER45936      6188 - 6188 
      ER45937      6189 - 6189      ER45938      6190 - 6190      ER45939      6191 - 6191 
      ER45940      6192 - 6192      ER45941      6193 - 6193      ER45942      6194 - 6194 
      ER45943      6195 - 6195      ER45944      6196 - 6196      ER45945      6197 - 6197 
      ER45946      6198 - 6198      ER45947      6199 - 6199      ER45948      6200 - 6200 
      ER45949      6201 - 6201      ER45950      6202 - 6202      ER45951      6203 - 6203 
      ER45952      6204 - 6204      ER45953      6205 - 6205      ER45954      6206 - 6208 
      ER45955      6209 - 6209      ER45956      6210 - 6210      ER45957      6211 - 6211 
      ER45958      6212 - 6212      ER45959      6213 - 6213      ER45960      6214 - 6214 
      ER45961      6215 - 6215      ER45962      6216 - 6216      ER45963      6217 - 6217 
      ER45964      6218 - 6218      ER45965      6219 - 6219      ER45966      6220 - 6220 
      ER45967      6221 - 6221      ER45968      6222 - 6222      ER45969      6223 - 6223 
      ER45970      6224 - 6224      ER45971      6225 - 6225      ER45972      6226 - 6226 
      ER45973      6227 - 6229      ER45974      6230 - 6230      ER45975      6231 - 6231 
      ER45976      6232 - 6232      ER45977      6233 - 6233      ER45978      6234 - 6234 
      ER45979      6235 - 6235      ER45980      6236 - 6236      ER45981      6237 - 6237 
      ER45982      6238 - 6238      ER45983      6239 - 6239      ER45984      6240 - 6240 
      ER45985      6241 - 6241      ER45986      6242 - 6242      ER45987      6243 - 6243 
      ER45988      6244 - 6244      ER45989      6245 - 6245      ER45990      6246 - 6246 
      ER45991      6247 - 6247      ER45992      6248 - 6250      ER45993      6251 - 6251 
      ER45994      6252 - 6252      ER45995      6253 - 6253      ER45996      6254 - 6254 
      ER45997      6255 - 6255      ER45998      6256 - 6256      ER45999      6257 - 6257 
      ER46000      6258 - 6258      ER46001      6259 - 6259      ER46002      6260 - 6260 
      ER46003      6261 - 6261      ER46004      6262 - 6262      ER46005      6263 - 6263 
      ER46006      6264 - 6264      ER46007      6265 - 6265      ER46008      6266 - 6266 
      ER46009      6267 - 6267      ER46010      6268 - 6268      ER46011      6269 - 6271 
      ER46012      6272 - 6272      ER46013      6273 - 6273      ER46014      6274 - 6274 
      ER46015      6275 - 6275      ER46016      6276 - 6276      ER46017      6277 - 6277 
      ER46018      6278 - 6278      ER46019      6279 - 6279      ER46020      6280 - 6280 
      ER46021      6281 - 6281      ER46022      6282 - 6282      ER46023      6283 - 6283 
      ER46024      6284 - 6284      ER46025      6285 - 6285      ER46026      6286 - 6286 
      ER46027      6287 - 6287      ER46028      6288 - 6288      ER46029      6289 - 6289 
      ER46030      6290 - 6292      ER46031      6293 - 6293      ER46032      6294 - 6294 
      ER46033      6295 - 6295      ER46034      6296 - 6296      ER46035      6297 - 6297 
      ER46036      6298 - 6298      ER46037      6299 - 6299      ER46038      6300 - 6300 
      ER46039      6301 - 6301      ER46040      6302 - 6302      ER46041      6303 - 6303 
      ER46042      6304 - 6304      ER46043      6305 - 6305      ER46044      6306 - 6306 
      ER46045      6307 - 6307      ER46046      6308 - 6308      ER46047      6309 - 6309 
      ER46048      6310 - 6310      ER46049      6311 - 6313      ER46050      6314 - 6317 
      ER46051      6318 - 6318      ER46052      6319 - 6319      ER46053      6320 - 6320 
      ER46054      6321 - 6321      ER46055      6322 - 6322      ER46056      6323 - 6323 
      ER46057      6324 - 6324      ER46058      6325 - 6325      ER46059      6326 - 6326 
      ER46060      6327 - 6327      ER46061      6328 - 6328      ER46062      6329 - 6329 
      ER46063      6330 - 6330      ER46064      6331 - 6331      ER46065      6332 - 6332 
      ER46066      6333 - 6333      ER46067      6334 - 6334      ER46068      6335 - 6335 
      ER46069      6336 - 6336      ER46070      6337 - 6337      ER46071      6338 - 6338 
      ER46072      6339 - 6339      ER46073      6340 - 6340      ER46074      6341 - 6341 
      ER46075      6342 - 6342      ER46076      6343 - 6343      ER46077      6344 - 6344 
      ER46078      6345 - 6345      ER46079      6346 - 6346      ER46080      6347 - 6347 
      ER46081      6348 - 6348      ER46082      6349 - 6349      ER46083      6350 - 6350 
      ER46084      6351 - 6351      ER46085      6352 - 6352      ER46086      6353 - 6353 
      ER46087      6354 - 6354      ER46088      6355 - 6355      ER46089      6356 - 6356 
      ER46090      6357 - 6357      ER46091      6358 - 6358      ER46092      6359 - 6359 
      ER46093      6360 - 6360      ER46094      6361 - 6361      ER46095      6362 - 6362 
      ER46096      6363 - 6363      ER46097      6364 - 6364      ER46098      6365 - 6365 
      ER46099      6366 - 6366      ER46100      6367 - 6367      ER46101      6368 - 6368 
      ER46102      6369 - 6369      ER46103      6370 - 6370      ER46104      6371 - 6371 
      ER46105      6372 - 6372      ER46106      6373 - 6373      ER46107      6374 - 6374 
      ER46108      6375 - 6375      ER46109      6376 - 6376      ER46110      6377 - 6377 
      ER46111      6378 - 6378      ER46112      6379 - 6379      ER46113      6380 - 6380 
      ER46114      6381 - 6381      ER46115      6382 - 6382      ER46116      6383 - 6383 
      ER46117      6384 - 6384      ER46118      6385 - 6385      ER46119      6386 - 6386 
      ER46120      6387 - 6389      ER46121      6390 - 6390      ER46122      6391 - 6391 
      ER46123      6392 - 6392      ER46124      6393 - 6393      ER46125      6394 - 6394 
      ER46126      6395 - 6395      ER46127      6396 - 6396      ER46128      6397 - 6397 
      ER46129      6398 - 6398      ER46130      6399 - 6399      ER46131      6400 - 6400 
      ER46132      6401 - 6401      ER46133      6402 - 6402      ER46134      6403 - 6403 
      ER46135      6404 - 6404      ER46136      6405 - 6405      ER46137      6406 - 6406 
      ER46138      6407 - 6407      ER46139      6408 - 6410      ER46140      6411 - 6411 
      ER46141      6412 - 6412      ER46142      6413 - 6413      ER46143      6414 - 6414 
      ER46144      6415 - 6415      ER46145      6416 - 6416      ER46146      6417 - 6417 
      ER46147      6418 - 6418      ER46148      6419 - 6419      ER46149      6420 - 6420 
      ER46150      6421 - 6421      ER46151      6422 - 6422      ER46152      6423 - 6423 
      ER46153      6424 - 6424      ER46154      6425 - 6425      ER46155      6426 - 6426 
      ER46156      6427 - 6427      ER46157      6428 - 6428      ER46158      6429 - 6431 
      ER46159      6432 - 6432      ER46160      6433 - 6433      ER46161      6434 - 6434 
      ER46162      6435 - 6435      ER46163      6436 - 6436      ER46164      6437 - 6437 
      ER46165      6438 - 6438      ER46166      6439 - 6439      ER46167      6440 - 6440 
      ER46168      6441 - 6441      ER46169      6442 - 6442      ER46170      6443 - 6443 
      ER46171      6444 - 6444      ER46172      6445 - 6445      ER46173      6446 - 6446 
      ER46174      6447 - 6447      ER46175      6448 - 6448      ER46176      6449 - 6449 
      ER46177      6450 - 6452      ER46178      6453 - 6453      ER46179      6454 - 6454 
      ER46180      6455 - 6455      ER46181      6456 - 6456      ER46182      6457 - 6457 
      ER46183      6458 - 6458      ER46184      6459 - 6459      ER46185      6460 - 6460 
      ER46186      6461 - 6461      ER46187      6462 - 6462      ER46188      6463 - 6463 
      ER46189      6464 - 6464      ER46190      6465 - 6465      ER46191      6466 - 6466 
      ER46192      6467 - 6467      ER46193      6468 - 6468      ER46194      6469 - 6469 
      ER46195      6470 - 6470      ER46196      6471 - 6473      ER46197      6474 - 6474 
      ER46198      6475 - 6475      ER46199      6476 - 6476      ER46200      6477 - 6477 
      ER46201      6478 - 6478      ER46202      6479 - 6479      ER46203      6480 - 6480 
      ER46204      6481 - 6481      ER46205      6482 - 6482      ER46206      6483 - 6483 
      ER46207      6484 - 6484      ER46208      6485 - 6485      ER46209      6486 - 6486 
      ER46210      6487 - 6487      ER46211      6488 - 6488      ER46212      6489 - 6489 
      ER46213      6490 - 6490      ER46214      6491 - 6491      ER46215      6492 - 6494 
      ER46216      6495 - 6495      ER46217      6496 - 6496      ER46218      6497 - 6497 
      ER46219      6498 - 6498      ER46220      6499 - 6499      ER46221      6500 - 6500 
      ER46222      6501 - 6501      ER46223      6502 - 6502      ER46224      6503 - 6503 
      ER46225      6504 - 6504      ER46226      6505 - 6505      ER46227      6506 - 6506 
      ER46228      6507 - 6507      ER46229      6508 - 6508      ER46230      6509 - 6509 
      ER46231      6510 - 6510      ER46232      6511 - 6511      ER46233      6512 - 6512 
      ER46234      6513 - 6515      ER46235      6516 - 6516      ER46236      6517 - 6517 
      ER46237      6518 - 6518      ER46238      6519 - 6519      ER46239      6520 - 6520 
      ER46240      6521 - 6521      ER46241      6522 - 6522      ER46242      6523 - 6523 
      ER46243      6524 - 6524      ER46244      6525 - 6525      ER46245      6526 - 6526 
      ER46246      6527 - 6527      ER46247      6528 - 6528      ER46248      6529 - 6529 
      ER46249      6530 - 6530      ER46250      6531 - 6531      ER46251      6532 - 6532 
      ER46252      6533 - 6533      ER46253      6534 - 6536      ER46254      6537 - 6537 
      ER46255      6538 - 6538      ER46256      6539 - 6539      ER46257      6540 - 6540 
      ER46258      6541 - 6541      ER46259      6542 - 6542      ER46260      6543 - 6543 
      ER46261      6544 - 6544      ER46262      6545 - 6545      ER46263      6546 - 6546 
      ER46264      6547 - 6547      ER46265      6548 - 6548      ER46266      6549 - 6549 
      ER46267      6550 - 6550      ER46268      6551 - 6551      ER46269      6552 - 6552 
      ER46270      6553 - 6553      ER46271      6554 - 6554      ER46272      6555 - 6557 
      ER46273      6558 - 6558      ER46274      6559 - 6559      ER46275      6560 - 6560 
      ER46276      6561 - 6561      ER46277      6562 - 6562      ER46278      6563 - 6563 
      ER46279      6564 - 6564      ER46280      6565 - 6565      ER46281      6566 - 6566 
      ER46282      6567 - 6567      ER46283      6568 - 6568      ER46284      6569 - 6569 
      ER46285      6570 - 6570      ER46286      6571 - 6571      ER46287      6572 - 6572 
      ER46288      6573 - 6573      ER46289      6574 - 6574      ER46290      6575 - 6575 
      ER46291      6576 - 6578      ER46292      6579 - 6579      ER46293      6580 - 6580 
      ER46294      6581 - 6581      ER46295      6582 - 6582      ER46296      6583 - 6583 
      ER46297      6584 - 6584      ER46298      6585 - 6585      ER46299      6586 - 6586 
      ER46300      6587 - 6587      ER46301      6588 - 6588      ER46302      6589 - 6589 
      ER46303      6590 - 6590      ER46304      6591 - 6591      ER46305      6592 - 6592 
      ER46306      6593 - 6593      ER46307      6594 - 6594      ER46308      6595 - 6595 
      ER46309      6596 - 6596      ER46310      6597 - 6599      ER46311      6600 - 6600 
      ER46312      6601 - 6601      ER46313      6602 - 6602      ER46314      6603 - 6603 
      ER46315      6604 - 6604      ER46316      6605 - 6605      ER46317      6606 - 6606 
      ER46318      6607 - 6607      ER46319      6608 - 6608      ER46320      6609 - 6609 
      ER46321      6610 - 6610      ER46322      6611 - 6611      ER46323      6612 - 6612 
      ER46324      6613 - 6613      ER46325      6614 - 6614      ER46326      6615 - 6615 
      ER46327      6616 - 6616      ER46328      6617 - 6617      ER46329      6618 - 6620 
      ER46330      6621 - 6621      ER46331      6622 - 6622      ER46332      6623 - 6623 
      ER46333      6624 - 6624      ER46334      6625 - 6625      ER46335      6626 - 6626 
      ER46336      6627 - 6627      ER46337      6628 - 6628      ER46338      6629 - 6629 
      ER46339      6630 - 6630      ER46340      6631 - 6631      ER46341      6632 - 6632 
      ER46342      6633 - 6633      ER46343      6634 - 6634      ER46344      6635 - 6635 
      ER46345      6636 - 6636      ER46346      6637 - 6637      ER46347      6638 - 6638 
      ER46348      6639 - 6641      ER46349      6642 - 6642      ER46350      6643 - 6643 
      ER46351      6644 - 6644      ER46352      6645 - 6645      ER46353      6646 - 6646 
      ER46354      6647 - 6647      ER46355      6648 - 6648      ER46356      6649 - 6649 
      ER46357      6650 - 6650      ER46358      6651 - 6651      ER46359      6652 - 6652 
      ER46360      6653 - 6653      ER46361      6654 - 6654      ER46362      6655 - 6655 
      ER46363      6656 - 6656      ER46364      6657 - 6657      ER46365      6658 - 6658 
      ER46366      6659 - 6659      ER46367      6660 - 6662      ER46368      6663 - 6663 
      ER46369      6664 - 6664      ER46370      6665 - 6665      ER46371      6666 - 6666 
      ER46372      6667 - 6667      ER46373      6668 - 6668      ER46374      6669 - 6669 
      ER46375      6670 - 6671      ER46376      6672 - 6672      ER46377      6673 - 6673 
      ER46378      6674 - 6674      ER46379      6675 - 6675      ER46380      6676 - 6677 
      ER46381      6678 - 6679      ER46382      6680 - 6680      ER46383      6681 - 6686 
      ER46384      6687 - 6687      ER46385      6688 - 6688      ER46386      6689 - 6689 
      ER46387      6690 - 6695      ER46388      6696 - 6696      ER46389      6697 - 6697 
      ER46390      6698 - 6698      ER46391      6699 - 6699      ER46392      6700 - 6700 
      ER46393      6701 - 6706      ER46394      6707 - 6707      ER46395      6708 - 6708 
      ER46396      6709 - 6709      ER46397      6710 - 6710      ER46398      6711 - 6711 
      ER46399      6712 - 6717      ER46400      6718 - 6718      ER46401      6719 - 6719 
      ER46402      6720 - 6720      ER46403      6721 - 6721      ER46404      6722 - 6729 
      ER46405      6730 - 6730      ER46406      6731 - 6731      ER46407      6732 - 6732 
      ER46408      6733 - 6733      ER46409      6734 - 6734      ER46410      6735 - 6735 
      ER46411      6736 - 6737      ER46412      6738 - 6739      ER46413      6740 - 6740 
      ER46414      6741 - 6742      ER46415      6743 - 6743      ER46416      6744 - 6744 
      ER46417      6745 - 6746      ER46418      6747 - 6747      ER46419      6748 - 6750 
      ER46420      6751 - 6753      ER46421      6754 - 6755      ER46422      6756 - 6757 
      ER46423      6758 - 6758      ER46424      6759 - 6760      ER46425      6761 - 6761 
      ER46426      6762 - 6762      ER46427      6763 - 6764      ER46428      6765 - 6765 
      ER46429      6766 - 6768      ER46430      6769 - 6771      ER46431      6772 - 6772 
      ER46432      6773 - 6774      ER46433      6775 - 6775      ER46434      6776 - 6776 
      ER46435      6777 - 6778      ER46436      6779 - 6779      ER46437      6780 - 6780 
      ER46438      6781 - 6782      ER46439      6783 - 6783      ER46440      6784 - 6784 
      ER46441      6785 - 6786      ER46442      6787 - 6787      ER46443      6788 - 6788 
      ER46444      6789 - 6790      ER46445      6791 - 6791      ER46446      6792 - 6792 
      ER46447      6793 - 6793      ER46448      6794 - 6794      ER46449      6795 - 6795 
      ER46450      6796 - 6796      ER46451      6797 - 6797      ER46452      6798 - 6798 
      ER46453      6799 - 6799      ER46454      6800 - 6801      ER46455      6802 - 6803 
      ER46456      6804 - 6804      ER46457      6805 - 6805      ER46458      6806 - 6806 
      ER46459      6807 - 6808      ER46460      6809 - 6812      ER46461      6813 - 6814 
      ER46462      6815 - 6816      ER46463      6817 - 6820      ER46464      6821 - 6822 
      ER46465      6823 - 6826      ER46466      6827 - 6828      ER46467      6829 - 6830 
      ER46468      6831 - 6834      ER46469      6835 - 6835      ER46470      6836 - 6837 
      ER46471      6838 - 6841      ER46472      6842 - 6842      ER46473      6843 - 6843 
      ER46474      6844 - 6845      ER46475      6846 - 6847      ER46476      6848 - 6851 
      ER46477      6852 - 6853      ER46478      6854 - 6854      ER46479      6855 - 6855 
      ER46480      6856 - 6856      ER46481      6857 - 6858      ER46482      6859 - 6860 
      ER46483      6861 - 6862      ER46484      6863 - 6866      ER46485      6867 - 6867 
      ER46486      6868 - 6868      ER46487      6869 - 6870      ER46488      6871 - 6872 
      ER46489      6873 - 6874      ER46490      6875 - 6878      ER46491      6879 - 6879 
      ER46492      6880 - 6880      ER46493      6881 - 6882      ER46494      6883 - 6884 
      ER46495      6885 - 6886      ER46496      6887 - 6890      ER46497      6891 - 6891 
      ER46498      6892 - 6893      ER46499      6894 - 6895      ER46500      6896 - 6897 
      ER46501      6898 - 6899      ER46502      6900 - 6902      ER46503      6903 - 6905 
      ER46504      6906 - 6906      ER46505      6907 - 6908      ER46506      6909 - 6910 
      ER46507      6911 - 6911      ER46508      6912 - 6913      ER46509      6914 - 6914 
      ER46510      6915 - 6915      ER46511      6916 - 6917      ER46512      6918 - 6918 
      ER46513      6919 - 6921      ER46514      6922 - 6924      ER46515      6925 - 6926 
      ER46516      6927 - 6928      ER46517      6929 - 6929      ER46518      6930 - 6931 
      ER46519      6932 - 6932      ER46520      6933 - 6933      ER46521      6934 - 6935 
      ER46522      6936 - 6936      ER46523      6937 - 6939      ER46524      6940 - 6942 
      ER46525      6943 - 6943      ER46526      6944 - 6945      ER46527      6946 - 6946 
      ER46528      6947 - 6947      ER46529      6948 - 6949      ER46530      6950 - 6950 
      ER46531      6951 - 6951      ER46532      6952 - 6953      ER46533      6954 - 6954 
      ER46534      6955 - 6955      ER46535      6956 - 6957      ER46536      6958 - 6958 
      ER46537      6959 - 6959      ER46538      6960 - 6961      ER46539      6962 - 6962 
      ER46540      6963 - 6963      ER46541      6964 - 6964      ER46542      6965 - 6965 
      ER46543      6966 - 6966      ER46544      6967 - 6967      ER46545      6968 - 6968 
      ER46546      6969 - 6969      ER46547      6970 - 6970      ER46548      6971 - 6972 
      ER46549      6973 - 6974      ER46550      6975 - 6975      ER46551      6976 - 6976 
      ER46552      6977 - 6977      ER46553      6978 - 6979      ER46554      6980 - 6983 
      ER46555      6984 - 6985      ER46556      6986 - 6987      ER46557      6988 - 6991 
      ER46558      6992 - 6993      ER46559      6994 - 6997      ER46560      6998 - 6999 
      ER46561      7000 - 7001      ER46562      7002 - 7005      ER46563      7006 - 7006 
      ER46564      7007 - 7008      ER46565      7009 - 7012      ER46566      7013 - 7013 
      ER46567      7014 - 7014      ER46568      7015 - 7016      ER46569      7017 - 7018 
      ER46570      7019 - 7022      ER46571      7023 - 7024      ER46572      7025 - 7025 
      ER46573      7026 - 7026      ER46574      7027 - 7027      ER46575      7028 - 7029 
      ER46576      7030 - 7031      ER46577      7032 - 7033      ER46578      7034 - 7037 
      ER46579      7038 - 7038      ER46580      7039 - 7039      ER46581      7040 - 7041 
      ER46582      7042 - 7043      ER46583      7044 - 7045      ER46584      7046 - 7049 
      ER46585      7050 - 7050      ER46586      7051 - 7051      ER46587      7052 - 7053 
      ER46588      7054 - 7055      ER46589      7056 - 7057      ER46590      7058 - 7061 
      ER46591      7062 - 7062      ER46592      7063 - 7064      ER46593      7065 - 7066 
      ER46594      7067 - 7068      ER46595      7069 - 7070      ER46596      7071 - 7073 
      ER46597      7074 - 7076      ER46598      7077 - 7077      ER46599      7078 - 7078 
      ER46600      7079 - 7084      ER46601      7085 - 7085      ER46602      7086 - 7086 
      ER46603      7087 - 7087      ER46604      7088 - 7088      ER46605      7089 - 7089 
      ER46606      7090 - 7095      ER46607      7096 - 7096      ER46608      7097 - 7097 
      ER46609      7098 - 7098      ER46610      7099 - 7099      ER46611      7100 - 7100 
      ER46612      7101 - 7105      ER46613      7106 - 7106      ER46614      7107 - 7107 
      ER46615      7108 - 7108      ER46616      7109 - 7109      ER46617      7110 - 7110 
      ER46618      7111 - 7115      ER46619      7116 - 7116      ER46620      7117 - 7117 
      ER46621      7118 - 7118      ER46622      7119 - 7119      ER46623      7120 - 7120 
      ER46624      7121 - 7125      ER46625      7126 - 7126      ER46626      7127 - 7127 
      ER46627      7128 - 7128      ER46628      7129 - 7129      ER46629      7130 - 7130 
      ER46630      7131 - 7135      ER46631      7136 - 7136      ER46632      7137 - 7137 
      ER46633      7138 - 7138      ER46634      7139 - 7139      ER46635      7140 - 7140 
      ER46636      7141 - 7145      ER46637      7146 - 7146      ER46638      7147 - 7147 
      ER46639      7148 - 7148      ER46640      7149 - 7149      ER46641      7150 - 7150 
      ER46642      7151 - 7155      ER46643      7156 - 7156      ER46644      7157 - 7157 
      ER46645      7158 - 7158      ER46646      7159 - 7159      ER46647      7160 - 7160 
      ER46648      7161 - 7165      ER46649      7166 - 7166      ER46650      7167 - 7167 
      ER46651      7168 - 7168      ER46652      7169 - 7169      ER46653      7170 - 7170 
      ER46654      7171 - 7175      ER46655      7176 - 7176      ER46656      7177 - 7177 
      ER46657      7178 - 7178      ER46658      7179 - 7179      ER46659      7180 - 7180 
      ER46660      7181 - 7185      ER46661      7186 - 7186      ER46662      7187 - 7187 
      ER46663      7188 - 7188      ER46664      7189 - 7189      ER46665      7190 - 7190 
      ER46666      7191 - 7192      ER46667      7193 - 7193      ER46668      7194 - 7195 
      ER46669      7196 - 7196      ER46670      7197 - 7198      ER46671      7199 - 7201 
      ER46672      7202 - 7202      ER46673      7203 - 7212      ER46674      7213 - 7213 
      ER46675      7214 - 7214      ER46676      7215 - 7215      ER46677      7216 - 7217 
      ER46678      7218 - 7218      ER46679      7219 - 7220      ER46680      7221 - 7221 
      ER46681      7222 - 7223      ER46682      7224 - 7226      ER46683      7227 - 7227 
      ER46684      7228 - 7237      ER46685      7238 - 7238      ER46686      7239 - 7239 
      ER46687      7240 - 7240      ER46688      7241 - 7241      ER46689      7242 - 7242 
      ER46690      7243 - 7243      ER46691      7244 - 7244      ER46692      7245 - 7245 
      ER46693      7246 - 7246      ER46694      7247 - 7247      ER46695      7248 - 7248 
      ER46696      7249 - 7249      ER46697      7250 - 7250      ER46698      7251 - 7253 
      ER46699      7254 - 7254      ER46700      7255 - 7255      ER46701      7256 - 7256 
      ER46702      7257 - 7257      ER46703      7258 - 7258      ER46704      7259 - 7259 
      ER46705      7260 - 7260      ER46706      7261 - 7261      ER46707      7262 - 7262 
      ER46708      7263 - 7263      ER46709      7264 - 7264      ER46710      7265 - 7265 
      ER46711      7266 - 7266      ER46712      7267 - 7267      ER46713      7268 - 7268 
      ER46714      7269 - 7269      ER46715      7270 - 7270      ER46716      7271 - 7271 
      ER46717      7272 - 7272      ER46718      7273 - 7273      ER46719      7274 - 7274 
      ER46720      7275 - 7275      ER46721      7276 - 7276      ER46722      7277 - 7277 
      ER46723      7278 - 7278      ER46724      7279 - 7279      ER46725      7280 - 7280 
      ER46726      7281 - 7281      ER46727      7282 - 7282      ER46728      7283 - 7283 
      ER46729      7284 - 7284      ER46730      7285 - 7285      ER46731      7286 - 7286 
      ER46732      7287 - 7287      ER46733      7288 - 7288      ER46734      7289 - 7289 
      ER46735      7290 - 7290      ER46736      7291 - 7291      ER46737      7292 - 7292 
      ER46738      7293 - 7293      ER46739      7294 - 7294      ER46740      7295 - 7295 
      ER46741      7296 - 7296      ER46742      7297 - 7297      ER46743      7298 - 7298 
      ER46744      7299 - 7299      ER46745      7300 - 7300      ER46746      7301 - 7301 
      ER46747      7302 - 7302      ER46748      7303 - 7303      ER46749      7304 - 7304 
      ER46750      7305 - 7305      ER46751      7306 - 7306      ER46752      7307 - 7307 
      ER46753      7308 - 7308      ER46754      7309 - 7309      ER46755      7310 - 7310 
      ER46756      7311 - 7311      ER46757      7312 - 7312      ER46758      7313 - 7313 
      ER46759      7314 - 7314      ER46760      7315 - 7316      ER46761      7317 - 7320 
      ER46762      7321 - 7321      ER46763      7322 - 7324      ER46764      7325 - 7325 
      ER46765      7326 - 7329      ER46766      7330 - 7330      ER46767      7331 - 7334 
      ER46768      7335 - 7338      ER46769      7339 - 7339      ER46770      7340 - 7343 
      ER46771      7344 - 7344      ER46772      7345 - 7348      ER46773      7349 - 7349 
      ER46774      7350 - 7353      ER46775      7354 - 7354      ER46776      7355 - 7358 
      ER46777      7359 - 7359      ER46778      7360 - 7363      ER46779      7364 - 7364 
      ER46780      7365 - 7368      ER46781      7369 - 7369      ER46782      7370 - 7373 
      ER46783      7374 - 7374      ER46784      7375 - 7377      ER46785      7378 - 7378 
      ER46786      7379 - 7382      ER46787      7383 - 7383      ER46788      7384 - 7387 
      ER46789      7388 - 7391      ER46790      7392 - 7392      ER46791      7393 - 7396 
      ER46792      7397 - 7397      ER46793      7398 - 7401      ER46794      7402 - 7402 
      ER46795      7403 - 7406      ER46796      7407 - 7407      ER46797      7408 - 7411 
      ER46798      7412 - 7412      ER46799      7413 - 7416      ER46800      7417 - 7417 
      ER46801      7418 - 7421      ER46802      7422 - 7422      ER46803      7423 - 7429 
      ER46804      7430 - 7430      ER46805      7431 - 7431      ER46806      7432 - 7438 
      ER46807      7439 - 7439      ER46808      7440 - 7446      ER46809      7447 - 7453 
      ER46810      7454 - 7454      ER46811      7455 - 7461      ER46812      7462 - 7462 
      ER46813      7463 - 7468      ER46814      7469 - 7469      ER46815      7470 - 7475 
      ER46816      7476 - 7476      ER46817      7477 - 7482      ER46818      7483 - 7483 
      ER46819      7484 - 7489      ER46820      7490 - 7490      ER46821      7491 - 7497 
      ER46822      7498 - 7498      ER46823      7499 - 7505      ER46824      7506 - 7506 
      ER46825      7507 - 7513      ER46826      7514 - 7514      ER46827      7515 - 7520 
      ER46828      7521 - 7521      ER46829      7522 - 7528      ER46830      7529 - 7534 
      ER46831      7535 - 7535      ER46832      7536 - 7541      ER46833      7542 - 7542 
      ER46834      7543 - 7548      ER46835      7549 - 7549      ER46836      7550 - 7555 
      ER46837      7556 - 7556      ER46838      7557 - 7563      ER46839      7564 - 7570 
      ER46840      7571 - 7571      ER46841      7572 - 7578      ER46842      7579 - 7579 
      ER46843      7580 - 7585      ER46844      7586 - 7586      ER46845      7587 - 7592 
      ER46846      7593 - 7593      ER46847      7594 - 7599      ER46848      7600 - 7600 
      ER46849      7601 - 7606      ER46850      7607 - 7607      ER46851      7608 - 7614 
      ER46852      7615 - 7620      ER46853      7621 - 7621      ER46854      7622 - 7627 
      ER46855      7628 - 7628      ER46856      7629 - 7634      ER46857      7635 - 7635 
      ER46858      7636 - 7641      ER46859      7642 - 7642      ER46860      7643 - 7648 
      ER46861      7649 - 7649      ER46862      7650 - 7655      ER46863      7656 - 7656 
      ER46864      7657 - 7662      ER46865      7663 - 7663      ER46866      7664 - 7669 
      ER46867      7670 - 7670      ER46868      7671 - 7676      ER46869      7677 - 7677 
      ER46870      7678 - 7683      ER46871      7684 - 7684      ER46872      7685 - 7690 
      ER46873      7691 - 7691      ER46874      7692 - 7697      ER46875      7698 - 7698 
      ER46876      7699 - 7704      ER46877      7705 - 7705      ER46878      7706 - 7711 
      ER46879      7712 - 7712      ER46880      7713 - 7718      ER46881      7719 - 7719 
      ER46882      7720 - 7725      ER46883      7726 - 7726      ER46884      7727 - 7732 
      ER46885      7733 - 7733      ER46886      7734 - 7739      ER46887      7740 - 7740 
      ER46888      7741 - 7746      ER46889      7747 - 7747      ER46890      7748 - 7753 
      ER46891      7754 - 7754      ER46892      7755 - 7760      ER46893      7761 - 7761 
      ER46894      7762 - 7767      ER46895      7768 - 7768      ER46896      7769 - 7774 
      ER46897      7775 - 7775      ER46898      7776 - 7781      ER46899      7782 - 7782 
      ER46900      7783 - 7789      ER46901      7790 - 7795      ER46902      7796 - 7801 
      ER46903      7802 - 7808      ER46904      7809 - 7809      ER46905      7810 - 7815 
      ER46906      7816 - 7816      ER46907      7817 - 7823      ER46908      7824 - 7829 
      ER46909      7830 - 7830      ER46910      7831 - 7836      ER46911      7837 - 7837 
      ER46912      7838 - 7843      ER46913      7844 - 7844      ER46914      7845 - 7850 
      ER46915      7851 - 7851      ER46916      7852 - 7857      ER46917      7858 - 7858 
      ER46918      7859 - 7864      ER46919      7865 - 7865      ER46920      7866 - 7871 
      ER46921      7872 - 7872      ER46922      7873 - 7878      ER46923      7879 - 7879 
      ER46924      7880 - 7885      ER46925      7886 - 7886      ER46926      7887 - 7892 
      ER46927      7893 - 7893      ER46928      7894 - 7899      ER46929      7900 - 7905 
      ER46930      7906 - 7906      ER46931      7907 - 7912      ER46932      7913 - 7913 
      ER46933      7914 - 7919      ER46934      7920 - 7920      ER46935      7921 - 7927 
      ER46936      7928 - 7928      ER46937      7929 - 7929      ER46938      7930 - 7938 
      ER46939      7939 - 7939      ER46940      7940 - 7940      ER46941      7941 - 7941 
      ER46942      7942 - 7950      ER46943      7951 - 7951      ER46944      7952 - 7952 
      ER46945      7953 - 7953      ER46946      7954 - 7962      ER46947      7963 - 7963 
      ER46948      7964 - 7964      ER46949      7965 - 7965      ER46950      7966 - 7974 
      ER46951      7975 - 7975      ER46952      7976 - 7976      ER46953      7977 - 7977 
      ER46954      7978 - 7986      ER46955      7987 - 7987      ER46956      7988 - 7996 
      ER46957      7997 - 7997      ER46958      7998 - 7998      ER46959      7999 - 7999 
      ER46960      8000 - 8008      ER46961      8009 - 8009      ER46962      8010 - 8010 
      ER46963      8011 - 8011      ER46964      8012 - 8020      ER46965      8021 - 8021 
      ER46966      8022 - 8030      ER46967      8031 - 8031      ER46968      8032 - 8040 
      ER46969      8041 - 8041      ER46970      8042 - 8050      ER46971      8051 - 8051 
      ER46972      8052 - 8056      ER46973      8057 - 8061      ER46974      8062 - 8062 
      ER46975      8063 - 8064      ER46976      8065 - 8065      ER46977      8066 - 8066 
      ER46978      8067 - 8067      ER46979      8068 - 8068      ER46980      8069 - 8069 
      ER46981      8070 - 8071      ER46982      8072 - 8073      ER46983      8074 - 8074 
      ER46984      8075 - 8075      ER46985      8076 - 8076      ER46986      8077 - 8080 
      ER46987      8081 - 8084      ER46988      8085 - 8085      ER46989      8086 - 8086 
      ER46990      8087 - 8091      ER46991      8092 - 8096      ER46992      8097 - 8097 
      ER46993      8098 - 8099      ER46994      8100 - 8104      ER46995      8105 - 8105 
      ER46996      8106 - 8107      ER46997      8108 - 8112      ER46998      8113 - 8113 
      ER46999      8114 - 8115      ER47000      8116 - 8120      ER47001      8121 - 8121 
      ER47002      8122 - 8123      ER47003      8124 - 8128      ER47004      8129 - 8129 
      ER47005      8130 - 8130      ER47006      8131 - 8131      ER47007      8132 - 8132 
      ER47008      8133 - 8133      ER47009      8134 - 8134      ER47010      8135 - 8135 
      ER47011      8136 - 8136      ER47012      8137 - 8143 
   ;

file rawdat lrecl=8143;

put    
ER42002
ER42003
ER42007
ER42009
ER42012
ER42013
ER42014
ER42016
ER42017
ER42018
ER42019
ER42023
ER42029
ER42030
ER42031
ER42037
ER42038
ER42039
ER42040
ER42041
ER42042
ER42043
ER42044
ER42045
ER42046
ER42047
ER42048
ER42049
ER42050
ER42051
ER42052
ER42053
ER42054
ER42055
ER42056
ER42057
ER42058
ER42059
ER42060
ER42061
ER42062
ER42063
ER42064
ER42065
ER42066
ER42067
ER42068
ER42069
ER42070
ER42071
ER42072
ER42073
ER42074
ER42075
ER42076
ER42077
ER42080
ER42081
ER42082
ER42092
ER42093
ER42094
ER42095
ER42096
ER42098
ER42132
ER42133
ER42134
ER42135
ER42140
ER42141
ER42142
ER42169
ER42200
ER42201
ER42202
ER42211
ER42388
ER42389
ER42390
ER42392
ER42393
ER42394
ER42421
ER42452
ER42453
ER42454
ER42463
ER42640
ER42641
ER42642
ER42692
ER42693
ER42710
ER42712
ER42713
ER42714
ER42716
ER42717
ER42718
ER42719
ER42720
ER42721
ER42722
ER42723
ER42724
ER42726
ER42727
ER42728
ER42729
ER42730
ER42731
ER42733
ER42734
ER42737
ER42738
ER42739
ER42740
ER42744
ER42745
ER42746
ER42747
ER42748
ER42749
ER42750
ER42751
ER42753
ER42754
ER42757
ER42760
ER42761
ER42762
ER42763
ER42767
ER42768
ER42769
ER42770
ER42771
ER42772
ER42773
ER42774
ER42776
ER42777
ER42780
ER42783
ER42784
ER42785
ER42786
ER42790
ER42791
ER42792
ER42793
ER42794
ER42795
ER42796
ER42797
ER42799
ER42800
ER42803
ER42804
ER42806
ER42807
ER42808
ER42809
ER42810
ER42811
ER42812
ER42814
ER42816
ER42817
ER42818
ER42822
ER42823
ER42827
ER42828
ER42832
ER42833
ER42837
ER42838
ER42843
ER42847
ER42920
ER42924
ER42926
ER42930
ER42933
ER42937
ER42941
ER42958
ER42991
ER42993
ER42994
ER43010
ER43011
ER43342
ER43343
ER43344
ER43522
ER43528
ER43544
ER43548
ER43553
ER43558
ER43578
ER43579
ER43580
ER43586
ER43607
ER43612
ER43643
ER43681
ER43692
ER44179
ER46458
ER46466
ER46469
ER46473
ER46504
ER46543
ER46552
ER46560
ER46563
ER46567
ER46761
ER46763
ER46765
ER46767
ER46768
ER46770
ER46782
ER46784
ER46786
ER46788
ER46789
ER46791
ER46808
ER46829
ER46838
ER46841
ER46842
ER46851
ER46900
ER46907
ER46908
ER46929
ER46931
ER46933
ER46935
ER46974
ER47012
;

proc means;
run;

PROC PRINTTO PRINT=PRINT;
RUN; 

PROC PRINTTO LOG=LOG;
RUN; 
